/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

public class CalendarCache {
    private static final int[] primes = new int[]{61, 127, 509, 1021, 2039, 4093, 8191, 16381, 32749, 65521, 131071, 262139};
    private int pIndex = 0;
    private int size = 0;
    private int arraySize = primes[this.pIndex];
    private int threshold = this.arraySize * 3 / 4;
    private long[] keys = new long[this.arraySize];
    private long[] values = new long[this.arraySize];
    public static long EMPTY = Long.MIN_VALUE;

    public CalendarCache() {
        this.makeArrays(this.arraySize);
    }

    private void makeArrays(int n2) {
        this.keys = new long[n2];
        this.values = new long[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.values[i2] = EMPTY;
        }
        this.arraySize = n2;
        this.threshold = (int)((double)this.arraySize * 0.75);
        this.size = 0;
    }

    public synchronized long get(long l2) {
        return this.values[this.findIndex(l2)];
    }

    public synchronized void put(long l2, long l3) {
        if (this.size >= this.threshold) {
            this.rehash();
        }
        int n2 = this.findIndex(l2);
        this.keys[n2] = l2;
        this.values[n2] = l3;
        ++this.size;
    }

    private final int findIndex(long l2) {
        int n2 = this.hash(l2);
        int n3 = 0;
        while (this.values[n2] != EMPTY && this.keys[n2] != l2) {
            if (n3 == 0) {
                n3 = this.hash2(l2);
            }
            n2 = (n2 + n3) % this.arraySize;
        }
        return n2;
    }

    private void rehash() {
        int n2 = this.arraySize;
        long[] lArray = this.keys;
        long[] lArray2 = this.values;
        this.arraySize = this.pIndex < primes.length - 1 ? primes[++this.pIndex] : this.arraySize * 2 + 1;
        this.size = 0;
        this.makeArrays(this.arraySize);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (lArray2[i2] == EMPTY) continue;
            this.put(lArray[i2], lArray2[i2]);
        }
    }

    private final int hash(long l2) {
        int n2 = (int)((l2 * 15821L + 1L) % (long)this.arraySize);
        if (n2 < 0) {
            n2 += this.arraySize;
        }
        return n2;
    }

    private final int hash2(long l2) {
        return this.arraySize - 2 - (int)(l2 % (long)(this.arraySize - 2));
    }
}

