/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.charset;

class UTF8 {
    private static final int[] U8_LEAD3_T1_BITS = new int[]{32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 16, 48, 48};
    private static final int[] U8_LEAD4_T1_BITS = new int[]{3584, 3840, 3840, 3840, 256};
    static int MAX_LENGTH = 4;

    UTF8() {
    }

    static int countTrailBytes(byte by2) {
        if (by2 < -32) {
            return by2 < -62 ? 0 : 1;
        }
        if (by2 < -16) {
            return 2;
        }
        return by2 <= -12 ? 3 : 0;
    }

    static int countBytes(byte by2) {
        if (by2 >= 0) {
            return 1;
        }
        if (by2 < -32) {
            return by2 < -62 ? 0 : 2;
        }
        if (by2 < -16) {
            return 3;
        }
        return by2 <= -12 ? 4 : 0;
    }

    static boolean isValidLead3AndT1(int n2, byte by2) {
        return (U8_LEAD3_T1_BITS[n2 & 0xF] & 1 << ((by2 & 0xFF) >> 5)) != 0;
    }

    static boolean isValidLead4AndT1(int n2, byte by2) {
        return (U8_LEAD4_T1_BITS[n2 & 7] & 1 << ((by2 & 0xFF) >> 4)) != 0;
    }

    static boolean isSingle(byte by2) {
        return by2 >= 0;
    }

    static boolean isLead(byte by2) {
        return (by2 - 194 & 0xFF) <= 50;
    }

    static boolean isTrail(byte by2) {
        return by2 < -64;
    }

    static int length(int n2) {
        if (n2 >= 0) {
            if (n2 <= 127) {
                return 1;
            }
            if (n2 <= 2047) {
                return 2;
            }
            if (n2 <= 55295) {
                return 3;
            }
            if (n2 <= 65535) {
                return n2 >= 57344 ? 3 : 0;
            }
            if (n2 <= 0x10FFFF) {
                return 4;
            }
        }
        return 0;
    }

    static boolean isValidTrail(int n2, byte by2, int n3, int n4) {
        if (n4 <= 2 || n3 > 1) {
            return UTF8.isTrail(by2);
        }
        if (n4 == 3) {
            return UTF8.isValidLead3AndT1(n2, by2);
        }
        return UTF8.isValidLead4AndT1(n2, by2);
    }
}

