/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetDecoderICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetEncoderICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetMBCS;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.UConverterSharedData;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

class CharsetLMBCS
extends CharsetICU {
    private static final short ULMBCS_CHARSIZE_MAX = 3;
    private static final short ULMBCS_C0END = 31;
    private static final short ULMBCS_C1START = 128;
    private static final short ULMBCS_GRP_L1 = 1;
    private static final short ULMBCS_GRP_GR = 2;
    private static final short ULMBCS_GRP_HE = 3;
    private static final short ULMBCS_GRP_AR = 4;
    private static final short ULMBCS_GRP_RU = 5;
    private static final short ULMBCS_GRP_L2 = 6;
    private static final short ULMBCS_GRP_TR = 8;
    private static final short ULMBCS_GRP_TH = 11;
    private static final short ULMBCS_GRP_JA = 16;
    private static final short ULMBCS_GRP_KO = 17;
    private static final short ULMBCS_GRP_TW = 18;
    private static final short ULMBCS_GRP_CN = 19;
    private static final short ULMBCS_DOUBLEOPTGROUP_START = 16;
    private static final short ULMBCS_HT = 9;
    private static final short ULMBCS_LF = 10;
    private static final short ULMBCS_CR = 13;
    private static final short ULMBCS_123SYSTEMRANGE = 25;
    private static final short ULMBCS_GRP_CTRL = 15;
    private static final short ULMBCS_CTRLOFFSET = 32;
    private static final short ULMBCS_GRP_EXCEPT = 0;
    private static final short ULMBCS_GRP_UNICODE = 20;
    private static char ULMBCS_UNICOMPATZERO = (char)246;
    private static final short ULMBCS_UNICODE_SIZE = 3;
    private static final short ULMBCS_GRP_LAST = 19;
    private static final String[] OptGroupByteToCPName = new String[]{"lmb-excp", "ibm-850", "ibm-851", "windows-1255", "windows-1256", "windows-1251", "ibm-852", null, "windows-1254", null, null, "windows-874", null, null, null, null, "windows-932", "windows-949", "windows-950", "windows-936", null};
    private static final short ULMBCS_AMBIGUOUS_SBCS = 128;
    private static final short ULMBCS_AMBIGUOUS_MBCS = 129;
    private static final short ULMBCS_AMBIGUOUS_ALL = 130;
    private static final _UniLMBCSGrpMap[] UniLMBCSGrpMap = new _UniLMBCSGrpMap[]{new _UniLMBCSGrpMap(1, 31, 15), new _UniLMBCSGrpMap(128, 159, 15), new _UniLMBCSGrpMap(160, 166, 128), new _UniLMBCSGrpMap(167, 168, 130), new _UniLMBCSGrpMap(169, 175, 128), new _UniLMBCSGrpMap(176, 177, 130), new _UniLMBCSGrpMap(178, 179, 128), new _UniLMBCSGrpMap(180, 180, 130), new _UniLMBCSGrpMap(181, 181, 128), new _UniLMBCSGrpMap(182, 182, 130), new _UniLMBCSGrpMap(183, 214, 128), new _UniLMBCSGrpMap(215, 215, 130), new _UniLMBCSGrpMap(216, 246, 128), new _UniLMBCSGrpMap(247, 247, 130), new _UniLMBCSGrpMap(248, 461, 128), new _UniLMBCSGrpMap(462, 462, 18), new _UniLMBCSGrpMap(463, 697, 128), new _UniLMBCSGrpMap(698, 698, 19), new _UniLMBCSGrpMap(700, 712, 128), new _UniLMBCSGrpMap(713, 720, 129), new _UniLMBCSGrpMap(728, 733, 128), new _UniLMBCSGrpMap(900, 912, 128), new _UniLMBCSGrpMap(913, 937, 130), new _UniLMBCSGrpMap(938, 944, 128), new _UniLMBCSGrpMap(945, 969, 130), new _UniLMBCSGrpMap(970, 974, 128), new _UniLMBCSGrpMap(1024, 1024, 5), new _UniLMBCSGrpMap(1025, 1025, 130), new _UniLMBCSGrpMap(1026, 1039, 5), new _UniLMBCSGrpMap(1040, 1073, 130), new _UniLMBCSGrpMap(1074, 1102, 5), new _UniLMBCSGrpMap(1103, 1103, 130), new _UniLMBCSGrpMap(1104, 1169, 5), new _UniLMBCSGrpMap(1456, 1522, 3), new _UniLMBCSGrpMap(1548, 1711, 4), new _UniLMBCSGrpMap(3585, 3675, 11), new _UniLMBCSGrpMap(8204, 8207, 128), new _UniLMBCSGrpMap(8208, 8208, 129), new _UniLMBCSGrpMap(8211, 8212, 128), new _UniLMBCSGrpMap(8213, 8213, 129), new _UniLMBCSGrpMap(8214, 8214, 129), new _UniLMBCSGrpMap(8215, 8215, 128), new _UniLMBCSGrpMap(8216, 8217, 130), new _UniLMBCSGrpMap(8218, 8219, 128), new _UniLMBCSGrpMap(8220, 8221, 130), new _UniLMBCSGrpMap(8222, 8223, 128), new _UniLMBCSGrpMap(8224, 8225, 130), new _UniLMBCSGrpMap(8226, 8228, 128), new _UniLMBCSGrpMap(8229, 8229, 129), new _UniLMBCSGrpMap(8230, 8230, 130), new _UniLMBCSGrpMap(8231, 8231, 18), new _UniLMBCSGrpMap(8240, 8240, 130), new _UniLMBCSGrpMap(8241, 8241, 128), new _UniLMBCSGrpMap(8242, 8243, 129), new _UniLMBCSGrpMap(8245, 8245, 129), new _UniLMBCSGrpMap(8249, 8250, 128), new _UniLMBCSGrpMap(8251, 8251, 129), new _UniLMBCSGrpMap(8252, 8252, 0), new _UniLMBCSGrpMap(8308, 8308, 17), new _UniLMBCSGrpMap(8319, 8319, 0), new _UniLMBCSGrpMap(8321, 8324, 17), new _UniLMBCSGrpMap(8356, 8364, 128), new _UniLMBCSGrpMap(8451, 8457, 129), new _UniLMBCSGrpMap(8465, 8480, 128), new _UniLMBCSGrpMap(8481, 8481, 129), new _UniLMBCSGrpMap(8482, 8486, 128), new _UniLMBCSGrpMap(8491, 8491, 129), new _UniLMBCSGrpMap(8501, 8501, 128), new _UniLMBCSGrpMap(8531, 8532, 17), new _UniLMBCSGrpMap(8539, 8542, 0), new _UniLMBCSGrpMap(8544, 8569, 129), new _UniLMBCSGrpMap(8592, 8595, 130), new _UniLMBCSGrpMap(8596, 8597, 0), new _UniLMBCSGrpMap(8598, 8601, 129), new _UniLMBCSGrpMap(8616, 8616, 0), new _UniLMBCSGrpMap(8632, 8633, 19), new _UniLMBCSGrpMap(8656, 8657, 0), new _UniLMBCSGrpMap(8658, 8658, 129), new _UniLMBCSGrpMap(8659, 8659, 0), new _UniLMBCSGrpMap(8660, 8660, 129), new _UniLMBCSGrpMap(8661, 8661, 0), new _UniLMBCSGrpMap(8679, 8679, 19), new _UniLMBCSGrpMap(8704, 8704, 129), new _UniLMBCSGrpMap(8705, 8705, 0), new _UniLMBCSGrpMap(8706, 8706, 129), new _UniLMBCSGrpMap(8707, 8707, 129), new _UniLMBCSGrpMap(8708, 8710, 0), new _UniLMBCSGrpMap(8711, 8712, 129), new _UniLMBCSGrpMap(8713, 8714, 0), new _UniLMBCSGrpMap(8715, 8715, 129), new _UniLMBCSGrpMap(8719, 8725, 129), new _UniLMBCSGrpMap(8729, 8729, 0), new _UniLMBCSGrpMap(8730, 8730, 129), new _UniLMBCSGrpMap(8731, 8732, 0), new _UniLMBCSGrpMap(8733, 8734, 129), new _UniLMBCSGrpMap(8735, 8735, 0), new _UniLMBCSGrpMap(8736, 8736, 129), new _UniLMBCSGrpMap(8739, 8746, 129), new _UniLMBCSGrpMap(8747, 8765, 129), new _UniLMBCSGrpMap(8773, 8776, 0), new _UniLMBCSGrpMap(8780, 8780, 18), new _UniLMBCSGrpMap(8786, 8786, 129), new _UniLMBCSGrpMap(8800, 8801, 129), new _UniLMBCSGrpMap(8802, 8805, 0), new _UniLMBCSGrpMap(8806, 8815, 129), new _UniLMBCSGrpMap(8834, 8835, 129), new _UniLMBCSGrpMap(8836, 8837, 0), new _UniLMBCSGrpMap(8838, 8839, 129), new _UniLMBCSGrpMap(8840, 8855, 0), new _UniLMBCSGrpMap(8857, 8895, 129), new _UniLMBCSGrpMap(8896, 8896, 0), new _UniLMBCSGrpMap(8976, 8976, 0), new _UniLMBCSGrpMap(8978, 8978, 129), new _UniLMBCSGrpMap(8984, 8993, 0), new _UniLMBCSGrpMap(8984, 8993, 19), new _UniLMBCSGrpMap(9312, 9449, 129), new _UniLMBCSGrpMap(9472, 9472, 128), new _UniLMBCSGrpMap(9473, 9473, 129), new _UniLMBCSGrpMap(9474, 9474, 130), new _UniLMBCSGrpMap(9475, 9475, 129), new _UniLMBCSGrpMap(9476, 9477, 18), new _UniLMBCSGrpMap(9478, 9829, 130), new _UniLMBCSGrpMap(9830, 9830, 0), new _UniLMBCSGrpMap(9831, 9833, 128), new _UniLMBCSGrpMap(9834, 9834, 130), new _UniLMBCSGrpMap(9835, 9836, 128), new _UniLMBCSGrpMap(9837, 9837, 129), new _UniLMBCSGrpMap(9838, 9838, 128), new _UniLMBCSGrpMap(9839, 9839, 16), new _UniLMBCSGrpMap(9840, 11903, 128), new _UniLMBCSGrpMap(11904, 63585, 129), new _UniLMBCSGrpMap(63586, 63743, 0), new _UniLMBCSGrpMap(63744, 64045, 129), new _UniLMBCSGrpMap(64256, 65279, 128), new _UniLMBCSGrpMap(65281, 65518, 129), new _UniLMBCSGrpMap(65535, 65535, 20)};
    private static final _LocaleLMBCSGrpMap[] LocaleLMBCSGrpMap = new _LocaleLMBCSGrpMap[]{new _LocaleLMBCSGrpMap("ar", 4), new _LocaleLMBCSGrpMap("be", 5), new _LocaleLMBCSGrpMap("bg", 6), new _LocaleLMBCSGrpMap("cs", 6), new _LocaleLMBCSGrpMap("el", 2), new _LocaleLMBCSGrpMap("he", 3), new _LocaleLMBCSGrpMap("hu", 6), new _LocaleLMBCSGrpMap("iw", 3), new _LocaleLMBCSGrpMap("ja", 16), new _LocaleLMBCSGrpMap("ko", 17), new _LocaleLMBCSGrpMap("mk", 5), new _LocaleLMBCSGrpMap("pl", 6), new _LocaleLMBCSGrpMap("ro", 6), new _LocaleLMBCSGrpMap("ru", 5), new _LocaleLMBCSGrpMap("sh", 6), new _LocaleLMBCSGrpMap("sk", 6), new _LocaleLMBCSGrpMap("sl", 6), new _LocaleLMBCSGrpMap("sq", 6), new _LocaleLMBCSGrpMap("sr", 5), new _LocaleLMBCSGrpMap("th", 11), new _LocaleLMBCSGrpMap("tr", 8), new _LocaleLMBCSGrpMap("uk", 5), new _LocaleLMBCSGrpMap("zhTW", 18), new _LocaleLMBCSGrpMap("zh", 19), new _LocaleLMBCSGrpMap(null, 1)};
    private UConverterDataLMBCS extraInfo;
    private byte[] fromUSubstitution = new byte[]{63};

    private boolean ULMBCS_AMBIGUOUS_MATCH(short s2, short s3) {
        return s2 == 128 && s3 < 16 || s2 == 129 && s3 >= 16 || s2 == 130;
    }

    static short FindLMBCSUniRange(char c2) {
        int n2 = 0;
        while (c2 > CharsetLMBCS.UniLMBCSGrpMap[n2].uniEndRange) {
            ++n2;
        }
        if (c2 >= CharsetLMBCS.UniLMBCSGrpMap[n2].uniStartRange) {
            return CharsetLMBCS.UniLMBCSGrpMap[n2].GrpType;
        }
        return 20;
    }

    static short FindLMBCSLocale(String string) {
        int n2 = 0;
        if (string == null) {
            return 0;
        }
        while (CharsetLMBCS.LocaleLMBCSGrpMap[n2].LocaleID != null) {
            if (CharsetLMBCS.LocaleLMBCSGrpMap[n2].LocaleID.equals(string)) {
                return CharsetLMBCS.LocaleLMBCSGrpMap[n2].OptGroup;
            }
            if (CharsetLMBCS.LocaleLMBCSGrpMap[n2].LocaleID.compareTo(string) > 0) break;
            ++n2;
        }
        return 1;
    }

    public CharsetLMBCS(String string, String string2, String[] stringArray) {
        super(string, string2, stringArray);
        int n2;
        this.maxBytesPerChar = 3;
        this.minBytesPerChar = 1;
        this.maxCharsPerByte = 1.0f;
        this.extraInfo = new UConverterDataLMBCS();
        for (n2 = 0; n2 <= 19; ++n2) {
            if (OptGroupByteToCPName[n2] == null) continue;
            this.extraInfo.OptGrpConverter[n2] = ((CharsetMBCS)CharsetICU.forNameICU((String)CharsetLMBCS.OptGroupByteToCPName[n2])).sharedData;
        }
        n2 = Integer.parseInt(string.substring(6));
        this.extraInfo.OptGroup = (short)n2;
        this.extraInfo.localeConverterIndex = CharsetLMBCS.FindLMBCSLocale(ULocale.getDefault().getBaseName());
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new CharsetDecoderLMBCS(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new CharsetEncoderLMBCS(this);
    }

    @Override
    void getUnicodeSetImpl(UnicodeSet unicodeSet, int n2) {
        CharsetLMBCS.getCompleteUnicodeSet(unicodeSet);
    }

    class CharsetEncoderLMBCS
    extends CharsetEncoderICU {
        public CharsetEncoderLMBCS(CharsetICU charsetICU) {
            super(charsetICU, CharsetLMBCS.this.fromUSubstitution);
            this.implReset();
        }

        @Override
        protected void implReset() {
            super.implReset();
        }

        private int LMBCSConversionWorker(short s2, byte[] byArray, char c2, short[] sArray, boolean[] blArray) {
            int n2 = 0;
            UConverterSharedData uConverterSharedData = ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.OptGrpConverter[s2];
            int[] nArray = new int[1];
            ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.charset.sharedData = uConverterSharedData;
            int n3 = ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.encoder.fromUChar32(c2, nArray, false);
            if (n3 <= 0) {
                blArray[s2] = true;
                return 0;
            }
            short s3 = (short)(nArray[0] >> (n3 - 1) * 8 & 0xFF);
            sArray[0] = s2;
            if (s2 != 0 && ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.OptGroup != s2) {
                int n4 = n2;
                n2 = (byte)(n2 + 1);
                byArray[n4] = (byte)s2;
                if (n3 == 1 && s2 >= 16) {
                    int n5 = n2;
                    n2 = (byte)(n2 + 1);
                    byArray[n5] = (byte)s2;
                }
            }
            if (n3 == 1 && s3 < 32) {
                return 0;
            }
            switch (n3) {
                case 4: {
                    int n6 = n2;
                    n2 = (byte)(n2 + 1);
                    byArray[n6] = (byte)(nArray[0] >> 24);
                }
                case 3: {
                    int n7 = n2;
                    n2 = (byte)(n2 + 1);
                    byArray[n7] = (byte)(nArray[0] >> 16);
                }
                case 2: {
                    int n8 = n2;
                    n2 = (byte)(n2 + 1);
                    byArray[n8] = (byte)(nArray[0] >> 8);
                }
                case 1: {
                    int n9 = n2;
                    n2 = (byte)(n2 + 1);
                    byArray[n9] = (byte)nArray[0];
                }
            }
            return n2;
        }

        private int LMBCSConvertUni(byte[] byArray, char c2) {
            int n2 = 0;
            short s2 = (short)(c2 & 0xFF);
            short s3 = (short)(c2 >> 8 & 0xFF);
            byArray[n2++] = 20;
            if (s2 == 0) {
                byArray[n2++] = (byte)ULMBCS_UNICOMPATZERO;
                byArray[n2++] = (byte)s3;
            } else {
                byArray[n2++] = (byte)s3;
                byArray[n2++] = (byte)s2;
            }
            return 3;
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, boolean bl2) {
            CoderResult coderResult = CoderResult.UNDERFLOW;
            short[] sArray = new short[1];
            byte[] byArray = new byte[3];
            boolean[] blArray = new boolean[20];
            int n2 = 0;
            short s2 = 0;
            while (charBuffer.hasRemaining() && coderResult.isUnderflow()) {
                short s3;
                s2 = ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.localeConverterIndex;
                if (!byteBuffer.hasRemaining()) {
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
                char c2 = charBuffer.get(charBuffer.position());
                int n3 = 0;
                int n4 = 0;
                if (c2 >= '\u0080' && c2 <= '\u00ff' && c2 != '\u00b1' && c2 != '\u00d7' && c2 != '\u00f7' && c2 != '\u00b0' && c2 != '\u00b4' && c2 != '\u00b6' && c2 != '\u00a7' && c2 != '\u00a8') {
                    ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.localeConverterIndex = 1;
                }
                if (c2 > '\u001f' && c2 < '\u0080' || c2 == '\u0000' || c2 == '\t' || c2 == '\r' || c2 == '\n' || c2 == '\u0019') {
                    int n5 = n4;
                    n4 = (byte)(n4 + 1);
                    byArray[n5] = (byte)c2;
                    n3 = 1;
                }
                if (n3 == 0) {
                    s3 = CharsetLMBCS.FindLMBCSUniRange(c2);
                    if (s3 == 20) {
                        n3 = this.LMBCSConvertUni(byArray, c2);
                    } else if (s3 == 15) {
                        if (c2 <= '\u001f') {
                            int n6 = n4;
                            n4 = (byte)(n4 + 1);
                            byArray[n6] = 15;
                            int n7 = n4;
                            n4 = (byte)(n4 + 1);
                            byArray[n7] = (byte)(32 + c2);
                        } else if (c2 >= '\u0080' && c2 <= '\u00a0') {
                            int n8 = n4;
                            n4 = (byte)(n4 + 1);
                            byArray[n8] = 15;
                            int n9 = n4;
                            n4 = (byte)(n4 + 1);
                            byArray[n9] = (byte)c2;
                        }
                        n3 = n4;
                    } else if (s3 < 20) {
                        n3 = this.LMBCSConversionWorker(s3, byArray, c2, sArray, blArray);
                    }
                    if (n3 == 0) {
                        blArray = new boolean[20];
                        if (((CharsetLMBCS)CharsetLMBCS.this).extraInfo.OptGroup != 1 && CharsetLMBCS.this.ULMBCS_AMBIGUOUS_MATCH(s3, ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.OptGroup)) {
                            if (((CharsetLMBCS)CharsetLMBCS.this).extraInfo.localeConverterIndex < 16) {
                                n3 = this.LMBCSConversionWorker((short)1, byArray, c2, sArray, blArray);
                                if (n3 == 0) {
                                    n3 = this.LMBCSConversionWorker((short)0, byArray, c2, sArray, blArray);
                                }
                                if (n3 == 0) {
                                    n3 = this.LMBCSConversionWorker(((CharsetLMBCS)CharsetLMBCS.this).extraInfo.localeConverterIndex, byArray, c2, sArray, blArray);
                                }
                            } else {
                                n3 = this.LMBCSConversionWorker(((CharsetLMBCS)CharsetLMBCS.this).extraInfo.localeConverterIndex, byArray, c2, sArray, blArray);
                            }
                        }
                        if (n3 == 0 && ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.localeConverterIndex > 0 && CharsetLMBCS.this.ULMBCS_AMBIGUOUS_MATCH(s3, ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.localeConverterIndex)) {
                            n3 = this.LMBCSConversionWorker(((CharsetLMBCS)CharsetLMBCS.this).extraInfo.localeConverterIndex, byArray, c2, sArray, blArray);
                        }
                        if (n3 == 0 && sArray[0] > 0 && CharsetLMBCS.this.ULMBCS_AMBIGUOUS_MATCH(s3, sArray[0])) {
                            n3 = this.LMBCSConversionWorker(sArray[0], byArray, c2, sArray, blArray);
                        }
                        if (n3 == 0) {
                            int n10;
                            short s4 = s3 == 129 ? (short)16 : 1;
                            int n11 = n10 = s3 == 129 ? 19 : 11;
                            if (s3 == 130) {
                                s4 = 1;
                                n10 = 19;
                            }
                            for (short s5 = s4; s5 <= n10 && n3 == 0; s5 = (short)((short)(s5 + 1))) {
                                if (((CharsetLMBCS)CharsetLMBCS.this).extraInfo.OptGrpConverter[s5] == null || blArray[s5]) continue;
                                n3 = this.LMBCSConversionWorker(s5, byArray, c2, sArray, blArray);
                            }
                            if (n3 == 0 && s4 == 1) {
                                n3 = this.LMBCSConversionWorker((short)0, byArray, c2, sArray, blArray);
                            }
                        }
                        if (n3 == 0) {
                            n3 = this.LMBCSConvertUni(byArray, c2);
                        }
                    }
                }
                charBuffer.get();
                n4 = 0;
                while (byteBuffer.hasRemaining() && n3 > 0) {
                    --n3;
                    int n12 = n4;
                    n4 = (byte)(n4 + 1);
                    byteBuffer.put(byArray[n12]);
                    if (intBuffer == null) continue;
                    intBuffer.put(n2);
                }
                ++n2;
                if (n3 > 0) {
                    coderResult = CoderResult.OVERFLOW;
                    this.errorBufferLength = n3;
                    s3 = 0;
                    while (n3 > 0) {
                        int n13 = n4;
                        n4 = (byte)(n4 + 1);
                        this.errorBuffer[s3] = byArray[n13];
                        ++s3;
                        --n3;
                    }
                }
                ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.localeConverterIndex = s2;
            }
            return coderResult;
        }
    }

    class CharsetDecoderLMBCS
    extends CharsetDecoderICU {
        public CharsetDecoderLMBCS(CharsetICU charsetICU) {
            super(charsetICU);
            this.implReset();
        }

        @Override
        protected void implReset() {
            super.implReset();
        }

        private char GetUniFromLMBCSUni(ByteBuffer byteBuffer) {
            short s2 = (short)(byteBuffer.get() & 0xFF);
            short s3 = (short)(byteBuffer.get() & 0xFF);
            if (s2 == ULMBCS_UNICOMPATZERO) {
                s2 = s3;
                s3 = 0;
            }
            return (char)(s2 << 8 | s3);
        }

        private int LMBCS_SimpleGetNextUChar(UConverterSharedData uConverterSharedData, ByteBuffer byteBuffer, int n2, int n3) {
            ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.charset.sharedData = uConverterSharedData;
            int n4 = byteBuffer.limit();
            int n5 = byteBuffer.position();
            byteBuffer.position(n5 + n2);
            byteBuffer.limit(byteBuffer.position() + n3);
            int n6 = ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.decoder.simpleGetNextUChar(byteBuffer, false);
            byteBuffer.limit(n4);
            byteBuffer.position(n5);
            return n6;
        }

        private int LMBCSGetNextUCharWorker(ByteBuffer byteBuffer, CoderResult[] coderResultArray) {
            int n2 = 0;
            if (!byteBuffer.hasRemaining()) {
                coderResultArray[0] = CoderResult.malformedForLength(0);
                return 65535;
            }
            int n3 = byteBuffer.get() & 0xFF;
            if (n3 > 31 && n3 < 128 || n3 == 0 || n3 == 9 || n3 == 13 || n3 == 10 || n3 == 25) {
                n2 = n3;
            } else if (n3 == 15) {
                if (byteBuffer.position() + 1 > byteBuffer.limit()) {
                    coderResultArray[0] = CoderResult.OVERFLOW;
                    byteBuffer.position(byteBuffer.limit());
                    return 65535;
                }
                int n4 = byteBuffer.get() & 0xFF;
                n2 = n4 < 128 ? n4 - 32 : n4;
            } else {
                if (n3 == 20) {
                    if (byteBuffer.position() + 2 > byteBuffer.limit()) {
                        coderResultArray[0] = CoderResult.OVERFLOW;
                        byteBuffer.position(byteBuffer.limit());
                        return 65535;
                    }
                    return this.GetUniFromLMBCSUni(byteBuffer);
                }
                if (n3 <= 32) {
                    UConverterSharedData uConverterSharedData;
                    int n5 = n3;
                    if (n5 > 19 || (uConverterSharedData = ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.OptGrpConverter[n5]) == null) {
                        coderResultArray[0] = CoderResult.unmappableForLength(1);
                    } else if (n5 >= 16) {
                        if (byteBuffer.position() + 2 > byteBuffer.limit()) {
                            coderResultArray[0] = CoderResult.OVERFLOW;
                            byteBuffer.position(byteBuffer.limit());
                            return 65535;
                        }
                        if (byteBuffer.get(byteBuffer.position()) == n5) {
                            byteBuffer.get();
                            n2 = this.LMBCS_SimpleGetNextUChar(uConverterSharedData, byteBuffer, 0, 1);
                            byteBuffer.get();
                        } else {
                            n2 = this.LMBCS_SimpleGetNextUChar(uConverterSharedData, byteBuffer, 0, 2);
                            byteBuffer.get();
                            byteBuffer.get();
                        }
                    } else {
                        if (byteBuffer.position() + 1 > byteBuffer.limit()) {
                            coderResultArray[0] = CoderResult.OVERFLOW;
                            byteBuffer.position(byteBuffer.limit());
                            return 65535;
                        }
                        n3 = (short)(byteBuffer.get() & 0xFF);
                        if (n3 >= 128) {
                            n2 = CharsetMBCS.MBCS_SINGLE_SIMPLE_GET_NEXT_BMP(uConverterSharedData.mbcs, n3);
                        } else {
                            byte[] byArray = new byte[2];
                            uConverterSharedData = ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.OptGrpConverter[0];
                            byArray[0] = (byte)n5;
                            byArray[1] = (byte)n3;
                            n2 = this.LMBCS_SimpleGetNextUChar(uConverterSharedData, ByteBuffer.wrap(byArray), 0, 2);
                        }
                    }
                } else if (n3 >= 128) {
                    short s2 = ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.OptGroup;
                    UConverterSharedData uConverterSharedData = ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.OptGrpConverter[s2];
                    if (s2 >= 16) {
                        if (CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(uConverterSharedData.mbcs.stateTable[0][n3])) {
                            if (byteBuffer.position() + 0 > byteBuffer.limit()) {
                                coderResultArray[0] = CoderResult.OVERFLOW;
                                byteBuffer.position(byteBuffer.limit());
                                return 65535;
                            }
                            n2 = this.LMBCS_SimpleGetNextUChar(uConverterSharedData, byteBuffer, -1, 1);
                        } else {
                            if (byteBuffer.position() + 1 > byteBuffer.limit()) {
                                coderResultArray[0] = CoderResult.OVERFLOW;
                                byteBuffer.position(byteBuffer.limit());
                                return 65535;
                            }
                            n2 = this.LMBCS_SimpleGetNextUChar(uConverterSharedData, byteBuffer, -1, 2);
                            byteBuffer.get();
                        }
                    } else {
                        n2 = CharsetMBCS.MBCS_SINGLE_SIMPLE_GET_NEXT_BMP(uConverterSharedData.mbcs, n3);
                    }
                }
            }
            return n2;
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, boolean bl2) {
            int n2;
            CoderResult[] coderResultArray = new CoderResult[]{CoderResult.UNDERFLOW};
            byte[] byArray = new byte[6];
            int n3 = 0;
            int n4 = 0;
            while (coderResultArray[0].isUnderflow() && byteBuffer.hasRemaining() && charBuffer.hasRemaining()) {
                char c2;
                int n5 = byteBuffer.position();
                if (this.toULength > 0) {
                    int n6;
                    n2 = this.toULength;
                    int n7 = 3 - n2;
                    int n8 = byteBuffer.remaining();
                    int n9 = n7 < n8 ? n7 : n8;
                    n4 = (byte)(n2 + n9);
                    for (n6 = 0; n6 < n4; ++n6) {
                        byArray[n6] = n6 < n2 ? this.toUBytesArray[n6] : byteBuffer.get();
                    }
                    ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray);
                    byteBuffer2.limit(n4);
                    c2 = (char)this.LMBCSGetNextUCharWorker(byteBuffer2, coderResultArray);
                    byteBuffer.position(n5 + byteBuffer2.position() - n2);
                    n3 = n5 - n2;
                    if (coderResultArray[0].isOverflow()) {
                        this.toULength = n4;
                        for (n6 = 0; n6 < n4; ++n6) {
                            this.toUBytesArray[n6] = byArray[n6];
                        }
                        byteBuffer.position(byteBuffer.limit());
                        coderResultArray[0] = CoderResult.UNDERFLOW;
                        return coderResultArray[0];
                    }
                    this.toULength = 0;
                } else {
                    n3 = n5;
                    c2 = (char)this.LMBCSGetNextUCharWorker(byteBuffer, coderResultArray);
                    n4 = (byte)(byteBuffer.position() - n5);
                }
                if (!coderResultArray[0].isUnderflow()) continue;
                if (c2 < '\ufffe') {
                    charBuffer.put(c2);
                    if (intBuffer == null) continue;
                    intBuffer.put(n5);
                    continue;
                }
                if (c2 == '\ufffe') {
                    coderResultArray[0] = CoderResult.unmappableForLength(byteBuffer.position() - n5);
                    continue;
                }
                coderResultArray[0] = CoderResult.malformedForLength(byteBuffer.position() - n5);
            }
            if (coderResultArray[0].isUnderflow() && byteBuffer.hasRemaining() && !charBuffer.hasRemaining()) {
                coderResultArray[0] = CoderResult.OVERFLOW;
            } else if (!coderResultArray[0].isUnderflow()) {
                this.toULength = n4;
                if (n4 > 0) {
                    for (n2 = 0; n2 < n4; ++n2) {
                        this.toUBytesArray[n2] = byteBuffer.get(n3 + n2);
                    }
                }
                if (coderResultArray[0].isOverflow()) {
                    coderResultArray[0] = CoderResult.UNDERFLOW;
                }
            }
            return coderResultArray[0];
        }
    }

    private static class UConverterDataLMBCS {
        UConverterSharedData[] OptGrpConverter = new UConverterSharedData[20];
        short OptGroup;
        short localeConverterIndex;
        CharsetMBCS.CharsetDecoderMBCS decoder;
        CharsetMBCS.CharsetEncoderMBCS encoder;
        CharsetMBCS charset = (CharsetMBCS)CharsetICU.forNameICU("ibm-850");

        UConverterDataLMBCS() {
            this.encoder = (CharsetMBCS.CharsetEncoderMBCS)this.charset.newEncoder();
            this.decoder = (CharsetMBCS.CharsetDecoderMBCS)this.charset.newDecoder();
        }
    }

    private static class _LocaleLMBCSGrpMap {
        String LocaleID;
        short OptGroup;

        _LocaleLMBCSGrpMap(String string, short s2) {
            this.LocaleID = string;
            this.OptGroup = s2;
        }
    }

    private static class _UniLMBCSGrpMap {
        int uniStartRange;
        int uniEndRange;
        short GrpType;

        _UniLMBCSGrpMap(int n2, int n3, short s2) {
            this.uniStartRange = n2;
            this.uniEndRange = n3;
            this.GrpType = s2;
        }
    }
}

