/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetDecoderICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetEncoderICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetMBCS;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.UConverterSharedData;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

class CharsetISO2022
extends CharsetICU {
    private UConverterDataISO2022 myConverterData;
    private int variant;
    private static final byte[] SHIFT_IN_STR = new byte[]{15};
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final char HWKANA_START = '\uff61';
    private static final char HWKANA_END = '\uff9f';
    private static final char GR96_START = '\u00a0';
    private static final char GR96_END = '\u00ff';
    private static final byte INVALID_STATE = -1;
    private static final byte ASCII = 0;
    private static final byte SS2_STATE = 16;
    private static final byte SS3_STATE = 17;
    private static final byte ISO8859_1 = 1;
    private static final byte ISO8859_7 = 2;
    private static final byte JISX201 = 3;
    private static final byte JISX208 = 4;
    private static final byte JISX212 = 5;
    private static final byte GB2312 = 6;
    private static final byte KSC5601 = 7;
    private static final byte HWKANA_7BIT = 8;
    private static final byte GB2312_1 = 1;
    private static final byte ISO_IR_165 = 2;
    private static final byte CNS_11643 = 3;
    private static final byte CNS_11643_0 = 32;
    private static final byte CNS_11643_1 = 33;
    private static final byte CNS_11643_2 = 34;
    private static final byte CNS_11643_3 = 35;
    private static final byte CNS_11643_4 = 36;
    private static final byte CNS_11643_5 = 37;
    private static final byte CNS_11643_6 = 38;
    private static final byte CNS_11643_7 = 39;
    private static final short[] jpCharsetMasks = new short[]{(short)(CharsetISO2022.CSM((short)0) | CharsetISO2022.CSM((short)3) | CharsetISO2022.CSM((short)4) | CharsetISO2022.CSM((short)8)), (short)(CharsetISO2022.CSM((short)0) | CharsetISO2022.CSM((short)3) | CharsetISO2022.CSM((short)4) | CharsetISO2022.CSM((short)8) | CharsetISO2022.CSM((short)5)), (short)(CharsetISO2022.CSM((short)0) | CharsetISO2022.CSM((short)3) | CharsetISO2022.CSM((short)4) | CharsetISO2022.CSM((short)8) | CharsetISO2022.CSM((short)5) | CharsetISO2022.CSM((short)6) | CharsetISO2022.CSM((short)7) | CharsetISO2022.CSM((short)1) | CharsetISO2022.CSM((short)2)), (short)(CharsetISO2022.CSM((short)0) | CharsetISO2022.CSM((short)3) | CharsetISO2022.CSM((short)4) | CharsetISO2022.CSM((short)8) | CharsetISO2022.CSM((short)5) | CharsetISO2022.CSM((short)6) | CharsetISO2022.CSM((short)7) | CharsetISO2022.CSM((short)1) | CharsetISO2022.CSM((short)2)), (short)(CharsetISO2022.CSM((short)0) | CharsetISO2022.CSM((short)3) | CharsetISO2022.CSM((short)4) | CharsetISO2022.CSM((short)8) | CharsetISO2022.CSM((short)5) | CharsetISO2022.CSM((short)6) | CharsetISO2022.CSM((short)7) | CharsetISO2022.CSM((short)1) | CharsetISO2022.CSM((short)2))};
    private static final byte UCNV_2022_MAX_CONVERTERS = 10;
    private static final byte ESC_2022 = 27;
    private static final byte INVALID_2022 = -1;
    private static final byte VALID_NON_TERMINAL_2022 = 0;
    private static final byte VALID_TERMINAL_2022 = 1;
    private static final byte VALID_MAYBE_TERMINAL_2022 = 2;
    private static final byte[] normalize_esq_chars_2022 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 4, 7, 29, 0, 2, 24, 26, 27, 0, 3, 23, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 25, 28, 0, 0, 21, 0, 0, 0, 0, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final short MAX_STATES_2022 = 74;
    private static final int[] escSeqStateTable_Key_2022 = new int[]{1, 34, 36, 39, 55, 57, 60, 61, 1093, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103, 1104, 1105, 1106, 1109, 1154, 1157, 1160, 1161, 1176, 1178, 1179, 1254, 1257, 1768, 1773, 1957, 35105, 36933, 36936, 36937, 36938, 36939, 36940, 36942, 36943, 36944, 36945, 36946, 36947, 36948, 37640, 37642, 37644, 37646, 37711, 37744, 37745, 37746, 37747, 37748, 40133, 40136, 40138, 40139, 40140, 40141, 1123363, 35947624, 35947625, 35947626, 35947627, 35947629, 35947630, 35947631, 35947635, 35947636, 35947638};
    private static final byte[] escSeqStateTable_Value_2022 = new byte[]{0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static final byte ISO_2022_JP = 1;
    private static final byte ISO_2022_KR = 2;
    private static final byte ISO_2022_CN = 3;
    private static final byte[] nextStateToUnicodeJP = new byte[]{-1, -1, -1, -1, -1, 16, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, 3, 8, 3, -1, -1, -1, 4, 6, 4, -1, -1, -1, -1, -1, 1, 2, 4, -1, -1, -1, -1, 7, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final byte[] nextStateToUnicodeCN = new byte[]{-1, -1, -1, -1, -1, 16, 17, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, -1, 2, 33, 34, 35, 36, 37, 38, 39, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final byte[] jpCharsetPref = new byte[]{0, 3, 1, 4, 2, 5, 6, 7, 8};
    private static final byte[][] escSeqChars = new byte[][]{{27, 40, 66}, {27, 46, 65}, {27, 46, 70}, {27, 40, 74}, {27, 36, 66}, {27, 36, 40, 68}, {27, 36, 65}, {27, 36, 40, 67}, {27, 40, 73}};
    private static final char[] hwkana_fb = new char[]{'\u2123', '\u2156', '\u2157', '\u2122', '\u2126', '\u2572', '\u2521', '\u2523', '\u2525', '\u2527', '\u2529', '\u2563', '\u2565', '\u2567', '\u2543', '\u213c', '\u2522', '\u2524', '\u2526', '\u2528', '\u252a', '\u252b', '\u252d', '\u252f', '\u2531', '\u2533', '\u2535', '\u2537', '\u2539', '\u253b', '\u253d', '\u253f', '\u2541', '\u2544', '\u2546', '\u2548', '\u254a', '\u254b', '\u254c', '\u254d', '\u254e', '\u254f', '\u2552', '\u2555', '\u2558', '\u255b', '\u255e', '\u255f', '\u2560', '\u2561', '\u2562', '\u2564', '\u2566', '\u2568', '\u2569', '\u256a', '\u256b', '\u256c', '\u256d', '\u256f', '\u2573', '\u212b', '\u212c'};
    protected byte[][] fromUSubstitutionChar = new byte[][]{{26}, {47, 126}};
    private static final byte[] GB_2312_80_STR = new byte[]{27, 36, 41, 65};
    private static final byte[] ISO_IR_165_STR = new byte[]{27, 36, 41, 69};
    private static final byte[] CNS_11643_1992_Plane_1_STR = new byte[]{27, 36, 41, 71};
    private static final byte[] CNS_11643_1992_Plane_2_STR = new byte[]{27, 36, 42, 72};
    private static final byte[] CNS_11643_1992_Plane_3_STR = new byte[]{27, 36, 43, 73};
    private static final byte[] CNS_11643_1992_Plane_4_STR = new byte[]{27, 36, 43, 74};
    private static final byte[] CNS_11643_1992_Plane_5_STR = new byte[]{27, 36, 43, 75};
    private static final byte[] CNS_11643_1992_Plane_6_STR = new byte[]{27, 36, 43, 76};
    private static final byte[] CNS_11643_1992_Plane_7_STR = new byte[]{27, 36, 43, 77};
    private static final byte[][] escSeqCharsCN = new byte[][]{SHIFT_IN_STR, GB_2312_80_STR, ISO_IR_165_STR, CNS_11643_1992_Plane_1_STR, CNS_11643_1992_Plane_2_STR, CNS_11643_1992_Plane_3_STR, CNS_11643_1992_Plane_4_STR, CNS_11643_1992_Plane_5_STR, CNS_11643_1992_Plane_6_STR, CNS_11643_1992_Plane_7_STR};

    public CharsetISO2022(String string, String string2, String[] stringArray) {
        super(string, string2, stringArray);
        int n2;
        this.myConverterData = new UConverterDataISO2022();
        int n3 = string.indexOf("version=");
        this.myConverterData.version = n2 = Integer.decode(string.substring(n3 + 8, n3 + 9)).intValue();
        if (string.indexOf("locale=ja") > 0) {
            this.ISO2022InitJP(n2);
        } else if (string.indexOf("locale=zh") > 0) {
            this.ISO2022InitCN(n2);
        } else {
            this.ISO2022InitKR(n2);
        }
        this.myConverterData.currentEncoder = (CharsetMBCS.CharsetEncoderMBCS)this.myConverterData.currentConverter.newEncoder();
        this.myConverterData.currentDecoder = (CharsetMBCS.CharsetDecoderMBCS)this.myConverterData.currentConverter.newDecoder();
    }

    private void ISO2022InitJP(int n2) {
        this.variant = 1;
        this.maxBytesPerChar = 6;
        this.minBytesPerChar = 1;
        this.maxCharsPerByte = 1.0f;
        if ((jpCharsetMasks[n2] & CharsetISO2022.CSM((short)2)) != 0) {
            this.myConverterData.myConverterArray[2] = ((CharsetMBCS)CharsetICU.forNameICU((String)"ISO8859_7")).sharedData;
        }
        this.myConverterData.myConverterArray[4] = ((CharsetMBCS)CharsetICU.forNameICU((String)"Shift-JIS")).sharedData;
        if ((jpCharsetMasks[n2] & CharsetISO2022.CSM((short)5)) != 0) {
            this.myConverterData.myConverterArray[5] = ((CharsetMBCS)CharsetICU.forNameICU((String)"jisx-212")).sharedData;
        }
        if ((jpCharsetMasks[n2] & CharsetISO2022.CSM((short)6)) != 0) {
            this.myConverterData.myConverterArray[6] = ((CharsetMBCS)CharsetICU.forNameICU((String)"ibm-5478")).sharedData;
        }
        if ((jpCharsetMasks[n2] & CharsetISO2022.CSM((short)7)) != 0) {
            this.myConverterData.myConverterArray[7] = ((CharsetMBCS)CharsetICU.forNameICU((String)"ksc_5601")).sharedData;
        }
        this.myConverterData.currentConverter = (CharsetMBCS)CharsetICU.forNameICU("icu-internal-25546");
    }

    private void ISO2022InitCN(int n2) {
        this.variant = 3;
        this.maxBytesPerChar = 8;
        this.minBytesPerChar = 1;
        this.maxCharsPerByte = 1.0f;
        this.myConverterData.myConverterArray[1] = ((CharsetMBCS)CharsetICU.forNameICU((String)"ibm-5478")).sharedData;
        if (n2 == 1) {
            this.myConverterData.myConverterArray[2] = ((CharsetMBCS)CharsetICU.forNameICU((String)"iso-ir-165")).sharedData;
        }
        this.myConverterData.myConverterArray[3] = ((CharsetMBCS)CharsetICU.forNameICU((String)"cns-11643-1992")).sharedData;
        this.myConverterData.currentConverter = (CharsetMBCS)CharsetICU.forNameICU("icu-internal-25546");
    }

    private void ISO2022InitKR(int n2) {
        this.variant = 2;
        this.maxBytesPerChar = 8;
        this.minBytesPerChar = 1;
        this.maxCharsPerByte = 1.0f;
        if (n2 == 1) {
            this.myConverterData.currentConverter = (CharsetMBCS)CharsetICU.forNameICU("icu-internal-25546");
            this.myConverterData.currentConverter.subChar1 = this.fromUSubstitutionChar[0][0];
        } else {
            this.myConverterData.currentConverter = (CharsetMBCS)CharsetICU.forNameICU("ibm-949");
        }
        this.myConverterData.currentEncoder = (CharsetMBCS.CharsetEncoderMBCS)this.myConverterData.currentConverter.newEncoder();
        this.myConverterData.currentDecoder = (CharsetMBCS.CharsetDecoderMBCS)this.myConverterData.currentConverter.newDecoder();
    }

    private static boolean IS_2022_CONTROL(int n2) {
        return n2 < 32 && (1 << n2 & 0x800C000) != 0;
    }

    private static int _2022FromGR94DBCS(int n2) {
        if (n2 <= 65278 && n2 >= 41377 && (short)(n2 & 0xFF) <= 254 && (short)(n2 & 0xFF) >= 161) {
            return n2 - 32896;
        }
        return 0;
    }

    private static boolean IS_JP_DBCS(byte by2) {
        return 4 <= by2 && by2 <= 7;
    }

    private static short CSM(short s2) {
        return (short)(1 << s2);
    }

    private static int getEndOfBuffer_2022(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.position();
        byte by2 = 0;
        by2 = byteBuffer.get(n2);
        while (byteBuffer.hasRemaining() && by2 != 27 && (by2 = byteBuffer.get()) != 27) {
            ++n2;
        }
        return n2;
    }

    private int MBCSSimpleGetNextUChar(UConverterSharedData uConverterSharedData, ByteBuffer byteBuffer, boolean bl2) {
        UConverterSharedData uConverterSharedData2 = this.myConverterData.currentConverter.sharedData;
        this.myConverterData.currentConverter.sharedData = uConverterSharedData;
        int n2 = this.myConverterData.currentDecoder.simpleGetNextUChar(byteBuffer, bl2);
        this.myConverterData.currentConverter.sharedData = uConverterSharedData2;
        return n2;
    }

    static int MBCSSingleFromUChar32(UConverterSharedData uConverterSharedData, int n2, int[] nArray, boolean bl2) {
        if (n2 >= 65536 && !uConverterSharedData.mbcs.hasSupplementary()) {
            return 0;
        }
        char[] cArray = uConverterSharedData.mbcs.fromUnicodeTable;
        char c2 = CharsetMBCS.MBCS_SINGLE_RESULT_FROM_U(cArray, uConverterSharedData.mbcs.fromUnicodeChars, n2);
        nArray[0] = c2 & 0xFF;
        if (c2 >= '\u0f00') {
            return 1;
        }
        if (bl2 ? c2 >= '\u0800' : c2 >= '\u0c00') {
            return -1;
        }
        return 0;
    }

    private CoderResult changeState_2022(CharsetDecoderICU charsetDecoderICU, ByteBuffer byteBuffer, int n2) {
        int n3;
        CoderResult coderResult = CoderResult.UNDERFLOW;
        boolean bl2 = false;
        int[] nArray = new int[]{this.myConverterData.key};
        int[] nArray2 = new int[]{0};
        int n4 = charsetDecoderICU.toULength;
        int n5 = 0;
        int n6 = 0;
        while (byteBuffer.hasRemaining()) {
            byte by2 = byteBuffer.get();
            ++n5;
            charsetDecoderICU.toUBytesArray[charsetDecoderICU.toULength++] = by2;
            n6 = CharsetISO2022.getKey_2022(by2, nArray, nArray2);
            switch (n6) {
                case 0: {
                    break;
                }
                case 1: {
                    nArray[0] = 0;
                    bl2 = true;
                    break;
                }
                case -1: {
                    bl2 = true;
                    break;
                }
                case 2: {
                    n6 = 1;
                    nArray[0] = 0;
                    bl2 = true;
                }
            }
            if (!bl2) continue;
        }
        this.myConverterData.key = nArray[0];
        if (n6 == 0) {
            return coderResult;
        }
        if (n6 == -1) {
            coderResult = CoderResult.malformedForLength(n5);
        } else {
            block6 : switch (n2) {
                case 1: {
                    n3 = nextStateToUnicodeJP[nArray2[0]];
                    switch (n3) {
                        case -1: {
                            coderResult = CoderResult.malformedForLength(n5);
                            break block6;
                        }
                        case 16: {
                            if (this.myConverterData.toU2022State.cs[2] != 0) {
                                if (this.myConverterData.toU2022State.g < 2) {
                                    this.myConverterData.toU2022State.prevG = this.myConverterData.toU2022State.g;
                                }
                                this.myConverterData.toU2022State.g = (byte)2;
                                break block6;
                            }
                            coderResult = CoderResult.malformedForLength(n5);
                            break block6;
                        }
                        case 1: 
                        case 2: {
                            if ((jpCharsetMasks[this.myConverterData.version] & CharsetISO2022.CSM((short)n3)) == 0) {
                                coderResult = CoderResult.unmappableForLength(n5);
                                break block6;
                            }
                            ((ISO2022State)this.myConverterData.toU2022State).cs[2] = n3;
                            break block6;
                        }
                    }
                    if ((jpCharsetMasks[this.myConverterData.version] & CharsetISO2022.CSM((short)n3)) == 0) {
                        coderResult = CoderResult.unmappableForLength(byteBuffer.position() - 1);
                        break;
                    }
                    ((ISO2022State)this.myConverterData.toU2022State).cs[0] = n3;
                    break;
                }
                case 3: {
                    n3 = nextStateToUnicodeCN[nArray2[0]];
                    switch (n3) {
                        case -1: {
                            coderResult = CoderResult.unmappableForLength(n5);
                            break block6;
                        }
                        case 16: {
                            if (this.myConverterData.toU2022State.cs[2] != 0) {
                                if (this.myConverterData.toU2022State.g < 2) {
                                    this.myConverterData.toU2022State.prevG = this.myConverterData.toU2022State.g;
                                }
                                this.myConverterData.toU2022State.g = (byte)2;
                                break block6;
                            }
                            coderResult = CoderResult.malformedForLength(n5);
                            break block6;
                        }
                        case 17: {
                            if (this.myConverterData.toU2022State.cs[3] != 0) {
                                if (this.myConverterData.toU2022State.g < 2) {
                                    this.myConverterData.toU2022State.prevG = this.myConverterData.toU2022State.g;
                                }
                                this.myConverterData.toU2022State.g = (byte)3;
                                break block6;
                            }
                            coderResult = CoderResult.malformedForLength(n5);
                            break block6;
                        }
                        case 2: {
                            if (this.myConverterData.version == 0) {
                                coderResult = CoderResult.unmappableForLength(n5);
                                break block6;
                            }
                        }
                        case 1: 
                        case 33: {
                            ((ISO2022State)this.myConverterData.toU2022State).cs[1] = n3;
                            break block6;
                        }
                        case 34: {
                            ((ISO2022State)this.myConverterData.toU2022State).cs[2] = n3;
                            break block6;
                        }
                    }
                    if (this.myConverterData.version == 0) {
                        coderResult = CoderResult.unmappableForLength(byteBuffer.position() - 1);
                        break;
                    }
                    ((ISO2022State)this.myConverterData.toU2022State).cs[3] = n3;
                    break;
                }
                case 2: {
                    if (nArray2[0] == 48) break;
                    coderResult = CoderResult.unmappableForLength(n5);
                    break;
                }
                default: {
                    coderResult = CoderResult.malformedForLength(n5);
                }
            }
        }
        if (!coderResult.isError()) {
            charsetDecoderICU.toULength = 0;
        } else if (coderResult.isMalformed() && charsetDecoderICU.toULength > 1) {
            n3 = charsetDecoderICU.toULength - 1;
            int n7 = charsetDecoderICU.toULength - n4;
            if (n3 <= n7) {
                byteBuffer.position(byteBuffer.position() - n3);
            } else {
                charsetDecoderICU.preToULength = (byte)(n7 - n3);
                for (int i2 = 0; i2 < -charsetDecoderICU.preToULength; ++i2) {
                    charsetDecoderICU.preToUArray[i2] = charsetDecoderICU.toUBytesArray[i2 + 1];
                }
                byteBuffer.position(byteBuffer.position() - n7);
            }
            charsetDecoderICU.toULength = 1;
        }
        return coderResult;
    }

    private static byte getKey_2022(byte by2, int[] nArray, int[] nArray2) {
        int n2;
        int n3 = 0;
        int n4 = 74;
        int n5 = 0;
        int n6 = normalize_esq_chars_2022[by2 & 0xFF];
        if (n6 == 0) {
            nArray[0] = 0;
            nArray2[0] = 0;
            return -1;
        }
        n6 = (nArray[0] << 5) + n6;
        while (n4 != n3 && (n2 = n4 + n3 >> 1) != n5) {
            if (escSeqStateTable_Key_2022[n2] > n6) {
                n4 = n2;
            } else if (escSeqStateTable_Key_2022[n2] < n6) {
                n3 = n2;
            } else {
                nArray[0] = n6;
                nArray2[0] = n2;
                return escSeqStateTable_Value_2022[n2];
            }
            n5 = n2;
        }
        return -1;
    }

    private static CoderResult toUnicodeCallback(CharsetDecoderICU charsetDecoderICU, int n2, int n3) {
        CoderResult coderResult = CoderResult.UNDERFLOW;
        if (n2 > 255) {
            charsetDecoderICU.toUBytesArray[0] = (byte)(n2 >> 8);
            charsetDecoderICU.toUBytesArray[1] = (byte)n2;
            charsetDecoderICU.toULength = 2;
        } else {
            charsetDecoderICU.toUBytesArray[0] = (byte)n2;
            charsetDecoderICU.toULength = 1;
        }
        coderResult = n3 == 65534 ? CoderResult.unmappableForLength(1) : CoderResult.malformedForLength(1);
        return coderResult;
    }

    @Override
    public CharsetDecoder newDecoder() {
        switch (this.variant) {
            case 1: {
                return new CharsetDecoderISO2022JP(this);
            }
            case 3: {
                return new CharsetDecoderISO2022CN(this);
            }
            case 2: {
                this.setInitialStateToUnicodeKR();
                return new CharsetDecoderISO2022KR(this);
            }
        }
        return null;
    }

    @Override
    public CharsetEncoder newEncoder() {
        switch (this.variant) {
            case 1: {
                return new CharsetEncoderISO2022JP(this);
            }
            case 3: {
                return new CharsetEncoderISO2022CN(this);
            }
            case 2: {
                CharsetEncoderISO2022KR charsetEncoderISO2022KR = new CharsetEncoderISO2022KR(this);
                this.setInitialStateFromUnicodeKR(charsetEncoderISO2022KR);
                return charsetEncoderISO2022KR;
            }
        }
        return null;
    }

    private void setInitialStateToUnicodeKR() {
        if (this.myConverterData.version == 1) {
            this.myConverterData.currentDecoder.toUnicodeStatus = 0;
            this.myConverterData.currentDecoder.mode = 0;
            this.myConverterData.currentDecoder.toULength = 0;
        }
    }

    private void setInitialStateFromUnicodeKR(CharsetEncoderICU charsetEncoderICU) {
        if (charsetEncoderICU.errorBufferLength == 0) {
            charsetEncoderICU.errorBufferLength = 4;
            charsetEncoderICU.errorBuffer[0] = 27;
            charsetEncoderICU.errorBuffer[1] = 36;
            charsetEncoderICU.errorBuffer[2] = 41;
            charsetEncoderICU.errorBuffer[3] = 67;
        }
        if (this.myConverterData.version == 1) {
            ((CharsetMBCS)this.myConverterData.currentEncoder.charset()).subChar1 = (byte)26;
            this.myConverterData.currentEncoder.fromUChar32 = 0;
            this.myConverterData.currentEncoder.fromUnicodeStatus = 1;
        }
    }

    @Override
    void getUnicodeSetImpl(UnicodeSet unicodeSet, int n2) {
        switch (this.variant) {
            case 1: {
                unicodeSet.add(165);
                unicodeSet.add(8254);
                if ((jpCharsetMasks[this.myConverterData.version] & CharsetISO2022.CSM((short)1)) != 0) {
                    unicodeSet.add(0, 255);
                } else {
                    unicodeSet.add(0, 127);
                }
                if (this.myConverterData.version != 3 && this.myConverterData.version != 4 && n2 != 1) break;
                unicodeSet.add(65377, 65439);
                break;
            }
            case 3: {
                unicodeSet.add(0, 127);
                break;
            }
            case 2: {
                this.myConverterData.currentConverter.getUnicodeSetImpl(unicodeSet, n2);
                break;
            }
        }
        for (int i2 = 0; i2 < 10; ++i2) {
            if (this.myConverterData.myConverterArray[i2] == null) continue;
            int n3 = this.variant == 3 && this.myConverterData.version == 0 && i2 == 3 ? 3 : (this.variant == 1 && i2 == 4 ? 4 : (i2 == 7 ? 5 : 1));
            this.myConverterData.currentConverter.MBCSGetFilteredUnicodeSetForUnicode(this.myConverterData.myConverterArray[i2], unicodeSet, n2, n3);
        }
        unicodeSet.remove(14);
        unicodeSet.remove(15);
        unicodeSet.remove(27);
        unicodeSet.remove(128, 159);
    }

    private class CharsetEncoderISO2022KR
    extends CharsetEncoderICU {
        public CharsetEncoderISO2022KR(CharsetICU charsetICU) {
            super(charsetICU, CharsetISO2022.this.fromUSubstitutionChar[((CharsetISO2022)CharsetISO2022.this).myConverterData.version]);
        }

        @Override
        protected void implReset() {
            super.implReset();
            CharsetISO2022.this.myConverterData.reset();
            CharsetISO2022.this.setInitialStateFromUnicodeKR(this);
        }

        @Override
        CoderResult cbFromUWriteSub(CharsetEncoderICU charsetEncoderICU, CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer) {
            CoderResult coderResult = CoderResult.UNDERFLOW;
            byte[] byArray = new byte[8];
            int n2 = 0;
            byte[] byArray2 = charsetEncoderICU.replacement();
            int n3 = byArray2.length;
            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.version == 0) {
                if (n3 == 1) {
                    if (charsetEncoderICU.fromUnicodeStatus != 0) {
                        charsetEncoderICU.fromUnicodeStatus = 0;
                        byArray[n2++] = 15;
                    }
                    byArray[n2++] = byArray2[0];
                } else {
                    if (charsetEncoderICU.fromUnicodeStatus == 0) {
                        charsetEncoderICU.fromUnicodeStatus = 1;
                        byArray[n2++] = 14;
                    }
                    byArray[n2++] = byArray2[0];
                    byArray[n2++] = byArray2[1];
                }
                coderResult = CharsetEncoderICU.fromUWriteBytes(this, byArray, 0, n2, byteBuffer, intBuffer, charBuffer.position() - 1);
            } else {
                byte[] byArray3 = ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.replacement();
                ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.replaceWith(byArray2);
                ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentConverter.subChar1 = CharsetISO2022.this.fromUSubstitutionChar[0][0];
                ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.fromUChar32 = charsetEncoderICU.fromUChar32;
                coderResult = ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.cbFromUWriteSub(((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder, charBuffer, byteBuffer, intBuffer);
                charsetEncoderICU.fromUChar32 = ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.fromUChar32;
                ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.replaceWith(byArray3);
                if (coderResult.isOverflow()) {
                    if (((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.errorBufferLength > 0) {
                        charsetEncoderICU.errorBuffer = (byte[])((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.errorBuffer.clone();
                    }
                    charsetEncoderICU.errorBufferLength = ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.errorBufferLength;
                    ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.errorBufferLength = 0;
                }
            }
            return coderResult;
        }

        private CoderResult encodeLoopIBM(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, boolean bl2) {
            CoderResult coderResult = CoderResult.UNDERFLOW;
            ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.fromUChar32 = this.fromUChar32;
            coderResult = ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.cnvMBCSFromUnicodeWithOffsets(charBuffer, byteBuffer, intBuffer, bl2);
            this.fromUChar32 = ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.fromUChar32;
            if (coderResult.isOverflow()) {
                if (((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.errorBufferLength > 0) {
                    this.errorBuffer = (byte[])((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.errorBuffer.clone();
                }
                this.errorBufferLength = ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.errorBufferLength;
                ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.errorBufferLength = 0;
            }
            return coderResult;
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, boolean bl2) {
            int n2;
            CoderResult coderResult = CoderResult.UNDERFLOW;
            int[] nArray = new int[]{0};
            int n3 = 0;
            int n4 = 0;
            boolean bl3 = false;
            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.version == 1) {
                return this.encodeLoopIBM(charBuffer, byteBuffer, intBuffer, bl2);
            }
            boolean bl4 = this.useFallback;
            boolean bl5 = this.fromUnicodeStatus != 0;
            n3 = this.fromUChar32;
            if (n3 != 0 && byteBuffer.hasRemaining()) {
                bl3 = true;
            }
            while (charBuffer.hasRemaining() || bl3) {
                nArray[0] = 65535;
                if (byteBuffer.hasRemaining() || bl3) {
                    if (!bl3) {
                        n3 = charBuffer.get();
                        if (CharsetISO2022.IS_2022_CONTROL(n3)) {
                            coderResult = CoderResult.malformedForLength(1);
                            this.fromUChar32 = n3;
                            break;
                        }
                        ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentConverter.sharedData.mbcs.outputType = 1;
                        n4 = ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.fromUChar32(n3, nArray, bl4);
                        if (n4 < 0) {
                            n4 = -n4;
                        }
                        if (n4 > 2 || n4 == 0 || n4 == 1 && nArray[0] > 127 || n4 == 2 && ((char)(nArray[0] - 41377) > '\u5d5d' || (nArray[0] - 161 & 0xFF) > 93)) {
                            nArray[0] = 65535;
                        }
                    }
                    if (!bl3 && nArray[0] != 65535) {
                        boolean bl6 = bl5;
                        boolean bl7 = bl5 = nArray[0] > 255;
                        if (bl6 != bl5) {
                            if (bl5) {
                                byteBuffer.put((byte)14);
                            } else {
                                byteBuffer.put((byte)15);
                            }
                            if (intBuffer != null) {
                                intBuffer.put(charBuffer.position() - 1);
                            }
                        }
                        if (nArray[0] <= 255) {
                            if (byteBuffer.hasRemaining()) {
                                byteBuffer.put((byte)nArray[0]);
                                if (intBuffer == null) continue;
                                intBuffer.put(charBuffer.position() - 1);
                                continue;
                            }
                            this.errorBuffer[this.errorBufferLength++] = (byte)nArray[0];
                            coderResult = CoderResult.OVERFLOW;
                            continue;
                        }
                        if (byteBuffer.hasRemaining()) {
                            byteBuffer.put((byte)(0xFF & (nArray[0] >> 8) - 128));
                            if (intBuffer != null) {
                                intBuffer.put(charBuffer.position() - 1);
                            }
                            if (byteBuffer.hasRemaining()) {
                                byteBuffer.put((byte)(0xFF & nArray[0] - 128));
                                if (intBuffer == null) continue;
                                intBuffer.put(charBuffer.position() - 1);
                                continue;
                            }
                            this.errorBuffer[this.errorBufferLength++] = (byte)(0xFF & nArray[0] - 128);
                            coderResult = CoderResult.OVERFLOW;
                            continue;
                        }
                        this.errorBuffer[this.errorBufferLength++] = (byte)(0xFF & (nArray[0] >> 8) - 128);
                        this.errorBuffer[this.errorBufferLength++] = (byte)(0xFF & nArray[0] - 128);
                        coderResult = CoderResult.OVERFLOW;
                        continue;
                    }
                    if (bl3 || UTF16.isSurrogate(n3)) {
                        if (bl3 || UTF16.isLeadSurrogate(n3)) {
                            bl3 = false;
                            if (charBuffer.hasRemaining()) {
                                n2 = charBuffer.get();
                                charBuffer.position(charBuffer.position() - 1);
                                if (UTF16.isTrailSurrogate(n2)) {
                                    charBuffer.get();
                                    n3 = UCharacter.getCodePoint(n3, n2);
                                    coderResult = CoderResult.unmappableForLength(2);
                                } else {
                                    coderResult = CoderResult.malformedForLength(1);
                                }
                            } else {
                                coderResult = CoderResult.UNDERFLOW;
                            }
                        } else {
                            coderResult = CoderResult.malformedForLength(1);
                        }
                    } else {
                        coderResult = CoderResult.unmappableForLength(1);
                    }
                    this.fromUChar32 = n3;
                    break;
                }
                coderResult = CoderResult.OVERFLOW;
                break;
            }
            if (!coderResult.isError() && bl5 && bl2 && !charBuffer.hasRemaining() && this.fromUChar32 == 0) {
                bl5 = false;
                n2 = charBuffer.position();
                if (n2 > 0) {
                    if (UTF16.isTrailSurrogate(charBuffer.get(--n2)) && UTF16.isLeadSurrogate(charBuffer.get(n2 - 1))) {
                        --n2;
                    }
                } else {
                    n2 = -1;
                }
                CharsetEncoderICU.fromUWriteBytes(this, SHIFT_IN_STR, 0, 1, byteBuffer, intBuffer, n2);
            }
            this.fromUnicodeStatus = bl5 ? 1 : 0;
            return coderResult;
        }
    }

    private class CharsetEncoderISO2022CN
    extends CharsetEncoderICU {
        public CharsetEncoderISO2022CN(CharsetICU charsetICU) {
            super(charsetICU, CharsetISO2022.this.fromUSubstitutionChar[0]);
        }

        @Override
        protected void implReset() {
            super.implReset();
            CharsetISO2022.this.myConverterData.reset();
        }

        @Override
        CoderResult cbFromUWriteSub(CharsetEncoderICU charsetEncoderICU, CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer) {
            CoderResult coderResult = CoderResult.UNDERFLOW;
            byte[] byArray = new byte[8];
            int n2 = 0;
            byte[] byArray2 = charsetEncoderICU.replacement();
            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g != 0) {
                ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g = (byte)0;
                byArray[n2++] = 15;
            }
            byArray[n2++] = byArray2[0];
            coderResult = CharsetEncoderICU.fromUWriteBytes(this, byArray, 0, n2, byteBuffer, intBuffer, charBuffer.position() - 1);
            return coderResult;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, boolean bl2) {
            int n2;
            CoderResult coderResult = CoderResult.UNDERFLOW;
            byte[] byArray = new byte[8];
            byte[] byArray2 = new byte[3];
            int n3 = 0;
            boolean bl3 = false;
            int n4 = 0;
            int n5 = this.fromUChar32;
            if (n5 != 0 && byteBuffer.hasRemaining()) {
                bl3 = true;
            }
            while (charBuffer.hasRemaining() || bl3) {
                int n6;
                block49: {
                    int n7;
                    boolean bl4;
                    int n8;
                    int n9;
                    int n10;
                    block50: {
                        block47: {
                            block48: {
                                block46: {
                                    if (!byteBuffer.hasRemaining() && !bl3) break block47;
                                    n10 = charBuffer.position();
                                    if (!bl3) {
                                        n5 = charBuffer.get();
                                    }
                                    if (UTF16.isSurrogate(n5) || bl3) {
                                        if (UTF16.isLeadSurrogate(n5) || bl3) {
                                            bl3 = false;
                                            if (charBuffer.hasRemaining()) {
                                                n2 = charBuffer.get();
                                                charBuffer.position(charBuffer.position() - 1);
                                                if (UTF16.isTrailSurrogate(n2)) {
                                                    charBuffer.get();
                                                    n5 = UCharacter.getCodePoint(n5, n2);
                                                    this.fromUChar32 = 0;
                                                    break block46;
                                                } else {
                                                    coderResult = CoderResult.malformedForLength(1);
                                                    this.fromUChar32 = n5;
                                                    break;
                                                }
                                            }
                                            this.fromUChar32 = n5;
                                            break;
                                        }
                                        coderResult = CoderResult.malformedForLength(1);
                                        this.fromUChar32 = n5;
                                        break;
                                    }
                                }
                                if (n5 > 127) break block48;
                                if (CharsetISO2022.IS_2022_CONTROL(n5)) {
                                    coderResult = CoderResult.malformedForLength(1);
                                    this.fromUChar32 = n5;
                                    break;
                                }
                                if (((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g == 0) {
                                    byArray[0] = (byte)n5;
                                    n6 = 1;
                                } else {
                                    byArray[0] = 15;
                                    byArray[1] = (byte)n5;
                                    n6 = 2;
                                    ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g = (byte)0;
                                    n4 = 0;
                                }
                                if (n5 == 13 || n5 == 10) {
                                    ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.reset();
                                    n4 = 0;
                                }
                                break block49;
                            }
                            if (n4 == 0) {
                                byArray2[0] = ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.cs[1];
                                if (byArray2[0] == 0) {
                                    byArray2[0] = 1;
                                }
                                if (((CharsetISO2022)CharsetISO2022.this).myConverterData.version == 0) {
                                    byArray2[1] = byArray2[0] == 1 ? 33 : 1;
                                    n4 = 2;
                                } else if (((CharsetISO2022)CharsetISO2022.this).myConverterData.version == 1) {
                                    switch (byArray2[0]) {
                                        case 1: {
                                            byArray2[1] = 33;
                                            byArray2[2] = 2;
                                            break;
                                        }
                                        case 2: {
                                            byArray2[1] = 1;
                                            byArray2[2] = 33;
                                            break;
                                        }
                                        default: {
                                            byArray2[1] = 1;
                                            byArray2[2] = 2;
                                        }
                                    }
                                    n4 = 3;
                                } else {
                                    byArray2[0] = 33;
                                    byArray2[1] = 1;
                                    n4 = 2;
                                }
                            }
                            n9 = 0;
                            n8 = 0;
                            n6 = 0;
                            bl4 = this.useFallback;
                            break block50;
                        }
                        coderResult = CoderResult.OVERFLOW;
                        break;
                    }
                    for (n2 = 0; n2 < n4 && n6 <= 0; ++n2) {
                        int n11;
                        n7 = byArray2[n2];
                        if (n7 <= 0) continue;
                        int[] nArray = new int[1];
                        if (n7 > 32) {
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentConverter.sharedData = ((CharsetISO2022)CharsetISO2022.this).myConverterData.myConverterArray[3];
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentConverter.sharedData.mbcs.outputType = (short)2;
                            n11 = ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.fromUChar32(n5, nArray, bl4);
                            if (n11 != 3 && (n11 != -3 || n6 != 0)) continue;
                            n3 = nArray[0];
                            n8 = (byte)(32 + (nArray[0] >> 16) - 128);
                            if (n11 >= 0) {
                                n6 = 2;
                            } else {
                                n6 = -2;
                                bl4 = false;
                            }
                            if (n8 == 33) {
                                n9 = 1;
                                continue;
                            }
                            if (n8 == 34) {
                                n9 = 2;
                                continue;
                            }
                            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.version == 1) {
                                n9 = 3;
                                continue;
                            }
                            n6 = 0;
                            continue;
                        }
                        ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentConverter.sharedData = ((CharsetISO2022)CharsetISO2022.this).myConverterData.myConverterArray[n7];
                        ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentConverter.sharedData.mbcs.outputType = 1;
                        n11 = ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.fromUChar32(n5, nArray, bl4);
                        if (n11 != 2 && (n11 != -2 || n6 != 0)) continue;
                        n3 = nArray[0];
                        n6 = n11;
                        n8 = n7;
                        n9 = 1;
                        bl4 = false;
                    }
                    if (n6 == 0) {
                        coderResult = CoderResult.unmappableForLength(charBuffer.position() - n10);
                        this.fromUChar32 = n5;
                        break;
                    }
                    n6 = 0;
                    if (n8 != ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.cs[n9]) {
                        if (n8 < 3) {
                            for (n7 = 0; n7 < escSeqCharsCN[n8].length; ++n7) {
                                byArray[n7] = escSeqCharsCN[n8][n7];
                            }
                        } else {
                            for (n7 = 0; n7 < escSeqCharsCN[3 + (n8 - 33)].length; ++n7) {
                                byArray[n7] = escSeqCharsCN[3 + (n8 - 33)][n7];
                            }
                        }
                        n6 = 4;
                        ((ISO2022State)((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State).cs[n9] = n8;
                        if (n9 == 1) {
                            n4 = 0;
                        }
                    }
                    if (n9 != ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g) {
                        switch (n9) {
                            case 1: {
                                byArray[n6++] = 14;
                                ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g = (byte)1;
                                break;
                            }
                            case 2: {
                                byArray[n6++] = 27;
                                byArray[n6++] = 78;
                                break;
                            }
                            default: {
                                byArray[n6++] = 27;
                                byArray[n6++] = 79;
                            }
                        }
                    }
                    byArray[n6++] = (byte)(n3 >> 8);
                    byArray[n6++] = (byte)n3;
                }
                if (n6 == 1) {
                    byteBuffer.put(byArray[0]);
                    if (intBuffer == null) continue;
                    intBuffer.put(charBuffer.position() - 1);
                    continue;
                }
                if (n6 == 2 && byteBuffer.remaining() >= 2) {
                    byteBuffer.put(byArray[0]);
                    byteBuffer.put(byArray[1]);
                    if (intBuffer == null) continue;
                    n2 = charBuffer.position();
                    intBuffer.put(n2);
                    intBuffer.put(n2);
                    continue;
                }
                coderResult = CharsetEncoderICU.fromUWriteBytes(this, byArray, 0, n6, byteBuffer, intBuffer, charBuffer.position() - 1);
                if (!coderResult.isError()) continue;
            }
            if (coderResult.isError()) return coderResult;
            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g == 0) return coderResult;
            if (!bl2) return coderResult;
            if (charBuffer.hasRemaining()) return coderResult;
            if (this.fromUChar32 != 0) return coderResult;
            ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g = (byte)0;
            n2 = charBuffer.position();
            if (n2 > 0) {
                if (!UTF16.isTrailSurrogate(charBuffer.get(--n2))) return CharsetEncoderICU.fromUWriteBytes(this, SHIFT_IN_STR, 0, 1, byteBuffer, intBuffer, n2);
                if (n2 != 0) {
                    if (!UTF16.isLeadSurrogate(charBuffer.get(n2 - 1))) return CharsetEncoderICU.fromUWriteBytes(this, SHIFT_IN_STR, 0, 1, byteBuffer, intBuffer, n2);
                }
                --n2;
                return CharsetEncoderICU.fromUWriteBytes(this, SHIFT_IN_STR, 0, 1, byteBuffer, intBuffer, n2);
            } else {
                n2 = -1;
            }
            return CharsetEncoderICU.fromUWriteBytes(this, SHIFT_IN_STR, 0, 1, byteBuffer, intBuffer, n2);
        }
    }

    private class CharsetEncoderISO2022JP
    extends CharsetEncoderICU {
        public CharsetEncoderISO2022JP(CharsetICU charsetICU) {
            super(charsetICU, CharsetISO2022.this.fromUSubstitutionChar[0]);
        }

        @Override
        protected void implReset() {
            super.implReset();
            CharsetISO2022.this.myConverterData.reset();
        }

        private int jisx201FromU(int n2) {
            if (n2 <= 127) {
                if (n2 != 92 && n2 != 126) {
                    return n2;
                }
            } else {
                if (n2 == 165) {
                    return 92;
                }
                if (n2 == 8254) {
                    return 126;
                }
            }
            return 65534;
        }

        private int _2022FromSJIS(int n2) {
            if (n2 > 61436) {
                return 0;
            }
            short s2 = (short)(n2 & 0xFF);
            n2 = (n2 &= 0xFF00) <= 40704 ? (n2 -= 28672) : (n2 -= 45056);
            n2 <<= 1;
            if (s2 <= 158) {
                n2 -= 256;
                n2 = s2 <= 126 ? (n2 |= s2 - 31 & 0xFF) : (n2 |= s2 - 32 & 0xFF);
            } else {
                n2 |= s2 - 126 & 0xFF;
            }
            return n2;
        }

        @Override
        CoderResult cbFromUWriteSub(CharsetEncoderICU charsetEncoderICU, CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer) {
            byte by2;
            CoderResult coderResult = CoderResult.UNDERFLOW;
            byte[] byArray = new byte[8];
            int n2 = 0;
            byte[] byArray2 = charsetEncoderICU.replacement();
            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g == 1) {
                ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g = (byte)0;
                byArray[n2++] = 15;
            }
            if ((by2 = ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.cs[0]) != 0 && by2 != 3) {
                ((ISO2022State)((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State).cs[0] = 0;
                byArray[n2++] = 27;
                byArray[n2++] = 40;
                byArray[n2++] = 66;
            }
            byArray[n2++] = byArray2[0];
            coderResult = CharsetEncoderICU.fromUWriteBytes(this, byArray, 0, n2, byteBuffer, intBuffer, charBuffer.position() - 1);
            return coderResult;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, boolean bl2) {
            int n2;
            int n3;
            int n4;
            CoderResult coderResult = CoderResult.UNDERFLOW;
            byte[] byArray = new byte[10];
            int n5 = 0;
            byte[] byArray2 = new byte[8];
            boolean bl3 = false;
            int n6 = 0;
            int n7 = this.fromUChar32;
            if (n7 != 0 && byteBuffer.hasRemaining()) {
                bl3 = true;
            }
            while (bl3 || charBuffer.hasRemaining()) {
                boolean bl4;
                int n8;
                byte by2;
                byte by3;
                int n9;
                if (bl3 || byteBuffer.hasRemaining()) {
                    block50: {
                        n9 = charBuffer.position();
                        if (!bl3) {
                            n7 = charBuffer.get();
                        }
                        if (bl3 || UTF16.isSurrogate(n7)) {
                            if (bl3 || UTF16.isLeadSurrogate(n7)) {
                                if (bl3) {
                                    bl3 = false;
                                }
                                if (charBuffer.hasRemaining()) {
                                    n4 = charBuffer.get();
                                    charBuffer.position(charBuffer.position() - 1);
                                    if (UTF16.isTrailSurrogate(n4)) {
                                        charBuffer.get();
                                        n7 = UCharacter.getCodePoint(n7, n4);
                                        this.fromUChar32 = 0;
                                        break block50;
                                    } else {
                                        coderResult = CoderResult.malformedForLength(1);
                                        this.fromUChar32 = n7;
                                        break;
                                    }
                                }
                                this.fromUChar32 = n7;
                                break;
                            }
                            coderResult = CoderResult.malformedForLength(1);
                            this.fromUChar32 = n7;
                            break;
                        }
                    }
                    if (CharsetISO2022.IS_2022_CONTROL(n7)) {
                        coderResult = CoderResult.malformedForLength(1);
                        this.fromUChar32 = n7;
                        break;
                    }
                    if (n6 == 0) {
                        n4 = (char)jpCharsetMasks[((CharsetISO2022)CharsetISO2022.this).myConverterData.version];
                        n6 = 0;
                        if (((CharsetISO2022)CharsetISO2022.this).myConverterData.version == 3 || ((CharsetISO2022)CharsetISO2022.this).myConverterData.version == 4) {
                            byArray[n6++] = 8;
                        }
                        n4 = (char)(n4 & ~CharsetISO2022.CSM((short)8));
                        byArray[n6++] = by3 = ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.cs[0];
                        n4 = (char)(n4 & ~CharsetISO2022.CSM(by3));
                        by3 = ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.cs[2];
                        if (by3 != 0) {
                            byArray[n6++] = by3;
                            n4 = (char)(n4 & ~CharsetISO2022.CSM(by3));
                        }
                        for (n3 = 0; n3 < jpCharsetPref.length; ++n3) {
                            by3 = jpCharsetPref[n3];
                            if ((CharsetISO2022.CSM(by3) & n4) == 0) continue;
                            byArray[n6++] = by3;
                            n4 = (char)(n4 & ~CharsetISO2022.CSM(by3));
                        }
                    }
                    by2 = 0;
                    by3 = 0;
                    n8 = 0;
                    bl4 = this.useFallback;
                } else {
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
                block13: for (n4 = 0; n4 < n6 && n8 <= 0; ++n4) {
                    int[] nArray = new int[1];
                    byte by4 = byArray[n4];
                    switch (by4) {
                        case 0: {
                            if (n7 > 127) continue block13;
                            n5 = n7;
                            n8 = 1;
                            by3 = by4;
                            by2 = 0;
                            continue block13;
                        }
                        case 1: {
                            if (160 > n7 || n7 > 255) continue block13;
                            n5 = n7 - 128;
                            n8 = 1;
                            by3 = by4;
                            by2 = 2;
                            continue block13;
                        }
                        case 8: {
                            if (n7 > 65439 || n7 < 65377) continue block13;
                            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.version == 3) {
                                n5 = (int)(0xFFFFFFFFL & (long)(n7 - 65344));
                                n8 = 1;
                                ((ISO2022State)((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State).cs[1] = by3 = by4;
                                by2 = 1;
                                continue block13;
                            }
                            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.version != 4) continue block13;
                            n5 = (int)(0xFFFFFFFFL & (long)(n7 - 65216));
                            n8 = 1;
                            by3 = ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.cs[0];
                            if (CharsetISO2022.IS_JP_DBCS(by3)) {
                                by3 = 3;
                            }
                            by2 = 0;
                            continue block13;
                        }
                        case 3: {
                            nArray[0] = this.jisx201FromU(n7);
                            if (nArray[0] > 127) continue block13;
                            n5 = nArray[0];
                            n8 = 1;
                            by3 = by4;
                            by2 = 0;
                            bl4 = false;
                            continue block13;
                        }
                        case 4: {
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentConverter.sharedData = ((CharsetISO2022)CharsetISO2022.this).myConverterData.myConverterArray[by4];
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentConverter.sharedData.mbcs.outputType = 1;
                            int n10 = ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.fromUChar32(n7, nArray, bl4);
                            if (n10 == 2 || n10 == -2 && n8 == 0) {
                                nArray[0] = this._2022FromSJIS(nArray[0]);
                                if (nArray[0] == 0) continue block13;
                                n5 = nArray[0];
                                n8 = n10;
                                by3 = by4;
                                by2 = 0;
                                bl4 = false;
                                continue block13;
                            }
                            if (n8 != 0 || !bl4 || n7 > 65439 || n7 < 65377) continue block13;
                            n5 = hwkana_fb[n7 - 65377];
                            n8 = -2;
                            by3 = by4;
                            by2 = 0;
                            bl4 = false;
                            continue block13;
                        }
                        case 2: {
                            int n10 = CharsetISO2022.MBCSSingleFromUChar32(((CharsetISO2022)CharsetISO2022.this).myConverterData.myConverterArray[by4], n7, nArray, bl4);
                            if (n10 == 0 || n10 < 0 && n8 != 0 || 160 > nArray[0] || nArray[0] > 255) continue block13;
                            n5 = nArray[0] - 128;
                            n8 = n10;
                            by3 = by4;
                            by2 = 2;
                            bl4 = false;
                            continue block13;
                        }
                        default: {
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentConverter.sharedData = ((CharsetISO2022)CharsetISO2022.this).myConverterData.myConverterArray[by4];
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentConverter.sharedData.mbcs.outputType = 1;
                            int n10 = ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.fromUChar32(n7, nArray, bl4);
                            if (n10 != 2 && (n10 != -2 || n8 != 0)) continue block13;
                            if (by4 == 7) {
                                nArray[0] = CharsetISO2022._2022FromGR94DBCS(nArray[0]);
                                if (nArray[0] == 0) continue block13;
                            }
                            n5 = nArray[0];
                            n8 = n10;
                            by3 = by4;
                            by2 = 0;
                            bl4 = false;
                        }
                    }
                }
                if (n8 == 0) {
                    coderResult = CoderResult.unmappableForLength(charBuffer.position() - n9);
                    this.fromUChar32 = n7;
                    break;
                }
                if (n8 < 0) {
                    n8 = -n8;
                }
                n2 = 0;
                if (((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g == 1 && by2 == 0) {
                    byArray2[n2++] = 15;
                    ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g = (byte)0;
                }
                if (by3 != ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.cs[by2]) {
                    for (n4 = 0; n4 < escSeqChars[by3].length; ++n4) {
                        byArray2[n2++] = escSeqChars[by3][n4];
                    }
                    ((ISO2022State)((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State).cs[by2] = by3;
                    n6 = 0;
                }
                if (by2 != ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g) {
                    switch (by2) {
                        case 1: {
                            byArray2[n2++] = 14;
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g = (byte)1;
                            break;
                        }
                        default: {
                            byArray2[n2++] = 27;
                            byArray2[n2++] = 78;
                        }
                    }
                }
                if (n8 == 1) {
                    byArray2[n2++] = (byte)n5;
                } else {
                    byArray2[n2++] = (byte)(n5 >> 8);
                    byArray2[n2++] = (byte)n5;
                }
                if (n7 == 13 || n7 == 10) {
                    ((ISO2022State)((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State).cs[2] = 0;
                    n6 = 0;
                }
                if (n2 == 1) {
                    byteBuffer.put(byArray2[0]);
                    if (intBuffer == null) continue;
                    intBuffer.put(charBuffer.remaining() - 1);
                    continue;
                }
                if (n2 == 2 && byteBuffer.position() + 2 <= byteBuffer.limit()) {
                    byteBuffer.put(byArray2[0]);
                    byteBuffer.put(byArray2[1]);
                    if (intBuffer == null) continue;
                    n4 = charBuffer.position() - 1;
                    intBuffer.put(n4);
                    intBuffer.put(n4);
                    continue;
                }
                coderResult = CharsetEncoderICU.fromUWriteBytes(this, byArray2, 0, n2, byteBuffer, intBuffer, charBuffer.position() - 1);
            }
            if (coderResult.isError()) return coderResult;
            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g == 0) {
                if (((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.cs[0] == 0) return coderResult;
            }
            if (!bl2) return coderResult;
            if (charBuffer.hasRemaining()) return coderResult;
            if (this.fromUChar32 != 0) return coderResult;
            n2 = 0;
            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g != 0) {
                byArray2[n2++] = 15;
                ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g = (byte)0;
            }
            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.cs[0] != 0) {
                for (n3 = 0; n3 < escSeqChars[0].length; ++n3) {
                    byArray2[n2++] = escSeqChars[0][n3];
                }
                ((ISO2022State)((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State).cs[0] = 0;
            }
            if ((n4 = charBuffer.position()) > 0) {
                if (!UTF16.isTrailSurrogate(charBuffer.get(--n4))) return CharsetEncoderICU.fromUWriteBytes(this, byArray2, 0, n2, byteBuffer, intBuffer, n4);
                if (n4 != 0) {
                    if (!UTF16.isLeadSurrogate(charBuffer.get(n4 - 1))) return CharsetEncoderICU.fromUWriteBytes(this, byArray2, 0, n2, byteBuffer, intBuffer, n4);
                }
                --n4;
                return CharsetEncoderICU.fromUWriteBytes(this, byArray2, 0, n2, byteBuffer, intBuffer, n4);
            } else {
                n4 = -1;
            }
            return CharsetEncoderICU.fromUWriteBytes(this, byArray2, 0, n2, byteBuffer, intBuffer, n4);
        }
    }

    private class CharsetDecoderISO2022KR
    extends CharsetDecoderICU {
        public CharsetDecoderISO2022KR(CharsetICU charsetICU) {
            super(charsetICU);
        }

        @Override
        protected void implReset() {
            super.implReset();
            CharsetISO2022.this.setInitialStateToUnicodeKR();
            CharsetISO2022.this.myConverterData.reset();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, boolean bl2) {
            CoderResult coderResult = CoderResult.UNDERFLOW;
            int n2 = 0;
            int n3 = 0;
            byte[] byArray = new byte[2];
            boolean bl3 = false;
            boolean bl4 = false;
            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.version == 1) {
                return this.decodeLoopIBM(((CharsetISO2022)CharsetISO2022.this).myConverterData.currentDecoder, byteBuffer, charBuffer, intBuffer, bl2);
            }
            boolean bl5 = this.isFallbackUsed();
            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.key != 0) {
                bl4 = true;
            } else if (this.toULength == 1 && byteBuffer.hasRemaining() && charBuffer.hasRemaining()) {
                n2 = this.toUBytesArray[0] & 0xFF;
                this.toULength = 0;
                bl3 = true;
            }
            while (true) {
                int n4;
                int n5;
                if (!byteBuffer.hasRemaining() && !bl3) {
                    if (!bl4) return coderResult;
                }
                if (!charBuffer.hasRemaining() && !bl3) {
                    if (!bl4) return CoderResult.OVERFLOW;
                }
                if (!bl3 && !bl4) {
                    n2 = (char)(byteBuffer.get() & 0xFF);
                }
                if (!bl3 && !bl4 && n2 == 15) {
                    ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g = (byte)0;
                    if (!((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment) continue;
                    ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment = false;
                    coderResult = CoderResult.malformedForLength(1);
                    this.toUBytesArray[0] = (byte)n2;
                    this.toULength = 1;
                    return coderResult;
                }
                if (!bl3 && !bl4 && n2 == 14) {
                    ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g = (byte)1;
                    ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment = true;
                    continue;
                }
                if (!bl3 && (bl4 || n2 == 27)) {
                    if (!bl4) {
                        byteBuffer.position(byteBuffer.position() - 1);
                    }
                    bl4 = false;
                    ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment = false;
                    coderResult = CharsetISO2022.this.changeState_2022(this, byteBuffer, 2);
                    if (!coderResult.isError()) continue;
                    return coderResult;
                }
                ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment = false;
                if (((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g == 1 || bl3) {
                    if (!byteBuffer.hasRemaining() && !bl3) break;
                    bl3 = false;
                    short s2 = (short)(byteBuffer.get(byteBuffer.position()) & 0xFF);
                    n3 = 65535;
                    n5 = (short)(0xFF & n2 - 33) <= 93 ? 1 : 0;
                    int n6 = n4 = (short)(0xFF & s2 - 33) <= 93 ? 1 : 0;
                    if (n5 != 0 && n4 != 0) {
                        byteBuffer.get();
                        byArray[0] = (byte)(n2 + 128);
                        byArray[1] = (byte)(s2 + 128);
                        n3 = CharsetISO2022.this.MBCSSimpleGetNextUChar(((CharsetISO2022)CharsetISO2022.this).myConverterData.currentConverter.sharedData, ByteBuffer.wrap(byArray), bl5);
                        n2 = (char)(n2 << 8 | s2);
                    } else if (n4 == 0 && !CharsetISO2022.IS_2022_CONTROL(s2)) {
                        byteBuffer.get();
                        n2 = (char)(0x10000 | n2 << 8 | s2);
                    }
                } else if (n2 <= 127) {
                    n5 = byteBuffer.limit();
                    n4 = byteBuffer.position();
                    byteBuffer.limit(byteBuffer.position());
                    byteBuffer.position(byteBuffer.position() - 1);
                    n3 = CharsetISO2022.this.MBCSSimpleGetNextUChar(((CharsetISO2022)CharsetISO2022.this).myConverterData.currentConverter.sharedData, byteBuffer, bl5);
                    byteBuffer.limit(n5);
                    byteBuffer.position(n4);
                } else {
                    n3 = 65535;
                }
                if (n3 >= 65534) return CharsetISO2022.toUnicodeCallback(this, n2, n3);
                charBuffer.put((char)n3);
                if (intBuffer == null) continue;
                intBuffer.array()[charBuffer.position()] = byteBuffer.position() - (n2 <= 255 ? 1 : 2);
            }
            this.toUBytesArray[0] = (byte)n2;
            this.toULength = 1;
            return coderResult;
        }

        protected CoderResult decodeLoopIBM(CharsetMBCS.CharsetDecoderMBCS charsetDecoderMBCS, ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, boolean bl2) {
            int n2;
            CoderResult coderResult = CoderResult.UNDERFLOW;
            boolean bl3 = false;
            int n3 = n2 = byteBuffer.position();
            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.key != 0) {
                bl3 = true;
            }
            while (bl3 || !coderResult.isError() && byteBuffer.hasRemaining()) {
                if (!bl3) {
                    int n4 = byteBuffer.position();
                    int n5 = CharsetISO2022.getEndOfBuffer_2022(byteBuffer);
                    byteBuffer.position(n4);
                    if (byteBuffer.position() != n5) {
                        if (this.toULength > 0) {
                            charsetDecoderMBCS.toUBytesArray = (byte[])this.toUBytesArray.clone();
                        }
                        charsetDecoderMBCS.toULength = this.toULength;
                        int n6 = charBuffer.position();
                        int n7 = byteBuffer.limit();
                        byteBuffer.limit(n5);
                        coderResult = ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentDecoder.cnvMBCSToUnicodeWithOffsets(byteBuffer, charBuffer, intBuffer, bl2);
                        byteBuffer.limit(n7);
                        if (intBuffer != null && n3 != n2) {
                            int n8 = n2 - n3;
                            while (n6 < charBuffer.position()) {
                                int n9 = intBuffer.get();
                                intBuffer.position(intBuffer.position() - 1);
                                if (n9 >= 0) {
                                    intBuffer.put(n9 + n8);
                                    intBuffer.position(intBuffer.position() - 1);
                                }
                                intBuffer.get();
                                charBuffer.get();
                            }
                        }
                        n2 = byteBuffer.position();
                        if (charsetDecoderMBCS.toULength > 0) {
                            this.toUBytesArray = (byte[])charsetDecoderMBCS.toUBytesArray.clone();
                        }
                        this.toULength = charsetDecoderMBCS.toULength;
                        if (coderResult.isOverflow()) {
                            if (charsetDecoderMBCS.charErrorBufferLength > 0) {
                                this.charErrorBufferArray = (char[])charsetDecoderMBCS.charErrorBufferArray.clone();
                            }
                            this.charErrorBufferLength = charsetDecoderMBCS.charErrorBufferLength;
                            charsetDecoderMBCS.charErrorBufferLength = 0;
                        }
                    }
                    if (coderResult.isError() || coderResult.isOverflow() || byteBuffer.position() == byteBuffer.limit()) {
                        return coderResult;
                    }
                }
                bl3 = false;
                coderResult = CharsetISO2022.this.changeState_2022(this, byteBuffer, 2);
            }
            return coderResult;
        }
    }

    private class CharsetDecoderISO2022CN
    extends CharsetDecoderICU {
        public CharsetDecoderISO2022CN(CharsetICU charsetICU) {
            super(charsetICU);
        }

        @Override
        protected void implReset() {
            super.implReset();
            CharsetISO2022.this.myConverterData.reset();
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, boolean bl2) {
            CoderResult coderResult = CoderResult.UNDERFLOW;
            byte[] byArray = new byte[3];
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            boolean bl3 = false;
            boolean bl4 = false;
            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.key != 0) {
                bl3 = true;
            } else if (this.toULength == 1 && byteBuffer.hasRemaining() && charBuffer.hasRemaining()) {
                n3 = this.toUBytesArray[0] & 0xFF;
                this.toULength = 0;
                n2 = 65535;
                bl4 = true;
            }
            block6: while (byteBuffer.hasRemaining() || bl4 || bl3) {
                n2 = 65535;
                if (charBuffer.hasRemaining() || bl3) {
                    n4 = bl3 ? (n3 = 27) : (bl4 ? 255 : (n3 = 0xFF & byteBuffer.get()));
                    switch (n4) {
                        case 15: {
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g = (byte)0;
                            if (!((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment) continue block6;
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment = false;
                            coderResult = CoderResult.malformedForLength(1);
                            this.toUBytesArray[0] = (byte)n3;
                            this.toULength = 1;
                            return coderResult;
                        }
                        case 14: {
                            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.cs[1] != 0) {
                                ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g = (byte)1;
                                ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment = true;
                                continue block6;
                            }
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment = false;
                            break;
                        }
                        case 27: {
                            if (!bl3) {
                                byteBuffer.position(byteBuffer.position() - 1);
                            }
                            bl3 = false;
                            int n5 = byteBuffer.position();
                            int n6 = this.toULength;
                            coderResult = CharsetISO2022.this.changeState_2022(this, byteBuffer, 3);
                            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.key == 0 && !coderResult.isError() && ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment) {
                                coderResult = CoderResult.malformedForLength(byteBuffer.position() - n5);
                                this.toULength = n6 + (byteBuffer.position() - n5);
                            }
                            if (!coderResult.isError()) continue block6;
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment = false;
                            return coderResult;
                        }
                        case 10: 
                        case 13: {
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.reset();
                        }
                        default: {
                            int n6;
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment = false;
                            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g != 0 || bl4) {
                                if (byteBuffer.hasRemaining() || bl4) {
                                    boolean bl5;
                                    bl4 = false;
                                    short s2 = (short)(byteBuffer.get(byteBuffer.position()) & 0xFF);
                                    boolean bl6 = (short)(0xFF & n3 - 33) <= 93;
                                    boolean bl7 = bl5 = (short)(0xFF & s2 - 33) <= 93;
                                    if (bl6 && bl5) {
                                        int n7;
                                        UConverterSharedData uConverterSharedData;
                                        byteBuffer.get();
                                        n6 = ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.cs[((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g];
                                        if (n6 > 32) {
                                            uConverterSharedData = ((CharsetISO2022)CharsetISO2022.this).myConverterData.myConverterArray[3];
                                            byArray[0] = (byte)(128 + (n6 - 32));
                                            byArray[1] = (byte)n3;
                                            byArray[2] = (byte)s2;
                                            n7 = 3;
                                        } else {
                                            uConverterSharedData = ((CharsetISO2022)CharsetISO2022.this).myConverterData.myConverterArray[n6];
                                            byArray[0] = (byte)n3;
                                            byArray[1] = (byte)s2;
                                            n7 = 2;
                                        }
                                        ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray);
                                        byteBuffer2.limit(n7);
                                        n2 = CharsetISO2022.this.MBCSSimpleGetNextUChar(uConverterSharedData, byteBuffer2, false);
                                        n3 = n3 << 8 | s2;
                                    } else if (!bl5 && !CharsetISO2022.IS_2022_CONTROL(s2)) {
                                        byteBuffer.get();
                                        n3 = 0x10000 | n3 << 8 | s2;
                                    }
                                    if (((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g < 2) break;
                                    ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g = ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.prevG;
                                    break;
                                }
                                this.toUBytesArray[0] = (byte)n3;
                                this.toULength = 1;
                                return coderResult;
                            }
                            if (n3 > 127) break;
                            n2 = (char)n3;
                        }
                    }
                    if ((0xFFFFFFFFL & (long)n2) < 65534L) {
                        if (intBuffer != null) {
                            intBuffer.array()[charBuffer.position()] = byteBuffer.remaining() - (n3 <= 255 ? 1 : 2);
                        }
                        charBuffer.put((char)n2);
                        continue;
                    }
                    if ((0xFFFFFFFFL & (long)n2) > 65535L) {
                        charBuffer.put((char)(55296 + (char)((n2 -= 65536) >> 10)));
                        if (intBuffer != null) {
                            intBuffer.array()[charBuffer.position() - 1] = byteBuffer.position() - (n3 <= 255 ? 1 : 2);
                        }
                        if (charBuffer.hasRemaining()) {
                            charBuffer.put((char)(56320 + (char)(n2 & 0x3FF)));
                            if (intBuffer == null) continue;
                            intBuffer.array()[charBuffer.position() - 1] = byteBuffer.position() - (n3 <= 255 ? 1 : 2);
                            continue;
                        }
                        this.charErrorBufferArray[this.charErrorBufferLength++] = (char)(56320 + (char)(n2 & 0x3FF));
                        continue;
                    }
                    coderResult = CharsetISO2022.toUnicodeCallback(this, n3, n2);
                    break;
                }
                coderResult = CoderResult.OVERFLOW;
                break;
            }
            return coderResult;
        }
    }

    private class CharsetDecoderISO2022JP
    extends CharsetDecoderICU {
        public CharsetDecoderISO2022JP(CharsetICU charsetICU) {
            super(charsetICU);
        }

        @Override
        protected void implReset() {
            super.implReset();
            CharsetISO2022.this.myConverterData.reset();
        }

        private int jisx201ToU(int n2) {
            if (n2 < 92) {
                return n2;
            }
            if (n2 == 92) {
                return 165;
            }
            if (n2 == 126) {
                return 8254;
            }
            return n2;
        }

        private void _2022ToSJIS(char c2, char c3, byte[] byArray) {
            if ((c2 & '\u0001') > 0) {
                c2 = (char)(c2 + '\u0001');
                c3 = c3 <= '_' ? (char)(c3 + 31) : (c3 <= '~' ? (char)(c3 + 32) : (char)'\u0000');
            } else {
                c3 = c3 >= '!' && c3 <= '~' ? (char)(c3 + 126) : (char)'\u0000';
            }
            c2 = (char)(c2 >> 1);
            c2 = c2 <= '/' ? (char)(c2 + 112) : (c2 <= '?' ? (char)(c2 + 176) : (char)'\u0000');
            byArray[0] = (byte)(0xFF & c2);
            byArray[1] = (byte)(0xFF & c3);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, boolean bl2) {
            byte by2;
            boolean bl3 = false;
            boolean bl4 = false;
            CoderResult coderResult = CoderResult.UNDERFLOW;
            byte[] byArray = new byte[2];
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            byte by3 = 0;
            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.key != 0) {
                bl4 = true;
            } else if (this.toULength == 1 && byteBuffer.hasRemaining() && charBuffer.hasRemaining()) {
                n3 = this.toUBytesArray[0] & 0xFF;
                this.toULength = 0;
                by2 = ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.cs[((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g];
                n4 = 153;
                bl3 = true;
            }
            block13: while (byteBuffer.hasRemaining() || bl4 || bl3) {
                if (bl4) {
                    n4 = 27;
                }
                n2 = 65535;
                if (bl4 || bl3 || charBuffer.hasRemaining()) {
                    if (!bl4 && !bl3) {
                        n4 = n3 = byteBuffer.get() & 0xFF;
                    }
                    block0 : switch (n4) {
                        case 15: {
                            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.version == 3) {
                                ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g = (byte)0;
                                continue block13;
                            }
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment = false;
                            break;
                        }
                        case 14: {
                            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.version == 3) {
                                ((ISO2022State)((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State).cs[1] = 8;
                                ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g = (byte)1;
                                continue block13;
                            }
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment = false;
                            break;
                        }
                        case 27: {
                            if (!bl4) {
                                byteBuffer.position(byteBuffer.position() - 1);
                            } else {
                                bl4 = false;
                            }
                            int n5 = byteBuffer.position();
                            int n6 = this.toULength;
                            coderResult = CharsetISO2022.this.changeState_2022(this, byteBuffer, CharsetISO2022.this.variant);
                            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.version == 0 && ((CharsetISO2022)CharsetISO2022.this).myConverterData.key == 0 && !coderResult.isError() && ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment) {
                                coderResult = CoderResult.malformedForLength(byteBuffer.position() - n5);
                                this.toULength = n6 + (byteBuffer.position() - n5);
                            }
                            if (coderResult.isError()) {
                                ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment = false;
                                return coderResult;
                            }
                            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.key != 0) continue block13;
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment = true;
                            continue block13;
                        }
                        case 10: 
                        case 13: {
                            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.cs[0] != 0 && ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.cs[0] != 3) {
                                ((ISO2022State)((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State).cs[0] = 0;
                            }
                            ((ISO2022State)((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State).cs[2] = 0;
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g = (byte)0;
                        }
                        default: {
                            int n6;
                            int n5;
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment = false;
                            by3 = by2 = ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.cs[((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g];
                            if (bl3) {
                                by3 = -103;
                            }
                            if (!bl3 && n3 >= 161 && n3 <= 223 && ((CharsetISO2022)CharsetISO2022.this).myConverterData.version == 4 && !CharsetISO2022.IS_JP_DBCS(by2)) {
                                n2 = n3 + 65216;
                                if (((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g < 2) break;
                                ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g = ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.prevG;
                                break;
                            }
                            switch (by3) {
                                case 0: {
                                    if (n3 > 127) break block0;
                                    n2 = n3;
                                    break block0;
                                }
                                case 1: {
                                    if (n3 <= 127) {
                                        n2 = n3 + 128;
                                    }
                                    ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g = ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.prevG;
                                    break block0;
                                }
                                case 2: {
                                    if (n3 <= 127) {
                                        n2 = CharsetMBCS.MBCS_SINGLE_SIMPLE_GET_NEXT_BMP(((CharsetISO2022)CharsetISO2022.this).myConverterData.myConverterArray[by2].mbcs, n3 + 128);
                                    }
                                    ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g = ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.prevG;
                                    break block0;
                                }
                                case 3: {
                                    if (n3 > 127) break block0;
                                    n2 = this.jisx201ToU(n3);
                                    break block0;
                                }
                                case 8: {
                                    if (n3 >= 33 && n3 <= 95) {
                                        n2 = n3 + 65344;
                                        break block0;
                                    }
                                }
                                default: {
                                    if (bl3 || byteBuffer.hasRemaining()) {
                                        boolean bl5;
                                        bl3 = false;
                                        n6 = (short)(byteBuffer.get(byteBuffer.position()) & 0xFF);
                                        boolean bl6 = (short)(0xFF & n3 - 33) <= 93;
                                        boolean bl7 = bl5 = (short)(0xFF & n6 - 33) <= 93;
                                        if (bl6 && bl5) {
                                            byteBuffer.get();
                                            n5 = n3 << 8 | n6;
                                            if (by2 == 4) {
                                                this._2022ToSJIS((char)n3, (char)n6, byArray);
                                                n3 = n5;
                                            } else {
                                                n3 = n5;
                                                if (by2 == 7) {
                                                    n5 += 32896;
                                                }
                                                byArray[0] = (byte)(0xFF & n5 >> 8);
                                                byArray[1] = (byte)(0xFF & n5);
                                            }
                                            n2 = CharsetISO2022.this.MBCSSimpleGetNextUChar(((CharsetISO2022)CharsetISO2022.this).myConverterData.myConverterArray[by2], ByteBuffer.wrap(byArray), false);
                                            break block0;
                                        }
                                        if (bl5 || CharsetISO2022.IS_2022_CONTROL(n6)) break block0;
                                        byteBuffer.get();
                                        n3 = 0x10000 | n3 << 8 | n6;
                                        break block0;
                                    }
                                    this.toUBytesArray[0] = (byte)n3;
                                    this.toULength = 1;
                                    return coderResult;
                                }
                            }
                        }
                    }
                    if (n2 < 65534) {
                        if (intBuffer != null) {
                            intBuffer.put(charBuffer.remaining(), byteBuffer.remaining() - (n3 <= 255 ? 1 : 2));
                        }
                        charBuffer.put((char)n2);
                        continue;
                    }
                    if (n2 > 65535) {
                        charBuffer.put((char)(55296 + (char)((n2 -= 65536) >> 10)));
                        charBuffer.position(charBuffer.position() - 1);
                        if (intBuffer != null) {
                            intBuffer.put(charBuffer.remaining(), byteBuffer.remaining() - (n3 <= 255 ? 1 : 2));
                        }
                        charBuffer.get();
                        if (charBuffer.hasRemaining()) {
                            charBuffer.put((char)(56320 + (char)(n2 & 0x3FF)));
                            charBuffer.position(charBuffer.position() - 1);
                            if (intBuffer != null) {
                                intBuffer.put(charBuffer.remaining(), byteBuffer.remaining() - (n3 <= 255 ? 1 : 2));
                            }
                            charBuffer.get();
                            continue;
                        }
                        this.charErrorBufferArray[this.charErrorBufferLength++] = (char)(56320 + (char)(n2 & 0x3FF));
                        continue;
                    }
                    coderResult = CharsetISO2022.toUnicodeCallback(this, n3, n2);
                    break;
                }
                coderResult = CoderResult.OVERFLOW;
                break;
            }
            return coderResult;
        }
    }

    private static class UConverterDataISO2022 {
        UConverterSharedData[] myConverterArray = new UConverterSharedData[10];
        CharsetMBCS.CharsetEncoderMBCS currentEncoder;
        CharsetMBCS.CharsetDecoderMBCS currentDecoder;
        CharsetMBCS currentConverter;
        ISO2022State toU2022State = new ISO2022State();
        ISO2022State fromU2022State = new ISO2022State();
        int key = 0;
        int version = 0;
        boolean isEmptySegment = false;

        UConverterDataISO2022() {
        }

        void reset() {
            this.toU2022State.reset();
            this.fromU2022State.reset();
            this.isEmptySegment = false;
        }
    }

    private static class ISO2022State {
        private byte[] cs = new byte[4];
        private byte g;
        private byte prevG;

        ISO2022State() {
        }

        void reset() {
            Arrays.fill(this.cs, (byte)0);
            this.g = 0;
            this.prevG = 0;
        }
    }
}

