/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.charset;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetCallback;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Assert;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;

public abstract class CharsetEncoderICU
extends CharsetEncoder {
    static final char MISSING_CHAR_MARKER = '\uffff';
    byte[] errorBuffer = new byte[30];
    int errorBufferLength = 0;
    int fromUnicodeStatus;
    int fromUChar32;
    boolean useSubChar1;
    boolean useFallback;
    static final int EXT_MAX_UCHARS = 19;
    int preFromUFirstCP;
    char[] preFromUArray = new char[19];
    int preFromUBegin;
    int preFromULength;
    char[] invalidUCharBuffer = new char[2];
    int invalidUCharLength;
    Object fromUContext;
    private CharsetCallback.Encoder onUnmappableInput = CharsetCallback.FROM_U_CALLBACK_STOP;
    private CharsetCallback.Encoder onMalformedInput = CharsetCallback.FROM_U_CALLBACK_STOP;
    CharsetCallback.Encoder fromCharErrorBehaviour = new CharsetCallback.Encoder(){

        @Override
        public CoderResult call(CharsetEncoderICU charsetEncoderICU, Object object, CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, char[] cArray, int n2, int n3, CoderResult coderResult) {
            if (coderResult.isUnmappable()) {
                return CharsetEncoderICU.this.onUnmappableInput.call(charsetEncoderICU, object, charBuffer, byteBuffer, intBuffer, cArray, n2, n3, coderResult);
            }
            return CharsetEncoderICU.this.onMalformedInput.call(charsetEncoderICU, object, charBuffer, byteBuffer, intBuffer, cArray, n2, n3, coderResult);
        }
    };
    private static final CharBuffer EMPTY = CharBuffer.allocate(0);

    CharsetEncoderICU(CharsetICU charsetICU, byte[] byArray) {
        super(charsetICU, (charsetICU.minBytesPerChar + charsetICU.maxBytesPerChar) / 2, charsetICU.maxBytesPerChar, byArray);
    }

    public boolean isFallbackUsed() {
        return this.useFallback;
    }

    public void setFallbackUsed(boolean bl2) {
        this.useFallback = bl2;
    }

    final boolean isFromUUseFallback(int n2) {
        return this.useFallback || CharsetEncoderICU.isUnicodePrivateUse(n2);
    }

    static final boolean isFromUUseFallback(boolean bl2, int n2) {
        return bl2 || CharsetEncoderICU.isUnicodePrivateUse(n2);
    }

    private static final boolean isUnicodePrivateUse(int n2) {
        return n2 >= 57344 && (n2 <= 63743 || n2 >= 983040 && (n2 <= 1048573 || n2 >= 0x100000 && n2 <= 1114109));
    }

    @Override
    protected void implOnMalformedInput(CodingErrorAction codingErrorAction) {
        this.onMalformedInput = CharsetEncoderICU.getCallback(codingErrorAction);
    }

    @Override
    protected void implOnUnmappableCharacter(CodingErrorAction codingErrorAction) {
        this.onUnmappableInput = CharsetEncoderICU.getCallback(codingErrorAction);
    }

    public final void setFromUCallback(CoderResult coderResult, CharsetCallback.Encoder encoder, Object object) {
        if (coderResult.isMalformed()) {
            this.onMalformedInput = encoder;
        } else if (coderResult.isUnmappable()) {
            this.onUnmappableInput = encoder;
        }
        if (this.fromUContext == null || !this.fromUContext.equals(object)) {
            this.setFromUContext(object);
        }
    }

    public final void setFromUContext(Object object) {
        this.fromUContext = object;
    }

    private static CharsetCallback.Encoder getCallback(CodingErrorAction codingErrorAction) {
        if (codingErrorAction == CodingErrorAction.REPLACE) {
            return CharsetCallback.FROM_U_CALLBACK_SUBSTITUTE;
        }
        if (codingErrorAction == CodingErrorAction.IGNORE) {
            return CharsetCallback.FROM_U_CALLBACK_SKIP;
        }
        return CharsetCallback.FROM_U_CALLBACK_STOP;
    }

    @Override
    protected CoderResult implFlush(ByteBuffer byteBuffer) {
        return this.encode(EMPTY, byteBuffer, null, true);
    }

    @Override
    protected void implReset() {
        this.errorBufferLength = 0;
        this.fromUnicodeStatus = 0;
        this.fromUChar32 = 0;
        this.fromUnicodeReset();
    }

    private void fromUnicodeReset() {
        this.preFromUBegin = 0;
        this.preFromUFirstCP = -1;
        this.preFromULength = 0;
    }

    @Override
    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (!charBuffer.hasRemaining() && this.errorBufferLength == 0) {
            this.fromUChar32 = 0;
            return CoderResult.UNDERFLOW;
        }
        charBuffer.position(charBuffer.position() + this.fromUCountPending());
        CoderResult coderResult = this.encode(charBuffer, byteBuffer, null, false);
        this.setSourcePosition(charBuffer);
        return coderResult;
    }

    abstract CoderResult encodeLoop(CharBuffer var1, ByteBuffer var2, IntBuffer var3, boolean var4);

    final CoderResult encode(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, boolean bl2) {
        if (byteBuffer == null || charBuffer == null) {
            throw new IllegalArgumentException();
        }
        if (this.errorBufferLength > 0) {
            byte[] byArray = this.errorBuffer;
            int n2 = this.errorBufferLength;
            int n3 = 0;
            do {
                if (byteBuffer.remaining() == 0) {
                    int n4 = 0;
                    do {
                        byArray[n4++] = byArray[n3++];
                    } while (n3 < n2);
                    this.errorBufferLength = (byte)n4;
                    return CoderResult.OVERFLOW;
                }
                byteBuffer.put(byArray[n3++]);
                if (intBuffer == null) continue;
                intBuffer.put(-1);
            } while (n3 < n2);
            this.errorBufferLength = 0;
        }
        if (!bl2 && charBuffer.remaining() == 0 && this.preFromULength >= 0) {
            return CoderResult.UNDERFLOW;
        }
        return this.fromUnicodeWithCallback(charBuffer, byteBuffer, intBuffer, bl2);
    }

    /*
     * Unable to fully structure code
     */
    final CoderResult fromUnicodeWithCallback(CharBuffer var1_1, ByteBuffer var2_2, IntBuffer var3_3, boolean var4_4) {
        var10_5 = CharBuffer.allocate(19);
        var11_6 = 0;
        var14_7 = CoderResult.UNDERFLOW;
        var6_8 = 0;
        if (this.preFromULength >= 0) {
            var12_9 = null;
            var13_10 = false;
        } else {
            var12_9 = var1_1;
            var13_10 = var4_4;
            var10_5.put(this.preFromUArray, 0, -this.preFromULength);
            var1_1 = var10_5;
            var1_1.position(var11_6);
            var1_1.limit(var11_6 - this.preFromULength);
            var4_4 = false;
            this.preFromULength = 0;
        }
        block0: while (true) {
            var8_13 = (var14_7 = this.encodeLoop(var1_1, var2_2, var3_3, var4_4)).isUnderflow() != false && var4_4 != false && var1_1.remaining() == 0 && this.fromUChar32 == 0;
            var9_14 = false;
            var7_12 = 0;
            while (true) {
                if (this.preFromULength < 0) {
                    if (var12_9 == null) {
                        var12_9 = var1_1;
                        var13_10 = var4_4;
                        var10_5.put(this.preFromUArray, 0, -this.preFromULength);
                        var1_1 = var10_5;
                        var1_1.position(var11_6);
                        var1_1.limit(var11_6 - this.preFromULength);
                        var4_4 = false;
                        if ((var6_8 += this.preFromULength) < 0) {
                            var6_8 = -1;
                        }
                        this.preFromULength = 0;
                    } else {
                        Assert.assrt(var12_9 == null);
                    }
                }
                var5_11 = var1_1.position();
                if (var14_7.isUnderflow()) {
                    if (var5_11 < var1_1.limit()) continue block0;
                    if (var12_9 != null) {
                        var1_1 = var12_9;
                        var4_4 = var13_10;
                        var6_8 = var1_1.position();
                        var12_9 = null;
                        continue block0;
                    }
                    if (var4_4 && this.fromUChar32 != 0) {
                        var14_7 = CoderResult.malformedForLength(1);
                        var9_14 = false;
                    } else {
                        if (var4_4) {
                            if (var8_13) ** break;
                            continue block0;
                            this.implReset();
                        }
                        return var14_7;
                    }
                }
                if (var9_14 || var14_7.isOverflow() || !var14_7.isMalformed() && !var14_7.isUnmappable()) {
                    if (var12_9 != null && (var15_15 = var1_1.remaining()) > 0) {
                        var1_1.get(this.preFromUArray, 0, var15_15);
                        this.preFromULength = (byte)(-var15_15);
                    }
                    return var14_7;
                }
                var15_15 = this.fromUChar32;
                this.invalidUCharLength = var7_12 = UTF16.append(this.invalidUCharBuffer, 0, this.fromUChar32);
                this.fromUChar32 = 0;
                var14_7 = this.fromCharErrorBehaviour.call(this, this.fromUContext, var1_1, var2_2, var3_3, this.invalidUCharBuffer, this.invalidUCharLength, var15_15, var14_7);
                var9_14 = true;
            }
            break;
        }
    }

    @Override
    public boolean isLegalReplacement(byte[] byArray) {
        return true;
    }

    static final CoderResult fromUWriteBytes(CharsetEncoderICU charsetEncoderICU, byte[] byArray, int n2, int n3, ByteBuffer byteBuffer, IntBuffer intBuffer, int n4) {
        int n5 = n3;
        CoderResult coderResult = CoderResult.UNDERFLOW;
        int n6 = n2 + n3;
        try {
            while (n2 < n6) {
                byteBuffer.put(byArray[n2]);
                ++n2;
            }
            n3 = 0;
        }
        catch (BufferOverflowException bufferOverflowException) {
            coderResult = CoderResult.OVERFLOW;
        }
        if (intBuffer != null) {
            while (n5 > n3) {
                intBuffer.put(n4);
                --n5;
            }
        }
        charsetEncoderICU.errorBufferLength = n6 - n2;
        if (charsetEncoderICU.errorBufferLength > 0) {
            int n7 = 0;
            while (n2 < n6) {
                charsetEncoderICU.errorBuffer[n7++] = byArray[n2++];
            }
            coderResult = CoderResult.OVERFLOW;
        }
        return coderResult;
    }

    int fromUCountPending() {
        if (this.preFromULength > 0) {
            return UTF16.getCharCount(this.preFromUFirstCP) + this.preFromULength;
        }
        if (this.preFromULength < 0) {
            return -this.preFromULength;
        }
        if (this.fromUChar32 > 0) {
            return 1;
        }
        if (this.preFromUFirstCP > 0) {
            return UTF16.getCharCount(this.preFromUFirstCP);
        }
        return 0;
    }

    private final void setSourcePosition(CharBuffer charBuffer) {
        charBuffer.position(charBuffer.position() - this.fromUCountPending());
    }

    CoderResult cbFromUWriteSub(CharsetEncoderICU charsetEncoderICU, CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer) {
        CharsetICU charsetICU = (CharsetICU)charsetEncoderICU.charset();
        byte[] byArray = charsetEncoderICU.replacement();
        if (charsetICU.subChar1 != 0 && charsetEncoderICU.invalidUCharBuffer[0] <= '\u00ff') {
            return CharsetEncoderICU.fromUWriteBytes(charsetEncoderICU, new byte[]{charsetICU.subChar1}, 0, 1, byteBuffer, intBuffer, charBuffer.position());
        }
        return CharsetEncoderICU.fromUWriteBytes(charsetEncoderICU, byArray, 0, byArray.length, byteBuffer, intBuffer, charBuffer.position());
    }

    CoderResult cbFromUWriteUChars(CharsetEncoderICU charsetEncoderICU, CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer) {
        CoderResult coderResult = CoderResult.UNDERFLOW;
        int n2 = charBuffer.position();
        coderResult = charsetEncoderICU.encode(charBuffer, byteBuffer, null, false);
        if (intBuffer != null) {
            for (int i2 = byteBuffer.position(); byteBuffer.position() != i2; ++i2) {
                intBuffer.put(n2);
            }
        }
        if (coderResult.isOverflow()) {
            int n3 = charsetEncoderICU.errorBufferLength;
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(charsetEncoderICU.errorBuffer);
            byteBuffer2.position(n3);
            charsetEncoderICU.errorBufferLength = 0;
            charsetEncoderICU.encode(charBuffer, byteBuffer2, null, false);
            charsetEncoderICU.errorBuffer = byteBuffer2.array();
            charsetEncoderICU.errorBufferLength = byteBuffer2.position();
        }
        return coderResult;
    }

    final CoderResult handleSurrogates(CharBuffer charBuffer, char c2) {
        if (!UTF16.isLeadSurrogate(c2)) {
            this.fromUChar32 = c2;
            return CoderResult.malformedForLength(1);
        }
        if (!charBuffer.hasRemaining()) {
            this.fromUChar32 = c2;
            return CoderResult.UNDERFLOW;
        }
        char c3 = charBuffer.get();
        if (!UTF16.isTrailSurrogate(c3)) {
            this.fromUChar32 = c2;
            charBuffer.position(charBuffer.position() - 1);
            return CoderResult.malformedForLength(1);
        }
        this.fromUChar32 = UCharacter.getCodePoint(c2, c3);
        return null;
    }

    final CoderResult handleSurrogates(char[] cArray, int n2, int n3, char c2) {
        if (!UTF16.isLeadSurrogate(c2)) {
            this.fromUChar32 = c2;
            return CoderResult.malformedForLength(1);
        }
        if (n2 >= n3) {
            this.fromUChar32 = c2;
            return CoderResult.UNDERFLOW;
        }
        char c3 = cArray[n2];
        if (!UTF16.isTrailSurrogate(c3)) {
            this.fromUChar32 = c2;
            return CoderResult.malformedForLength(1);
        }
        this.fromUChar32 = UCharacter.getCodePoint(c2, c3);
        return null;
    }

    public final float maxCharsPerByte() {
        return ((CharsetICU)this.charset()).maxCharsPerByte;
    }

    public static int getMaxBytesForString(int n2, int n3) {
        return (n2 + 10) * n3;
    }
}

