/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetDecoderICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetEncoderICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetMBCS;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

class CharsetCompoundText
extends CharsetICU {
    private static final byte[] fromUSubstitution = new byte[]{63};
    private CharsetMBCS[] myConverterArray;
    private byte state;
    private static final byte INVALID = -2;
    private static final byte DO_SEARCH = -1;
    private static final byte COMPOUND_TEXT_SINGLE_0 = 0;
    private static final byte COMPOUND_TEXT_SINGLE_1 = 1;
    private static final byte COMPOUND_TEXT_SINGLE_2 = 2;
    private static final byte COMPOUND_TEXT_SINGLE_3 = 3;
    private static final byte IBM_915 = 12;
    private static final byte IBM_916 = 13;
    private static final byte IBM_914 = 14;
    private static final byte IBM_874 = 15;
    private static final byte IBM_912 = 16;
    private static final byte IBM_913 = 17;
    private static final byte ISO_8859_14 = 18;
    private static final byte IBM_923 = 19;
    private static final byte NUM_OF_CONVERTERS = 20;
    private static final byte SEARCH_LENGTH = 12;
    private static final byte[][] escSeqCompoundText = new byte[][]{{27, 45, 65}, {27, 45, 77}, {27, 45, 70}, {27, 45, 71}, {27, 36, 41, 65}, {27, 36, 41, 66}, {27, 36, 41, 67}, {27, 36, 41, 68}, {27, 36, 41, 71}, {27, 36, 41, 72}, {27, 36, 41, 73}, {27, 37, 71}, {27, 45, 76}, {27, 45, 72}, {27, 45, 68}, {27, 45, 84}, {27, 45, 66}, {27, 45, 67}, {27, 45, 95}, {27, 45, 98}};
    private static final byte ESC_START = 27;

    private static boolean isASCIIRange(int n2) {
        return n2 == 0 || n2 == 9 || n2 == 10 || n2 >= 32 && n2 <= 127 || n2 >= 160 && n2 <= 255;
    }

    private static boolean isIBM915(int n2) {
        return n2 >= 1025 && n2 <= 1119 || n2 == 8470;
    }

    private static boolean isIBM916(int n2) {
        return n2 >= 1488 && n2 <= 1514 || n2 == 8215 || n2 == 8254;
    }

    private static boolean isCompoundS3(int n2) {
        return n2 == 1548 || n2 == 1563 || n2 == 1567 || n2 >= 1569 && n2 <= 1594 || n2 >= 1600 && n2 <= 1618 || n2 >= 1632 && n2 <= 1645 || n2 == 8203 || n2 >= 65136 && n2 <= 65138 || n2 == 65140 || n2 >= 65142 && n2 <= 65214;
    }

    private static boolean isCompoundS2(int n2) {
        return n2 == 700 || n2 == 701 || n2 >= 900 && n2 <= 974 || n2 == 8213;
    }

    private static boolean isIBM914(int n2) {
        return n2 == 256 || n2 == 257 || n2 == 274 || n2 == 275 || n2 == 278 || n2 == 279 || n2 == 290 || n2 == 291 || n2 >= 296 && n2 <= 299 || n2 == 302 || n2 == 303 || n2 >= 310 && n2 <= 312 || n2 == 315 || n2 == 316 || n2 == 325 || n2 == 326 || n2 >= 330 && n2 <= 333 || n2 == 342 || n2 == 343 || n2 >= 358 && n2 <= 363 || n2 == 370 || n2 == 371;
    }

    private static boolean isIBM874(int n2) {
        return n2 >= 3585 && n2 <= 3642 || n2 >= 3647 && n2 <= 3675;
    }

    private static boolean isIBM912(int n2) {
        return n2 >= 258 && n2 <= 263 || n2 >= 268 && n2 <= 273 || n2 >= 280 && n2 <= 283 || n2 == 313 || n2 == 314 || n2 == 317 || n2 == 318 || n2 >= 321 && n2 <= 324 || n2 == 327 || n2 == 336 || n2 == 337 || n2 == 340 || n2 == 341 || n2 >= 344 && n2 <= 347 || n2 == 350 || n2 == 351 || n2 >= 352 && n2 <= 357 || n2 == 366 || n2 == 367 || n2 == 368 || n2 == 369 || n2 >= 377 && n2 <= 382 || n2 == 711 || n2 == 728 || n2 == 729 || n2 == 731 || n2 == 733;
    }

    private static boolean isIBM913(int n2) {
        return n2 >= 264 && n2 <= 267 || n2 == 284 || n2 == 285 || n2 == 288 || n2 == 289 || n2 >= 292 && n2 <= 295 || n2 == 308 || n2 == 309 || n2 == 348 || n2 == 349 || n2 == 364 || n2 == 365;
    }

    private static boolean isCompoundS1(int n2) {
        return n2 == 286 || n2 == 287 || n2 == 304 || n2 == 305 || n2 >= 536 && n2 <= 539;
    }

    private static boolean isISO8859_14(int n2) {
        return n2 >= 372 && n2 <= 375 || n2 == 7690 || n2 == 7691 || n2 == 7710 || n2 == 7711 || n2 == 7744 || n2 == 7745 || n2 == 7766 || n2 == 7767 || n2 == 7776 || n2 == 7777 || n2 == 7786 || n2 == 7787 || n2 == 7922 || n2 == 7923 || n2 >= 7808 && n2 <= 7813;
    }

    private static boolean isIBM923(int n2) {
        return n2 == 338 || n2 == 339 || n2 == 376 || n2 == 8364;
    }

    private static int findNextEsc(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.limit();
        for (int i2 = byteBuffer.position() + 1; i2 < n2; ++i2) {
            if (byteBuffer.get(i2) != 27) continue;
            return i2;
        }
        return n2;
    }

    private static byte getState(int n2) {
        int n3 = -1;
        if (CharsetCompoundText.isASCIIRange(n2)) {
            n3 = 0;
        } else if (CharsetCompoundText.isIBM912(n2)) {
            n3 = 16;
        } else if (CharsetCompoundText.isIBM913(n2)) {
            n3 = 17;
        } else if (CharsetCompoundText.isISO8859_14(n2)) {
            n3 = 18;
        } else if (CharsetCompoundText.isIBM923(n2)) {
            n3 = 19;
        } else if (CharsetCompoundText.isIBM874(n2)) {
            n3 = 15;
        } else if (CharsetCompoundText.isIBM914(n2)) {
            n3 = 14;
        } else if (CharsetCompoundText.isCompoundS2(n2)) {
            n3 = 2;
        } else if (CharsetCompoundText.isCompoundS3(n2)) {
            n3 = 3;
        } else if (CharsetCompoundText.isIBM916(n2)) {
            n3 = 13;
        } else if (CharsetCompoundText.isIBM915(n2)) {
            n3 = 12;
        } else if (CharsetCompoundText.isCompoundS1(n2)) {
            n3 = 1;
        }
        return (byte)n3;
    }

    private static byte findStateFromEscSeq(ByteBuffer byteBuffer, byte[] byArray, int n2) {
        byte by2;
        byte by3 = -2;
        int n3 = byteBuffer.position();
        boolean bl2 = false;
        int n4 = n2;
        int n5 = byteBuffer.limit();
        for (by2 = 0; by2 < escSeqCompoundText.length; by2 = (byte)(by2 + 1)) {
            bl2 = true;
            for (int n6 = 0; n6 < escSeqCompoundText[by2].length; n6 = (int)((byte)(n6 + 1))) {
                if (n6 < n2) {
                    if (byArray[n6] == escSeqCompoundText[by2][n6]) continue;
                    bl2 = false;
                    break;
                }
                if (n3 + (n6 - n4) >= n5) {
                    return -1;
                }
                if (byteBuffer.get(n3 + (n6 - n4)) == escSeqCompoundText[by2][n6]) continue;
                bl2 = false;
                break;
            }
            if (bl2) break;
        }
        if (bl2) {
            by3 = by2;
            byteBuffer.position(n3 + (escSeqCompoundText[by2].length - n4));
        }
        return by3;
    }

    public CharsetCompoundText(String string, String string2, String[] stringArray) {
        super(string, string2, stringArray);
        this.LoadConverters();
        this.maxBytesPerChar = 6;
        this.minBytesPerChar = 1;
        this.maxCharsPerByte = 1.0f;
    }

    private void LoadConverters() {
        this.myConverterArray = new CharsetMBCS[20];
        this.myConverterArray[0] = null;
        for (int i2 = 1; i2 < 12; ++i2) {
            String string = "icu-internal-compound-";
            string = i2 <= 3 ? string + "s" + i2 : (i2 <= 10 ? string + "d" + (i2 - 3) : string + "t");
            this.myConverterArray[i2] = (CharsetMBCS)CharsetICU.forNameICU(string);
        }
        this.myConverterArray[12] = (CharsetMBCS)CharsetICU.forNameICU("ibm-915_P100-1995");
        this.myConverterArray[13] = (CharsetMBCS)CharsetICU.forNameICU("ibm-916_P100-1995");
        this.myConverterArray[14] = (CharsetMBCS)CharsetICU.forNameICU("ibm-914_P100-1995");
        this.myConverterArray[15] = (CharsetMBCS)CharsetICU.forNameICU("ibm-874_P100-1995");
        this.myConverterArray[16] = (CharsetMBCS)CharsetICU.forNameICU("ibm-912_P100-1995");
        this.myConverterArray[17] = (CharsetMBCS)CharsetICU.forNameICU("ibm-913_P100-2000");
        this.myConverterArray[18] = (CharsetMBCS)CharsetICU.forNameICU("iso-8859_14-1998");
        this.myConverterArray[19] = (CharsetMBCS)CharsetICU.forNameICU("ibm-923_P100-1998");
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new CharsetDecoderCompoundText(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new CharsetEncoderCompoundText(this);
    }

    @Override
    void getUnicodeSetImpl(UnicodeSet unicodeSet, int n2) {
        for (int i2 = 1; i2 < 20; ++i2) {
            this.myConverterArray[i2].MBCSGetFilteredUnicodeSetForUnicode(this.myConverterArray[i2].sharedData, unicodeSet, n2, 1);
        }
        unicodeSet.add(0);
        unicodeSet.add(9);
        unicodeSet.add(10);
        unicodeSet.add(32, 127);
        unicodeSet.add(160, 255);
    }

    class CharsetDecoderCompoundText
    extends CharsetDecoderICU {
        CharsetMBCS.CharsetDecoderMBCS[] gbDecoder;

        public CharsetDecoderCompoundText(CharsetICU charsetICU) {
            super(charsetICU);
            this.gbDecoder = new CharsetMBCS.CharsetDecoderMBCS[20];
            for (int i2 = 0; i2 < 20; ++i2) {
                this.gbDecoder[i2] = i2 == 0 ? null : (CharsetMBCS.CharsetDecoderMBCS)CharsetCompoundText.this.myConverterArray[i2].newDecoder();
            }
        }

        @Override
        protected void implReset() {
            super.implReset();
            for (int i2 = 0; i2 < 20; ++i2) {
                if (this.gbDecoder[i2] == null) continue;
                this.gbDecoder[i2].implReset();
            }
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, boolean bl2) {
            byte by2;
            CoderResult coderResult = CoderResult.UNDERFLOW;
            byte[] byArray = new byte[]{0};
            byte by3 = by2 = CharsetCompoundText.this.state;
            int n2 = byteBuffer.limit();
            if (!byteBuffer.hasRemaining()) {
                return CoderResult.UNDERFLOW;
            }
            if (!charBuffer.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            while (byteBuffer.hasRemaining()) {
                if (charBuffer.hasRemaining()) {
                    byArray[0] = this.toULength > 0 ? this.toUBytesArray[0] : byteBuffer.get(byteBuffer.position());
                    if (byArray[0] == 27) {
                        by3 = CharsetCompoundText.findStateFromEscSeq(byteBuffer, this.toUBytesArray, this.toULength);
                        if (by3 == -1) {
                            while (byteBuffer.hasRemaining()) {
                                this.toUBytesArray[this.toULength++] = byteBuffer.get();
                            }
                            break;
                        }
                        if (by3 < 0) {
                            coderResult = CoderResult.malformedForLength(1);
                            if (this.toULength != 0) break;
                            byteBuffer.get();
                            break;
                        }
                        this.toULength = 0;
                    }
                    if (by3 != by2) {
                        by2 = by3;
                    }
                    if (by2 == 0) {
                        while (byteBuffer.hasRemaining()) {
                            if (!charBuffer.hasRemaining()) {
                                coderResult = CoderResult.OVERFLOW;
                            } else if (byteBuffer.get(byteBuffer.position()) != 27) {
                                if (!charBuffer.hasRemaining()) continue;
                                charBuffer.put((char)(0xFF & byteBuffer.get()));
                                continue;
                            }
                            break;
                        }
                    } else if (byteBuffer.hasRemaining()) {
                        byteBuffer.limit(CharsetCompoundText.findNextEsc(byteBuffer));
                        CharsetMBCS.CharsetDecoderMBCS charsetDecoderMBCS = this.gbDecoder[by2];
                        charsetDecoderMBCS.toUBytesArray = this.toUBytesArray;
                        charsetDecoderMBCS.toULength = this.toULength;
                        coderResult = charsetDecoderMBCS.decodeLoop(byteBuffer, charBuffer, intBuffer, true);
                        this.toULength = charsetDecoderMBCS.toULength;
                        charsetDecoderMBCS.toULength = 0;
                        if (coderResult.isError() && coderResult.isOverflow()) {
                            this.charErrorBufferArray = charsetDecoderMBCS.charErrorBufferArray;
                            this.charErrorBufferBegin = charsetDecoderMBCS.charErrorBufferBegin;
                            this.charErrorBufferLength = charsetDecoderMBCS.charErrorBufferLength;
                            charsetDecoderMBCS.charErrorBufferBegin = 0;
                            charsetDecoderMBCS.charErrorBufferLength = 0;
                        }
                        byteBuffer.limit(n2);
                    }
                    if (!coderResult.isError()) continue;
                    break;
                }
                coderResult = CoderResult.OVERFLOW;
                break;
            }
            CharsetCompoundText.this.state = by2;
            return coderResult;
        }
    }

    class CharsetEncoderCompoundText
    extends CharsetEncoderICU {
        CharsetMBCS.CharsetEncoderMBCS[] gbEncoder;

        public CharsetEncoderCompoundText(CharsetICU charsetICU) {
            super(charsetICU, fromUSubstitution);
            this.gbEncoder = new CharsetMBCS.CharsetEncoderMBCS[20];
            for (int i2 = 0; i2 < 20; ++i2) {
                this.gbEncoder[i2] = i2 == 0 ? null : (CharsetMBCS.CharsetEncoderMBCS)CharsetCompoundText.this.myConverterArray[i2].newEncoder();
            }
        }

        @Override
        protected void implReset() {
            super.implReset();
            for (int i2 = 0; i2 < 20; ++i2) {
                if (this.gbEncoder[i2] == null) continue;
                this.gbEncoder[i2].implReset();
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, boolean bl2) {
            int n2;
            CoderResult coderResult = CoderResult.UNDERFLOW;
            char[] cArray = new char[]{'\u0000'};
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(3);
            byte[] byArray = new byte[10];
            int n3 = 0;
            byte by2 = CharsetCompoundText.this.state;
            byte by3 = 0;
            int n4 = 0;
            boolean bl3 = false;
            if (!charBuffer.hasRemaining()) {
                return CoderResult.UNDERFLOW;
            }
            if (!byteBuffer.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            int n5 = this.fromUChar32;
            if (n5 != 0 && byteBuffer.hasRemaining()) {
                bl3 = true;
            }
            block0: while (charBuffer.hasRemaining()) {
                block23: {
                    block21: {
                        block19: {
                            block22: {
                                block20: {
                                    block18: {
                                        if (!byteBuffer.hasRemaining()) break block19;
                                        if (!bl3) {
                                            n5 = charBuffer.get();
                                        }
                                        n3 = 0;
                                        byteBuffer2.position(0);
                                        byteBuffer2.limit(3);
                                        if (UTF16.isSurrogate(n5) || bl3) {
                                            if (UTF16.isLeadSurrogate(n5) || bl3) {
                                                bl3 = false;
                                                if (charBuffer.hasRemaining()) {
                                                    n2 = charBuffer.get();
                                                    charBuffer.position(charBuffer.position() - 1);
                                                    if (UTF16.isTrailSurrogate(n2)) {
                                                        charBuffer.get();
                                                        n5 = UCharacter.getCodePoint(n5, n2);
                                                        this.fromUChar32 = 0;
                                                        break block18;
                                                    } else {
                                                        coderResult = CoderResult.malformedForLength(1);
                                                        this.fromUChar32 = n5;
                                                        break;
                                                    }
                                                }
                                                this.fromUChar32 = n5;
                                                break;
                                            }
                                            coderResult = CoderResult.malformedForLength(1);
                                            this.fromUChar32 = n5;
                                            break;
                                        }
                                    }
                                    by3 = CharsetCompoundText.getState(n5);
                                    cArray[0] = (char)n5;
                                    if (by3 >= 0) break block20;
                                    break block21;
                                }
                                if (by3 != 0) break block22;
                                byteBuffer2.put(0, (byte)n5);
                                byteBuffer2.limit(1);
                                break block23;
                            }
                            coderResult = this.gbEncoder[by3].cnvMBCSFromUnicodeWithOffsets(CharBuffer.wrap(cArray), byteBuffer2, intBuffer, true);
                            if (coderResult.isError()) break block23;
                            byteBuffer2.limit(byteBuffer2.position());
                            break block23;
                        }
                        coderResult = CoderResult.OVERFLOW;
                        break;
                    }
                    for (n4 = 1; n4 < 12; ++n4) {
                        coderResult = this.gbEncoder[n4].cnvMBCSFromUnicodeWithOffsets(CharBuffer.wrap(cArray), byteBuffer2, intBuffer, true);
                        if (coderResult.isError()) continue;
                        by3 = (byte)n4;
                        byteBuffer2.limit(byteBuffer2.position());
                        this.implReset();
                        break;
                    }
                }
                if (coderResult.isError()) break;
                if (by2 != by3) {
                    by2 = by3;
                    for (n4 = 0; n4 < escSeqCompoundText[by2].length; ++n4) {
                        byArray[n4] = escSeqCompoundText[by2][n4];
                    }
                    n3 = n4;
                }
                for (n4 = 0; n4 < byteBuffer2.limit(); ++n4) {
                    byArray[n4 + n3] = byteBuffer2.get(n4);
                }
                n3 += n4;
                for (n4 = 0; n4 < n3; ++n4) {
                    if (byteBuffer.hasRemaining()) {
                        byteBuffer.put(byArray[n4]);
                        continue;
                    }
                    coderResult = CoderResult.OVERFLOW;
                    continue block0;
                }
            }
            if (coderResult.isOverflow()) {
                n2 = 0;
                for (int i2 = n4; i2 < n3; ++i2) {
                    this.errorBuffer[n2++] = byArray[i2];
                }
                this.errorBufferLength = n2;
            }
            CharsetCompoundText.this.state = by2;
            return coderResult;
        }
    }
}

