/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.comp;

import java.util.EnumSet;
import java.util.Set;
import org.openjdk.tools.javac.code.DeferredLintHandler;
import org.openjdk.tools.javac.code.Kinds;
import org.openjdk.tools.javac.code.Scope;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.javac.code.Symtab;
import org.openjdk.tools.javac.code.Type;
import org.openjdk.tools.javac.code.TypeTag;
import org.openjdk.tools.javac.code.Types;
import org.openjdk.tools.javac.comp.Annotate;
import org.openjdk.tools.javac.comp.Attr;
import org.openjdk.tools.javac.comp.AttrContext;
import org.openjdk.tools.javac.comp.AttrContextEnv;
import org.openjdk.tools.javac.comp.Check;
import org.openjdk.tools.javac.comp.Enter;
import org.openjdk.tools.javac.comp.Env;
import org.openjdk.tools.javac.tree.JCTree;
import org.openjdk.tools.javac.tree.TreeInfo;
import org.openjdk.tools.javac.util.Assert;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.JCDiagnostic;
import org.openjdk.tools.javac.util.List;
import org.openjdk.tools.javac.util.ListBuffer;
import org.openjdk.tools.javac.util.Log;

public class MemberEnter
extends JCTree.Visitor {
    protected static final Context.Key<MemberEnter> memberEnterKey = new Context.Key();
    private final Enter enter;
    private final Log log;
    private final Check chk;
    private final Attr attr;
    private final Symtab syms;
    private final Annotate annotate;
    private final Types types;
    private final DeferredLintHandler deferredLintHandler;
    protected Env<AttrContext> env;

    public static MemberEnter instance(Context context) {
        MemberEnter memberEnter = context.get(memberEnterKey);
        if (memberEnter == null) {
            memberEnter = new MemberEnter(context);
        }
        return memberEnter;
    }

    protected MemberEnter(Context context) {
        context.put(memberEnterKey, this);
        this.enter = Enter.instance(context);
        this.log = Log.instance(context);
        this.chk = Check.instance(context);
        this.attr = Attr.instance(context);
        this.syms = Symtab.instance(context);
        this.annotate = Annotate.instance(context);
        this.types = Types.instance(context);
        this.deferredLintHandler = DeferredLintHandler.instance(context);
    }

    Type signature(Symbol.MethodSymbol methodSymbol, List<JCTree.JCTypeParameter> list, List<JCTree.JCVariableDecl> list2, JCTree jCTree, JCTree.JCVariableDecl jCVariableDecl, List<JCTree.JCExpression> list3, Env<AttrContext> env) {
        Type type;
        List<Type> list4 = this.enter.classEnter(list, env);
        this.attr.attribTypeVariables(list, env);
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        List list5 = list2;
        while (list5.nonEmpty()) {
            this.memberEnter((JCTree)list5.head, env);
            listBuffer.append(((JCTree.JCVariableDecl)list5.head).vartype.type);
            list5 = list5.tail;
        }
        List list6 = list5 = jCTree == null ? this.syms.voidType : this.attr.attribType(jCTree, env);
        if (jCVariableDecl != null) {
            this.memberEnter(jCVariableDecl, env);
            type = jCVariableDecl.vartype.type;
        } else {
            type = null;
        }
        ListBuffer<Type> listBuffer2 = new ListBuffer<Type>();
        List list7 = list3;
        while (list7.nonEmpty()) {
            Type type2 = this.attr.attribType((JCTree)list7.head, env);
            if (!type2.hasTag(TypeTag.TYPEVAR)) {
                type2 = this.chk.checkClassType(((JCTree.JCExpression)list7.head).pos(), type2);
            } else if (type2.tsym.owner == methodSymbol) {
                type2.tsym.flags_field |= 0x800000000000L;
            }
            listBuffer2.append(type2);
            list7 = list7.tail;
        }
        list7 = new Type.MethodType(listBuffer.toList(), (Type)((Object)list5), listBuffer2.toList(), this.syms.methodClass);
        ((Type.MethodType)((Object)list7)).recvtype = type;
        return list4.isEmpty() ? list7 : new Type.ForAll(list4, (Type)((Object)list7));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void memberEnter(JCTree jCTree, Env<AttrContext> env) {
        Env<AttrContext> env2 = this.env;
        try {
            this.env = env;
            jCTree.accept(this);
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.chk.completionError(jCTree.pos(), completionFailure);
        }
        finally {
            this.env = env2;
        }
    }

    void memberEnter(List<? extends JCTree> list, Env<AttrContext> env) {
        List<JCTree> list2 = list;
        while (list2.nonEmpty()) {
            this.memberEnter((JCTree)list2.head, env);
            list2 = list2.tail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
        Scope.WriteableScope writeableScope = this.enter.enterScope(this.env);
        Symbol.MethodSymbol methodSymbol = new Symbol.MethodSymbol(0L, jCMethodDecl.name, null, writeableScope.owner);
        methodSymbol.flags_field = this.chk.checkFlags(jCMethodDecl.pos(), jCMethodDecl.mods.flags, methodSymbol, jCMethodDecl);
        jCMethodDecl.sym = methodSymbol;
        if ((jCMethodDecl.mods.flags & 0x80000000000L) != 0L) {
            methodSymbol.enclClass().flags_field |= 0x80000000000L;
        }
        Env<AttrContext> env = this.methodEnv(jCMethodDecl, this.env);
        JCDiagnostic.DiagnosticPosition diagnosticPosition = this.deferredLintHandler.setPos(jCMethodDecl.pos());
        try {
            methodSymbol.type = this.signature(methodSymbol, jCMethodDecl.typarams, jCMethodDecl.params, jCMethodDecl.restype, jCMethodDecl.recvparam, jCMethodDecl.thrown, env);
        }
        finally {
            this.deferredLintHandler.setPos(diagnosticPosition);
        }
        if (this.types.isSignaturePolymorphic(methodSymbol)) {
            methodSymbol.flags_field |= 0x400000000000L;
        }
        ListBuffer<Symbol.VarSymbol> listBuffer = new ListBuffer<Symbol.VarSymbol>();
        JCTree.JCVariableDecl jCVariableDecl = null;
        List<JCTree.JCVariableDecl> list = jCMethodDecl.params;
        while (list.nonEmpty()) {
            JCTree.JCVariableDecl jCVariableDecl2 = jCVariableDecl = (JCTree.JCVariableDecl)list.head;
            listBuffer.append(Assert.checkNonNull(jCVariableDecl2.sym));
            list = list.tail;
        }
        methodSymbol.params = listBuffer.toList();
        if (jCVariableDecl != null && (jCVariableDecl.mods.flags & 0x400000000L) != 0L) {
            methodSymbol.flags_field |= 0x400000000L;
        }
        ((AttrContext)env.info).scope.leave();
        if (this.chk.checkUnique(jCMethodDecl.pos(), methodSymbol, writeableScope)) {
            writeableScope.enter(methodSymbol);
        }
        this.annotate.annotateLater(jCMethodDecl.mods.annotations, env, methodSymbol, jCMethodDecl.pos());
        this.annotate.queueScanTreeAndTypeAnnotate(jCMethodDecl, env, methodSymbol, jCMethodDecl.pos());
        if (jCMethodDecl.defaultValue != null) {
            methodSymbol.defaultValue = this.annotate.unfinishedDefaultValue();
            this.annotate.annotateDefaultValueLater(jCMethodDecl.defaultValue, env, methodSymbol, jCMethodDecl.pos());
        }
    }

    Env<AttrContext> methodEnv(JCTree.JCMethodDecl jCMethodDecl, Env<AttrContext> env) {
        Env<AttrContext> env2 = env.dup(jCMethodDecl, ((AttrContext)env.info).dup(((AttrContext)env.info).scope.dupUnshared(jCMethodDecl.sym)));
        env2.enclMethod = jCMethodDecl;
        if (jCMethodDecl.sym.type != null) {
            AttrContext attrContext = (AttrContext)env2.info;
            Attr attr = this.attr;
            attr.getClass();
            attrContext.returnResult = attr.new Attr.ResultInfo(Kinds.KindSelector.VAL, jCMethodDecl.sym.type.getReturnType());
        }
        if ((jCMethodDecl.mods.flags & 8L) != 0L) {
            ++((AttrContext)env2.info).staticLevel;
        }
        return env2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
        Object object;
        Env<AttrContext> env = this.env;
        if ((jCVariableDecl.mods.flags & 8L) != 0L || (((AttrContext)this.env.info).scope.owner.flags() & 0x200L) != 0L) {
            env = this.env.dup(jCVariableDecl, ((AttrContext)this.env.info).dup());
            ++((AttrContext)env.info).staticLevel;
        }
        JCDiagnostic.DiagnosticPosition diagnosticPosition = this.deferredLintHandler.setPos(jCVariableDecl.pos());
        try {
            if (TreeInfo.isEnumInit(jCVariableDecl)) {
                this.attr.attribIdentAsEnumType(env, (JCTree.JCIdent)jCVariableDecl.vartype);
            } else {
                this.attr.attribType((JCTree)jCVariableDecl.vartype, env);
                if (TreeInfo.isReceiverParam(jCVariableDecl)) {
                    this.checkReceiver(jCVariableDecl, env);
                }
            }
        }
        finally {
            this.deferredLintHandler.setPos(diagnosticPosition);
        }
        if ((jCVariableDecl.mods.flags & 0x400000000L) != 0L) {
            object = (Type.ArrayType)jCVariableDecl.vartype.type;
            jCVariableDecl.vartype.type = ((Type.ArrayType)object).makeVarargs();
        }
        object = this.enter.enterScope(this.env);
        Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(0L, jCVariableDecl.name, jCVariableDecl.vartype.type, ((Scope.WriteableScope)object).owner);
        varSymbol.flags_field = this.chk.checkFlags(jCVariableDecl.pos(), jCVariableDecl.mods.flags, varSymbol, jCVariableDecl);
        jCVariableDecl.sym = varSymbol;
        if (jCVariableDecl.init != null) {
            varSymbol.flags_field |= 0x40000L;
            if ((varSymbol.flags_field & 0x10L) != 0L && this.needsLazyConstValue(jCVariableDecl.init)) {
                Env<AttrContext> env2 = this.getInitEnv(jCVariableDecl, this.env);
                ((AttrContext)env2.info).enclVar = varSymbol;
                varSymbol.setLazyConstValue(this.initEnv(jCVariableDecl, env2), this.attr, jCVariableDecl);
            }
        }
        if (this.chk.checkUnique(jCVariableDecl.pos(), varSymbol, (Scope)object)) {
            this.chk.checkTransparentVar(jCVariableDecl.pos(), varSymbol, (Scope)object);
            ((Scope.WriteableScope)object).enter(varSymbol);
        }
        this.annotate.annotateLater(jCVariableDecl.mods.annotations, env, varSymbol, jCVariableDecl.pos());
        this.annotate.queueScanTreeAndTypeAnnotate(jCVariableDecl.vartype, env, varSymbol, jCVariableDecl.pos());
        varSymbol.pos = jCVariableDecl.pos;
    }

    void checkType(JCTree jCTree, Type type, String string) {
        if (!jCTree.type.isErroneous() && !this.types.isSameType(jCTree.type, type)) {
            this.log.error(jCTree, string, type, jCTree.type);
        }
    }

    void checkReceiver(JCTree.JCVariableDecl jCVariableDecl, Env<AttrContext> env) {
        this.attr.attribExpr(jCVariableDecl.nameexpr, env);
        Symbol.MethodSymbol methodSymbol = env.enclMethod.sym;
        if (methodSymbol.isConstructor()) {
            Type type = methodSymbol.owner.owner.type;
            if (type.hasTag(TypeTag.METHOD)) {
                type = methodSymbol.owner.owner.owner.type;
            }
            if (type.hasTag(TypeTag.CLASS)) {
                this.checkType(jCVariableDecl.vartype, type, "incorrect.constructor.receiver.type");
                this.checkType(jCVariableDecl.nameexpr, type, "incorrect.constructor.receiver.name");
            } else {
                this.log.error(jCVariableDecl, "receiver.parameter.not.applicable.constructor.toplevel.class", new Object[0]);
            }
        } else {
            this.checkType(jCVariableDecl.vartype, methodSymbol.owner.type, "incorrect.receiver.type");
            this.checkType(jCVariableDecl.nameexpr, methodSymbol.owner.type, "incorrect.receiver.name");
        }
    }

    public boolean needsLazyConstValue(JCTree jCTree) {
        InitTreeVisitor initTreeVisitor = new InitTreeVisitor();
        jCTree.accept(initTreeVisitor);
        return initTreeVisitor.result;
    }

    Env<AttrContext> initEnv(JCTree.JCVariableDecl jCVariableDecl, Env<AttrContext> env) {
        Env<AttrContext> env2 = env.dupto(new AttrContextEnv((JCTree)jCVariableDecl, ((AttrContext)env.info).dup()));
        if (jCVariableDecl.sym.owner.kind == Kinds.Kind.TYP) {
            ((AttrContext)env2.info).scope = ((AttrContext)env.info).scope.dupUnshared(jCVariableDecl.sym);
        }
        if ((jCVariableDecl.mods.flags & 8L) != 0L || (env.enclClass.sym.flags() & 0x200L) != 0L && env.enclMethod == null) {
            ++((AttrContext)env2.info).staticLevel;
        }
        return env2;
    }

    @Override
    public void visitTree(JCTree jCTree) {
    }

    @Override
    public void visitErroneous(JCTree.JCErroneous jCErroneous) {
        if (jCErroneous.errs != null) {
            this.memberEnter(jCErroneous.errs, this.env);
        }
    }

    public Env<AttrContext> getMethodEnv(JCTree.JCMethodDecl jCMethodDecl, Env<AttrContext> env) {
        Env<AttrContext> env2 = this.methodEnv(jCMethodDecl, env);
        ((AttrContext)env2.info).lint = ((AttrContext)env2.info).lint.augment(jCMethodDecl.sym);
        List<JCTree> list = jCMethodDecl.typarams;
        while (list.nonEmpty()) {
            ((AttrContext)env2.info).scope.enterIfAbsent(((JCTree.JCTypeParameter)list.head).type.tsym);
            list = list.tail;
        }
        list = jCMethodDecl.params;
        while (list.nonEmpty()) {
            ((AttrContext)env2.info).scope.enterIfAbsent(((JCTree.JCVariableDecl)list.head).sym);
            list = list.tail;
        }
        return env2;
    }

    public Env<AttrContext> getInitEnv(JCTree.JCVariableDecl jCVariableDecl, Env<AttrContext> env) {
        Env<AttrContext> env2 = this.initEnv(jCVariableDecl, env);
        return env2;
    }

    static class InitTreeVisitor
    extends JCTree.Visitor {
        private static final Set<JCTree.Tag> ALLOWED_OPERATORS = EnumSet.of(JCTree.Tag.POS, new JCTree.Tag[]{JCTree.Tag.NEG, JCTree.Tag.NOT, JCTree.Tag.COMPL, JCTree.Tag.PLUS, JCTree.Tag.MINUS, JCTree.Tag.MUL, JCTree.Tag.DIV, JCTree.Tag.MOD, JCTree.Tag.SL, JCTree.Tag.SR, JCTree.Tag.USR, JCTree.Tag.LT, JCTree.Tag.LE, JCTree.Tag.GT, JCTree.Tag.GE, JCTree.Tag.EQ, JCTree.Tag.NE, JCTree.Tag.BITAND, JCTree.Tag.BITXOR, JCTree.Tag.BITOR, JCTree.Tag.AND, JCTree.Tag.OR});
        boolean result = true;

        InitTreeVisitor() {
        }

        @Override
        public void visitTree(JCTree jCTree) {
            this.result = false;
        }

        @Override
        public void visitLiteral(JCTree.JCLiteral jCLiteral) {
        }

        @Override
        public void visitTypeCast(JCTree.JCTypeCast jCTypeCast) {
            jCTypeCast.expr.accept(this);
        }

        @Override
        public void visitUnary(JCTree.JCUnary jCUnary) {
            if (!ALLOWED_OPERATORS.contains((Object)jCUnary.getTag())) {
                this.result = false;
                return;
            }
            jCUnary.arg.accept(this);
        }

        @Override
        public void visitBinary(JCTree.JCBinary jCBinary) {
            if (!ALLOWED_OPERATORS.contains((Object)jCBinary.getTag())) {
                this.result = false;
                return;
            }
            jCBinary.lhs.accept(this);
            jCBinary.rhs.accept(this);
        }

        @Override
        public void visitConditional(JCTree.JCConditional jCConditional) {
            jCConditional.cond.accept(this);
            jCConditional.truepart.accept(this);
            jCConditional.falsepart.accept(this);
        }

        @Override
        public void visitParens(JCTree.JCParens jCParens) {
            jCParens.expr.accept(this);
        }

        @Override
        public void visitIdent(JCTree.JCIdent jCIdent) {
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
            jCFieldAccess.selected.accept(this);
        }
    }
}

