/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.text;

import org.jpedal.fonts.CodeSpaceRange;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.text.GlyphData;

public final class HexTextUtils {
    private static final int[] multiply16 = new int[]{0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40};

    private HexTextUtils() {
    }

    static int getHexValueFromNonEmbedAdobeCMAP(byte[] stream, int i, GlyphData glyphData, PdfFont currentFontData) {
        CodeSpaceRange cmap = glyphData.getCodeSpaceRange();
        int nn = 0;
        int v = 0;
        int p = 1;
        while (nn < 8) {
            nn = StreamReaderUtils.skipSpaces(stream, nn + i) - i;
            int b1 = stream[i + nn];
            ++nn;
            nn = StreamReaderUtils.skipSpaces(stream, nn + i) - i;
            int b2 = stream[i + nn];
            if (b1 == 62 || b2 == 62 || cmap.isInCodeSpaceRange(v = v << 8 | ((b1 = (b1 | 0x20) % 39 - 9) << 4 | (b2 = (b2 | 0x20) % 39 - 9)), ++nn / 2)) break;
            ++p;
        }
        int cid = cmap.cidMap[v];
        int uni = cmap.uniMap[cid];
        glyphData.setRawInt(v);
        glyphData.setRawChar((char)v);
        glyphData.setDisplayValue(String.valueOf((char)uni).intern());
        glyphData.setUnicodeValue(String.valueOf((char)uni).intern());
        float actualWidth = HexTextUtils.calcActualWidth(currentFontData, p > 1, cid);
        if (actualWidth > 0.0f) {
            glyphData.setActualWidth(actualWidth);
        }
        return i + nn - 1;
    }

    private static float calcActualWidth(PdfFont currentFontData, boolean isValid, int cid) {
        float actualWidth;
        if (isValid) {
            actualWidth = currentFontData.getDefaultWidth(cid);
            if (actualWidth == -1.0f) {
                actualWidth = currentFontData.getDefaultWidth(-1);
            }
        } else {
            actualWidth = -1.0f;
            if ((currentFontData.getFontType() == -1684566726 || currentFontData.getFontType() == -1684566724) && (actualWidth = currentFontData.getDefaultWidth(cid)) == -1.0f) {
                actualWidth = currentFontData.getDefaultWidth(-1) / 2.0f;
            }
        }
        return actualWidth;
    }

    static int getHexValueForceUnicode(byte[] stream, int i, GlyphData glyphData, PdfFont currentFontData) {
        CodeSpaceRange cmap = glyphData.getCodeSpaceRange();
        int nn = 0;
        int v = 0;
        int p = 1;
        while (nn < 8) {
            nn = StreamReaderUtils.skipSpaces(stream, nn + i) - i;
            int b1 = stream[i + nn];
            ++nn;
            nn = StreamReaderUtils.skipSpaces(stream, nn + i) - i;
            int b2 = stream[i + nn];
            if (b1 == 62 || b2 == 62 || cmap.isInCodeSpaceRange(v = v << 8 | ((b1 = (b1 | 0x20) % 39 - 9) << 4 | (b2 = (b2 | 0x20) % 39 - 9)), ++nn / 2)) break;
            ++p;
        }
        int cid = cmap.cidMap[v];
        int uni = cmap.uniMap[cid];
        glyphData.setRawInt(uni);
        glyphData.setRawChar((char)v);
        glyphData.setDisplayValue(String.valueOf((char)uni).intern());
        glyphData.setUnicodeValue(String.valueOf((char)uni).intern());
        float actualWidth = HexTextUtils.calcActualWidth(currentFontData, p > 1, cid);
        if (actualWidth > 0.0f) {
            glyphData.setActualWidth(actualWidth);
        }
        return i + nn - 1;
    }

    static int getHexValue(byte[] stream, int i, GlyphData glyphData, PdfFont currentFontData, ParserOptions parserOptions) {
        int chars = 0;
        int start = i;
        int charSize = glyphData.getCharSize();
        block4: for (int i2 = 1; i2 < charSize; ++i2) {
            byte nextInt = stream[start + i2];
            switch (nextInt) {
                case 62: {
                    i2 = 4;
                    charSize = 2;
                    glyphData.setCharSize(2);
                    continue block4;
                }
                case 10: 
                case 13: {
                    ++start;
                    --i2;
                    continue block4;
                }
                default: {
                    ++chars;
                }
            }
        }
        i = HexTextUtils.getValue(chars, stream, i, glyphData) - 1;
        return HexTextUtils.setValue(glyphData, glyphData.getPossibleValue(), i, currentFontData, parserOptions);
    }

    static int getHexCIDValue(byte[] stream, int i, GlyphData glyphData, PdfFont currentFontData, ParserOptions parserOptions) {
        int twoByteEndPtr = 0;
        int oneByteEndPtr = HexTextUtils.getValue(1, stream, i, glyphData);
        int val = glyphData.getPossibleValue();
        HexTextUtils.setValue(glyphData, val, i, currentFontData, parserOptions);
        if (StandardFonts.CMAP == null) {
            StandardFonts.readCMAP();
        }
        boolean hasCharString = glyphData.getRawInt() > 0 && currentFontData.CMapName != null && currentFontData.getFontType() == -1684566726 && currentFontData.getGlyphData().containsKey(String.valueOf(glyphData.getRawInt()));
        boolean isMultiByte = false;
        if (!(currentFontData.CMapName != null && currentFontData.getUnicodeMapping(glyphData.getRawInt()) != null || stream[i] == 62 || hasCharString)) {
            twoByteEndPtr = HexTextUtils.getValue(3, stream, i, glyphData);
            char combinedVal = (char)glyphData.getPossibleValue();
            int isDouble = currentFontData.isDoubleBytes(val, combinedVal & 0xFF, false);
            if (isDouble == 1 || currentFontData.glyphs.getEmbeddedGlyph(null, null, combinedVal, "", -1.0f, null) != null) {
                isMultiByte = true;
                val = combinedVal;
            }
        }
        if (isMultiByte) {
            return HexTextUtils.setValue(glyphData, val, twoByteEndPtr - 1, currentFontData, parserOptions);
        }
        return oneByteEndPtr - 1;
    }

    private static int setValue(GlyphData glyphData, int val, int i, PdfFont currentFontData, ParserOptions parserOptions) {
        glyphData.setRawInt(val);
        glyphData.setRawChar((char)val);
        glyphData.setDisplayValue(currentFontData.getGlyphValue(val));
        if (currentFontData.isCIDFont() && currentFontData.getCMAP() != null && currentFontData.getUnicodeMapping(val) == null) {
            glyphData.setRawChar(glyphData.getDisplayValue().charAt(0));
            glyphData.setRawInt(glyphData.getRawChar());
        }
        if (parserOptions.isTextExtracted()) {
            glyphData.setUnicodeValue(currentFontData.getUnicodeValue(glyphData.getDisplayValue(), glyphData.getRawInt()));
        }
        return i;
    }

    private static int getValue(int chars, byte[] stream, int i, GlyphData glyphData) {
        int val = 0;
        int charsToFind = chars;
        while (charsToFind > -1) {
            int topHex = stream[i];
            topHex = topHex >= 65 && topHex <= 70 ? (topHex -= 55) : (topHex >= 97 && topHex <= 102 ? (topHex -= 87) : (topHex >= 48 && topHex <= 57 ? (topHex -= 48) : -1));
            if (topHex > -1) {
                val += topHex << multiply16[charsToFind];
                --charsToFind;
            }
            ++i;
        }
        glyphData.setPossibleValue(val);
        return i;
    }

    public static int getHexValue(int start, int count, byte[] characterStream) {
        int val = 0;
        int ptr = 0;
        for (int aa = 1; aa < count + 1; ++aa) {
            int topHex = characterStream[start + count - aa];
            if (topHex >= 65 && topHex <= 70) {
                topHex -= 55;
            } else if (topHex >= 97 && topHex <= 102) {
                topHex -= 87;
            } else {
                if (topHex < 48 || topHex > 57) continue;
                topHex -= 48;
            }
            val += topHex << multiply16[ptr];
            ++ptr;
        }
        return val;
    }

    private static boolean isHexDigit(int code) {
        return code >= 48 && code <= 57 || code >= 65 && code <= 70 || code >= 97 && code <= 102;
    }

    public static int getHexCharCount(int i, byte[] cont, int charsToFind) {
        int charCount = 0;
        int chars = 0;
        int length = cont.length;
        while (chars < charsToFind && i < length) {
            ++charCount;
            if (HexTextUtils.isHexDigit(cont[i] & 0xFF)) {
                ++chars;
            }
            ++i;
        }
        return charCount;
    }
}

