/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.segment.pattern;

import org.jpedal.jbig2.decoders.JBIG2StreamDecoder;
import org.jpedal.jbig2.image.JBIG2Bitmap;
import org.jpedal.jbig2.segment.Segment;
import org.jpedal.jbig2.segment.pattern.PatternDictionaryFlags;
import org.jpedal.jbig2.util.BinaryOperation;

public class PatternDictionarySegment
extends Segment {
    private final PatternDictionaryFlags patternDictionaryFlags = new PatternDictionaryFlags();
    private JBIG2Bitmap[] bitmaps;
    private int size;

    public PatternDictionarySegment(JBIG2StreamDecoder streamDecoder) {
        super(streamDecoder);
    }

    @Override
    public void readSegment() {
        this.readPatternDictionaryFlags();
        short width = this.decoder.readByte();
        short height = this.decoder.readByte();
        short[] buf = new short[4];
        this.decoder.readByte(buf);
        int grayMax = BinaryOperation.getInt32(buf);
        boolean useMMR = this.patternDictionaryFlags.getFlagValue("HD_MMR") == 1;
        int template = this.patternDictionaryFlags.getFlagValue("HD_TEMPLATE");
        if (!useMMR) {
            this.arithmeticDecoder.resetGenericStats(template, null);
            this.arithmeticDecoder.start();
        }
        short[] genericBAdaptiveTemplateX = new short[4];
        short[] genericBAdaptiveTemplateY = new short[4];
        genericBAdaptiveTemplateX[0] = -width;
        genericBAdaptiveTemplateY[0] = 0;
        genericBAdaptiveTemplateX[1] = -3;
        genericBAdaptiveTemplateY[1] = -1;
        genericBAdaptiveTemplateX[2] = 2;
        genericBAdaptiveTemplateY[2] = -2;
        genericBAdaptiveTemplateX[3] = -2;
        genericBAdaptiveTemplateY[3] = -2;
        this.size = grayMax + 1;
        JBIG2Bitmap bitmap = new JBIG2Bitmap(this.size * width, height, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder, this.decoder);
        bitmap.clear(0);
        if (useMMR) {
            bitmap.readBitmapWithMMR(this.segmentHeader.getSegmentDataLength() - 7);
        } else {
            bitmap.readBitmap(template, false, false, null, genericBAdaptiveTemplateX, genericBAdaptiveTemplateY);
        }
        JBIG2Bitmap[] bitmaps = new JBIG2Bitmap[this.size];
        int x = 0;
        for (int i = 0; i < this.size; ++i) {
            bitmaps[i] = bitmap.getSlice(x, 0, width, height);
            x += width;
        }
        bitmap.getDataWriter().clearResources();
        this.bitmaps = bitmaps;
    }

    @Override
    public JBIG2Bitmap[] getBitmaps() {
        return this.bitmaps;
    }

    private void readPatternDictionaryFlags() {
        short patternDictionaryFlagsField = this.decoder.readByte();
        this.patternDictionaryFlags.setFlags(patternDictionaryFlagsField);
    }

    public int getSize() {
        return this.size;
    }
}

