/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import com.idrsolutions.pdf.color.shading.ShadedPaint;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.jpedal.color.ColorspaceFactory;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PatternDisplay;
import org.jpedal.color.PatternPaint;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.color.ShearedTexturePaint;
import org.jpedal.color.TilingPaint;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectFactory;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.PatternObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.ShadingObject;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.PdfStreamDecoderForPattern;
import org.jpedal.utils.Matrix;

public class PatternColorSpace
extends GenericColorSpace {
    public static boolean useMemoryEfficentPaint = true;
    private final PdfObjectReader currentPdfFile;
    private PatternObject PatternObj;
    private final GenericColorSpace patternColorSpace;
    private PdfPaint strokCol;

    public PatternColorSpace(PdfObjectReader currentPdfFile, GenericColorSpace patternColorSpace) {
        this.setType(1146450818);
        this.currentPdfFile = currentPdfFile;
        this.patternColorSpace = patternColorSpace;
        this.currentColor = new PdfColor(1.0f, 1.0f, 1.0f);
    }

    @Override
    public void setColor(String[] value_loc) {
        int elementCount = value_loc.length - 1;
        if (elementCount > 0) {
            String[] colVals = new String[elementCount];
            for (int i = 0; i < elementCount; ++i) {
                colVals[i] = value_loc[elementCount - i];
            }
            this.patternColorSpace.setColor(colVals);
            this.strokCol = this.patternColorSpace.getColor();
        }
        this.PatternObj = PatternColorSpace.getPatternObjectFromRefOrDirect(this.currentPdfFile, (byte[])this.patterns.get(value_loc[0]));
        byte[] streamData = this.PatternObj.getDecodedStream();
        int shadingType = this.PatternObj.getInt(1755231159);
        Object matrix = Matrix.getIdentity();
        float[] inputs = this.PatternObj.getFloatArray(1145198201);
        if (inputs != null) {
            matrix = new float[][]{{inputs[0], inputs[1], 0.0f}, {inputs[2], inputs[3], 0.0f}, {inputs[4], inputs[5], 1.0f}};
        }
        if (shadingType == 1) {
            this.currentColor = this.setupTiling(this.PatternObj, (float[][])matrix, streamData);
        } else if (shadingType == 2) {
            this.currentColor = this.setupShading(this.PatternObj, (float[][])matrix);
        }
    }

    private static PatternObject getPatternObjectFromRefOrDirect(PdfObjectReader currentPdfFile, byte[] data) {
        PatternObject colObj = new PatternObject(new String(data));
        if (data[0] == 60) {
            colObj.setStatus(2);
        } else {
            colObj.setStatus(1);
        }
        colObj.setUnresolvedData(data, 1146450818);
        ObjectDecoder objectDecoder = new ObjectDecoder(currentPdfFile.getObjectReader());
        objectDecoder.checkResolved(colObj);
        return colObj;
    }

    private static GeneralPath getAsPath(float[] rawBBox) {
        GeneralPath rawPath = new GeneralPath();
        rawPath.moveTo(rawBBox[0], rawBBox[1]);
        rawPath.lineTo(rawBBox[2], rawBBox[1]);
        rawPath.lineTo(rawBBox[2], rawBBox[3]);
        rawPath.lineTo(rawBBox[0], rawBBox[3]);
        rawPath.lineTo(rawBBox[0], rawBBox[1]);
        rawPath.closePath();
        return rawPath;
    }

    private static float[][] getMatrix(AffineTransform af) {
        return new float[][]{{(float)af.getScaleX(), (float)af.getShearX(), 0.0f}, {(float)af.getShearY(), (float)af.getScaleY(), 0.0f}, {(float)af.getTranslateX(), (float)af.getTranslateY(), 1.0f}};
    }

    public BufferedImage getRawImage(AffineTransform callerAffine) {
        byte[] streamData = this.currentPdfFile.readStream(this.PatternObj, true, true, true, false, false, this.PatternObj.getCacheName(this.currentPdfFile.getObjectReader()));
        ObjectStore localStore = this.currentPdfFile.getObjectStore();
        AffineTransform pattern = new AffineTransform();
        pattern.concatenate(callerAffine);
        PatternDisplay glyphDisplay = this.decodePatternContent(this.PatternObj, PatternColorSpace.getMatrix(pattern), streamData, localStore);
        return glyphDisplay.getSingleImagePattern();
    }

    private PdfPaint setupTiling(PdfObject PatternObj, float[][] matrix, byte[] streamData) {
        PatternDisplay glyphDisplay;
        BufferedImage sing;
        boolean isRotated;
        Object mm = matrix;
        AffineTransform affine = new AffineTransform();
        float[][] rotatedCTM = Matrix.getIdentity();
        float[] inputs = PatternObj.getFloatArray(1145198201);
        if (inputs != null) {
            mm = new float[][]{{inputs[0], inputs[1], 0.0f}, {inputs[2], inputs[3], 0.0f}, {inputs[4], inputs[5], 1.0f}};
            affine = Matrix.toAffine(mm);
        }
        ObjectStore localStore = this.currentPdfFile.getObjectStore();
        boolean bl = isRotated = affine.getShearX() != 0.0 || affine.getShearY() != 0.0;
        if (isRotated) {
            rotatedCTM = mm;
            affine = new AffineTransform();
            mm = Matrix.getIdentity();
        } else if (useMemoryEfficentPaint) {
            return new TilingPaint(PatternObj, streamData, this, this.currentPdfFile.getObjectStore());
        }
        float[] rawBBox = PatternObj.getFloatArray(303185736);
        float xGap = Math.abs(rawBBox[2] - rawBBox[0]);
        float yGap = Math.abs(rawBBox[1] - rawBBox[3]);
        GeneralPath rawPath = PatternColorSpace.getAsPath(rawBBox);
        Shape rawShape = rawPath.createTransformedShape(affine);
        Rectangle2D rawRect = rawShape.getBounds2D();
        float rawXStep = PatternObj.getFloatNumber(591672680);
        rawXStep = 30000.0f < rawXStep || rawXStep < -30000.0f ? 0.0f : rawXStep;
        float rawYStep = PatternObj.getFloatNumber(591672681);
        rawYStep = 30000.0f < rawYStep || rawYStep < -30000.0f ? 0.0f : rawYStep;
        float[] bbox = PatternColorSpace.getBBBox(xGap, yGap, rawXStep, rawYStep);
        GeneralPath boxPath = PatternColorSpace.getAsPath(bbox);
        Shape boxShape = boxPath.createTransformedShape(affine);
        Rectangle2D boxRect = boxShape.getBounds2D();
        double imageW = Math.abs(boxRect.getX()) + boxRect.getWidth() - Math.abs(rawRect.getX());
        double imageH = Math.abs(boxRect.getY()) + boxRect.getHeight() - Math.abs(rawRect.getY());
        imageW = rawXStep == 0.0f ? rawRect.getWidth() : imageW;
        imageH = rawYStep == 0.0f ? rawRect.getWidth() : imageH;
        imageW = imageW > 3000.0 ? 3000.0 : imageW;
        imageH = imageH > 3000.0 ? 3000.0 : imageH;
        int iw = (int)imageW;
        iw = Math.max(iw, 1);
        int ih = (int)imageH;
        ih = Math.max(ih, 1);
        if (imageH < 1.0 && imageW < 2.5) {
            iw = 1;
        }
        Rectangle2D.Double fRect = new Rectangle2D.Double(rawRect.getX(), rawRect.getY(), imageW, imageH);
        BufferedImage image = new BufferedImage(iw, ih, 2);
        if (isRotated && (sing = (glyphDisplay = this.decodePatternContent(PatternObj, null, streamData, localStore)).getSingleImagePattern()) != null) {
            return new PatternPaint(PatternObj, streamData, this, this.currentPdfFile.getObjectStore());
        }
        float[] fArray = mm[2];
        fArray[0] = (float)((double)fArray[0] - rawRect.getX());
        float[] fArray2 = mm[2];
        fArray2[1] = (float)((double)fArray2[1] - rawRect.getY());
        glyphDisplay = this.decodePatternContent(PatternObj, (float[][])mm, streamData, localStore);
        Graphics2D g2 = image.createGraphics();
        glyphDisplay.setG2(g2);
        glyphDisplay.paint(null, null, null);
        return new ShearedTexturePaint(image, fRect, rotatedCTM);
    }

    private static float[] getBBBox(float xGap, float yGap, float rawXStep, float rawYStep) {
        float[] bbox = new float[4];
        bbox[2] = rawXStep < 0.0f ? xGap - rawXStep : rawXStep;
        bbox[3] = rawYStep < 0.0f ? yGap - rawYStep : rawYStep;
        return bbox;
    }

    public PatternDisplay decodePatternContent(PdfObject PatternObj, float[][] matrix, byte[] streamData, ObjectStore localStore) {
        PdfObject Resources = PatternObj.getDictionary(2004251818);
        PdfStreamDecoderForPattern glyphDecoder = new PdfStreamDecoderForPattern(this.currentPdfFile);
        glyphDecoder.setParameters(false, true, 7, 0, false);
        glyphDecoder.setObjectValue(-8, localStore);
        PatternDisplay glyphDisplay = new PatternDisplay(0, false, 20, localStore);
        glyphDisplay.fromPattern = true;
        glyphDecoder.setRenderer(glyphDisplay);
        if (Resources != null) {
            glyphDecoder.readResources(Resources, true);
        }
        GraphicsState currentGraphicsState = new GraphicsState(0, 0);
        glyphDecoder.setGS(currentGraphicsState);
        if (matrix != null) {
            currentGraphicsState.CTM = matrix;
        }
        if (this.strokCol == null) {
            glyphDecoder.setDefaultColors(this.gs.getStrokeColor(), this.gs.getNonstrokeColor());
        } else {
            glyphDecoder.setDefaultColors(this.strokCol, this.strokCol);
        }
        glyphDecoder.decodePageContent(currentGraphicsState, streamData);
        return glyphDisplay;
    }

    private PdfPaint setupShading(PdfObject PatternObj, float[][] matrix) {
        PdfArrayIterator shadingArray = PatternObj.getMixedArray(878474856);
        PdfObject Shading = PdfObjectFactory.getPDFObjectObjectFromRefOrDirect(new ShadingObject(PatternObj.getObjectRefAsString()), this.currentPdfFile.getObjectReader(), shadingArray.getNextValueAsByte(true), 878474856);
        PdfArrayIterator ColorSpace2 = Shading.getMixedArray(2087749783);
        GenericColorSpace newColorSpace = ColorspaceFactory.getColorSpaceInstance(this.currentPdfFile, ColorSpace2);
        float[] xObjCoords = new float[]{0.0f, 0.0f};
        if (this.currentPdfFile.xobjectStartTM != null) {
            xObjCoords[0] = this.currentPdfFile.xobjectStartTM[2][0];
            xObjCoords[1] = this.currentPdfFile.xobjectStartTM[2][1];
        }
        ParserOptions parser = new ParserOptions();
        parser.init(true, true, 7, 1, false);
        return new ShadedPaint(Shading, newColorSpace, this.currentPdfFile, matrix, xObjCoords, this.gs, parser);
    }

    public PatternObject getPatternObj() {
        this.currentPdfFile.checkResolved(this.PatternObj);
        return this.PatternObj;
    }

    public PdfObjectReader getObjectReader() {
        return this.currentPdfFile;
    }
}

