/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.utility;

import com.idrsolutions.image.tiff.Deflate;
import com.idrsolutions.image.tiff.TiffDecoder;
import com.idrsolutions.image.utility.DataWriter;
import com.idrsolutions.image.utility.WriterFileBig;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

public class TiffToPdf {
    private final List<Integer> offsets = new ArrayList<Integer>();
    private final List<Integer> pages = new ArrayList<Integer>();
    private int op;
    private int ic;
    private static final String STREAM = "stream\n";
    private static final String ENDSTREAM = "\nendstream\n";
    private static final String ENDOBJ = "endobj\n";

    public void write(BufferedImage image, File pdfFile) throws IOException {
        if (image == null) {
            throw new NullPointerException("BufferedImage must not be null.");
        }
        this.init();
        WriterFileBig writer = new WriterFileBig(pdfFile);
        writer.write("%PDF-1.6\n".getBytes());
        this.appendImage(image, writer);
        this.writeCatalogPagesXref(writer);
        writer.close();
    }

    public void write(File imageFile, File pdfFile) throws Exception {
        WriterFileBig writer;
        RandomAccessFile raf;
        if (imageFile.exists()) {
            try (FileInputStream fis = new FileInputStream(imageFile);){
                byte[] test = new byte[Math.min(140, (int)imageFile.length())];
                fis.read(test);
            }
            raf = new RandomAccessFile(imageFile, "r");
            TiffDecoder decoder = new TiffDecoder();
            decoder.read(raf);
            this.init();
            writer = new WriterFileBig(pdfFile);
            writer.write("%PDF-1.6\n".getBytes());
            for (int i = 1; i <= decoder.getPageCount(); ++i) {
                BufferedImage image = decoder.read(i);
                this.appendImage(image, writer);
            }
        } else {
            throw new FileNotFoundException("Unable to find image file. " + imageFile.getAbsolutePath());
        }
        this.writeCatalogPagesXref(writer);
        writer.close();
        raf.close();
    }

    private void init() {
        this.offsets.clear();
        this.pages.clear();
        this.op = 0;
        this.ic = 0;
        for (int i = 0; i < 2; ++i) {
            this.addToOffsets(0);
        }
    }

    private void appendImage(BufferedImage image, DataWriter writer) throws IOException {
        this.writePage(writer, image.getWidth(), image.getHeight());
        this.writeResources(writer);
        this.writeContentStream(writer, image);
        this.writeXObject(writer, image);
        ++this.ic;
    }

    private void writePage(DataWriter writer, int imageWidth, int imageHeight) throws IOException {
        this.addToOffsets(writer.getLength());
        this.pages.add(this.op);
        int resources = this.op + 1;
        int content = this.op + 2;
        String sb = TiffToPdf.toObj(this.op) + "\n<</Type /Page /Parent 2 0 R /MediaBox [0 0 " + imageWidth + ' ' + imageHeight + "] /Rotate 0 /Resources " + TiffToPdf.toRef(resources) + " /Contents " + TiffToPdf.toRef(content) + ">>\nendobj\n";
        writer.write(sb.getBytes());
    }

    private void writeResources(DataWriter writer) throws IOException {
        this.addToOffsets(writer.getLength());
        String sb = TiffToPdf.toObj(this.op) + '\n' + "<</XObject <</Im" + this.ic + ' ' + TiffToPdf.toRef(this.op + 2) + ">> >>" + ENDOBJ;
        writer.write(sb.getBytes());
    }

    private void writeXObject(DataWriter writer, BufferedImage image) throws IOException {
        byte[] pixels;
        this.addToOffsets(writer.getLength());
        StringBuilder sb = new StringBuilder();
        sb.append(TiffToPdf.toObj(this.op)).append('\n');
        sb.append("<< /Type /XObject /Subtype /Image /Name /X");
        sb.append(" /Width ").append(image.getWidth()).append(" /Height ").append(image.getHeight());
        byte[] alphas = null;
        switch (image.getType()) {
            case 10: {
                pixels = TiffToPdf.handleByteGray(image, sb);
                break;
            }
            case 12: {
                pixels = TiffToPdf.handleByteBinary(image, sb);
                break;
            }
            case 2: 
            case 3: {
                alphas = new byte[image.getWidth() * image.getHeight()];
                pixels = this.handleIntARGB(image, alphas, sb);
                break;
            }
            case 6: 
            case 7: {
                alphas = new byte[image.getWidth() * image.getHeight()];
                pixels = this.handle4ByteABGR(image, alphas, sb);
                break;
            }
            default: {
                pixels = TiffToPdf.handleDefault(image, sb);
            }
        }
        writer.write(sb.toString().getBytes());
        writer.write(STREAM.getBytes());
        writer.write(pixels);
        writer.write(ENDSTREAM.getBytes());
        writer.write(ENDOBJ.getBytes());
        if (alphas != null) {
            alphas = Deflate.compress(alphas, 9);
            this.writeSmask(writer, image, alphas);
        }
    }

    private static byte[] handleDefault(BufferedImage image, StringBuilder sb) throws IOException {
        byte[] pixels = TiffToPdf.grabPixels(image);
        pixels = Deflate.compress(pixels, 9);
        sb.append(" /Length ").append(pixels.length);
        sb.append(" /Filter /FlateDecode /ColorSpace /DeviceRGB /BitsPerComponent 8 >>\n");
        return pixels;
    }

    private byte[] handle4ByteABGR(BufferedImage image, byte[] alphas, StringBuilder sb) throws IOException {
        int p = 0;
        int a = 0;
        int q = 0;
        byte[] pixels = new byte[image.getWidth() * image.getHeight() * 3];
        byte[] temp = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int ii = image.getWidth() * image.getHeight();
        for (int i = 0; i < ii; ++i) {
            alphas[a++] = temp[q];
            pixels[p++] = temp[q + 3];
            pixels[p++] = temp[q + 2];
            pixels[p++] = temp[q + 1];
            q += 4;
        }
        pixels = Deflate.compress(pixels, 9);
        sb.append(" /Length ").append(pixels.length);
        sb.append(" /SMask ").append(TiffToPdf.toRef(this.op + 1));
        sb.append(" /Filter /FlateDecode /ColorSpace /DeviceRGB /BitsPerComponent 8 >>\n");
        return pixels;
    }

    private byte[] handleIntARGB(BufferedImage image, byte[] alphas, StringBuilder sb) throws IOException {
        int p = 0;
        int a = 0;
        byte[] pixels = new byte[image.getWidth() * image.getHeight() * 3];
        int[] pixInts = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int ii = image.getWidth() * image.getHeight();
        for (int i = 0; i < ii; ++i) {
            byte[] argb = TiffToPdf.intToBytes(pixInts[i]);
            alphas[a++] = argb[0];
            pixels[p++] = argb[1];
            pixels[p++] = argb[2];
            pixels[p++] = argb[3];
        }
        pixels = Deflate.compress(pixels, 9);
        sb.append(" /Length ").append(pixels.length);
        sb.append(" /SMask ").append(TiffToPdf.toRef(this.op + 1));
        sb.append(" /Filter /FlateDecode /ColorSpace /DeviceRGB /BitsPerComponent 8 >>\n");
        return pixels;
    }

    private static byte[] handleByteBinary(BufferedImage image, StringBuilder sb) throws IOException {
        byte[] pixels = TiffToPdf.grabPixels(image);
        pixels = Deflate.compress(pixels, 9);
        sb.append(" /Length ").append(pixels.length);
        sb.append(" /BitsPerComponent ").append(image.getColorModel().getPixelSize());
        sb.append(" /Filter /FlateDecode /ColorSpace /DeviceGray >>\n");
        return pixels;
    }

    private static byte[] handleByteGray(BufferedImage image, StringBuilder sb) throws IOException {
        byte[] pixels = TiffToPdf.grabPixels(image);
        pixels = Deflate.compress(pixels, 9);
        sb.append(" /Length ").append(pixels.length);
        sb.append(" /Filter /FlateDecode /ColorSpace /DeviceGray /BitsPerComponent 8 >>\n");
        return pixels;
    }

    private void writeSmask(DataWriter writer, BufferedImage image, byte[] alphas) throws IOException {
        this.addToOffsets(writer.getLength());
        String sb = TiffToPdf.toObj(this.op) + '\n' + "<< /Type /XObject /Subtype /Image /Name /X /Width " + image.getWidth() + " /Height " + image.getHeight() + " /Length " + alphas.length + " /Filter /FlateDecode /ColorSpace /DeviceGray /BitsPerComponent 8 >>\n";
        writer.write(sb.getBytes());
        writer.write(STREAM.getBytes());
        writer.write(alphas);
        writer.write(ENDSTREAM.getBytes());
        writer.write(ENDOBJ.getBytes());
    }

    private void writeContentStream(DataWriter writer, BufferedImage image) throws IOException {
        this.addToOffsets(writer.getLength());
        String conSB = "q\n" + image.getWidth() + " 0 0 " + image.getHeight() + " 0 0 cm\n/Im" + this.ic + " Do\nQ\n";
        byte[] contents = conSB.getBytes();
        String sb = TiffToPdf.toObj(this.op) + "\n<</Length " + contents.length + ">>\n";
        writer.write(sb.getBytes());
        writer.write(STREAM.getBytes());
        writer.write(contents);
        writer.write(ENDSTREAM.getBytes());
        writer.write(ENDOBJ.getBytes());
    }

    private void addToOffsets(int position) {
        ++this.op;
        this.offsets.add(position);
    }

    private static String toRef(int objNum) {
        return objNum + " 0 R";
    }

    private static String toObj(int objNum) {
        return objNum + " 0 obj";
    }

    private static byte[] grabPixels(BufferedImage image) {
        byte[] raw;
        switch (image.getType()) {
            case 1: {
                raw = TiffToPdf.handleIntRGB(image);
                break;
            }
            case 4: {
                raw = TiffToPdf.handleIntBGR(image);
                break;
            }
            case 5: {
                raw = TiffToPdf.handle3ByteBGR(image);
                break;
            }
            case 10: 
            case 12: {
                raw = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                break;
            }
            default: {
                raw = TiffToPdf.handleDefault(image);
            }
        }
        return raw;
    }

    private static byte[] handleDefault(BufferedImage image) {
        byte[] raw = new byte[image.getWidth() * image.getHeight() * 3];
        BufferedImage bImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        bImage.createGraphics().drawImage((Image)image, 0, 0, null);
        int[] pixInts = ((DataBufferInt)bImage.getRaster().getDataBuffer()).getData();
        int p = 0;
        int ii = image.getWidth() * image.getHeight();
        for (int i = 0; i < ii; ++i) {
            byte[] rgb = TiffToPdf.intToBytes(pixInts[i]);
            raw[p++] = rgb[1];
            raw[p++] = rgb[2];
            raw[p++] = rgb[3];
        }
        return raw;
    }

    private static byte[] handle3ByteBGR(BufferedImage image) {
        int ih = image.getHeight();
        int iw = image.getWidth();
        byte[] raw = new byte[ih * iw * 3];
        byte[] pByte = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int pb = 0;
        int p = 0;
        for (int i = 0; i < ih; ++i) {
            for (int j = 0; j < iw; ++j) {
                raw[p++] = pByte[pb + 2];
                raw[p++] = pByte[pb + 1];
                raw[p++] = pByte[pb];
                pb += 3;
            }
        }
        return raw;
    }

    private static byte[] handleIntBGR(BufferedImage image) {
        int ih = image.getHeight();
        int iw = image.getWidth();
        byte[] raw = new byte[ih * iw * 3];
        int p = 0;
        int[] pixInts = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int bb = 0;
        for (int i = 0; i < ih; ++i) {
            for (int j = 0; j < iw; ++j) {
                byte[] bgr = TiffToPdf.intToBytes(pixInts[bb]);
                raw[p++] = bgr[3];
                raw[p++] = bgr[2];
                raw[p++] = bgr[1];
                ++bb;
            }
        }
        return raw;
    }

    private static byte[] handleIntRGB(BufferedImage image) {
        int ih = image.getHeight();
        int iw = image.getWidth();
        int dim = ih * iw;
        int p = 0;
        byte[] raw = new byte[ih * iw * 3];
        int[] pixInts = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int aa = 0;
        for (int i = 0; i < dim; ++i) {
            byte[] rgb = TiffToPdf.intToBytes(pixInts[aa]);
            raw[p++] = rgb[1];
            raw[p++] = rgb[2];
            raw[p++] = rgb[3];
            ++aa;
        }
        return raw;
    }

    private static byte[] intToBytes(int value) {
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    private void writeCatalogPagesXref(DataWriter writer) throws IOException {
        this.offsets.set(0, writer.getLength());
        StringBuilder sb = new StringBuilder();
        sb.append(TiffToPdf.toObj(1));
        sb.append("\n<</Type /Catalog /Pages 2 0 R>>\n");
        sb.append(ENDOBJ);
        writer.write(sb.toString().getBytes());
        this.offsets.set(1, writer.getLength());
        sb = new StringBuilder();
        sb.append(TiffToPdf.toObj(2));
        sb.append("\n<</Type /Pages /Kids [ ");
        for (Integer page : this.pages) {
            sb.append(TiffToPdf.toRef(page)).append(' ');
        }
        sb.append("] /Count ").append(this.pages.size());
        sb.append(">>\n");
        sb.append(ENDOBJ);
        writer.write(sb.toString().getBytes());
        int xrefPos = writer.getLength();
        sb = new StringBuilder();
        sb.append("xref\n0 ").append(this.offsets.size() + 1);
        sb.append("\n0000000000 65535 f\t\n");
        for (Integer offset : this.offsets) {
            sb.append(TiffToPdf.offsetTo10Digits(offset)).append(" 00000 n\t\n");
        }
        sb.append("trailer <</Size ").append(this.offsets.size() + 1).append("/Root 1 0 R>>");
        sb.append("\nstartxref\n").append(xrefPos).append("\n%%EOF");
        writer.write(sb.toString().getBytes());
    }

    private static String offsetTo10Digits(int offset) {
        String offstr = String.valueOf(offset);
        int len = offstr.length();
        StringBuilder sb = new StringBuilder();
        int ii = 10 - len;
        for (int i = 0; i < ii; ++i) {
            sb.append('0');
        }
        sb.append(offstr);
        return sb.toString();
    }
}

