/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import jakarta.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.core.ClonePolicy;
import org.apache.axiom.core.CloneableCharacterData;
import org.apache.axiom.core.CoreCharacterDataNode;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.NodeType;
import org.apache.axiom.core.Semantics;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.mime.PartDataHandler;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMInformationItem;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSerializable;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.common.AxiomExceptionTranslator;
import org.apache.axiom.om.impl.common.AxiomSemantics;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;
import org.apache.axiom.om.impl.intf.AxiomCharacterDataNode;
import org.apache.axiom.om.impl.intf.AxiomText;
import org.apache.axiom.om.impl.intf.TextContent;
import org.apache.axiom.om.impl.llom.AxiomLeafNodeImpl;

public final class AxiomCharacterDataNodeImpl
extends AxiomLeafNodeImpl
implements AxiomCharacterDataNode,
CoreCharacterDataNode,
AxiomText,
OMText,
OMNode,
OMSerializable,
OMInformationItem {
    private Object data;

    public AxiomCharacterDataNodeImpl() {
        this.init$AxiomCharacterDataNodeMixin();
        this.init$CoreCharacterDataNodeMixin();
        this.init$AxiomTextMixin();
    }

    private void init$AxiomCharacterDataNodeMixin() {
    }

    private void init$CoreCharacterDataNodeMixin() {
    }

    private void init$AxiomTextMixin() {
    }

    public final int getType() {
        return this.coreIsIgnorable() ? 6 : 4;
    }

    public final void serialize(XMLStreamWriter writer, boolean cache) throws XMLStreamException {
        writer.writeCharacters(this.coreGetCharacterData().toString());
    }

    @Override
    public final NodeType coreGetNodeType() {
        return NodeType.CHARACTER_DATA;
    }

    @Override
    public final boolean coreIsIgnorable() {
        return this.internalGetFlag(32);
    }

    @Override
    public final void coreSetIgnorable(boolean ignorable) {
        this.internalSetFlag(32, ignorable);
    }

    @Override
    public final Object coreGetCharacterData() {
        return this.data == null ? "" : this.data;
    }

    @Override
    public final void coreSetCharacterData(Object data) {
        this.data = data;
    }

    @Override
    public final void coreSetCharacterData(Object data, Semantics semantics) {
        this.data = data;
    }

    @Override
    public final <T> void init(ClonePolicy<T> policy, T options, CoreNode other) {
        CoreCharacterDataNode o = (CoreCharacterDataNode)other;
        Object otherData = o.coreGetCharacterData();
        this.data = otherData instanceof CloneableCharacterData ? ((CloneableCharacterData)otherData).clone(policy, options) : otherData;
        this.coreSetIgnorable(o.coreIsIgnorable());
    }

    @Override
    public final void internalSerialize(XmlHandler handler, boolean cache) throws StreamException {
        handler.processCharacterData(this.coreGetCharacterData(), this.coreIsIgnorable());
    }

    private TextContent getTextContent(boolean force) {
        try {
            Object content = this.coreGetCharacterData();
            if (content instanceof TextContent) {
                return (TextContent)content;
            }
            if (force) {
                TextContent textContent = new TextContent((String)content);
                this.coreSetCharacterData(textContent, AxiomSemantics.INSTANCE);
                return textContent;
            }
            return null;
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    public final boolean isBinary() {
        TextContent textContent = this.getTextContent(false);
        return textContent != null && textContent.isBinary();
    }

    public final void setBinary(boolean binary) {
        TextContent textContent = this.getTextContent(binary);
        if (textContent != null) {
            textContent.setBinary(binary);
        }
    }

    public final boolean isOptimized() {
        TextContent textContent = this.getTextContent(false);
        return textContent != null && textContent.isOptimize();
    }

    public final void setOptimize(boolean optimize) {
        TextContent textContent = this.getTextContent(optimize);
        if (textContent != null) {
            textContent.setOptimize(optimize);
        }
    }

    public final String getText() throws OMException {
        try {
            return this.coreGetCharacterData().toString();
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    public final char[] getTextCharacters() {
        try {
            Object content = this.coreGetCharacterData();
            if (content instanceof TextContent) {
                return ((TextContent)content).toCharArray();
            }
            return ((String)content).toCharArray();
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    public final boolean isCharacters() {
        return false;
    }

    public final QName getTextAsQName() throws OMException {
        return ((OMElement)this.getParent()).resolveQName(this.getText());
    }

    public final OMNamespace getNamespace() {
        QName qname = this.getTextAsQName();
        if (qname == null) {
            return null;
        }
        String namespaceURI = qname.getNamespaceURI();
        return namespaceURI.length() == 0 ? null : new OMNamespaceImpl(namespaceURI, qname.getPrefix());
    }

    public final DataHandler getDataHandler() {
        try {
            Object content = this.coreGetCharacterData();
            if (content instanceof TextContent) {
                return ((TextContent)content).getDataHandler();
            }
            throw new OMException("No DataHandler available");
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    public final String getContentID() {
        return this.getTextContent(true).getContentID();
    }

    public final void buildWithAttachments() {
        DataHandler dataHandler;
        if (this.isOptimized() && (dataHandler = this.getDataHandler()) instanceof PartDataHandler) {
            ((PartDataHandler)dataHandler).getPart().fetch();
        }
    }

    public final void setContentID(String cid) {
        this.getTextContent(true).setContentID(cid);
    }
}

