/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package coldfusion.tagext.mail;

import coldfusion.runtime.ApplicationException;
import coldfusion.tagext.ChildTag;
import coldfusion.tagext.net.MailFilterable;

import java.util.HashMap;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.Tag;

/**
 * This tag is a child tag to set filter conditions for search operations. This tag can be embedded only within tag
 * classes extended from ImapTag
 * 
 * @author shilpik
 * @tag popfilter
 * @tagbody jsp
 * 
 */
public class PopFilterTag extends ChildTag
{
    protected static final long serialVersionUID = 1L;

    // Name of the filter attribute
    public String name = null;
    // Value of the filter attribute
    public Object value = null;
    // for date range attributes this is 'from' date value
    public String from = null;
    // for date range attributes this is 'to' date value
    public String to = null;

    MailFilterable popTag = null;

    public PopFilterTag()
    {
        super(PopTag.class);
    }

    protected void setAncestor(Tag ancestor)
    {
        popTag = (MailFilterable) ancestor;
    }

    public void setParent(Tag parent)
    {
        Class ancestorClass = PopTag.class;

        while (parent != null && !ancestorClass.isAssignableFrom(parent.getClass()))
        {
            parent = parent.getParent();
        }

        if (parent != null)
        {
            setAncestor(parent);
        }
    }

    public String getFrom()
    {
        return from;
    }

    public String getName()
    {
        return name;
    }

    public String getTo()
    {
        return to;
    }

    public Object getValue()
    {
        return value;
    }

    /**
     * @tagattribute
     * @required no
     * @rtexprvalue yes
     */
    public void setFrom(String from)
    {
        this.from = from;
    }

    /**
     * @tagattribute
     * @required yes
     * @rtexprvalue yes
     */
    public void setName(String name)
    {
        if ((name == null) || (name.trim().length() == 0))
        {
            throw new InvalidAttributeValueException("name");
        }

        this.name = name;
    }

    /**
     * Value for the {attribName} attribute is invalid.
     */
    public class InvalidAttributeValueException extends ApplicationException
    {
        private static final long serialVersionUID = 1L;
        public String attribName;

        public InvalidAttributeValueException(String attribName)
        {
            this.attribName = attribName;
        }
    }

    /**
     * @tagattribute
     * @required no
     * @rtexprvalue yes
     */
    public void setTo(String to)
    {
        this.to = to;
    }

    /**
     * @tagattribute
     * @required no
     * @rtexprvalue yes
     */
    public void setValue(Object value)
    {
        this.value = value;
    }
    
    protected static final String KEY_FROM = "from";
    protected static final String KEY_TO = "to";
    protected static final String KEY_VALUE = "value";
    
    public int doStartTag() throws JspException
    {
        onTagStart();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (value != null)
            map.put(KEY_VALUE, value);
        if (from != null)
            map.put(KEY_FROM, from);
        if (to != null)
            map.put(KEY_TO, to);
        popTag.addFilter(name, map);
        return EVAL_PAGE;
    }

    public void release()
    {
        super.release();
        from = null;
        name = null;
        to = null;
        value = null;
        onTagEnd();
    }
}
