/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;
import org.apache.solr.core.RateLimiterConfig;

@ThreadSafe
public class RequestRateLimiter {
    private final Semaphore totalSlotsPool;
    private final Semaphore borrowableSlotsPool;
    private final AtomicInteger nativeReservations;
    private final RateLimiterConfig rateLimiterConfig;
    public static final SlotReservation UNLIMITED = () -> {};

    public RequestRateLimiter(RateLimiterConfig rateLimiterConfig) {
        this.rateLimiterConfig = rateLimiterConfig;
        this.totalSlotsPool = new Semaphore(rateLimiterConfig.allowedRequests);
        int guaranteedSlots = rateLimiterConfig.guaranteedSlotsThreshold;
        if (!rateLimiterConfig.isSlotBorrowingEnabled || guaranteedSlots >= rateLimiterConfig.allowedRequests) {
            this.borrowableSlotsPool = null;
            this.nativeReservations = null;
        } else if (guaranteedSlots <= 0) {
            this.borrowableSlotsPool = this.totalSlotsPool;
            this.nativeReservations = null;
        } else {
            this.borrowableSlotsPool = new Semaphore(rateLimiterConfig.allowedRequests - guaranteedSlots);
            this.nativeReservations = new AtomicInteger();
        }
    }

    @VisibleForTesting
    boolean isEmpty() {
        if (this.totalSlotsPool.availablePermits() != this.rateLimiterConfig.allowedRequests) {
            return false;
        }
        if (this.nativeReservations == null) {
            return true;
        }
        if (this.nativeReservations.get() != 0) {
            return false;
        }
        assert (this.borrowableSlotsPool != null);
        return this.borrowableSlotsPool.availablePermits() == this.rateLimiterConfig.allowedRequests - this.rateLimiterConfig.guaranteedSlotsThreshold;
    }

    public SlotReservation handleRequest() throws InterruptedException {
        if (!this.rateLimiterConfig.isEnabled) {
            return UNLIMITED;
        }
        if (this.totalSlotsPool.tryAcquire(this.rateLimiterConfig.waitForSlotAcquisition, TimeUnit.MILLISECONDS)) {
            if (this.nativeReservations == null) {
                assert (this.borrowableSlotsPool == null || this.totalSlotsPool == this.borrowableSlotsPool);
                return new SingleSemaphoreReservation(this.totalSlotsPool);
            }
            assert (this.borrowableSlotsPool != null);
            if (this.nativeReservations.incrementAndGet() <= this.rateLimiterConfig.guaranteedSlotsThreshold || this.borrowableSlotsPool.tryAcquire()) {
                return new NativeBorrowableReservation(this.totalSlotsPool, this.borrowableSlotsPool, this.nativeReservations, this.rateLimiterConfig.guaranteedSlotsThreshold);
            }
            this.nativeReservations.decrementAndGet();
            this.totalSlotsPool.release();
            throw new IllegalStateException("if we have a top-level slot, there should be an available borrowable slot");
        }
        return null;
    }

    public SlotReservation allowSlotBorrowing() throws InterruptedException {
        if (this.borrowableSlotsPool == null) {
            return null;
        }
        if (this.totalSlotsPool.tryAcquire()) {
            if (this.totalSlotsPool == this.borrowableSlotsPool) {
                return new SingleSemaphoreReservation(this.borrowableSlotsPool);
            }
            if (this.borrowableSlotsPool.tryAcquire()) {
                return new BorrowedReservation(this.totalSlotsPool, this.borrowableSlotsPool);
            }
            this.totalSlotsPool.release();
        }
        return null;
    }

    public RateLimiterConfig getRateLimiterConfig() {
        return this.rateLimiterConfig;
    }

    public static interface SlotReservation
    extends Closeable {
    }

    static class SingleSemaphoreReservation
    implements SlotReservation {
        private final Semaphore usedPool;

        public SingleSemaphoreReservation(Semaphore usedPool) {
            assert (usedPool != null);
            this.usedPool = usedPool;
        }

        @Override
        public void close() {
            this.usedPool.release();
        }
    }

    static class NativeBorrowableReservation
    implements SlotReservation {
        private final Semaphore totalPool;
        private final Semaphore borrowablePool;
        private final AtomicInteger nativeReservations;
        private final int guaranteedSlots;

        public NativeBorrowableReservation(Semaphore totalPool, Semaphore borrowablePool, AtomicInteger nativeReservations, int guaranteedSlots) {
            this.totalPool = totalPool;
            this.borrowablePool = borrowablePool;
            this.nativeReservations = nativeReservations;
            this.guaranteedSlots = guaranteedSlots;
        }

        @Override
        public void close() {
            if (this.nativeReservations.getAndDecrement() > this.guaranteedSlots) {
                this.borrowablePool.release();
            }
            this.totalPool.release();
        }
    }

    static class BorrowedReservation
    implements SlotReservation {
        private final Semaphore totalPool;
        private final Semaphore borrowablePool;

        public BorrowedReservation(Semaphore totalPool, Semaphore borrowablePool) {
            this.totalPool = totalPool;
            this.borrowablePool = borrowablePool;
        }

        @Override
        public void close() {
            this.borrowablePool.release();
            this.totalPool.release();
        }
    }
}

