/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.QueryRescorer;
import org.apache.lucene.search.ScoreDoc;
import org.apache.solr.search.ReRankOperator;
import org.apache.solr.search.SyntaxError;

public class ReRankScaler {
    protected int mainQueryMin = -1;
    protected int mainQueryMax = -1;
    protected int reRankQueryMin = -1;
    protected int reRankQueryMax = -1;
    protected boolean explainResults;
    protected ReRankOperator reRankOperator;
    protected ReRankScalerExplain reRankScalerExplain;
    private QueryRescorer replaceRescorer;
    private Set<Integer> reRankSet;
    private double reRankScaleWeight;

    public ReRankScaler(String mainScale, String reRankScale, double reRankScaleWeight, ReRankOperator reRankOperator, QueryRescorer replaceRescorer, boolean explainResults) throws SyntaxError {
        this.reRankScaleWeight = reRankScaleWeight;
        this.explainResults = explainResults;
        this.reRankScalerExplain = new ReRankScalerExplain(mainScale, reRankScale);
        this.replaceRescorer = replaceRescorer;
        if (reRankOperator != ReRankOperator.ADD && reRankOperator != ReRankOperator.MULTIPLY && reRankOperator != ReRankOperator.REPLACE) {
            throw new SyntaxError("ReRank scaling only supports ADD, Multiply and Replace operators");
        }
        this.reRankOperator = reRankOperator;
        if (this.reRankScalerExplain.getMainScale() != null) {
            String[] mainMinMax = this.reRankScalerExplain.getMainScale().split("-");
            this.mainQueryMin = Integer.parseInt(mainMinMax[0]);
            this.mainQueryMax = Integer.parseInt(mainMinMax[1]);
        }
        if (this.reRankScalerExplain.getReRankScale() != null) {
            String[] reRankMinMax = this.reRankScalerExplain.getReRankScale().split("-");
            this.reRankQueryMin = Integer.parseInt(reRankMinMax[0]);
            this.reRankQueryMax = Integer.parseInt(reRankMinMax[1]);
        }
    }

    public int hashCode() {
        return Integer.hashCode(this.mainQueryMax) + Integer.hashCode(this.mainQueryMin) + Integer.hashCode(this.reRankQueryMin) + Integer.hashCode(this.reRankQueryMax) + this.reRankOperator.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ReRankScaler) {
            ReRankScaler _reRankScaler = (ReRankScaler)o;
            return this.mainQueryMin == _reRankScaler.mainQueryMin && this.mainQueryMax == _reRankScaler.mainQueryMax && this.reRankQueryMin == _reRankScaler.reRankQueryMin && this.reRankQueryMax == _reRankScaler.reRankQueryMax && this.reRankOperator.equals((Object)_reRankScaler.reRankOperator);
        }
        return false;
    }

    public QueryRescorer getReplaceRescorer() {
        return this.replaceRescorer;
    }

    public int getMainQueryMin() {
        return this.mainQueryMin;
    }

    public int getMainQueryMax() {
        return this.mainQueryMax;
    }

    public int getReRankQueryMin() {
        return this.reRankQueryMin;
    }

    public int getReRankQueryMax() {
        return this.reRankQueryMax;
    }

    public ReRankScalerExplain getReRankScalerExplain() {
        return this.reRankScalerExplain;
    }

    public double getReRankScaleWeight() {
        return this.reRankScaleWeight;
    }

    public boolean scaleScores() {
        return this.scaleMainScores() || this.scaleReRankScores();
    }

    public boolean scaleMainScores() {
        return this.mainQueryMin > -1 && this.mainQueryMax > -1;
    }

    public boolean scaleReRankScores() {
        return this.reRankQueryMin > -1 && this.reRankQueryMax > -1;
    }

    public ScoreDoc[] scaleScores(ScoreDoc[] originalDocs, ScoreDoc[] rescoredDocs, int howMany) {
        HashMap<Integer, Float> originalScoreMap = new HashMap<Integer, Float>();
        Map<Integer, Float> scaledOriginalScoreMap = null;
        Map<Integer, Float> scaledRescoredMap = null;
        HashMap<Integer, Float> rescoredMap = new HashMap<Integer, Float>();
        for (ScoreDoc scoreDoc : originalDocs) {
            originalScoreMap.put(scoreDoc.doc, Float.valueOf(scoreDoc.score));
        }
        if (this.scaleMainScores()) {
            MinMaxExplain mainExplain = ReRankScaler.getMinMaxExplain(this.mainQueryMin, this.mainQueryMax, originalScoreMap);
            scaledOriginalScoreMap = ReRankScaler.minMaxScaleScores(originalScoreMap, mainExplain);
            this.reRankScalerExplain.setMainScaleExplain(mainExplain);
        } else {
            scaledOriginalScoreMap = originalScoreMap;
        }
        this.reRankSet = this.explainResults ? new HashSet() : null;
        for (int i = 0; i < howMany; ++i) {
            float score;
            ScoreDoc rescoredDoc = rescoredDocs[i];
            int doc = rescoredDoc.doc;
            if (this.explainResults) {
                this.reRankSet.add(doc);
            }
            if (!((score = rescoredDoc.score) > 0.0f)) continue;
            rescoredMap.put(doc, Float.valueOf(score));
        }
        if (this.scaleReRankScores()) {
            MinMaxExplain reRankExplain = ReRankScaler.getMinMaxExplain(this.reRankQueryMin, this.reRankQueryMax, rescoredMap);
            scaledRescoredMap = ReRankScaler.minMaxScaleScores(rescoredMap, reRankExplain);
            this.reRankScalerExplain.setReRankScaleExplain(reRankExplain);
        } else {
            scaledRescoredMap = rescoredMap;
        }
        ScoreDoc[] scaledScoreDocs = new ScoreDoc[originalDocs.length];
        int index = 0;
        for (Map.Entry<Integer, Float> entry : scaledOriginalScoreMap.entrySet()) {
            int doc = entry.getKey();
            float scaledScore = entry.getValue().floatValue();
            ScoreDoc scoreDoc = null;
            scoreDoc = scaledRescoredMap.containsKey(doc) ? new ScoreDoc(doc, ReRankScaler.combineScores(scaledScore, scaledRescoredMap.get(doc).floatValue(), this.reRankScaleWeight, this.reRankOperator)) : new ScoreDoc(doc, scaledScore);
            scaledScoreDocs[index++] = scoreDoc;
        }
        Comparator<ScoreDoc> sortDocComparator = new Comparator<ScoreDoc>(){

            @Override
            public int compare(ScoreDoc a, ScoreDoc b) {
                if (a.score > b.score) {
                    return -1;
                }
                if (a.score < b.score) {
                    return 1;
                }
                return a.doc - b.doc;
            }
        };
        Arrays.sort(scaledScoreDocs, sortDocComparator);
        return scaledScoreDocs;
    }

    public static float combineScores(float orginalScore, float reRankScore, double reRankScaleWeight, ReRankOperator reRankOperator) {
        switch (reRankOperator) {
            case ADD: {
                return (float)((double)orginalScore + reRankScaleWeight * (double)reRankScore);
            }
            case REPLACE: {
                return (float)(reRankScaleWeight * (double)reRankScore);
            }
            case MULTIPLY: {
                return (float)((double)orginalScore * reRankScaleWeight * (double)reRankScore);
            }
        }
        return -1.0f;
    }

    public Explanation explain(int doc, Explanation mainQueryExplain, Explanation reRankQueryExplain) {
        float reRankScore = reRankQueryExplain.getDetails()[1].getValue().floatValue();
        float mainScore = mainQueryExplain.getValue().floatValue();
        if (null == this.reRankSet) {
            return Explanation.match((Number)Float.valueOf(reRankScore), (String)"ReRank Scaling effects unkown, consider using distrib.singlePass=true (see https://issues.apache.org/jira/browse/SOLR-17299)", (Explanation[])new Explanation[]{reRankQueryExplain});
        }
        if (this.reRankSet.contains(doc)) {
            if (this.scaleMainScores() && this.scaleReRankScores()) {
                if (reRankScore > 0.0f) {
                    MinMaxExplain mainScaleExplain = this.reRankScalerExplain.getMainScaleExplain();
                    MinMaxExplain reRankScaleExplain = this.reRankScalerExplain.getReRankScaleExplain();
                    float scaledMainScore = mainScaleExplain.scale(mainScore);
                    float scaledReRankScore = reRankScaleExplain.scale(reRankScore);
                    float combinedScaleScore = ReRankScaler.combineScores(scaledMainScore, scaledReRankScore, this.reRankScaleWeight, this.reRankOperator);
                    return Explanation.match((Number)Float.valueOf(combinedScaleScore), (String)"combined scaled first and second pass score", (Explanation[])new Explanation[]{Explanation.match((Number)Float.valueOf(scaledMainScore), (String)("first pass score scaled between: " + this.reRankScalerExplain.getMainScale()), (Explanation[])new Explanation[]{reRankQueryExplain.getDetails()[0], Explanation.match((Number)Float.valueOf(mainScaleExplain.localMin), (String)"min first pass score", (Explanation[])new Explanation[0]), Explanation.match((Number)Float.valueOf(mainScaleExplain.localMax), (String)"max first pass score", (Explanation[])new Explanation[0])}), Explanation.match((Number)Float.valueOf(scaledReRankScore), (String)("second pass score scaled between: " + this.reRankScalerExplain.getReRankScale()), (Explanation[])new Explanation[]{reRankQueryExplain.getDetails()[1], Explanation.match((Number)Float.valueOf(reRankScaleExplain.localMin), (String)"min second pass score", (Explanation[])new Explanation[0]), Explanation.match((Number)Float.valueOf(reRankScaleExplain.localMax), (String)"max second pass score", (Explanation[])new Explanation[0])}), Explanation.match((Number)this.reRankScaleWeight, (String)"rerank weight", (Explanation[])new Explanation[0])});
                }
                MinMaxExplain mainScaleExplain = this.reRankScalerExplain.getMainScaleExplain();
                float scaledMainScore = mainScaleExplain.scale(mainScore);
                return Explanation.match((Number)Float.valueOf(scaledMainScore), (String)"combined scaled first and second pass score", (Explanation[])new Explanation[]{Explanation.match((Number)Float.valueOf(scaledMainScore), (String)"scaled first pass score", (Explanation[])new Explanation[]{reRankQueryExplain.getDetails()[0], Explanation.match((Number)Float.valueOf(mainScaleExplain.localMin), (String)"min first pass score", (Explanation[])new Explanation[0]), Explanation.match((Number)Float.valueOf(mainScaleExplain.localMax), (String)"max first pass score", (Explanation[])new Explanation[0])}), reRankQueryExplain.getDetails()[1]});
            }
            if (this.scaleMainScores() && !this.scaleReRankScores()) {
                MinMaxExplain mainScaleExplain = this.reRankScalerExplain.getMainScaleExplain();
                float scaledMainScore = mainScaleExplain.scale(mainScore);
                float combinedScaleScore = ReRankScaler.combineScores(scaledMainScore, reRankScore, this.reRankScaleWeight, this.reRankOperator);
                return Explanation.match((Number)Float.valueOf(combinedScaleScore), (String)"combined scaled first and unscaled second pass score ", (Explanation[])new Explanation[]{Explanation.match((Number)Float.valueOf(scaledMainScore), (String)("first pass score scaled between: " + this.reRankScalerExplain.getMainScale()), (Explanation[])new Explanation[]{reRankQueryExplain.getDetails()[0], Explanation.match((Number)Float.valueOf(mainScaleExplain.localMin), (String)"min first pass score", (Explanation[])new Explanation[0]), Explanation.match((Number)Float.valueOf(mainScaleExplain.localMax), (String)"max first pass score", (Explanation[])new Explanation[0])}), reRankQueryExplain.getDetails()[1], Explanation.match((Number)this.reRankScaleWeight, (String)"rerank weight", (Explanation[])new Explanation[0])});
            }
            if (!this.scaleMainScores() && this.scaleReRankScores()) {
                if (reRankScore > 0.0f) {
                    MinMaxExplain reRankScaleExplain = this.reRankScalerExplain.getReRankScaleExplain();
                    float scaledReRankScore = reRankScaleExplain.scale(reRankScore);
                    float combinedScaleScore = ReRankScaler.combineScores(mainScore, scaledReRankScore, this.reRankScaleWeight, this.reRankOperator);
                    return Explanation.match((Number)Float.valueOf(combinedScaleScore), (String)"combined unscaled first and scaled second pass score ", (Explanation[])new Explanation[]{reRankQueryExplain.getDetails()[0], Explanation.match((Number)Float.valueOf(scaledReRankScore), (String)("second pass score scaled between:" + this.reRankScalerExplain.reRankScale), (Explanation[])new Explanation[]{reRankQueryExplain.getDetails()[1], Explanation.match((Number)Float.valueOf(reRankScaleExplain.localMin), (String)"min second pass score", (Explanation[])new Explanation[0]), Explanation.match((Number)Float.valueOf(reRankScaleExplain.localMax), (String)"max sceond pass score", (Explanation[])new Explanation[0])}), Explanation.match((Number)this.reRankScaleWeight, (String)"rerank weight", (Explanation[])new Explanation[0])});
                }
                return null;
            }
            return null;
        }
        if (this.scaleMainScores()) {
            MinMaxExplain mainScaleExplain = this.reRankScalerExplain.getMainScaleExplain();
            float scaledMainScore = mainScaleExplain.scale(mainScore);
            return Explanation.match((Number)Float.valueOf(scaledMainScore), (String)("scaled main query score between: " + this.reRankScalerExplain.mainScale), (Explanation[])new Explanation[]{mainQueryExplain, Explanation.match((Number)Float.valueOf(mainScaleExplain.localMin), (String)"min main query score", (Explanation[])new Explanation[0]), Explanation.match((Number)Float.valueOf(mainScaleExplain.localMax), (String)"max main query score", (Explanation[])new Explanation[0])});
        }
        return null;
    }

    public static MinMaxExplain getMinMaxExplain(float scaleMin, float scaleMax, Map<Integer, Float> docScoreMap) {
        float localMin = Float.MAX_VALUE;
        float localMax = Float.MIN_VALUE;
        for (float score : docScoreMap.values()) {
            localMin = Math.min(localMin, score);
            localMax = Math.max(localMax, score);
        }
        return new MinMaxExplain(scaleMin, scaleMax, localMin, localMax);
    }

    public static Map<Integer, Float> minMaxScaleScores(Map<Integer, Float> docScoreMap, MinMaxExplain explain) {
        HashMap<Integer, Float> scaledScores = new HashMap<Integer, Float>();
        for (Map.Entry<Integer, Float> entry : docScoreMap.entrySet()) {
            int doc = entry.getKey();
            float score = entry.getValue().floatValue();
            scaledScores.put(doc, Float.valueOf(explain.scale(score)));
        }
        return scaledScores;
    }

    public static final class ReRankScalerExplain {
        private MinMaxExplain mainScaleExplain;
        private MinMaxExplain reRankScaleExplain;
        private String mainScale;
        private String reRankScale;

        public ReRankScalerExplain(String mainScale, String reRankScale) {
            this.mainScale = mainScale;
            this.reRankScale = reRankScale;
        }

        public MinMaxExplain getMainScaleExplain() {
            return this.mainScaleExplain;
        }

        public MinMaxExplain getReRankScaleExplain() {
            return this.reRankScaleExplain;
        }

        public void setMainScaleExplain(MinMaxExplain mainScaleExplain) {
            this.mainScaleExplain = mainScaleExplain;
        }

        public void setReRankScaleExplain(MinMaxExplain reRankScaleExplain) {
            this.reRankScaleExplain = reRankScaleExplain;
        }

        public boolean reRankScale() {
            return this.getMainScale() != null || this.getReRankScale() != null;
        }

        public String getMainScale() {
            return this.mainScale;
        }

        public String getReRankScale() {
            return this.reRankScale;
        }

        public Explanation explain() {
            if (this.getMainScale() != null && this.getReRankScale() != null) {
                return Explanation.noMatch((String)"ReRankScaler Explain", (Explanation[])new Explanation[]{this.mainScaleExplain.explain("first pass scale"), this.reRankScaleExplain.explain("second pass scale")});
            }
            if (this.getMainScale() != null) {
                return this.mainScaleExplain.explain("first pass scale");
            }
            if (this.getReRankScale() != null) {
                return this.reRankScaleExplain.explain("second pass scale");
            }
            return null;
        }
    }

    public static final class MinMaxExplain {
        public final float scaleMin;
        public final float scaleMax;
        public final float localMin;
        public final float localMax;
        private float diff;

        public MinMaxExplain(float scaleMin, float scaleMax, float localMin, float localMax) {
            this.scaleMin = scaleMin;
            this.scaleMax = scaleMax;
            this.localMin = localMin;
            this.localMax = localMax;
            this.diff = scaleMax - scaleMin;
        }

        public Explanation explain(String message) {
            return Explanation.noMatch((String)message, (Explanation[])new Explanation[]{Explanation.match((Number)Float.valueOf(this.localMin), (String)"min score", (Explanation[])new Explanation[0]), Explanation.match((Number)Float.valueOf(this.localMax), (String)"max score", (Explanation[])new Explanation[0])});
        }

        public float scale(float score) {
            if (this.localMin == this.localMax) {
                return (this.scaleMin + this.scaleMax) / 2.0f;
            }
            float scaledScore = (score - this.localMin) / (this.localMax - this.localMin);
            if (this.scaleMin != 0.0f || this.scaleMax != 1.0f) {
                scaledScore = this.diff * scaledScore + this.scaleMin;
                return scaledScore;
            }
            return scaledScore;
        }
    }
}

