/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.github.benmanes.caffeine.cache.Interner;
import com.google.common.annotations.VisibleForTesting;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopTracerFactory;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.Application;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.config.Lookup;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.solr.api.ClusterPluginsSource;
import org.apache.solr.api.ContainerPluginsRegistry;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.SolrHttpClientBuilder;
import org.apache.solr.client.solrj.impl.SolrHttpClientContextBuilder;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.util.SolrIdentifierValidator;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ClusterSingleton;
import org.apache.solr.cloud.OverseerTaskQueue;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.api.collections.DistributedCollectionConfigSetCommandRunner;
import org.apache.solr.cluster.events.ClusterEventProducer;
import org.apache.solr.cluster.events.impl.ClusterEventProducerFactory;
import org.apache.solr.cluster.placement.PlacementPluginConfig;
import org.apache.solr.cluster.placement.PlacementPluginFactory;
import org.apache.solr.cluster.placement.impl.DelegatingPlacementPluginFactory;
import org.apache.solr.cluster.placement.impl.PlacementPluginFactoryLoader;
import org.apache.solr.common.AlreadyClosedException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterPropertiesListener;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.ObjectCache;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.BlobRepository;
import org.apache.solr.core.CloserThread;
import org.apache.solr.core.ClusterSingletons;
import org.apache.solr.core.ConfigSet;
import org.apache.solr.core.ConfigSetService;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.CoreSorter;
import org.apache.solr.core.CoresLocator;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.NodeRoles;
import org.apache.solr.core.PluginBag;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrCoreInitializationException;
import org.apache.solr.core.SolrCores;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.core.SolrPaths;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.SolrXmlConfig;
import org.apache.solr.core.TracerConfigurator;
import org.apache.solr.core.ZkContainer;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.core.backup.repository.BackupRepositoryFactory;
import org.apache.solr.filestore.ClusterFileStore;
import org.apache.solr.filestore.DistribFileStore;
import org.apache.solr.filestore.FileStore;
import org.apache.solr.filestore.NodeFileStore;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.ConfigSetsHandler;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.HealthCheckHandler;
import org.apache.solr.handler.admin.InfoHandler;
import org.apache.solr.handler.admin.MetricsHandler;
import org.apache.solr.handler.admin.SecurityConfHandler;
import org.apache.solr.handler.admin.SecurityConfHandlerLocal;
import org.apache.solr.handler.admin.SecurityConfHandlerZk;
import org.apache.solr.handler.admin.ZookeeperInfoHandler;
import org.apache.solr.handler.admin.ZookeeperReadAPI;
import org.apache.solr.handler.admin.ZookeeperStatusHandler;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.handler.designer.SchemaDesignerAPI;
import org.apache.solr.jersey.InjectionFactories;
import org.apache.solr.jersey.JerseyAppHandlerCache;
import org.apache.solr.logging.LogWatcher;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.metrics.SolrCoreMetricManager;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.pkg.SolrPackageLoader;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.search.CacheConfig;
import org.apache.solr.search.CpuAllowedLimit;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrFieldCacheBean;
import org.apache.solr.security.AllowListUrlChecker;
import org.apache.solr.security.AuditLoggerPlugin;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.security.AuthorizationPlugin;
import org.apache.solr.security.HttpClientBuilderPlugin;
import org.apache.solr.security.PKIAuthenticationPlugin;
import org.apache.solr.security.PublicKeyHandler;
import org.apache.solr.security.SecurityPluginHolder;
import org.apache.solr.security.SolrNodeKeyPair;
import org.apache.solr.update.SolrCoreState;
import org.apache.solr.update.UpdateShardHandler;
import org.apache.solr.util.OrderedExecutor;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.StartupLoggingUtils;
import org.apache.solr.util.ThreadCpuTimer;
import org.apache.solr.util.stats.MetricUtils;
import org.apache.zookeeper.KeeperException;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.ApplicationHandler;
import org.noggit.JSONParser;
import org.noggit.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreContainer {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final SolrCores solrCores;
    private volatile PluginBag<SolrRequestHandler> containerHandlers;
    private volatile ApplicationHandler jerseyAppHandler;
    private volatile JerseyAppHandlerCache appHandlersByConfigSetId;
    public final Supplier<SolrZkClient> zkClientSupplier;
    private ContainerPluginsRegistry containerPluginsRegistry;
    protected final Map<String, CoreLoadFailure> coreInitFailures;
    protected volatile CoreAdminHandler coreAdminHandler;
    protected volatile CollectionsHandler collectionsHandler;
    protected volatile HealthCheckHandler healthCheckHandler;
    private volatile InfoHandler infoHandler;
    protected volatile ConfigSetsHandler configSetsHandler;
    private volatile PKIAuthenticationPlugin pkiAuthenticationSecurityBuilder;
    protected volatile Properties containerProperties;
    private volatile ConfigSetService coreConfigService;
    protected final ZkContainer zkSys;
    protected volatile ShardHandlerFactory shardHandlerFactory;
    private volatile UpdateShardHandler updateShardHandler;
    private volatile ExecutorService coreContainerWorkExecutor;
    private final OrderedExecutor replayUpdatesExecutor;
    protected volatile LogWatcher<?> logging;
    private volatile CloserThread backgroundCloser;
    protected final NodeConfig cfg;
    protected final SolrResourceLoader loader;
    protected final Path solrHome;
    protected final SolrNodeKeyPair nodeKeyPair;
    protected final CoresLocator coresLocator;
    private volatile CoreSorter coreSorter;
    private volatile String hostName;
    private final BlobRepository blobRepository;
    private volatile boolean asyncSolrCoreLoad;
    protected volatile SecurityConfHandler securityConfHandler;
    private volatile SecurityPluginHolder<AuthorizationPlugin> authorizationPlugin;
    private volatile SecurityPluginHolder<AuthenticationPlugin> authenticationPlugin;
    private volatile SecurityPluginHolder<AuditLoggerPlugin> auditloggerPlugin;
    private volatile BackupRepositoryFactory backupRepoFactory;
    protected volatile SolrMetricManager metricManager;
    protected volatile String metricTag;
    protected volatile SolrMetricsContext solrMetricsContext;
    protected volatile Tracer tracer;
    protected MetricsHandler metricsHandler;
    private volatile SolrClientCache solrClientCache;
    private volatile Map<String, SolrCache<?, ?>> caches;
    private final ObjectCache objectCache;
    public final NodeRoles nodeRoles;
    private final ExecutorService collectorExecutor;
    private final ClusterSingletons clusterSingletons;
    private volatile ClusterEventProducer clusterEventProducer;
    private DelegatingPlacementPluginFactory placementPluginFactory;
    private DistribFileStore fileStore;
    private ClusterFileStore clusterFileStoreAPI;
    private SolrPackageLoader packageLoader;
    private final Set<Path> allowPaths;
    private final AllowListUrlChecker allowListUrlChecker;
    public static final long LOAD_COMPLETE = 1L;
    public static final long CORE_DISCOVERY_COMPLETE = 2L;
    public static final long INITIAL_CORE_LOAD_COMPLETE = 4L;
    private volatile long status;
    private ExecutorService coreContainerAsyncTaskExecutor;
    private volatile Optional<DistributedCollectionConfigSetCommandRunner> distributedCollectionCommandRunner;
    private volatile boolean isShutDown;
    final Set<String> inFlightCreations;

    public Executor getCollectorExecutor() {
        return this.collectorExecutor;
    }

    public ApplicationHandler getJerseyApplicationHandler() {
        return this.jerseyAppHandler;
    }

    public JerseyAppHandlerCache getJerseyAppHandlerCache() {
        return this.appHandlersByConfigSetId;
    }

    public BackupRepository newBackupRepository(String repositoryName) {
        BackupRepository repository = repositoryName != null ? this.backupRepoFactory.newInstance(this.getResourceLoader(), repositoryName) : this.backupRepoFactory.newInstance(this.getResourceLoader());
        return repository;
    }

    public ExecutorService getCoreZkRegisterExecutorService() {
        return this.zkSys.getCoreZkRegisterExecutorService();
    }

    public SolrRequestHandler getRequestHandler(String path) {
        return RequestHandlerBase.getRequestHandler(path, this.containerHandlers);
    }

    public PluginBag<SolrRequestHandler> getRequestHandlers() {
        return this.containerHandlers;
    }

    public CoreContainer(Path solrHome, Properties properties) {
        this(SolrXmlConfig.fromSolrHome(solrHome, properties));
    }

    public CoreContainer(NodeConfig config) {
        this(config, CoresLocator.instantiate(config));
    }

    public CoreContainer(NodeConfig config, boolean asyncSolrCoreLoad) {
        this(config, CoresLocator.instantiate(config), asyncSolrCoreLoad);
    }

    @VisibleForTesting
    public CoreContainer(NodeConfig config, CoresLocator locator) {
        this(config, locator, false);
    }

    public CoreContainer(NodeConfig config, CoresLocator locator, boolean asyncSolrCoreLoad) {
        ExecutorUtil.addThreadLocalProvider((ExecutorUtil.InheritableThreadLocalProvider)SolrRequestInfo.getInheritableThreadLocalProvider());
        this.containerHandlers = new PluginBag<SolrRequestHandler>(SolrRequestHandler.class, null);
        this.zkClientSupplier = () -> this.getZkController().getZkClient();
        this.coreInitFailures = new ConcurrentHashMap<String, CoreLoadFailure>();
        this.coreAdminHandler = null;
        this.collectionsHandler = null;
        this.healthCheckHandler = null;
        this.configSetsHandler = null;
        this.zkSys = new ZkContainer();
        this.coreContainerWorkExecutor = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new SolrNamedThreadFactory("coreContainerWorkExecutor"));
        this.logging = null;
        this.backgroundCloser = null;
        this.blobRepository = new BlobRepository(this);
        this.metricTag = SolrMetricProducer.getUniqueMetricTag(this, null);
        this.tracer = NoopTracerFactory.create();
        this.objectCache = new ObjectCache();
        this.nodeRoles = new NodeRoles(System.getProperty("solr.node.roles"));
        this.clusterSingletons = new ClusterSingletons(() -> this.getZkController() != null && this.getZkController().getOverseer() != null && !this.getZkController().getOverseer().isClosed(), r -> this.runAsync((Runnable)r));
        this.status = 0L;
        this.coreContainerAsyncTaskExecutor = ExecutorUtil.newMDCAwareCachedThreadPool((String)"Core Container Async Task");
        if (log.isDebugEnabled()) {
            log.debug("New CoreContainer {}", (Object)System.identityHashCode(this));
        }
        this.isShutDown = false;
        this.inFlightCreations = ConcurrentHashMap.newKeySet();
        this.cfg = Objects.requireNonNull(config);
        this.loader = config.getSolrResourceLoader();
        this.solrHome = config.getSolrHome();
        this.solrCores = SolrCores.newSolrCores(this);
        this.nodeKeyPair = new SolrNodeKeyPair(this.cfg.getCloudConfig());
        this.containerHandlers.put("/admin/info/key", new PublicKeyHandler(this.nodeKeyPair));
        if (null != this.cfg.getBooleanQueryMaxClauseCount()) {
            IndexSearcher.setMaxClauseCount((int)this.cfg.getBooleanQueryMaxClauseCount());
        }
        CoreContainer.setWeakStringInterner();
        this.coresLocator = locator;
        this.containerProperties = new Properties(config.getSolrProperties());
        this.asyncSolrCoreLoad = asyncSolrCoreLoad;
        this.replayUpdatesExecutor = new OrderedExecutor(this.cfg.getReplayUpdatesThreads(), ExecutorUtil.newMDCAwareCachedThreadPool((int)this.cfg.getReplayUpdatesThreads(), (int)this.cfg.getReplayUpdatesThreads(), (ThreadFactory)new SolrNamedThreadFactory("replayUpdatesExecutor")));
        this.appHandlersByConfigSetId = new JerseyAppHandlerCache();
        SolrPaths.AllowPathBuilder allowPathBuilder = new SolrPaths.AllowPathBuilder();
        allowPathBuilder.addPath(this.cfg.getSolrHome());
        allowPathBuilder.addPath(this.cfg.getCoreRootDirectory());
        if (this.cfg.getSolrDataHome() != null) {
            allowPathBuilder.addPath(this.cfg.getSolrDataHome());
        }
        if (!this.cfg.getAllowPaths().isEmpty()) {
            this.cfg.getAllowPaths().forEach(allowPathBuilder::addPath);
            if (log.isInfoEnabled()) {
                log.info("Allowing use of paths: {}", this.cfg.getAllowPaths());
            }
        }
        this.allowPaths = allowPathBuilder.build();
        this.allowListUrlChecker = AllowListUrlChecker.create(config);
        int indexSearcherExecutorThreads = this.cfg.getIndexSearcherExecutorThreads();
        this.collectorExecutor = 0 < indexSearcherExecutorThreads ? ExecutorUtil.newMDCAwareFixedThreadPool((int)indexSearcherExecutorThreads, (int)(indexSearcherExecutorThreads * 1000), (ThreadFactory)new SolrNamedThreadFactory("searcherCollector"), () -> ThreadCpuTimer.reset(CpuAllowedLimit.TIMING_CONTEXT)) : null;
    }

    private synchronized void initializeAuthorizationPlugin(Map<String, Object> authorizationConf) {
        authorizationConf = Utils.getDeepCopy(authorizationConf, (int)4);
        int newVersion = CoreContainer.readVersion(authorizationConf);
        SecurityPluginHolder<AuthorizationPlugin> old = this.authorizationPlugin;
        SecurityPluginHolder<AuthorizationPlugin> authorizationPlugin = null;
        if (authorizationConf != null) {
            String klas = (String)authorizationConf.get("class");
            if (klas == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "class is required for authorization plugin");
            }
            if (old != null && old.getZnodeVersion() == newVersion && newVersion > 0) {
                log.debug("Authorization config not modified");
                return;
            }
            log.info("Initializing authorization plugin: {}", (Object)klas);
            authorizationPlugin = new SecurityPluginHolder<AuthorizationPlugin>(newVersion, this.getResourceLoader().newInstance(klas, AuthorizationPlugin.class, null, new Class[]{CoreContainer.class}, new Object[]{this}));
            ((AuthorizationPlugin)authorizationPlugin.plugin).init(authorizationConf);
        } else {
            log.debug("Security conf doesn't exist. Skipping setup for authorization module.");
        }
        this.authorizationPlugin = authorizationPlugin;
        if (old != null) {
            try {
                ((AuthorizationPlugin)old.plugin).close();
            }
            catch (Exception e) {
                log.error("Exception while attempting to close old authorization plugin", (Throwable)e);
            }
        }
    }

    private void initializeAuditloggerPlugin(Map<String, Object> auditConf) {
        auditConf = Utils.getDeepCopy(auditConf, (int)4);
        int newVersion = CoreContainer.readVersion(auditConf);
        SecurityPluginHolder<AuditLoggerPlugin> old = this.auditloggerPlugin;
        SecurityPluginHolder<AuditLoggerPlugin> newAuditloggerPlugin = null;
        if (auditConf != null) {
            String klas = (String)auditConf.get("class");
            if (klas == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "class is required for auditlogger plugin");
            }
            if (old != null && old.getZnodeVersion() == newVersion && newVersion > 0) {
                log.debug("Auditlogger config not modified");
                return;
            }
            log.info("Initializing auditlogger plugin: {}", (Object)klas);
            newAuditloggerPlugin = new SecurityPluginHolder<AuditLoggerPlugin>(newVersion, this.getResourceLoader().newInstance(klas, AuditLoggerPlugin.class));
            ((AuditLoggerPlugin)newAuditloggerPlugin.plugin).init(auditConf);
            ((AuditLoggerPlugin)newAuditloggerPlugin.plugin).initializeMetrics(this.solrMetricsContext, "/auditlogging");
        } else {
            log.debug("Security conf doesn't exist. Skipping setup for audit logging module.");
        }
        this.auditloggerPlugin = newAuditloggerPlugin;
        if (old != null) {
            try {
                ((AuditLoggerPlugin)old.plugin).close();
            }
            catch (Exception e) {
                log.error("Exception while attempting to close old auditlogger plugin", (Throwable)e);
            }
        }
    }

    private synchronized void initializeAuthenticationPlugin(Map<String, Object> authenticationConfig) {
        authenticationConfig = Utils.getDeepCopy(authenticationConfig, (int)4);
        int newVersion = CoreContainer.readVersion(authenticationConfig);
        String pluginClassName = null;
        if (authenticationConfig != null) {
            if (authenticationConfig.containsKey("class")) {
                pluginClassName = String.valueOf(authenticationConfig.get("class"));
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No 'class' specified for authentication in ZK.");
            }
        }
        if (pluginClassName != null) {
            log.debug("Authentication plugin class obtained from security.json: {}", pluginClassName);
        } else if (System.getProperty("authenticationPlugin") != null) {
            pluginClassName = System.getProperty("authenticationPlugin");
            log.debug("Authentication plugin class obtained from system property '{}': {}", (Object)"authenticationPlugin", (Object)pluginClassName);
        } else {
            log.debug("No authentication plugin used.");
        }
        SecurityPluginHolder<AuthenticationPlugin> old = this.authenticationPlugin;
        SecurityPluginHolder<AuthenticationPlugin> authenticationPlugin = null;
        if (old != null && old.getZnodeVersion() == newVersion && newVersion > 0) {
            log.debug("Authentication config not modified");
            return;
        }
        if (pluginClassName != null) {
            log.info("Initializing authentication plugin: {}", (Object)pluginClassName);
            authenticationPlugin = new SecurityPluginHolder<AuthenticationPlugin>(newVersion, this.getResourceLoader().newInstance(pluginClassName, AuthenticationPlugin.class, null, new Class[]{CoreContainer.class}, new Object[]{this}));
        }
        if (authenticationPlugin != null) {
            ((AuthenticationPlugin)authenticationPlugin.plugin).init(authenticationConfig);
            this.setupHttpClientForAuthPlugin(authenticationPlugin.plugin);
            ((AuthenticationPlugin)authenticationPlugin.plugin).initializeMetrics(this.solrMetricsContext, "/authentication");
        }
        this.authenticationPlugin = authenticationPlugin;
        try {
            if (old != null) {
                ((AuthenticationPlugin)old.plugin).close();
            }
        }
        catch (Exception e) {
            log.error("Exception while attempting to close old authentication plugin", (Throwable)e);
        }
    }

    private void setupHttpClientForAuthPlugin(Object authcPlugin) {
        if (authcPlugin instanceof HttpClientBuilderPlugin) {
            HttpClientBuilderPlugin builderPlugin = (HttpClientBuilderPlugin)authcPlugin;
            final SolrHttpClientBuilder builder = builderPlugin.getHttpClientBuilder(HttpClientUtil.getHttpClientBuilder());
            SolrHttpClientContextBuilder httpClientBuilder = new SolrHttpClientContextBuilder();
            if (builder.getCredentialsProviderProvider() != null) {
                httpClientBuilder.setDefaultCredentialsProvider(new SolrHttpClientContextBuilder.CredentialsProviderProvider(){

                    public CredentialsProvider getCredentialsProvider() {
                        return builder.getCredentialsProviderProvider().getCredentialsProvider();
                    }
                });
            }
            if (builder.getAuthSchemeRegistryProvider() != null) {
                httpClientBuilder.setAuthSchemeRegistryProvider(new SolrHttpClientContextBuilder.AuthSchemeRegistryProvider(){

                    public Lookup<AuthSchemeProvider> getAuthSchemeRegistry() {
                        return builder.getAuthSchemeRegistryProvider().getAuthSchemeRegistry();
                    }
                });
            }
            HttpClientUtil.setHttpClientRequestContextBuilder((SolrHttpClientContextBuilder)httpClientBuilder);
        }
        if (this.pkiAuthenticationSecurityBuilder != null && !this.pkiAuthenticationSecurityBuilder.isInterceptorRegistered()) {
            this.pkiAuthenticationSecurityBuilder.getHttpClientBuilder(HttpClientUtil.getHttpClientBuilder());
            this.shardHandlerFactory.setSecurityBuilder(this.pkiAuthenticationSecurityBuilder);
            this.updateShardHandler.setSecurityBuilder(this.pkiAuthenticationSecurityBuilder);
        }
    }

    private static int readVersion(Map<String, Object> conf) {
        if (conf == null) {
            return -1;
        }
        Map meta = (Map)conf.get("");
        if (meta == null) {
            return -1;
        }
        Number v = (Number)meta.get("v");
        return v == null ? -1 : v.intValue();
    }

    protected CoreContainer(Object testConstructor) {
        ExecutorUtil.addThreadLocalProvider((ExecutorUtil.InheritableThreadLocalProvider)SolrRequestInfo.getInheritableThreadLocalProvider());
        this.containerHandlers = new PluginBag<SolrRequestHandler>(SolrRequestHandler.class, null);
        this.zkClientSupplier = () -> this.getZkController().getZkClient();
        this.coreInitFailures = new ConcurrentHashMap<String, CoreLoadFailure>();
        this.coreAdminHandler = null;
        this.collectionsHandler = null;
        this.healthCheckHandler = null;
        this.configSetsHandler = null;
        this.zkSys = new ZkContainer();
        this.coreContainerWorkExecutor = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new SolrNamedThreadFactory("coreContainerWorkExecutor"));
        this.logging = null;
        this.backgroundCloser = null;
        this.blobRepository = new BlobRepository(this);
        this.metricTag = SolrMetricProducer.getUniqueMetricTag(this, null);
        this.tracer = NoopTracerFactory.create();
        this.objectCache = new ObjectCache();
        this.nodeRoles = new NodeRoles(System.getProperty("solr.node.roles"));
        this.clusterSingletons = new ClusterSingletons(() -> this.getZkController() != null && this.getZkController().getOverseer() != null && !this.getZkController().getOverseer().isClosed(), r -> this.runAsync((Runnable)r));
        this.status = 0L;
        this.coreContainerAsyncTaskExecutor = ExecutorUtil.newMDCAwareCachedThreadPool((String)"Core Container Async Task");
        if (log.isDebugEnabled()) {
            log.debug("New CoreContainer {}", (Object)System.identityHashCode(this));
        }
        this.isShutDown = false;
        this.inFlightCreations = ConcurrentHashMap.newKeySet();
        this.solrHome = null;
        this.solrCores = null;
        this.nodeKeyPair = null;
        this.loader = null;
        this.coresLocator = null;
        this.cfg = null;
        this.containerProperties = null;
        this.replayUpdatesExecutor = null;
        this.distributedCollectionCommandRunner = Optional.empty();
        this.allowPaths = null;
        this.allowListUrlChecker = null;
        this.collectorExecutor = null;
    }

    public static CoreContainer createAndLoad(Path solrHome) {
        return CoreContainer.createAndLoad(solrHome, solrHome.resolve("solr.xml"));
    }

    public static CoreContainer createAndLoad(Path solrHome, Path configFile) {
        CoreContainer cc = new CoreContainer(SolrXmlConfig.fromFile(solrHome, configFile, new Properties()));
        try {
            cc.load();
        }
        catch (Exception e) {
            cc.shutdown();
            throw e;
        }
        return cc;
    }

    public Properties getContainerProperties() {
        return this.containerProperties;
    }

    public PKIAuthenticationPlugin getPkiAuthenticationSecurityBuilder() {
        return this.pkiAuthenticationSecurityBuilder;
    }

    public SolrMetricManager getMetricManager() {
        return this.metricManager;
    }

    public MetricsHandler getMetricsHandler() {
        return this.metricsHandler;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public OrderedExecutor getReplayUpdatesExecutor() {
        return this.replayUpdatesExecutor;
    }

    public SolrPackageLoader getPackageLoader() {
        return this.packageLoader;
    }

    public FileStore getFileStore() {
        return this.fileStore;
    }

    public SolrCache<?, ?> getCache(String name) {
        return this.caches.get(name);
    }

    public SolrClientCache getSolrClientCache() {
        return this.solrClientCache;
    }

    public ObjectCache getObjectCache() {
        return this.objectCache;
    }

    private void registerV2ApiIfEnabled(Object apiObject) {
        if (apiObject == null || this.containerHandlers.getApiBag() == null) {
            return;
        }
        this.containerHandlers.getApiBag().registerObject(apiObject);
    }

    private void registerV2ApiIfEnabled(Class<? extends JerseyResource> clazz) {
        if (this.containerHandlers.getJerseyEndpoints() == null) {
            return;
        }
        this.containerHandlers.getJerseyEndpoints().register(clazz);
    }

    @SuppressForbidden(reason="Set the thread contextClassLoader for all 3rd party dependencies that we cannot control")
    public void load() {
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.loader.getClassLoader());
            this.loadInternal();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadInternal() {
        if (log.isDebugEnabled()) {
            log.debug("Loading cores into CoreContainer [instanceDir={}]", (Object)this.getSolrHome());
        }
        this.logging = LogWatcher.newRegisteredLogWatcher(this.cfg.getLogWatcherConfig(), this.loader);
        ClusterPluginsSource pluginsSource = ClusterPluginsSource.loadClusterPluginsSource(this, this.loader);
        this.containerPluginsRegistry = new ContainerPluginsRegistry(this, this.containerHandlers.getApiBag(), pluginsSource);
        ClusterEventProducerFactory clusterEventProducerFactory = new ClusterEventProducerFactory(this);
        this.clusterEventProducer = clusterEventProducerFactory;
        this.placementPluginFactory = new DelegatingPlacementPluginFactory(PlacementPluginFactoryLoader.getDefaultPlacementPluginFactory());
        this.containerPluginsRegistry.registerListener(this.clusterSingletons.getPluginRegistryListener());
        this.containerPluginsRegistry.registerListener(clusterEventProducerFactory.getPluginRegistryListener());
        this.metricManager = new SolrMetricManager(this.loader, this.cfg.getMetricsConfig());
        String registryName = SolrMetricManager.getRegistryName(SolrInfoBean.Group.node, new String[0]);
        this.solrMetricsContext = new SolrMetricsContext(this.metricManager, registryName, this.metricTag);
        this.tracer = TracerConfigurator.loadTracer(this.loader, this.cfg.getTracerConfiguratorPluginInfo());
        this.coreContainerWorkExecutor = MetricUtils.instrumentedExecutorService(this.coreContainerWorkExecutor, null, this.metricManager.registry(SolrMetricManager.getRegistryName(SolrInfoBean.Group.node, new String[0])), SolrMetricManager.mkName("coreContainerWorkExecutor", SolrInfoBean.Category.CONTAINER.toString(), "threadPool"));
        this.shardHandlerFactory = ShardHandlerFactory.newInstance(this.cfg.getShardHandlerFactoryPluginInfo(), this.loader);
        if (this.shardHandlerFactory instanceof SolrMetricProducer) {
            SolrMetricProducer metricProducer = (SolrMetricProducer)((Object)this.shardHandlerFactory);
            metricProducer.initializeMetrics(this.solrMetricsContext, "httpShardHandler");
        }
        this.updateShardHandler = new UpdateShardHandler(this.cfg.getUpdateShardHandlerConfig());
        this.updateShardHandler.initializeMetrics(this.solrMetricsContext, "updateShardHandler");
        this.solrClientCache = new SolrClientCache(this.updateShardHandler.getDefaultHttpClient());
        Map<String, CacheConfig> cachesConfig = this.cfg.getCachesConfig();
        if (cachesConfig.isEmpty()) {
            this.caches = Collections.emptyMap();
        } else {
            HashMap m = CollectionUtil.newHashMap((int)cachesConfig.size());
            for (Map.Entry<String, CacheConfig> e : cachesConfig.entrySet()) {
                SolrCache c = e.getValue().newInstance();
                String cacheName = e.getKey();
                c.initializeMetrics(this.solrMetricsContext, "nodeLevelCache/" + cacheName);
                m.put(cacheName, c);
            }
            this.caches = Collections.unmodifiableMap(m);
        }
        StartupLoggingUtils.checkRequestLogging();
        this.hostName = this.cfg.getNodeName();
        this.zkSys.initZooKeeper(this, this.cfg.getCloudConfig());
        if (this.isZooKeeperAware()) {
            this.solrClientCache.setDefaultZKHost(this.getZkController().getZkServerAddress());
            this.zkSys.getZkMetricsProducer().initializeMetrics(this.solrMetricsContext, "zkClient");
            this.pkiAuthenticationSecurityBuilder = new PKIAuthenticationPlugin(this, this.zkSys.getZkController().getNodeName(), (PublicKeyHandler)this.containerHandlers.get("/admin/info/key"));
            this.pkiAuthenticationSecurityBuilder.initializeMetrics(this.solrMetricsContext, "/authentication/pki");
            this.fileStore = new DistribFileStore(this);
            this.registerV2ApiIfEnabled(ClusterFileStore.class);
            this.registerV2ApiIfEnabled(NodeFileStore.class);
            this.packageLoader = new SolrPackageLoader(this);
            this.registerV2ApiIfEnabled(this.packageLoader.getPackageAPI().editAPI);
            this.registerV2ApiIfEnabled(this.packageLoader.getPackageAPI().readAPI);
            this.registerV2ApiIfEnabled(ZookeeperReadAPI.class);
        }
        MDCLoggingContext.setNode(this);
        this.securityConfHandler = this.isZooKeeperAware() ? new SecurityConfHandlerZk(this) : new SecurityConfHandlerLocal(this);
        this.reloadSecurityProperties();
        this.warnUsersOfInsecureSettings();
        this.backupRepoFactory = new BackupRepositoryFactory(this.cfg.getBackupRepositoryPlugins());
        this.coreConfigService = ConfigSetService.createConfigSetService(this);
        this.createHandler("/admin/zookeeper", ZookeeperInfoHandler.class.getName(), ZookeeperInfoHandler.class);
        this.createHandler("/admin/zookeeper/status", ZookeeperStatusHandler.class.getName(), ZookeeperStatusHandler.class);
        this.distributedCollectionCommandRunner = this.isZooKeeperAware() && this.cfg.getCloudConfig().getDistributedCollectionConfigSetExecution() ? Optional.of(new DistributedCollectionConfigSetCommandRunner(this)) : Optional.empty();
        this.collectionsHandler = this.createHandler("/admin/collections", this.cfg.getCollectionsHandlerClass(), CollectionsHandler.class);
        this.configSetsHandler = this.createHandler("/admin/configs", this.cfg.getConfigSetsHandlerClass(), ConfigSetsHandler.class);
        ClusterAPI clusterAPI = new ClusterAPI(this.collectionsHandler, this.configSetsHandler);
        this.registerV2ApiIfEnabled(clusterAPI);
        this.registerV2ApiIfEnabled(clusterAPI.commands);
        if (this.isZooKeeperAware()) {
            this.registerV2ApiIfEnabled(new SchemaDesignerAPI(this));
        }
        this.healthCheckHandler = this.loader.newInstance(this.cfg.getHealthCheckHandlerClass(), HealthCheckHandler.class, null, new Class[]{CoreContainer.class}, new Object[]{this});
        this.infoHandler = this.createHandler("/admin/info", this.cfg.getInfoHandlerClass(), InfoHandler.class);
        this.coreAdminHandler = this.createHandler("/admin/cores", this.cfg.getCoreAdminHandlerClass(), CoreAdminHandler.class);
        Map<String, CoreAdminHandler.CoreAdminOp> coreAdminHandlerActions = this.cfg.getCoreAdminHandlerActions().entrySet().stream().collect(Collectors.toMap(item -> (String)item.getKey(), item -> this.loader.newInstance((String)item.getValue(), CoreAdminHandler.CoreAdminOp.class)));
        this.coreAdminHandler.registerCustomActions(coreAdminHandlerActions);
        this.metricsHandler = new MetricsHandler(this);
        this.containerHandlers.put("/admin/metrics", this.metricsHandler);
        this.metricsHandler.initializeMetrics(this.solrMetricsContext, "/admin/metrics");
        this.containerHandlers.put("/admin/authorization", this.securityConfHandler);
        this.securityConfHandler.initializeMetrics(this.solrMetricsContext, "/admin/authorization");
        this.containerHandlers.put("/admin/authentication", this.securityConfHandler);
        PluginInfo[] metricReporters = this.cfg.getMetricsConfig().getMetricReporters();
        this.metricManager.loadReporters(metricReporters, this.loader, this, null, null, SolrInfoBean.Group.node, new String[0]);
        this.metricManager.loadReporters(metricReporters, this.loader, this, null, null, SolrInfoBean.Group.jvm, new String[0]);
        this.metricManager.loadReporters(metricReporters, this.loader, this, null, null, SolrInfoBean.Group.jetty, new String[0]);
        this.containerProperties.putAll((Map<?, ?>)this.cfg.getSolrProperties());
        this.solrMetricsContext.gauge(this.solrCores::getNumLoadedPermanentCores, true, "loaded", SolrInfoBean.Category.CONTAINER.toString(), "cores");
        this.solrMetricsContext.gauge(this.solrCores::getNumLoadedTransientCores, true, "lazy", SolrInfoBean.Category.CONTAINER.toString(), "cores");
        this.solrMetricsContext.gauge(this.solrCores::getNumUnloadedCores, true, "unloaded", SolrInfoBean.Category.CONTAINER.toString(), "cores");
        Path dataHome = this.cfg.getSolrDataHome() != null ? this.cfg.getSolrDataHome() : this.cfg.getCoreRootDirectory();
        this.solrMetricsContext.gauge(() -> dataHome.toFile().getTotalSpace(), true, "totalSpace", SolrInfoBean.Category.CONTAINER.toString(), "fs");
        this.solrMetricsContext.gauge(() -> dataHome.toFile().getUsableSpace(), true, "usableSpace", SolrInfoBean.Category.CONTAINER.toString(), "fs");
        this.solrMetricsContext.gauge(dataHome::toString, true, "path", SolrInfoBean.Category.CONTAINER.toString(), "fs");
        this.solrMetricsContext.gauge(() -> this.cfg.getCoreRootDirectory().toFile().getTotalSpace(), true, "totalSpace", SolrInfoBean.Category.CONTAINER.toString(), "fs", "coreRoot");
        this.solrMetricsContext.gauge(() -> this.cfg.getCoreRootDirectory().toFile().getUsableSpace(), true, "usableSpace", SolrInfoBean.Category.CONTAINER.toString(), "fs", "coreRoot");
        this.solrMetricsContext.gauge(() -> this.cfg.getCoreRootDirectory().toString(), true, "path", SolrInfoBean.Category.CONTAINER.toString(), "fs", "coreRoot");
        this.solrMetricsContext.gauge(() -> this.getClass().getPackage().getSpecificationVersion(), true, "specification", SolrInfoBean.Category.CONTAINER.toString(), "version");
        this.solrMetricsContext.gauge(() -> this.getClass().getPackage().getImplementationVersion(), true, "implementation", SolrInfoBean.Category.CONTAINER.toString(), "version");
        SolrFieldCacheBean fieldCacheBean = new SolrFieldCacheBean();
        fieldCacheBean.initializeMetrics(this.solrMetricsContext, null);
        if (this.isZooKeeperAware()) {
            this.metricManager.loadClusterReporters(metricReporters, this);
        }
        ExecutorService coreLoadExecutor = MetricUtils.instrumentedExecutorService(ExecutorUtil.newMDCAwareFixedThreadPool((int)this.cfg.getCoreLoadThreadCount(this.isZooKeeperAware()), (ThreadFactory)new SolrNamedThreadFactory("coreLoadExecutor")), null, this.metricManager.registry(SolrMetricManager.getRegistryName(SolrInfoBean.Group.node, new String[0])), SolrMetricManager.mkName("coreLoadExecutor", SolrInfoBean.Category.CONTAINER.toString(), "threadPool"));
        this.coreSorter = this.loader.newInstance(this.cfg.getCoreSorterClass(), CoreSorter.class, null, new Class[]{CoreContainer.class}, new Object[]{this});
        try {
            List<CoreDescriptor> cds = this.coresLocator.discover(this);
            cds = this.coreSorter.sort(cds);
            CoreContainer.checkForDuplicateCoreNames(cds);
            this.status |= 2L;
            for (CoreDescriptor cd : cds) {
                if (cd.isTransient() || !cd.isLoadOnStartup()) {
                    this.solrCores.addCoreDescriptor(cd);
                } else if (this.asyncSolrCoreLoad) {
                    this.solrCores.markCoreAsLoading(cd);
                }
                if (!cd.isLoadOnStartup()) continue;
                coreLoadExecutor.submit(() -> {
                    SolrCore core;
                    try {
                        if (this.zkSys.getZkController() != null) {
                            this.zkSys.getZkController().throwErrorIfReplicaReplaced(cd);
                        }
                        MDCLoggingContext.setCoreDescriptor(this, cd);
                        this.solrCores.waitAddPendingCoreOps(cd.getName());
                        core = this.createFromDescriptor(cd, false, false);
                    }
                    catch (Exception e) {
                        log.error("SolrCore failed to load on startup", (Throwable)e);
                        MDCLoggingContext.clear();
                        return;
                    }
                    finally {
                        this.solrCores.removeFromPendingOps(cd.getName());
                        if (this.asyncSolrCoreLoad) {
                            this.solrCores.markCoreAsNotLoading(cd);
                        }
                    }
                    try {
                        this.zkSys.registerInZk(core, true, false);
                    }
                    catch (RuntimeException e) {
                        log.error("Error registering SolrCore", (Throwable)e);
                    }
                    finally {
                        MDCLoggingContext.clear();
                    }
                });
            }
            this.backgroundCloser = new CloserThread(this, this.solrCores, this.cfg);
            this.backgroundCloser.start();
        }
        finally {
            if (this.asyncSolrCoreLoad) {
                this.coreContainerWorkExecutor.submit(() -> ExecutorUtil.shutdownAndAwaitTerminationForever((ExecutorService)coreLoadExecutor));
            } else {
                ExecutorUtil.shutdownAndAwaitTerminationForever((ExecutorService)coreLoadExecutor);
            }
        }
        if (this.isZooKeeperAware()) {
            this.containerPluginsRegistry.refresh();
            this.getZkController().zkStateReader.registerClusterPropertiesListener((ClusterPropertiesListener)this.containerPluginsRegistry);
            this.registerV2ApiIfEnabled(pluginsSource.getReadApi());
            this.registerV2ApiIfEnabled(pluginsSource.getEditApi());
            PlacementPluginFactoryLoader.load(this.placementPluginFactory, this.containerPluginsRegistry);
            this.clusterEventProducer = clusterEventProducerFactory.create(this.containerPluginsRegistry);
            this.containerHandlers.keySet().forEach(handlerName -> {
                SolrRequestHandler handler = this.containerHandlers.get((String)handlerName);
                if (handler instanceof ClusterSingleton) {
                    ClusterSingleton singleton = (ClusterSingleton)((Object)handler);
                    this.clusterSingletons.getSingletons().put(singleton.getName(), singleton);
                }
            });
        }
        if (V2ApiUtils.isEnabled()) {
            final CoreContainer thisCCRef = this;
            this.containerHandlers.getJerseyEndpoints().register((Object)new AbstractBinder(){

                protected void configure() {
                    this.bindFactory(new InjectionFactories.SingletonFactory<CoreContainer>(thisCCRef)).to(CoreContainer.class).in(Singleton.class);
                }
            }).register((Object)new AbstractBinder(){

                protected void configure() {
                    this.bindFactory(new InjectionFactories.SingletonFactory<SolrNodeKeyPair>(CoreContainer.this.nodeKeyPair)).to(SolrNodeKeyPair.class).in(Singleton.class);
                }
            }).register((Object)new AbstractBinder(){

                protected void configure() {
                    this.bindFactory(new InjectionFactories.SingletonFactory<DistribFileStore>(CoreContainer.this.fileStore)).to(DistribFileStore.class).in(Singleton.class);
                }
            }).register((Object)new AbstractBinder(){

                protected void configure() {
                    this.bindFactory(new InjectionFactories.SingletonFactory<CoreAdminHandler.CoreAdminAsyncTracker>(CoreContainer.this.coreAdminHandler.getCoreAdminAsyncTracker())).to(CoreAdminHandler.CoreAdminAsyncTracker.class).in(Singleton.class);
                }
            });
            this.jerseyAppHandler = new ApplicationHandler((Application)this.containerHandlers.getJerseyEndpoints());
        }
        if (this.isZooKeeperAware()) {
            this.clusterSingletons.setReady();
            if ("preferred".equals(this.nodeRoles.getRoleMode(NodeRoles.Role.OVERSEER))) {
                try {
                    log.info("This node has been started as a preferred overseer");
                    this.zkSys.getZkController().setPreferredOverseer();
                }
                catch (InterruptedException | KeeperException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, e);
                }
            }
            if (!this.distributedCollectionCommandRunner.isPresent()) {
                this.zkSys.getZkController().checkOverseerDesignate();
            }
        }
        this.status |= 5L;
    }

    public void securityNodeChanged() {
        log.info("Security node changed, reloading security.json");
        this.reloadSecurityProperties();
    }

    private void reloadSecurityProperties() {
        SecurityConfHandler.SecurityConfig securityConfig = this.securityConfHandler.getSecurityConfig(false);
        this.initializeAuthorizationPlugin((Map)securityConfig.getData().get("authorization"));
        this.initializeAuthenticationPlugin((Map)securityConfig.getData().get("authentication"));
        this.initializeAuditloggerPlugin((Map)securityConfig.getData().get("auditlogging"));
    }

    private void warnUsersOfInsecureSettings() {
        if (this.authenticationPlugin == null || this.authorizationPlugin == null) {
            log.warn("Not all security plugins configured!  authentication={} authorization={}.  Solr is only as secure as you make it. Consider configuring authentication/authorization before exposing Solr to users internal or external.  See https://s.apache.org/solrsecurity for more info", (Object)(this.authenticationPlugin != null ? "enabled" : "disabled"), (Object)(this.authorizationPlugin != null ? "enabled" : "disabled"));
        }
        if (this.authenticationPlugin != null && StrUtils.isNullOrEmpty((String)System.getProperty("solr.jetty.https.port"))) {
            log.warn("Solr authentication is enabled, but SSL is off.  Consider enabling SSL to protect user credentials and data with encryption.");
        }
    }

    private static void checkForDuplicateCoreNames(List<CoreDescriptor> cds) {
        HashMap<String, Path> addedCores = new HashMap<String, Path>();
        for (CoreDescriptor cd : cds) {
            String name = cd.getName();
            if (addedCores.containsKey(name)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, String.format(Locale.ROOT, "Found multiple cores with the name [%s], with instancedirs [%s] and [%s]", name, addedCores.get(name), cd.getInstanceDir()));
            }
            addedCores.put(name, cd.getInstanceDir());
        }
    }

    public boolean isShutDown() {
        return this.isShutDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void shutdown() {
        ZkController zkController = this.getZkController();
        if (zkController != null) {
            if (this.distributedCollectionCommandRunner.isPresent()) {
                this.distributedCollectionCommandRunner.get().stopAndWaitForPendingTasksToComplete();
            } else {
                OverseerTaskQueue overseerCollectionQueue = zkController.getOverseerCollectionQueue();
                overseerCollectionQueue.allowOverseerPendingTasksToComplete();
            }
        }
        if (log.isInfoEnabled()) {
            log.info("Shutting down CoreContainer instance={}", (Object)System.identityHashCode(this));
        }
        ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.coreContainerAsyncTaskExecutor);
        ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.collectorExecutor);
        ExecutorService customThreadPool = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new SolrNamedThreadFactory("closeThreadPool"));
        this.isShutDown = true;
        try {
            block77: {
                if (this.isZooKeeperAware()) {
                    this.cancelCoreRecoveries();
                    this.zkSys.zkController.preClose();
                }
                this.pauseUpdatesAndAwaitInflightRequests();
                if (this.isZooKeeperAware()) {
                    this.zkSys.zkController.tryCancelAllElections();
                }
                ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.coreContainerWorkExecutor);
                Object object = this.solrCores.getModifyLock();
                // MONITORENTER : object
                this.solrCores.getModifyLock().notifyAll();
                // MONITOREXIT : object
                if (this.backgroundCloser != null) {
                    try {
                        while (true) {
                            this.backgroundCloser.join(15000L);
                            if (this.backgroundCloser.isAlive()) {
                                object = this.solrCores.getModifyLock();
                                // MONITORENTER : object
                                this.solrCores.getModifyLock().notifyAll();
                                // MONITOREXIT : object
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        if (!log.isDebugEnabled()) break block77;
                        log.debug("backgroundCloser thread was interrupted before finishing");
                    }
                }
            }
            this.solrCores.close();
            Map<String, SolrCache<?, ?>> closeCaches = this.caches;
            if (closeCaches != null) {
                for (Map.Entry<String, SolrCache<?, ?>> e : this.caches.entrySet()) {
                    try {
                        e.getValue().close();
                    }
                    catch (Exception ex) {
                        log.warn("error closing node-level cache: {}", (Object)e.getKey(), (Object)ex);
                    }
                }
            }
            try {
                this.objectCache.close();
            }
            catch (IOException e) {
                log.warn("Exception while closing ObjectCache.", (Throwable)e);
            }
            Object e = this.solrCores.getModifyLock();
            // MONITORENTER : e
            this.solrCores.getModifyLock().notifyAll();
            // MONITOREXIT : e
            customThreadPool.submit(() -> this.replayUpdatesExecutor.shutdownAndAwaitTermination());
            if (this.metricManager != null) {
                this.metricManager.closeReporters(SolrMetricManager.getRegistryName(SolrInfoBean.Group.node, new String[0]));
                this.metricManager.closeReporters(SolrMetricManager.getRegistryName(SolrInfoBean.Group.jvm, new String[0]));
                this.metricManager.closeReporters(SolrMetricManager.getRegistryName(SolrInfoBean.Group.jetty, new String[0]));
                this.metricManager.unregisterGauges(SolrMetricManager.getRegistryName(SolrInfoBean.Group.node, new String[0]), this.metricTag);
                this.metricManager.unregisterGauges(SolrMetricManager.getRegistryName(SolrInfoBean.Group.jvm, new String[0]), this.metricTag);
                this.metricManager.unregisterGauges(SolrMetricManager.getRegistryName(SolrInfoBean.Group.jetty, new String[0]), this.metricTag);
            }
            if (this.isZooKeeperAware()) {
                this.cancelCoreRecoveries();
                if (this.metricManager != null) {
                    this.metricManager.closeReporters(SolrMetricManager.getRegistryName(SolrInfoBean.Group.cluster, new String[0]));
                }
            }
            try {
                if (this.coreAdminHandler != null) {
                    customThreadPool.submit(() -> this.coreAdminHandler.shutdown());
                }
            }
            catch (Exception e2) {
                log.warn("Error shutting down CoreAdminHandler. Continuing to close CoreContainer.", (Throwable)e2);
            }
            if (this.solrClientCache != null) {
                this.solrClientCache.close();
            }
            if (this.containerPluginsRegistry != null) {
                IOUtils.closeQuietly((Closeable)this.containerPluginsRegistry);
            }
        }
        finally {
            try {
                if (this.shardHandlerFactory != null) {
                    customThreadPool.submit(() -> this.shardHandlerFactory.close());
                }
            }
            finally {
                try {
                    if (this.updateShardHandler != null) {
                        customThreadPool.submit(this.updateShardHandler::close);
                    }
                }
                finally {
                    try {
                        this.zkSys.close();
                    }
                    finally {
                        ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)customThreadPool);
                    }
                }
            }
        }
        try {
            if (this.authorizationPlugin != null) {
                ((AuthorizationPlugin)this.authorizationPlugin.plugin).close();
            }
        }
        catch (IOException e) {
            log.warn("Exception while closing authorization plugin.", (Throwable)e);
        }
        try {
            if (this.authenticationPlugin != null) {
                ((AuthenticationPlugin)this.authenticationPlugin.plugin).close();
                this.authenticationPlugin = null;
            }
        }
        catch (Exception e) {
            log.warn("Exception while closing authentication plugin.", (Throwable)e);
        }
        try {
            if (this.auditloggerPlugin != null) {
                ((AuditLoggerPlugin)this.auditloggerPlugin.plugin).close();
                this.auditloggerPlugin = null;
            }
        }
        catch (Exception e) {
            log.warn("Exception while closing auditlogger plugin.", (Throwable)e);
        }
        if (this.packageLoader != null) {
            org.apache.lucene.util.IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.packageLoader});
        }
        org.apache.lucene.util.IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.loader});
        this.tracer.close();
    }

    public void cancelCoreRecoveries() {
        List<SolrCore> cores = this.solrCores.getCores();
        for (SolrCore core : cores) {
            try {
                core.getSolrCoreState().cancelRecovery();
            }
            catch (Exception e) {
                log.error("Error canceling recovery for core", (Throwable)e);
            }
        }
    }

    private void pauseUpdatesAndAwaitInflightRequests() {
        this.getCores().parallelStream().forEach(solrCore -> {
            SolrCoreState solrCoreState = solrCore.getSolrCoreState();
            try {
                solrCoreState.pauseUpdatesAndAwaitInflightRequests();
            }
            catch (TimeoutException e) {
                log.warn("Timed out waiting for in-flight update requests to complete for core: {}", (Object)solrCore.getName());
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while waiting for in-flight update requests to complete for core: {}", (Object)solrCore.getName());
                Thread.currentThread().interrupt();
            }
        });
    }

    public CoresLocator getCoresLocator() {
        return this.coresLocator;
    }

    public CoreSorter getCoreSorter() {
        return this.coreSorter;
    }

    protected SolrCore registerCore(CoreDescriptor cd, SolrCore core, boolean registerInZk, boolean skipRecovery) {
        if (core == null) {
            throw new RuntimeException("Can not register a null core.");
        }
        if (this.isShutDown) {
            core.close();
            throw new IllegalStateException("This CoreContainer has been closed");
        }
        assert (core.getName().equals(cd.getName())) : "core name " + core.getName() + " != cd " + cd.getName();
        SolrCore old = this.solrCores.putCore(cd, core);
        this.coreInitFailures.remove(cd.getName());
        if (old == null || old == core) {
            if (log.isDebugEnabled()) {
                log.debug("registering core: {}", (Object)cd.getName());
            }
            if (registerInZk) {
                this.zkSys.registerInZk(core, false, skipRecovery);
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("replacing core: {}", (Object)cd.getName());
        }
        old.close();
        if (registerInZk) {
            this.zkSys.registerInZk(core, false, skipRecovery);
        }
        return old;
    }

    public SolrCore create(String coreName, Map<String, String> parameters) {
        return this.create(coreName, this.cfg.getCoreRootDirectory().resolve(coreName), parameters, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrCore create(String coreName, Path instancePath, Map<String, String> parameters, boolean newCollection) {
        boolean iAdded = false;
        try {
            iAdded = this.inFlightCreations.add(coreName);
            if (!iAdded) {
                String msg = "Already creating a core with name '" + coreName + "', call aborted '";
                log.warn(msg);
                throw new SolrException(SolrException.ErrorCode.CONFLICT, msg);
            }
            CoreDescriptor cd = new CoreDescriptor(coreName, instancePath, parameters, this.getContainerProperties(), this.getZkController());
            if (this.getCoreDescriptor(coreName) != null) {
                log.warn("Creating a core with existing name is not allowed: '{}'", (Object)coreName);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Core with name '" + coreName + "' already exists.");
            }
            this.assertPathAllowed(cd.getInstanceDir());
            this.assertPathAllowed(Paths.get(cd.getDataDir(), new String[0]));
            boolean preExistingZkEntry = false;
            try {
                SolrCore core;
                if (this.getZkController() != null) {
                    if (cd.getCloudDescriptor().getCoreNodeName() == null) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "coreNodeName missing " + parameters.toString());
                    }
                    preExistingZkEntry = this.getZkController().checkIfCoreNodeNameAlreadyExists(cd);
                }
                this.coresLocator.create(this, cd);
                try {
                    this.solrCores.waitAddPendingCoreOps(cd.getName());
                    core = this.createFromDescriptor(cd, true, newCollection);
                    this.coresLocator.persist(this, cd);
                }
                finally {
                    this.solrCores.removeFromPendingOps(cd.getName());
                }
                SolrCore solrCore = core;
                return solrCore;
            }
            catch (Exception ex) {
                this.coresLocator.delete(this, cd);
                if (this.isZooKeeperAware() && !preExistingZkEntry) {
                    try {
                        this.getZkController().unregister(coreName, cd);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.error("interrupted", (Throwable)e);
                    }
                    catch (KeeperException e) {
                        log.error("KeeperException unregistering core {}", (Object)coreName, (Object)e);
                    }
                    catch (Exception e) {
                        log.error("Exception unregistering core {}", (Object)coreName, (Object)e);
                    }
                }
                Throwable tc = ex;
                Throwable c = null;
                do {
                    if ((tc = tc.getCause()) == null) continue;
                    c = tc;
                } while (tc != null);
                Object rootMsg = "";
                if (c != null) {
                    rootMsg = " Caused by: " + c.getMessage();
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error CREATEing SolrCore '" + coreName + "': " + ex.getMessage() + (String)rootMsg, (Throwable)ex);
            }
        }
        finally {
            if (iAdded) {
                this.inFlightCreations.remove(coreName);
            }
        }
    }

    public void assertPathAllowed(Path pathToAssert) throws SolrException {
        SolrPaths.assertPathAllowed(pathToAssert, this.allowPaths);
    }

    @VisibleForTesting
    public Set<Path> getAllowPaths() {
        return this.allowPaths;
    }

    public AllowListUrlChecker getAllowListUrlChecker() {
        return this.allowListUrlChecker;
    }

    private SolrCore createFromDescriptor(CoreDescriptor dcore, boolean publishState, boolean newCollection) {
        if (this.isShutDown) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Solr has been shutdown.");
        }
        SolrCore core = null;
        try {
            MDCLoggingContext.setCoreDescriptor(this, dcore);
            SolrIdentifierValidator.validateCoreName((String)dcore.getName());
            if (this.zkSys.getZkController() != null) {
                this.zkSys.getZkController().preRegister(dcore, publishState);
            }
            ConfigSet coreConfig = this.coreConfigService.loadConfigSet(dcore);
            dcore.setConfigSetTrusted(coreConfig.isTrusted());
            if (log.isInfoEnabled()) {
                log.info("Creating SolrCore '{}' using configuration from {}, trusted={}", new Object[]{dcore.getName(), coreConfig.getName(), dcore.isConfigSetTrusted()});
            }
            try {
                core = new SolrCore(this, dcore, coreConfig);
            }
            catch (SolrException e) {
                core = this.processCoreCreateException(e, dcore, coreConfig);
            }
            if (!this.isZooKeeperAware() && core.getUpdateHandler().getUpdateLog() != null) {
                core.getUpdateHandler().getUpdateLog().recoverFromLog();
            }
            this.registerCore(dcore, core, publishState, newCollection);
            SolrCore e = core;
            return e;
        }
        catch (Exception e) {
            this.coreInitFailures.put(dcore.getName(), new CoreLoadFailure(dcore, e));
            if (e instanceof ZkController.NotInClusterStateException && !newCollection) {
                boolean deleteUnknownCores = Boolean.parseBoolean(System.getProperty("solr.deleteUnknownCores", "false"));
                log.error("SolrCore {} in {} is not in cluster state.{}", new Object[]{dcore.getName(), dcore.getInstanceDir(), deleteUnknownCores ? " It will be deleted. See SOLR-13396 for more information." : ""});
                this.unload(dcore.getName(), deleteUnknownCores, deleteUnknownCores, deleteUnknownCores);
                throw e;
            }
            this.solrCores.removeCoreDescriptor(dcore);
            SolrException solrException = new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to create core [" + dcore.getName() + "]", (Throwable)e);
            if (core != null && !core.isClosed()) {
                IOUtils.closeQuietly((Closeable)core);
            }
            throw solrException;
        }
        catch (Throwable t) {
            SolrException e = new SolrException(SolrException.ErrorCode.SERVER_ERROR, "JVM Error creating core [" + dcore.getName() + "]: " + t.getMessage(), t);
            this.coreInitFailures.put(dcore.getName(), new CoreLoadFailure(dcore, (Exception)((Object)e)));
            this.solrCores.removeCoreDescriptor(dcore);
            if (core != null && !core.isClosed()) {
                IOUtils.closeQuietly((Closeable)core);
            }
            throw t;
        }
        finally {
            MDCLoggingContext.clear();
        }
    }

    public boolean isSharedFs(CoreDescriptor cd) {
        try (SolrCore core = this.getCore(cd.getName());){
            if (core != null) {
                boolean bl = core.getDirectoryFactory().isSharedStorage();
                return bl;
            }
            ConfigSet configSet = this.coreConfigService.loadConfigSet(cd);
            boolean bl = DirectoryFactory.loadDirectoryFactory(configSet.getSolrConfig(), this, null).isSharedStorage();
            return bl;
        }
    }

    private SolrCore processCoreCreateException(SolrException original, CoreDescriptor dcore, ConfigSet coreConfig) {
        Throwable cause = original;
        while ((cause = cause.getCause()) != null && !(cause instanceof CorruptIndexException)) {
        }
        if (cause == null) {
            throw original;
        }
        CoreInitFailedAction action = CoreInitFailedAction.valueOf(System.getProperty(CoreInitFailedAction.class.getSimpleName(), "none"));
        log.debug("CorruptIndexException while creating core, will attempt to repair via {}", (Object)action);
        switch (action) {
            case fromleader: {
                if (this.isZooKeeperAware()) {
                    CloudDescriptor desc = dcore.getCloudDescriptor();
                    try {
                        Replica leader = this.getZkController().getClusterState().getCollection(desc.getCollectionName()).getSlice(desc.getShardId()).getLeader();
                        if (leader != null && leader.getState() == Replica.State.ACTIVE) {
                            log.info("Found active leader, will attempt to create fresh core and recover.");
                            this.resetIndexDirectory(dcore, coreConfig);
                            this.getZkController().getShardTerms(desc.getCollectionName(), desc.getShardId()).setTermToZero(desc.getCoreNodeName());
                            return new SolrCore(this, dcore, coreConfig);
                        }
                    }
                    catch (SolrException se) {
                        se.addSuppressed((Throwable)original);
                        throw se;
                    }
                }
                throw original;
            }
            case none: {
                throw original;
            }
        }
        log.warn("Failed to create core, and did not recognize specified 'CoreInitFailedAction': [{}]. Valid options are {}.", (Object)action, Arrays.asList(CoreInitFailedAction.values()));
        throw original;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resetIndexDirectory(CoreDescriptor dcore, ConfigSet coreConfig) {
        SolrConfig config = coreConfig.getSolrConfig();
        String registryName = SolrMetricManager.getRegistryName(SolrInfoBean.Group.core, dcore.getName());
        DirectoryFactory df = DirectoryFactory.loadDirectoryFactory(config, this, registryName);
        String dataDir = SolrCore.findDataDir(df, null, config, dcore);
        String tmpIdxDirName = "index." + new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.ROOT).format(new Date());
        SolrCore.modifyIndexProps(df, dataDir, config, tmpIdxDirName);
        Directory dir = null;
        try {
            dir = df.get(dataDir, DirectoryFactory.DirContext.META_DATA, config.indexConfig.lockType);
        }
        catch (IOException e) {
            try {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    df.release(dir);
                    df.doneWithDirectory(dir);
                    throw throwable;
                }
                catch (IOException e2) {
                    log.error("Exception releasing {}", (Object)dir, (Object)e2);
                }
                throw throwable;
            }
        }
        try {
            df.release(dir);
            df.doneWithDirectory(dir);
            return;
        }
        catch (IOException e) {
            log.error("Exception releasing {}", (Object)dir, (Object)e);
            return;
        }
    }

    @Deprecated
    public List<SolrCore> getCores() {
        return this.solrCores.getCores();
    }

    public List<String> getLoadedCoreNames() {
        return this.solrCores.getLoadedCoreNames();
    }

    public List<String> getAllCoreNames() {
        return this.solrCores.getAllCoreNames();
    }

    public int getNumAllCores() {
        return this.solrCores.getNumAllCores();
    }

    public Map<String, CoreLoadFailure> getCoreInitFailures() {
        return Map.copyOf(this.coreInitFailures);
    }

    private CoreDescriptor reloadCoreDescriptor(CoreDescriptor oldDesc) {
        if (oldDesc == null) {
            return null;
        }
        CoreDescriptor ret = this.getCoresLocator().reload(oldDesc, this);
        if (ret == null) {
            oldDesc.loadExtraProperties();
            return oldDesc;
        }
        if (ret.getCloudDescriptor() != null) {
            ret.getCloudDescriptor().reload(oldDesc.getCloudDescriptor());
        }
        return ret;
    }

    public void reload(String name) {
        this.reload(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(String name, UUID coreId) {
        if (this.isShutDown) {
            throw new AlreadyClosedException();
        }
        SolrCore newCore = null;
        SolrCore core = this.solrCores.getCoreFromAnyList(name, false, coreId);
        if (core != null) {
            CoreDescriptor cd = this.reloadCoreDescriptor(core.getCoreDescriptor());
            this.solrCores.addCoreDescriptor(cd);
            boolean success = false;
            try {
                RefCounted<IndexWriter> iwRef;
                this.solrCores.waitAddPendingCoreOps(cd.getName());
                ConfigSet coreConfig = this.coreConfigService.loadConfigSet(cd);
                if (log.isInfoEnabled()) {
                    log.info("Reloading SolrCore '{}' using configuration from {}", (Object)cd.getName(), (Object)coreConfig.getName());
                }
                newCore = core.reload(coreConfig);
                DocCollection docCollection = null;
                if (this.getZkController() != null && (docCollection = this.getZkController().getClusterState().getCollectionOrNull(cd.getCollectionName())) != null && docCollection.getBool("readOnly", false)) {
                    newCore.readOnly = true;
                }
                this.registerCore(cd, newCore, false, false);
                if (newCore.readOnly && (iwRef = core.getSolrCoreState().getIndexWriter(null)) != null) {
                    IndexWriter iw = iwRef.get();
                    core.readOnly = true;
                    try {
                        if (iw != null) {
                            iw.commit();
                        }
                    }
                    finally {
                        iwRef.decref();
                    }
                }
                if (docCollection != null) {
                    Replica replica = docCollection.getReplica(cd.getCloudDescriptor().getCoreNodeName());
                    assert (replica != null) : cd.getCloudDescriptor().getCoreNodeName() + " had no replica";
                    if (replica.getType() == Replica.Type.TLOG) {
                        this.getZkController().stopReplicationFromLeader(core.getName());
                        if (!cd.getCloudDescriptor().isLeader()) {
                            this.getZkController().startReplicationFromLeader(newCore.getName(), true);
                        }
                    } else if (replica.getType() == Replica.Type.PULL) {
                        this.getZkController().stopReplicationFromLeader(core.getName());
                        this.getZkController().startReplicationFromLeader(newCore.getName(), false);
                    }
                }
                success = true;
            }
            catch (SolrCoreState.CoreIsClosedException e) {
                throw e;
            }
            catch (Exception e) {
                this.coreInitFailures.put(cd.getName(), new CoreLoadFailure(cd, e));
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to reload core [" + cd.getName() + "]", (Throwable)e);
            }
            finally {
                if (!success && newCore != null && newCore.getOpenCount() > 0) {
                    IOUtils.closeQuietly((Closeable)newCore);
                }
                this.solrCores.removeFromPendingOps(cd.getName());
            }
        }
        if (coreId != null) {
            return;
        }
        CoreLoadFailure clf = this.coreInitFailures.get(name);
        if (clf != null) {
            try {
                this.solrCores.waitAddPendingCoreOps(clf.cd.getName());
                this.createFromDescriptor(clf.cd, true, false);
            }
            finally {
                this.solrCores.removeFromPendingOps(clf.cd.getName());
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + name);
        }
    }

    public void swap(String n0, String n1) {
        this.apiAssumeStandalone();
        if (n0 == null || n1 == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not swap unnamed cores.");
        }
        this.solrCores.swap(n0, n1);
        this.coresLocator.swap(this, this.solrCores.getCoreDescriptor(n0), this.solrCores.getCoreDescriptor(n1));
        log.info("swapped: {} with {}", (Object)n0, (Object)n1);
    }

    public void unload(String name) {
        this.unload(name, false, false, false);
    }

    public void unload(String name, boolean deleteIndexDir, boolean deleteDataDir, boolean deleteInstanceDir) {
        CoreLoadFailure loadFailure;
        CoreDescriptor cd = this.solrCores.getCoreDescriptor(name);
        if (name != null && (loadFailure = this.coreInitFailures.remove(name)) != null) {
            SolrCore.deleteUnloadedCore(loadFailure.cd, deleteDataDir, deleteInstanceDir);
            if (cd != null) {
                this.solrCores.removeCoreDescriptor(cd);
                this.coresLocator.delete(this, cd);
            }
            return;
        }
        if (cd == null) {
            log.warn("Cannot unload non-existent core '{}'", (Object)name);
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot unload non-existent core [" + name + "]");
        }
        boolean close = this.solrCores.isLoadedNotPendingClose(name);
        SolrCore core = this.solrCores.remove(name);
        this.solrCores.removeCoreDescriptor(cd);
        this.coresLocator.delete(this, cd);
        if (core == null) {
            SolrCore.deleteUnloadedCore(cd, deleteDataDir, deleteInstanceDir);
            return;
        }
        this.metricManager.removeRegistry(core.getCoreMetricManager().getRegistryName());
        if (this.zkSys.getZkController() != null) {
            core.getSolrCoreState().cancelRecovery();
            if (cd.getCloudDescriptor().getReplicaType() == Replica.Type.PULL || cd.getCloudDescriptor().getReplicaType() == Replica.Type.TLOG) {
                this.zkSys.getZkController().stopReplicationFromLeader(name);
            }
        }
        core.unloadOnClose(cd, deleteIndexDir, deleteDataDir, deleteInstanceDir);
        if (close) {
            core.closeAndWait();
        }
        if (this.zkSys.getZkController() != null) {
            try {
                this.zkSys.getZkController().unregister(name, cd);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted while unregistering core [" + name + "] from cloud state");
            }
            catch (KeeperException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error unregistering core [" + name + "] from cloud state", (Throwable)e);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error unregistering core [" + name + "] from cloud state", (Throwable)e);
            }
        }
    }

    public void rename(String name, String toName) {
        this.apiAssumeStandalone();
        SolrIdentifierValidator.validateCoreName((String)toName);
        try (SolrCore core = this.getCore(name);){
            if (core != null) {
                String oldRegistryName = core.getCoreMetricManager().getRegistryName();
                String newRegistryName = SolrCoreMetricManager.createRegistryName(core, toName);
                this.metricManager.swapRegistries(oldRegistryName, newRegistryName);
                CoreDescriptor cd = core.getCoreDescriptor();
                this.solrCores.removeCoreDescriptor(cd);
                cd.setProperty("name", toName);
                this.solrCores.addCoreDescriptor(cd);
                core.setName(toName);
                this.registerCore(cd, core, true, false);
                SolrCore old = this.solrCores.remove(name);
                this.coresLocator.rename(this, old.getCoreDescriptor(), core.getCoreDescriptor());
            }
        }
    }

    private void apiAssumeStandalone() {
        if (this.getZkController() != null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Not supported in SolrCloud");
        }
    }

    public List<CoreDescriptor> getCoreDescriptors() {
        return this.solrCores.getCoreDescriptors();
    }

    public CoreDescriptor getCoreDescriptor(String coreName) {
        return this.solrCores.getCoreDescriptor(coreName);
    }

    public Path getCoreRootDirectory() {
        return this.cfg.getCoreRootDirectory();
    }

    public SolrCore getCore(String name) {
        return this.getCore(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrCore getCore(String name, UUID id) {
        if (name == null) {
            return null;
        }
        SolrCore core = this.solrCores.getCoreFromAnyList(name, true, id);
        if (core != null) {
            return core;
        }
        CoreDescriptor desc = this.solrCores.getCoreDescriptor(name);
        CoreLoadFailure loadFailure = this.getCoreInitFailures().get(name);
        if (null != loadFailure) {
            throw new SolrCoreInitializationException(name, loadFailure.exception);
        }
        if (desc == null || this.zkSys.getZkController() != null) {
            return null;
        }
        core = this.solrCores.waitAddPendingCoreOps(name);
        if (this.isShutDown) {
            return null;
        }
        try {
            if (core == null) {
                if (this.zkSys.getZkController() != null) {
                    this.zkSys.getZkController().throwErrorIfReplicaReplaced(desc);
                }
                core = this.createFromDescriptor(desc, true, false);
            }
            core.open();
        }
        finally {
            this.solrCores.removeFromPendingOps(name);
        }
        return core;
    }

    public BlobRepository getBlobRepository() {
        return this.blobRepository;
    }

    public void waitForLoadingCoresToFinish(long timeoutMs) {
        this.solrCores.waitForLoadingCoresToFinish(timeoutMs);
    }

    public void waitForLoadingCore(String name, long timeoutMs) {
        this.solrCores.waitForLoadingCoreToFinish(name, timeoutMs);
    }

    protected <T> T createHandler(String path, String handlerClass, Class<T> clazz) {
        T handler = this.loader.newInstance(handlerClass, clazz, null, new Class[]{CoreContainer.class}, new Object[]{this});
        if (handler instanceof SolrRequestHandler) {
            this.containerHandlers.put(path, (SolrRequestHandler)handler);
        }
        if (handler instanceof SolrMetricProducer) {
            ((SolrMetricProducer)handler).initializeMetrics(this.solrMetricsContext, path);
        }
        return handler;
    }

    public CoreAdminHandler getMultiCoreHandler() {
        return this.coreAdminHandler;
    }

    public CollectionsHandler getCollectionsHandler() {
        return this.collectionsHandler;
    }

    public HealthCheckHandler getHealthCheckHandler() {
        return this.healthCheckHandler;
    }

    public InfoHandler getInfoHandler() {
        return this.infoHandler;
    }

    public ConfigSetsHandler getConfigSetsHandler() {
        return this.configSetsHandler;
    }

    public ConfigSetService getConfigSetService() {
        return this.coreConfigService;
    }

    public void setCoreConfigService(ConfigSetService configSetService) {
        this.coreConfigService = configSetService;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getManagementPath() {
        return this.cfg.getManagementPath();
    }

    public LogWatcher<?> getLogging() {
        return this.logging;
    }

    public boolean isLoaded(String name) {
        return this.solrCores.isLoaded(name);
    }

    public String getSolrHome() {
        return this.solrHome.toString();
    }

    public Path getUserFilesPath() {
        return this.solrHome.resolve("userfiles");
    }

    public boolean isZooKeeperAware() {
        return this.zkSys.getZkController() != null;
    }

    public ZkController getZkController() {
        return this.zkSys.getZkController();
    }

    public NodeConfig getConfig() {
        return this.cfg;
    }

    public ShardHandlerFactory getShardHandlerFactory() {
        return this.shardHandlerFactory;
    }

    public UpdateShardHandler getUpdateShardHandler() {
        return this.updateShardHandler;
    }

    public SolrResourceLoader getResourceLoader() {
        return this.loader;
    }

    public boolean isCoreLoading(String name) {
        return this.solrCores.isCoreLoading(name);
    }

    public AuthorizationPlugin getAuthorizationPlugin() {
        return this.authorizationPlugin == null ? null : (AuthorizationPlugin)this.authorizationPlugin.plugin;
    }

    public AuthenticationPlugin getAuthenticationPlugin() {
        return this.authenticationPlugin == null ? null : (AuthenticationPlugin)this.authenticationPlugin.plugin;
    }

    public AuditLoggerPlugin getAuditLoggerPlugin() {
        return this.auditloggerPlugin == null ? null : (AuditLoggerPlugin)this.auditloggerPlugin.plugin;
    }

    public NodeConfig getNodeConfig() {
        return this.cfg;
    }

    public long getStatus() {
        return this.status;
    }

    public boolean isStatusLoadComplete() {
        return 1L == (this.getStatus() & 1L);
    }

    public boolean hideStackTrace() {
        return this.cfg.hideStackTraces();
    }

    public Aliases getAliases() {
        if (this.isZooKeeperAware()) {
            return this.getZkController().getZkStateReader().getAliases();
        }
        throw new IllegalStateException("Aliases don't exist in a non-cloud context, check isZookeeperAware() before calling this method.");
    }

    public boolean checkTragicException(SolrCore solrCore) {
        Throwable tragicException;
        try {
            tragicException = solrCore.getSolrCoreState().getTragicException();
        }
        catch (IOException e) {
            tragicException = e;
        }
        if (tragicException != null && this.isZooKeeperAware()) {
            this.getZkController().giveupLeadership(solrCore.getCoreDescriptor());
            try {
                solrCore.getSolrCoreState().newIndexWriter(solrCore, false);
            }
            catch (IOException e) {
                log.warn("Could not roll index writer after tragedy");
            }
        }
        return tragicException != null;
    }

    public ContainerPluginsRegistry getContainerPluginsRegistry() {
        return this.containerPluginsRegistry;
    }

    public ClusterSingletons getClusterSingletons() {
        return this.clusterSingletons;
    }

    public ClusterEventProducer getClusterEventProducer() {
        return this.clusterEventProducer;
    }

    public PlacementPluginFactory<? extends PlacementPluginConfig> getPlacementPluginFactory() {
        return this.placementPluginFactory;
    }

    public Optional<DistributedCollectionConfigSetCommandRunner> getDistributedCollectionCommandRunner() {
        return this.distributedCollectionCommandRunner;
    }

    public void runAsync(Runnable r) {
        this.coreContainerAsyncTaskExecutor.submit(r);
    }

    public static void setWeakStringInterner() {
        boolean enable = "true".equals(System.getProperty("solr.use.str.intern", "true"));
        if (!enable) {
            return;
        }
        final Interner interner = Interner.newWeakInterner();
        ClusterState.setStrInternerParser((Function)new Function<JSONParser, ObjectBuilder>(){

            @Override
            public ObjectBuilder apply(JSONParser p) {
                try {
                    return new ObjectBuilder(p){

                        public void addKeyVal(Object map, Object key, Object val) throws IOException {
                            if (key != null) {
                                key = interner.intern((Object)key.toString());
                            }
                            if (val instanceof String) {
                                val = interner.intern((Object)((String)val));
                            }
                            super.addKeyVal(map, key, val);
                        }
                    };
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static class CoreLoadFailure {
        public final CoreDescriptor cd;
        public final Exception exception;

        public CoreLoadFailure(CoreDescriptor cd, Exception loadFailure) {
            this.cd = new CoreDescriptor(cd.getName(), cd);
            this.exception = loadFailure;
        }
    }

    private static enum CoreInitFailedAction {
        fromleader,
        none;

    }
}

