/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.common.cloud.SolrZkClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkMkrootTool
extends ToolBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ZkMkrootTool() {
        this(CLIO.getOutStream());
    }

    public ZkMkrootTool(PrintStream stdout) {
        super(stdout);
    }

    @Override
    public List<Option> getOptions() {
        return List.of(Option.builder().longOpt("path").argName("PATH").hasArg().required(true).desc("Path to create.").build(), Option.builder().longOpt("fail-on-exists").hasArg().required(false).desc("Raise an error if the root exists.  Defaults to false.").build(), SolrCLI.OPTION_RECURSE, SolrCLI.OPTION_SOLRURL, SolrCLI.OPTION_SOLRURL_DEPRECATED, SolrCLI.OPTION_ZKHOST, SolrCLI.OPTION_ZKHOST_DEPRECATED, SolrCLI.OPTION_VERBOSE);
    }

    @Override
    public String getName() {
        return "mkroot";
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        SolrCLI.raiseLogLevelUnlessVerbose(cli);
        String zkHost = SolrCLI.getZkHost(cli);
        boolean failOnExists = cli.hasOption("fail-on-exists");
        try (SolrZkClient zkClient = SolrCLI.getSolrZkClient(cli, zkHost);){
            this.echoIfVerbose("\nConnecting to ZooKeeper at " + zkHost + " ...", cli);
            String znode = cli.getOptionValue("path");
            this.echo("Creating ZooKeeper path " + znode + " on ZooKeeper at " + zkHost);
            zkClient.makePath(znode, failOnExists, true);
        }
        catch (Exception e) {
            log.error("Could not complete mkroot operation for reason: ", (Throwable)e);
            throw e;
        }
    }
}

