/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.common.cloud.SolrZkClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigSetDownloadTool
extends ToolBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ConfigSetDownloadTool() {
        this(CLIO.getOutStream());
    }

    public ConfigSetDownloadTool(PrintStream stdout) {
        super(stdout);
    }

    @Override
    public List<Option> getOptions() {
        return List.of(Option.builder().longOpt("conf-name").hasArg().argName("NAME").required(true).desc("Configset name in ZooKeeper.").build(), Option.builder().longOpt("conf-dir").hasArg().argName("DIR").required(true).desc("Local directory with configs.").build(), SolrCLI.OPTION_SOLRURL, SolrCLI.OPTION_SOLRURL_DEPRECATED, SolrCLI.OPTION_ZKHOST, SolrCLI.OPTION_ZKHOST_DEPRECATED);
    }

    @Override
    public String getName() {
        return "downconfig";
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        SolrCLI.raiseLogLevelUnlessVerbose(cli);
        String zkHost = SolrCLI.getZkHost(cli);
        try (SolrZkClient zkClient = SolrCLI.getSolrZkClient(cli, zkHost);){
            this.echoIfVerbose("\nConnecting to ZooKeeper at " + zkHost + " ...", cli);
            String confName = cli.getOptionValue("conf-name");
            String confDir = cli.getOptionValue("conf-dir");
            Path configSetPath = Paths.get(confDir, new String[0]);
            if (!configSetPath.endsWith("/conf")) {
                configSetPath = Paths.get(configSetPath.toString(), "conf");
            }
            Files.createDirectories(configSetPath, new FileAttribute[0]);
            this.echo("Downloading configset " + confName + " from ZooKeeper at " + zkHost + " to directory " + configSetPath.toAbsolutePath());
            zkClient.downConfig(confName, configSetPath);
        }
        catch (Exception e) {
            log.error("Could not complete downconfig operation for reason: ", (Throwable)e);
            throw e;
        }
    }
}

