/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Random;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.sasl.DigestMD5Properties;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.util.StringUtils;

public class SASLDigestMD5Mechanism
extends SASLMechanism {
    protected static final String ISO_8859_1 = "ISO-8859-1";
    protected static final String UTF_8 = "UTF-8";
    protected static final String[] QOP_TYPES = new String[]{"auth", "auth-int", "auth-conf"};
    protected String username;
    protected String host;
    protected String password;
    protected String charset = "ISO-8859-1";
    protected String cnonce;
    protected String digestUri;
    protected int nc = 0;
    protected String nonce;
    protected String qop;
    protected String realm;
    protected String rspauth;
    protected boolean isDone;

    protected static byte[] H(byte[] s) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        return md5.digest(s);
    }

    protected static String HEX(byte[] n) {
        StringBuffer sb = new StringBuffer(n.length * 2);
        for (int i = 0; i < n.length; ++i) {
            int b = n[i] & 0xFF;
            if (b < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(b));
        }
        return sb.toString();
    }

    public static byte[] KD(byte[] k, byte[] s) throws IOException, NoSuchAlgorithmException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(k.length + 1 + s.length);
        out.write(k);
        out.write(58);
        out.write(s);
        return SASLDigestMD5Mechanism.H(out.toByteArray());
    }

    public static String generateNonce() {
        byte[] bytes = new byte[8];
        new Random().nextBytes(bytes);
        return StringUtils.encodeBase64(bytes);
    }

    public SASLDigestMD5Mechanism(SASLAuthentication saslAuthentication) {
        super(saslAuthentication);
    }

    public void authenticate(String username, String host, String password) throws IOException {
        this.username = username;
        this.host = host;
        this.password = password;
        super.authenticate(username, host, password);
    }

    protected String getName() {
        return "DIGEST-MD5";
    }

    protected String getAuthenticationText(String username, String host, String password) {
        return null;
    }

    protected synchronized String getChallengeResponse(byte[] challenge) {
        try {
            if (this.isDone) {
                throw new Exception("already done");
            }
            ++this.nc;
            if (this.nc == 1) {
                DigestMD5Properties props = new DigestMD5Properties(new String(challenge, ISO_8859_1));
                this.nonce = props.getProperty("nonce", "");
                if (this.nonce.length() == 0) {
                    throw new Exception("no nonce");
                }
                List qopList = props.getList("qop");
                for (int i = 0; i < QOP_TYPES.length; ++i) {
                    String qop = QOP_TYPES[i];
                    if (!qopList.contains(qop)) continue;
                    this.qop = qop;
                    break;
                }
                if (this.qop == null) {
                    throw new Exception("No common protection layer between client and server");
                }
                String charset = props.getProperty("charset", "");
                if (charset.equals(UTF_8)) {
                    this.charset = UTF_8;
                }
                this.cnonce = SASLDigestMD5Mechanism.generateNonce();
                this.digestUri = "xmpp/" + this.host;
                this.realm = props.getProperty("realm", "");
                this.rspauth = this.getResponse(false);
                ResponseBuffer rb = new ResponseBuffer();
                if (this.realm.length() != 0) {
                    rb.appendQuoted("realm", this.realm);
                }
                if (charset.equals(UTF_8)) {
                    rb.append("charset", UTF_8);
                }
                rb.appendQuoted("username", this.username);
                rb.appendQuoted("nonce", this.nonce);
                rb.append("nc", "00000001");
                rb.appendQuoted("cnonce", this.cnonce);
                rb.appendQuoted("digest-uri", this.digestUri);
                rb.append("response", this.getResponse(true));
                rb.append("qop", this.qop);
                return rb.toString();
            }
            if (this.nc == 2) {
                DigestMD5Properties props = new DigestMD5Properties(new String(challenge, ISO_8859_1));
                if (!this.rspauth.equals(props.getProperty("rspauth"))) {
                    throw new Exception("Invalid rspauth from the server");
                }
                this.isDone = true;
            }
        }
        catch (Exception e) {
            this.isDone = true;
            throw new RuntimeException("DIGEST-MD5 failed: " + e.getMessage());
        }
        return "";
    }

    protected String getResponse(boolean isClient) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(this.username.getBytes(this.charset));
        out.write((":" + this.realm + ":").getBytes(ISO_8859_1));
        out.write(this.password.getBytes(this.charset));
        byte[] s = out.toByteArray();
        out.reset();
        out.write(SASLDigestMD5Mechanism.H(s));
        out.write((":" + this.nonce + ":" + this.cnonce).getBytes(ISO_8859_1));
        byte[] A1 = out.toByteArray();
        byte[] A2 = isClient ? (this.qop.equals("auth") ? ("AUTHENTICATE:" + this.digestUri).getBytes(ISO_8859_1) : ("AUTHENTICATE:" + this.digestUri + ":00000000000000000000000000000000").getBytes(ISO_8859_1)) : (this.qop.equals("auth") ? (":" + this.digestUri).getBytes(ISO_8859_1) : (":" + this.digestUri + ":00000000000000000000000000000000").getBytes(ISO_8859_1));
        byte[] k = SASLDigestMD5Mechanism.HEX(SASLDigestMD5Mechanism.H(A1)).getBytes(ISO_8859_1);
        s = (this.nonce + ":00000001:" + this.cnonce + ":" + this.qop + ":" + SASLDigestMD5Mechanism.HEX(SASLDigestMD5Mechanism.H(A2))).getBytes(ISO_8859_1);
        return SASLDigestMD5Mechanism.HEX(SASLDigestMD5Mechanism.KD(k, s));
    }

    protected static class ResponseBuffer {
        protected StringBuffer sb = new StringBuffer();

        protected ResponseBuffer() {
        }

        public void append(String key, String value) {
            if (this.sb.length() > 0) {
                this.sb.append(',');
            }
            this.sb.append(key);
            this.sb.append('=');
            this.sb.append(value);
        }

        public void appendQuoted(String key, String value) {
            if (this.sb.length() > 0) {
                this.sb.append(',');
            }
            this.sb.append(key);
            this.sb.append('=');
            this.sb.append('\"');
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == '\"') {
                    this.sb.append('\\');
                }
                this.sb.append(c);
            }
            this.sb.append('\"');
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

