/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;

public class Presence
extends Packet {
    private Type type = Type.AVAILABLE;
    private String status = null;
    private int priority = -1;
    private Mode mode = Mode.AVAILABLE;

    public Presence(Type type) {
        this.type = type;
    }

    public Presence(Type type, String status, int priority, Mode mode) {
        this.type = type;
        this.status = status;
        this.priority = priority;
        this.mode = mode;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        if (priority < -128 || priority > 128) {
            throw new IllegalArgumentException("Priority value " + priority + " is not valid. Valid range is -128 through 128.");
        }
        this.priority = priority;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("<presence");
        if (this.getPacketID() != null) {
            buf.append(" id=\"").append(this.getPacketID()).append("\"");
        }
        if (this.getTo() != null) {
            buf.append(" to=\"").append(StringUtils.escapeForXML(this.getTo())).append("\"");
        }
        if (this.getFrom() != null) {
            buf.append(" from=\"").append(StringUtils.escapeForXML(this.getFrom())).append("\"");
        }
        if (this.type != Type.AVAILABLE) {
            buf.append(" type=\"").append(this.type).append("\"");
        }
        buf.append(">");
        if (this.status != null) {
            buf.append("<status>").append(this.status).append("</status>");
        }
        if (this.priority != -1) {
            buf.append("<priority>").append(this.priority).append("</priority>");
        }
        if (this.mode != null && this.mode != Mode.AVAILABLE) {
            buf.append("<show>").append(this.mode).append("</show>");
        }
        buf.append(this.getExtensionsXML());
        XMPPError error = this.getError();
        if (error != null) {
            buf.append(error.toXML());
        }
        buf.append("</presence>");
        return buf.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.type);
        if (this.mode != null) {
            buf.append(": ").append(this.mode);
        }
        if (this.status != null) {
            buf.append(" (").append(this.status).append(")");
        }
        return buf.toString();
    }

    public static class Mode {
        public static final Mode AVAILABLE = new Mode("available");
        public static final Mode CHAT = new Mode("chat");
        public static final Mode AWAY = new Mode("away");
        public static final Mode EXTENDED_AWAY = new Mode("xa");
        public static final Mode DO_NOT_DISTURB = new Mode("dnd");
        public static final Mode INVISIBLE = new Mode("invisible");
        private String value;

        private Mode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static Mode fromString(String value) {
            if (value == null) {
                return AVAILABLE;
            }
            if ((value = value.toLowerCase()).equals("chat")) {
                return CHAT;
            }
            if (value.equals("away")) {
                return AWAY;
            }
            if (value.equals("xa")) {
                return EXTENDED_AWAY;
            }
            if (value.equals("dnd")) {
                return DO_NOT_DISTURB;
            }
            if (value.equals("invisible")) {
                return INVISIBLE;
            }
            return AVAILABLE;
        }
    }

    public static class Type {
        public static final Type AVAILABLE = new Type("available");
        public static final Type UNAVAILABLE = new Type("unavailable");
        public static final Type SUBSCRIBE = new Type("subscribe");
        public static final Type SUBSCRIBED = new Type("subscribed");
        public static final Type UNSUBSCRIBE = new Type("unsubscribe");
        public static final Type UNSUBSCRIBED = new Type("unsubscribed");
        public static final Type ERROR = new Type("error");
        private String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static Type fromString(String value) {
            if (value == null) {
                return AVAILABLE;
            }
            if ("unavailable".equals(value = value.toLowerCase())) {
                return UNAVAILABLE;
            }
            if ("subscribe".equals(value)) {
                return SUBSCRIBE;
            }
            if ("subscribed".equals(value)) {
                return SUBSCRIBED;
            }
            if ("unsubscribe".equals(value)) {
                return UNSUBSCRIBE;
            }
            if ("unsubscribed".equals(value)) {
                return UNSUBSCRIBED;
            }
            if ("error".equals(value)) {
                return ERROR;
            }
            return AVAILABLE;
        }
    }
}

