/*
 * Decompiled with CFR 0.152.
 */
package macromedia.slutil;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import macromedia.slutil.UtilLocalMessages;

public class UtilException
extends Exception {
    private static UtilLocalMessages messages;
    private int reason;
    private UtilException nextException;
    private boolean socketGenerated;

    public UtilException(UtilException utilException, int n, String[] stringArray) {
        super(UtilException.getLocalizedReason(n, stringArray));
        this.reason = n;
        this.nextException = utilException;
    }

    public UtilException(UtilException utilException, int n, String string) {
        super(UtilException.getLocalizedReason(n, string));
        this.reason = n;
        this.nextException = utilException;
    }

    public UtilException(UtilException utilException, int n) {
        super(UtilException.getLocalizedReason(n, (String[])null));
        this.reason = n;
        this.nextException = utilException;
    }

    public UtilException(int n, String[] stringArray) {
        super(UtilException.getLocalizedReason(n, stringArray));
        this.reason = n;
        this.nextException = null;
    }

    public UtilException(int n, String string) {
        super(UtilException.getLocalizedReason(n, string));
        this.reason = n;
        this.nextException = null;
    }

    public UtilException(int n, String string, boolean bl) {
        super(UtilException.getLocalizedReason(n, string));
        this.socketGenerated = bl;
    }

    public UtilException(int n) {
        super(UtilException.getLocalizedReason(n, (String[])null));
        this.reason = n;
        this.nextException = null;
    }

    public UtilException(int n, boolean bl) {
        super(UtilException.getLocalizedReason(n, (String[])null));
        this.socketGenerated = true;
    }

    public static String getLocalizedReason(int n, String[] stringArray) {
        String string = null;
        Object[] objectArray = stringArray;
        try {
            string = messages.getString(n, stringArray);
        }
        catch (Exception exception) {
            string = "Utility Internal Error - Could not load localized message for key: {0}";
            objectArray[0] = new String();
            objectArray[0] = Integer.toString(n);
        }
        if (objectArray != null) {
            string = MessageFormat.format(string, objectArray);
        }
        return string;
    }

    public static String getLocalizedReason(int n, String string) {
        String[] stringArray = new String[]{string};
        return UtilException.getLocalizedReason(n, stringArray);
    }

    static UtilException createTransliterationFailedException(String string) throws UtilException {
        if (string == null) {
            string = "unknown";
        }
        return new UtilException(1009, string);
    }

    public int getReason() {
        return this.reason;
    }

    public boolean wasSocketGenerated() {
        return this.socketGenerated;
    }

    public void chainException(UtilException utilException) {
        this.nextException = utilException;
    }

    static {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("macromedia.slutil.UtilLocal");
        messages = new UtilLocalMessages();
        messages.setResourceBundle(resourceBundle);
    }
}

