/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.ssp;

import java.sql.SQLException;
import java.sql.SQLWarning;
import macromedia.sequelink.ssp.Message;

public class Diagnostic {
    static final int SQLE_CLIENTCORE = 7361;
    static final int SQLE_INVALID_SSP_VERSION = 7361;
    static final int SQLE_SERVER_INVALID_CONTEXT = 7362;
    static final int SQLE_SERVER_EXIT = 7363;
    static final int SQLE_WRITE_STREAM = 7364;
    static final int SQLE_READ_STREAM = 7365;
    static final int SQLE_UNEXPECTED_VALUE = 7366;
    static final int SQLE_GETDIAGNOSTICS_FAILED = 7367;
    public static final int SQLE_SIGNED_INT = 7368;
    public static final int SQLE_BAD_SQLTYPE = 7369;
    static final int SQLE_CNV_DIAGNOSTIC = 7370;
    private static final String INT_CORE_ERR = "err.core.int";
    Diagnostic next;
    String message;
    int errorCode;
    int component;
    int type;
    int function;
    int rowNumber;
    int columnNumber;
    String sqlState;

    public static SQLException ClientCoreError(int n) {
        String string = "[Macromedia][SequeLink JDBC Driver]" + Message.Gen.getMessage(INT_CORE_ERR);
        return new SQLException(string, "HY000", n);
    }

    public static SQLException ClientCoreError(int n, String string) {
        String string2 = "[Macromedia][SequeLink JDBC Driver]" + Message.Gen.getMessage(INT_CORE_ERR);
        SQLException sQLException = new SQLException(string2, "HY000", n);
        return Message.Gen.addMessageToSQLException(sQLException, string);
    }

    Diagnostic() {
    }

    public void add(Diagnostic diagnostic) {
        if (this.next == null) {
            this.next = diagnostic;
        } else {
            this.next.add(diagnostic);
        }
    }

    public SQLException toSQLException() {
        this.convert(true);
        return new SQLException(this.message, this.sqlState, this.errorCode);
    }

    public SQLWarning toSQLWarning() {
        this.convert(false);
        SQLWarning sQLWarning = new SQLWarning(this.message, this.sqlState, this.errorCode);
        if (this.next != null) {
            sQLWarning.setNextWarning(this.next.toSQLWarning());
        }
        return sQLWarning;
    }

    private void convert(boolean bl) {
        String string;
        this.sqlState = "HY000";
        if (this.message.length() >= 7 && this.message.charAt(0) == '[' && this.message.charAt(6) == ']') {
            this.sqlState = this.message.substring(1, 6);
            this.message = this.message.substring(7);
        }
        if (this.message.endsWith("\n")) {
            this.message = this.message.substring(0, this.message.length() - 1);
        }
        switch (this.component) {
            case 3: 
            case 4: 
            case 5: {
                string = "[SequeLink Server]";
                break;
            }
            case 6: {
                string = "";
                break;
            }
            default: {
                string = "[???]";
            }
        }
        if (bl) {
            this.message = "[Macromedia][SequeLink JDBC Driver]" + string + this.message;
        }
    }
}

