/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.slbase;

import java.sql.SQLException;
import java.sql.Savepoint;
import macromedia.jdbc.slbase.BaseConnection;
import macromedia.jdbc.slbase.BaseExceptions;
import macromedia.jdbc.slbase.BaseSavepoint;

final class BaseSavepoints {
    private BaseExceptions exceptions;
    private BaseConnection connection;
    private BaseSavepoint firstSavepoint;
    private BaseSavepoint lastSavepoint;
    int idGenerator = 0;

    BaseSavepoints(BaseExceptions baseExceptions, BaseConnection baseConnection) {
        this.exceptions = baseExceptions;
        this.connection = baseConnection;
    }

    Savepoint createSavepoint(String string) {
        this.remove(string);
        BaseSavepoint baseSavepoint = new BaseSavepoint();
        baseSavepoint.exceptions = this.exceptions;
        baseSavepoint.keyObject = this.connection;
        baseSavepoint.id = this.idGenerator++;
        baseSavepoint.name = string;
        if (this.firstSavepoint == null) {
            this.firstSavepoint = baseSavepoint;
        }
        if (this.lastSavepoint != null) {
            this.lastSavepoint.next = baseSavepoint;
            baseSavepoint.previous = this.lastSavepoint;
        }
        this.lastSavepoint = baseSavepoint;
        return baseSavepoint;
    }

    void remove(Savepoint savepoint, boolean bl) {
        BaseSavepoint baseSavepoint = (BaseSavepoint)savepoint;
        if (baseSavepoint == null) {
            return;
        }
        if (this.firstSavepoint == baseSavepoint) {
            this.firstSavepoint = null;
        }
        if (this.lastSavepoint != null && this.lastSavepoint.id >= baseSavepoint.id) {
            this.idGenerator = baseSavepoint.id;
            this.lastSavepoint = baseSavepoint.previous;
        }
        baseSavepoint.released = true;
        if (baseSavepoint.previous != null) {
            baseSavepoint.previous.next = baseSavepoint.next;
        }
        if (baseSavepoint.next != null) {
            baseSavepoint.next.previous = baseSavepoint.previous;
        }
        BaseSavepoint baseSavepoint2 = baseSavepoint.next;
        baseSavepoint.next = null;
        baseSavepoint.previous = null;
        if (bl) {
            this.remove(baseSavepoint2, true);
        }
    }

    void remove() {
        if (this.firstSavepoint != null) {
            this.remove(this.firstSavepoint, true);
        }
    }

    private void remove(String string) {
        BaseSavepoint baseSavepoint = this.lastSavepoint;
        while (baseSavepoint != null) {
            if (baseSavepoint.name != null && baseSavepoint.name.equalsIgnoreCase(string)) {
                this.remove(baseSavepoint, false);
                return;
            }
            baseSavepoint = baseSavepoint.previous;
        }
    }

    String getName(Savepoint savepoint) throws SQLException {
        BaseSavepoint baseSavepoint = (BaseSavepoint)savepoint;
        if (baseSavepoint.name == null) {
            return "SPMN" + Integer.toString(baseSavepoint.id);
        }
        return baseSavepoint.name;
    }

    Savepoint get(String string) {
        BaseSavepoint baseSavepoint = this.lastSavepoint;
        while (baseSavepoint != null) {
            if (baseSavepoint.name != null && baseSavepoint.name.equalsIgnoreCase(string)) {
                return baseSavepoint;
            }
            baseSavepoint = baseSavepoint.previous;
        }
        return null;
    }

    boolean isValid(Savepoint savepoint, boolean bl) {
        if (savepoint instanceof BaseSavepoint) {
            BaseSavepoint baseSavepoint = (BaseSavepoint)savepoint;
            if (baseSavepoint.keyObject != this.connection) {
                return false;
            }
            if (bl && baseSavepoint.released) {
                return false;
            }
        }
        return true;
    }
}

