/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.slbase;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import macromedia.jdbc.slbase.BaseBlob;
import macromedia.jdbc.slbase.BaseExceptions;
import macromedia.jdbc.slbase.BaseImplBlob;
import macromedia.slutil.UtilDebug;

public class BaseBlobInputStream
extends InputStream {
    private long currentPosition;
    private long dataLength;
    private BaseImplBlob implBlob;
    private BaseBlob blob;
    BaseExceptions exceptions;
    public boolean closeImplBlobOnClose;

    public BaseBlobInputStream(BaseBlob baseBlob, BaseImplBlob baseImplBlob, BaseExceptions baseExceptions) throws SQLException {
        UtilDebug._assert("Must supplay a BaseImplBlob derivative", baseImplBlob != null);
        UtilDebug._assert("Must supply an exception generator", baseExceptions != null);
        this.currentPosition = 1L;
        this.blob = baseBlob;
        this.implBlob = baseImplBlob;
        this.dataLength = baseImplBlob.getLength();
        this.exceptions = baseExceptions;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        if (this.currentPosition > this.dataLength) {
            return -1;
        }
        try {
            int n = this.implBlob.readData(byArray, 0, this.currentPosition, 1);
            if (n == 0) {
                return -1;
            }
            ++this.currentPosition;
            return byArray[0] & 0xFF;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.currentPosition > this.dataLength) {
            return -1;
        }
        long l = this.dataLength - (this.currentPosition - 1L);
        if (l < Integer.MAX_VALUE && n2 > (n3 = new Long(l).intValue())) {
            n2 = n3;
        }
        try {
            int n4 = this.implBlob.readData(byArray, n, this.currentPosition, n2);
            if (n4 == 0) {
                return -1;
            }
            this.currentPosition += (long)n4;
            return n4;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    public void close() throws IOException {
        try {
            if (this.closeImplBlobOnClose) {
                this.implBlob.close();
            }
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }
}

