/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debugger.rds.handler;

import coldfusion.debugger.CFJVMDebugManager;
import coldfusion.rds.RdsRequest;
import coldfusion.rds.RdsResponse;
import coldfusion.rds.WddxUtils;
import java.util.Map;
import java.util.Vector;

public class DebugStartRequestHandler {
    public static String handleRequest(RdsRequest req, RdsResponse resp, CFJVMDebugManager dbgMgr) {
        boolean isRemote = false;
        int count = req.getMetaCount();
        if (req.getMetaCount() > 0) {
            String wddxString = req.getMetaString(1);
            Object wddxObject = null;
            try {
                wddxObject = WddxUtils.readObject((String)wddxString);
                Vector objs = (Vector)wddxObject;
                for (Map commandStruct : objs) {
                    Object obj = commandStruct.get("REMOTE_SESSION");
                    if (!(obj instanceof Boolean)) continue;
                    isRemote = (Boolean)obj;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        String sessionId = null;
        try {
            sessionId = dbgMgr.createNewDebugSession(true);
        }
        catch (Exception e) {
            resp.setError("Error creating a new session", (Throwable)e);
            return null;
        }
        String wddxStr = DebugStartRequestHandler.createWDDXResponseStr(sessionId);
        resp.addMetaData(sessionId);
        resp.addMetaData(wddxStr);
        return sessionId;
    }

    public static String createWDDXResponseStr(String sessionId) {
        StringBuffer buf = new StringBuffer("<wddxPacket version='1.0'><header></header><data><array length='1'><struct><var name='COMMAND'><string>DBG_START</string></var><var name='SESSION'><string>");
        buf.append(sessionId);
        buf.append("</string></var><var name='STATUS'><string>RDS_OK</string></var></struct></array></data></wddxPacket>");
        return buf.toString();
    }
}

