/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debug;

import coldfusion.debugger.rds.handler.DebuggerLaunchHelper;
import coldfusion.runtime.Cast;
import coldfusion.server.ConfigMap;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.server.j2ee.JvmConfigUtils;
import coldfusion.util.OrderedProperties;
import jakarta.servlet.ServletContext;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;

public class LineDebuggerConfig {
    public static final String KEY_DEBUGGER_PORT = "LINE_DEBUGGER_PORT";
    public static final String KEY_DEBUGGER_ENABLED = "LINE_DEBUGGER_ENABLED";
    public static final String KEY_MAX_DEBUG_SESSIONS = "MAX_DEBUG_SESSIONS";
    public static final int DEFAULT_DEBUGGER_PORT = 5005;
    private static LineDebuggerConfig debuggerConfig = new LineDebuggerConfig();
    private static boolean isStandalone = ServiceFactory.getLicenseService().getServerType() == 1;
    private int debuggerPort = this.getDefaultDebuggerPort();
    private String cfRootDir = null;
    private String ctxRoot = null;
    private boolean debuggerEnabled = false;
    private int maxDebuugerSession = 5;
    private boolean serverNeedRestart = false;
    private int maxSessionsAtLoad = -1;
    private boolean portConflictResolved = false;
    private int debuggerPortInJvmConfigAtLoad = -1;
    private boolean debuggerPortReadFromJvmConfigAtLoad = false;

    private LineDebuggerConfig() {
    }

    public static LineDebuggerConfig getInstance() {
        return debuggerConfig;
    }

    public String getCFRootDir() throws Exception {
        if (this.cfRootDir != null) {
            return this.cfRootDir;
        }
        RuntimeService runtimeSvc = null;
        try {
            runtimeSvc = ServiceFactory.getRuntimeService();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (runtimeSvc == null) {
            return null;
        }
        this.cfRootDir = runtimeSvc.getRootDir();
        return this.cfRootDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDebuggerSettingsInJvmConfig() throws Exception {
        if (!isStandalone) {
            return;
        }
        String pathSep = System.getProperty("file.separator");
        String cfRootDir = this.getCFRootDir();
        if (cfRootDir == null) {
            return;
        }
        String jvmConigPath = cfRootDir + pathSep + "bin" + pathSep + "jvm.config";
        ArrayList args = new ArrayList();
        JvmConfigUtils.getJavaArgsList((String)jvmConigPath, args, (boolean)false);
        StringBuffer newArgsBuf = new StringBuffer(200);
        Iterator it = args.iterator();
        while (it.hasNext()) {
            String arg = it.next().toString().trim();
            if (arg.startsWith("-Xdebug") || arg.startsWith("-Xrunjdwp")) continue;
            newArgsBuf.append(arg + " ");
        }
        OrderedProperties props = JvmConfigUtils.getJVMConfig((String)jvmConigPath);
        props.setProperty("java.args", newArgsBuf.toString());
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(jvmConigPath);
            props.store((OutputStream)fos);
            fos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDebuggerPortInJvmConfig(int portnum) throws Exception {
        if (!isStandalone) {
            return;
        }
        String pathSep = System.getProperty("file.separator");
        String cfRootDir = this.getCFRootDir();
        if (cfRootDir == null) {
            return;
        }
        String jvmConigPath = cfRootDir + pathSep + "bin" + pathSep + "jvm.config";
        ArrayList args = new ArrayList();
        JvmConfigUtils.getJavaArgsList((String)jvmConigPath, args, (boolean)false);
        StringBuffer newArgsBuf = new StringBuffer(200);
        Iterator it = args.iterator();
        while (it.hasNext()) {
            String arg = it.next().toString().trim();
            if (arg.startsWith("-Xdebug") || arg.startsWith("-Xrunjdwp")) continue;
            newArgsBuf.append(arg + " ");
        }
        String newArgs = "-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=" + portnum + " " + newArgsBuf.toString();
        OrderedProperties props = JvmConfigUtils.getJVMConfig((String)jvmConigPath);
        props.setProperty("java.args", newArgs);
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(jvmConigPath);
            props.store((OutputStream)fos);
            fos.close();
        }
    }

    public int getDebuggerPort() throws Exception {
        if (this.debuggerPort <= 0 || !this.portConflictResolved) {
            int tempDebuggerPort = this.getDebuggerPortHelper();
            if (tempDebuggerPort < 0 && this.debuggerPort <= 0) {
                this.debuggerPort = this.getDefaultDebuggerPort();
            } else if (tempDebuggerPort > 0) {
                this.debuggerPort = tempDebuggerPort;
            }
            this.portConflictResolved = true;
        }
        return this.debuggerPort;
    }

    public void setDebuggerPort(int port) throws Exception {
        if (this.maxDebuugerSession != this.maxSessionsAtLoad || isStandalone && this.getDebuggerPortAtLoadFromJvmConfig() != port) {
            this.setServerNeedRestart(true);
        } else {
            this.setServerNeedRestart(false);
        }
        this.setDebuggerPortInJvmConfig(port);
        this.debuggerPort = port;
    }

    private int getDebuggerPort(String rootDir) throws Exception {
        char c;
        String pathSep = System.getProperty("file.separator");
        String jvmConigPath = rootDir + pathSep + "bin" + pathSep + "jvm.config";
        String jvmArgs = JvmConfigUtils.getJavaArgs((String)jvmConigPath);
        int i1 = jvmArgs.indexOf("-Xrunjdwp");
        if (i1 == -1) {
            return -1;
        }
        if ((i1 = jvmArgs.indexOf("address=", i1)) == -1) {
            return -1;
        }
        StringBuffer portStr = new StringBuffer();
        for (int i = i1 + 8; i < jvmArgs.length() && !Character.isWhitespace(c = jvmArgs.charAt(i)); ++i) {
            portStr.append(c);
        }
        try {
            return Integer.parseInt(portStr.toString());
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private int getDebuggerPortAtLoadFromJvmConfig() {
        if (!isStandalone) {
            return -1;
        }
        if (this.debuggerPortReadFromJvmConfigAtLoad) {
            return this.debuggerPortInJvmConfigAtLoad;
        }
        try {
            if (this.getCFRootDir() != null) {
                this.debuggerPortInJvmConfigAtLoad = this.getDebuggerPortHelper();
                this.debuggerPortReadFromJvmConfigAtLoad = true;
                return this.debuggerPortInJvmConfigAtLoad;
            }
        }
        catch (Exception e) {
            return -1;
        }
        return -1;
    }

    private int getDebuggerPortHelper() throws Exception {
        int port = -1;
        String cfRootDir = null;
        cfRootDir = this.getCFRootDir();
        if (isStandalone && cfRootDir != null) {
            port = this.getDebuggerPort(cfRootDir);
        }
        return port;
    }

    public boolean isLineDebuggerEnabled() {
        return this.debuggerEnabled;
    }

    public void setLineDebuggerEnabled(boolean isEnabled) throws Exception {
        this.debuggerEnabled = isEnabled;
        DebuggerLaunchHelper dbgHelper = DebuggerLaunchHelper.getInstance();
        if (!this.debuggerEnabled) {
            if (dbgHelper.isDebugProcessRunning()) {
                dbgHelper.stopDebugger();
            }
            this.removeDebuggerSettingsInJvmConfig();
        }
    }

    public void setDebuggingSettings(ConfigMap lineDebuggingSettings) throws ServiceException {
        Object tmpObj = null;
        int portInJvmConfigAtLoad = -1;
        try {
            portInJvmConfigAtLoad = this.getDebuggerPortAtLoadFromJvmConfig();
        }
        catch (ServiceFactory.ServiceNotAvailableException sne) {
            this.debuggerPort = 0;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        this.portConflictResolved = false;
        if (lineDebuggingSettings != null) {
            try {
                tmpObj = lineDebuggingSettings.get((Object)KEY_DEBUGGER_PORT);
                if (tmpObj != null) {
                    this.debuggerPort = (int)Double.parseDouble(tmpObj.toString());
                    this.portConflictResolved = this.debuggerPort == portInJvmConfigAtLoad || !isStandalone;
                }
                if ((tmpObj = lineDebuggingSettings.get((Object)KEY_DEBUGGER_ENABLED)) != null) {
                    this.debuggerEnabled = Cast._boolean((String)tmpObj.toString());
                }
                if ((tmpObj = lineDebuggingSettings.get((Object)KEY_MAX_DEBUG_SESSIONS)) != null) {
                    this.maxSessionsAtLoad = this.maxDebuugerSession = (int)Double.parseDouble(tmpObj.toString());
                }
            }
            catch (Exception e) {
                throw new ServiceException((Throwable)e);
            }
        }
        if (this.debuggerPort <= 0) {
            this.debuggerPort = this.getDefaultDebuggerPort();
        }
    }

    public ConfigMap getDebuggingSettings() {
        ConfigMap lineDebuggingSettings = new ConfigMap();
        if (this.debuggerPort > 0) {
            lineDebuggingSettings.put((Object)KEY_DEBUGGER_PORT, (Object)new Integer(this.debuggerPort));
        }
        lineDebuggingSettings.put((Object)KEY_DEBUGGER_ENABLED, (Object)(this.debuggerEnabled ? Boolean.TRUE : Boolean.FALSE));
        lineDebuggingSettings.put((Object)KEY_MAX_DEBUG_SESSIONS, (Object)new Integer(this.maxDebuugerSession));
        return lineDebuggingSettings;
    }

    public int getMaxDebuggingSessions() {
        return this.maxDebuugerSession;
    }

    public void setMaxDebuggingSessions(int maxSessions) {
        if (this.maxSessionsAtLoad != maxSessions || isStandalone && this.getDebuggerPortAtLoadFromJvmConfig() != this.debuggerPort) {
            this.setServerNeedRestart(true);
        } else {
            this.setServerNeedRestart(false);
        }
        this.maxDebuugerSession = maxSessions;
    }

    public void stopLineDebugger() {
        DebuggerLaunchHelper.getInstance().stopDebugger();
    }

    public void startDebugger() throws Exception {
        DebuggerLaunchHelper helper = DebuggerLaunchHelper.getInstance();
        if (helper.isDebugProcessRunning()) {
            return;
        }
        helper.launchDebugger(this.getCFRootDir(), this.getCtxRoot(), this.getDebuggerPort(), 0, "localhost", this.getMaxDebuggingSessions());
    }

    public void restartDebugger() throws Exception {
        DebuggerLaunchHelper helper = DebuggerLaunchHelper.getInstance();
        if (helper.isDebugProcessRunning()) {
            helper.stopDebugger();
        }
        helper.launchDebugger(this.getCFRootDir(), this.getCtxRoot(), this.getDebuggerPort(), 0, "localhost", this.getMaxDebuggingSessions());
    }

    public boolean isLineDebuggerRunning() {
        DebuggerLaunchHelper helper = DebuggerLaunchHelper.getInstance();
        return helper.isDebugProcessRunning();
    }

    public boolean doesServerNeedRestart() {
        return this.serverNeedRestart;
    }

    public void setServerNeedRestart(boolean serverNeedRestart) {
        this.serverNeedRestart = serverNeedRestart;
    }

    public String getCtxRoot() {
        return this.ctxRoot;
    }

    public void setCtxRoot(String ctxRoot) {
        String fileSetp;
        if (ctxRoot.endsWith(".")) {
            int index = ctxRoot.lastIndexOf(46);
            ctxRoot = ctxRoot.substring(0, index);
        }
        if (ctxRoot.endsWith(fileSetp = System.getProperty("file.separator"))) {
            int index = ctxRoot.lastIndexOf(fileSetp);
            ctxRoot = ctxRoot.substring(0, index);
        }
        this.ctxRoot = ctxRoot;
    }

    public void setCtxRoot(ServletContext ctx) {
        try {
            this.setCtxRoot(ctx.getRealPath("/"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private synchronized boolean isPortFree(final int portNum) {
        if (System.getSecurityManager() == null) {
            return this.isPortFreeHelper(portNum);
        }
        try {
            return (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return LineDebuggerConfig.this.isPortFreeHelper(portNum) ? Boolean.TRUE : Boolean.FALSE;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            return true;
        }
    }

    private boolean isPortFreeHelper(int portNum) {
        try {
            ServerSocket soc = new ServerSocket();
            InetSocketAddress socAddress = new InetSocketAddress(portNum);
            soc.bind(socAddress);
            soc.close();
            return true;
        }
        catch (IOException ie) {
            return false;
        }
    }

    private int getDefaultDebuggerPort() {
        if (this.isPortFree(5005)) {
            return 5005;
        }
        try {
            return DebuggerLaunchHelper.getFreeSocketPort();
        }
        catch (Throwable t) {
            return 5005;
        }
    }

    public boolean showPortInUseWarning() throws Exception {
        if (this.getDebuggerPort() == this.getDebuggerPortAtLoadFromJvmConfig()) {
            return false;
        }
        return !this.isPortFree(this.getDebuggerPort());
    }
}

