/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.image;

import coldfusion.image.BesselFilter;
import coldfusion.image.BlackmanFilter;
import coldfusion.image.HammingFilter;
import coldfusion.image.HanningFilter;
import coldfusion.image.HermiteFilter;
import coldfusion.image.LanczosFilter;
import coldfusion.image.MitchellFilter;
import coldfusion.image.QuadraticFilter;
import coldfusion.image.SamplingFilter;
import coldfusion.image.TriangleFilter;
import coldfusion.image.core.ImageExceptions;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class ImageResizer {
    private static final int MaxRGB = 255;
    public static final int TRIANGLEFILTER = 0;
    public static final int HERMITEFILTER = 1;
    public static final int HANNINGFILTER = 2;
    public static final int HAMMINGFILTER = 3;
    public static final int BLACKMANFILTER = 4;
    public static final int QUADRATICFILTER = 5;
    public static final int MITCHELLFILTER = 6;
    public static final int LANCZOSFILTER = 7;
    public static final int BESSELFILTER = 8;

    private static int HorizontalFilter(BufferedImage source, BufferedImage destination, double xFactor, SamplingFilter filter, double blur, ContributionInfo[] contribution) {
        if (source.getWidth() == destination.getWidth() && source.getHeight() == destination.getHeight()) {
            destination.setData(source.getData());
            return destination.getWidth();
        }
        double scale = blur * Math.max(1.0 / xFactor, 1.0);
        double support = Math.max(scale * filter.getSupport(), 0.5);
        if (support <= 0.5) {
            support = 0.500000000001;
            scale = 1.0;
        }
        ColorModel cm = ColorModel.getRGBdefault();
        for (int x = 0; x < destination.getWidth(); ++x) {
            double center = (double)x / xFactor;
            int start = (int)Math.max(center - support + 0.5, 0.0);
            int end = (int)Math.min(center + support + 0.5, (double)source.getWidth());
            int n = ImageResizer.setContributionWeight(start, end, contribution, filter, center, scale);
            int sourceWidth = contribution[n - 1].getPixel() - contribution[0].getPixel() + 1;
            int[] sourcePixels = new int[sourceWidth * source.getHeight()];
            int[] destPixels = new int[destination.getHeight()];
            sourcePixels = source.getRGB(contribution[0].getPixel(), 0, sourceWidth, source.getHeight(), sourcePixels, 0, sourceWidth);
            int destIndex = 0;
            for (int y = 0; y < destination.getHeight(); ++y) {
                double blue = 0.0;
                double green = 0.0;
                double red = 0.0;
                double opacity = 0.0;
                int[] c = new int[4];
                for (int i = 0; i < n; ++i) {
                    int j = y * (contribution[n - 1].getPixel() - contribution[0].getPixel() + 1) + (contribution[i].getPixel() - contribution[0].getPixel());
                    c = cm.getComponents(sourcePixels[j], c, 0);
                    red += contribution[i].getWeight() * (double)c[0];
                    green += contribution[i].getWeight() * (double)c[1];
                    blue += contribution[i].getWeight() * (double)c[2];
                    opacity += contribution[i].getWeight() * (double)c[3];
                }
                double d = red < 0.0 ? 0.0 : (red = red > 255.0 ? 255.0 : red + 0.5);
                double d2 = green < 0.0 ? 0.0 : (green = green > 255.0 ? 255.0 : green + 0.5);
                double d3 = blue < 0.0 ? 0.0 : (blue = blue > 255.0 ? 255.0 : blue + 0.5);
                opacity = opacity < 0.0 ? 0.0 : (opacity > 255.0 ? 255.0 : opacity + 0.5);
                destPixels[destIndex] = cm.getDataElement(new int[]{(int)red, (int)green, (int)blue, (int)opacity}, 0);
                ++destIndex;
            }
            destination.setRGB(x, 0, 1, destination.getHeight(), destPixels, 0, 1);
        }
        return destination.getWidth();
    }

    private static int setContributionWeight(int start, int end, ContributionInfo[] contribution, SamplingFilter filter, double center, double scale) {
        int i;
        int n = 0;
        double density = 0.0;
        for (i = start; i < end; ++i) {
            contribution[n].setPixel(i);
            contribution[n].setWeight(filter.f(((double)i - center + 0.5) / scale) / scale);
            density += contribution[n].getWeight();
            ++n;
        }
        density = density == 0.0 ? 1.0 : 1.0 / density;
        for (i = 0; i < n; ++i) {
            contribution[i].setWeight(contribution[i].getWeight() * density);
        }
        return n;
    }

    private static int VerticalFilter(BufferedImage source, BufferedImage destination, double y_factor, SamplingFilter filter, double blur, ContributionInfo[] contribution) {
        if (source.getWidth() == destination.getWidth() && source.getHeight() == destination.getHeight()) {
            destination.setData(source.getData());
            return destination.getWidth();
        }
        double scale = blur * Math.max(1.0 / y_factor, 1.0);
        double support = Math.max(scale * filter.getSupport(), 0.5);
        if (support <= 0.5) {
            support = 0.500000000001;
            scale = 1.0;
        }
        ColorModel cm = ColorModel.getRGBdefault();
        for (int y = 0; y < destination.getHeight(); ++y) {
            double center = (double)y / y_factor;
            int start = (int)Math.max(center - support + 0.5, 0.0);
            int end = (int)Math.min(center + support + 0.5, (double)source.getHeight());
            int n = ImageResizer.setContributionWeight(start, end, contribution, filter, center, scale);
            int sourceHeight = contribution[n - 1].getPixel() - contribution[0].getPixel() + 1;
            int[] sourcePixels = new int[source.getWidth() * sourceHeight];
            int[] destPixels = new int[destination.getWidth()];
            sourcePixels = source.getRGB(0, contribution[0].getPixel(), source.getWidth(), sourceHeight, sourcePixels, 0, source.getWidth());
            int destIndex = 0;
            for (int x = 0; x < destination.getWidth(); ++x) {
                double blue = 0.0;
                double green = 0.0;
                double red = 0.0;
                double opacity = 0.0;
                int[] c = new int[4];
                for (int i = 0; i < n; ++i) {
                    int j = (contribution[i].getPixel() - contribution[0].getPixel()) * source.getWidth() + x;
                    c = cm.getComponents(sourcePixels[j], c, 0);
                    red += contribution[i].getWeight() * (double)c[0];
                    green += contribution[i].getWeight() * (double)c[1];
                    blue += contribution[i].getWeight() * (double)c[2];
                    opacity += contribution[i].getWeight() * (double)c[3];
                }
                double d = red < 0.0 ? 0.0 : (red = red > 255.0 ? 255.0 : red + 0.5);
                double d2 = green < 0.0 ? 0.0 : (green = green > 255.0 ? 255.0 : green + 0.5);
                double d3 = blue < 0.0 ? 0.0 : (blue = blue > 255.0 ? 255.0 : blue + 0.5);
                opacity = opacity < 0.0 ? 0.0 : (opacity > 255.0 ? 255.0 : opacity + 0.5);
                destPixels[destIndex] = cm.getDataElement(new int[]{(int)red, (int)green, (int)blue, (int)opacity}, 0);
                ++destIndex;
            }
            destination.setRGB(0, y, destination.getWidth(), 1, destPixels, 0, destination.getWidth());
        }
        return destination.getHeight();
    }

    public static BufferedImage scale(BufferedImage image, double scale, int filterType, double blur) {
        if (scale == 0.0) {
            throw new ImageExceptions.IllegalSizeException();
        }
        int columns = (int)Math.round((double)image.getWidth() * scale);
        int rows = (int)Math.round((double)image.getHeight() * scale);
        BufferedImage resizeImage = ImageResizer.createBufferedImage(image, columns, rows);
        if (scale == 1.0) {
            resizeImage.setData(image.getData());
            return resizeImage;
        }
        SamplingFilter filter = ImageResizer.getFilter(filterType);
        double scaleInverse = blur * Math.max(1.0 / scale, 1.0);
        double support = Math.max(scaleInverse * filter.getSupport(), 0.5);
        support = support < filter.getSupport() ? filter.getSupport() : support;
        ContributionInfo[] contribution = new ContributionInfo[(int)support * 2 + 3];
        for (int cloop = 0; cloop < (int)support * 2 + 3; ++cloop) {
            contribution[cloop] = new ContributionInfo();
        }
        BufferedImage sourceImage = ImageResizer.createBufferedImage(image, image.getWidth(), rows);
        int status = ImageResizer.VerticalFilter(image, sourceImage, scale, filter, blur, contribution);
        if ((status |= ImageResizer.HorizontalFilter(sourceImage, resizeImage, scale, filter, blur, contribution)) == 0) {
            throw new ImageExceptions.ImageResizeException();
        }
        return resizeImage;
    }

    public static BufferedImage resize(BufferedImage image, int columns, int rows, int filterType, double blur) {
        int status;
        double y_factor;
        double y_support;
        if (columns == 0 || rows == 0) {
            throw new ImageExceptions.IllegalSizeException();
        }
        BufferedImage resizeImage = ImageResizer.createBufferedImage(image, columns, rows);
        if (columns == image.getWidth() && rows == image.getHeight()) {
            resizeImage.setData(image.getData());
            return resizeImage;
        }
        SamplingFilter filter = ImageResizer.getFilter(filterType);
        double x_factor = (double)columns / (double)image.getWidth();
        double scale = blur * Math.max(1.0 / x_factor, 1.0);
        double x_support = Math.max(scale * filter.getSupport(), 0.5);
        double support = Math.max(x_support, y_support = Math.max((scale = blur * Math.max(1.0 / (y_factor = (double)rows / (double)image.getHeight()), 1.0)) * filter.getSupport(), 0.5));
        if (support < filter.getSupport()) {
            support = filter.getSupport();
        }
        ContributionInfo[] contribution = new ContributionInfo[(int)support * 2 + 3];
        for (int cloop = 0; cloop < (int)support * 2 + 3; ++cloop) {
            contribution[cloop] = new ContributionInfo();
        }
        if (columns * (image.getHeight() + rows) < rows * (image.getWidth() + columns)) {
            BufferedImage sourceImage = ImageResizer.createBufferedImage(image, columns, image.getHeight());
            status = ImageResizer.HorizontalFilter(image, sourceImage, x_factor, filter, blur, contribution);
            status |= ImageResizer.VerticalFilter(sourceImage, resizeImage, y_factor, filter, blur, contribution);
        } else {
            BufferedImage sourceImage = ImageResizer.createBufferedImage(image, image.getWidth(), rows);
            status = ImageResizer.VerticalFilter(image, sourceImage, y_factor, filter, blur, contribution);
            status |= ImageResizer.HorizontalFilter(sourceImage, resizeImage, x_factor, filter, blur, contribution);
        }
        if (status == 0) {
            throw new ImageExceptions.ImageResizeException();
        }
        return resizeImage;
    }

    private static BufferedImage createBufferedImage(BufferedImage image, int columns, int rows) {
        ColorModel colormodel = image.getColorModel();
        BufferedImage resize_image = colormodel instanceof IndexColorModel ? (colormodel.getTransparency() != 1 ? new BufferedImage(columns, rows, 2) : new BufferedImage(columns, rows, 1)) : new BufferedImage(colormodel, image.getRaster().createCompatibleWritableRaster(columns, rows), colormodel.isAlphaPremultiplied(), null);
        return resize_image;
    }

    private static SamplingFilter getFilter(int filter) {
        switch (filter) {
            case 0: {
                return new TriangleFilter();
            }
            case 1: {
                return new HermiteFilter();
            }
            case 2: {
                return new HanningFilter();
            }
            case 3: {
                return new HammingFilter();
            }
            case 4: {
                return new BlackmanFilter();
            }
            case 5: {
                return new QuadraticFilter();
            }
            case 6: {
                return new MitchellFilter();
            }
            case 7: {
                return new LanczosFilter();
            }
            case 8: {
                return new BesselFilter();
            }
        }
        throw new ImageExceptions.IllegalFilterException();
    }

    public static void main(String[] args) {
    }

    private static class ContributionInfo {
        int pixel;
        double weight;

        public ContributionInfo() {
        }

        public ContributionInfo(int pixel, double weight) {
            this.pixel = pixel;
            this.weight = weight;
        }

        public void setPixel(int pixel) {
            this.pixel = pixel;
        }

        public int getPixel() {
            return this.pixel;
        }

        public void setWeight(double weight) {
            this.weight = weight;
        }

        public double getWeight() {
            return this.weight;
        }
    }
}

