/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.aws.sns;

import coldfusion.cloud.aws.sns.SNSAPIException;
import coldfusion.cloud.aws.sns.SNSClient;
import coldfusion.cloud.aws.sns.SNSClientImpl;
import coldfusion.cloud.aws.sns.SNSSubscription;
import coldfusion.cloud.aws.sns.SNSTopic;
import coldfusion.log.Logger;
import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.GenerateCFInvoke;
import coldfusion.runtime.GenerateCFNamedInvoke;
import coldfusion.runtime.InvokeNamedMethodInvocationMap;
import coldfusion.runtime.NamedInvokable;
import coldfusion.runtime.NamedMethodInvoker;
import coldfusion.runtime.ObjectHandledInvokable;
import coldfusion.runtime.Struct;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;
import jakarta.servlet.jsp.PageContext;
import java.util.Map;

@GenerateCFInvoke
@GenerateCFNamedInvoke
public class SNSTopicImpl
implements SNSTopic,
ObjectHandledInvokable,
NamedInvokable {
    SNSClient snsClient;
    String topicArn;
    private Logger logger = ServiceFactory.getLoggingService().getLogger("coldfusion.sns");
    private static InvokeNamedMethodInvocationMap<SNSTopicImpl> __InvokeNamedMethodInvocationMap = new InvokeNamedMethodInvocationMap();

    public SNSTopicImpl(SNSClient snsClient, String topicArn) {
        this.topicArn = topicArn;
        this.snsClient = snsClient;
    }

    @Override
    public Struct publish(Map message) {
        message.put("topicArn", this.topicArn);
        return this.snsClient.publish(message);
    }

    @Override
    public String getTopicArn() {
        return this.topicArn;
    }

    @Override
    public Struct getAttributes() {
        return this.snsClient.getTopicAttributes(this.topicArn);
    }

    @Override
    public Struct setAttributes(Map attributes) {
        attributes.put("topicArn", this.topicArn);
        return this.snsClient.setTopicAttributes(attributes);
    }

    @Override
    public Struct tag(Map tags) {
        return this.snsClient.tagTopic(this.topicArn, tags);
    }

    @Override
    public Struct untag(Map tags) {
        return this.snsClient.untagTopic(this.topicArn, tags);
    }

    @Override
    public Struct listTags() {
        return this.snsClient.listTopicTags(this.topicArn);
    }

    @Override
    public SNSSubscription subscribe(Map subscription) {
        subscription.put("topicArn", this.topicArn);
        return this.snsClient.subscribe(subscription);
    }

    @Override
    public Struct listSubscriptions() {
        return this.snsClient.listTopicSubscriptions(this.topicArn);
    }

    @Override
    public Struct listSubscriptions(String nextToken) {
        return this.snsClient.listTopicSubscriptions(this.topicArn, nextToken);
    }

    @Override
    public Struct addPermission(Map permission) {
        return this.snsClient.addPermission(this.topicArn, permission);
    }

    @Override
    public Struct removePermission(String permissionLabel) {
        return this.snsClient.removePermission(this.topicArn, permissionLabel);
    }

    @Override
    public Struct confirmSubscription(Map subscription) {
        return this.snsClient.confirmSubscription(this.topicArn, subscription);
    }

    public Object invoke(String methodName, Object[] args, PageContext pageContext) throws Throwable {
        switch (methodName.toLowerCase()) {
            case "publish": {
                if (args != null && args.length == 1) {
                    return this.publish(Cast._Map((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSTopicImpl.class, (String)"PublishValidationError"));
            }
            case "gettopicarn": {
                if (args == null || args.length == 0) {
                    return this.getTopicArn();
                }
                throw new IllegalArgumentException(RB.getString(SNSTopicImpl.class, (String)"GetTopicArnValidationError"));
            }
            case "subscribe": {
                if (args != null && args.length == 1) {
                    return this.subscribe(Cast._Map((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSTopicImpl.class, (String)"SubscribeValidationError"));
            }
            case "addpermission": {
                if (args != null && args.length == 1) {
                    return this.addPermission(Cast._Map((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSTopicImpl.class, (String)"TopicAddPermissionValidationError"));
            }
            case "removepermission": {
                if (args != null && args.length == 1) {
                    return this.removePermission(Cast._String((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSTopicImpl.class, (String)"TopicRemovePermissionValidationError"));
            }
            case "confirmsubscription": {
                if (args != null && args.length == 1) {
                    return this.confirmSubscription(Cast._Map((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"TopicConfirmSubscriptionValidationError"));
            }
            case "getattributes": {
                if (args == null || args.length == 0) {
                    return this.getAttributes();
                }
                throw new IllegalArgumentException(RB.getString(SNSTopicImpl.class, (String)"GetTopicAttributesValidationError"));
            }
            case "setattributes": {
                if (args != null && args.length == 1) {
                    return this.setAttributes(Cast._Map((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSTopicImpl.class, (String)"SetTopicAttributesValidationError"));
            }
            case "tag": {
                if (args != null && args.length == 1) {
                    return this.tag(Cast._Map((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSTopicImpl.class, (String)"TagTopicValidationError_one"));
            }
            case "listtags": {
                if (args == null || args.length == 0) {
                    return this.listTags();
                }
                throw new IllegalArgumentException(RB.getString(SNSTopicImpl.class, (String)"ListTopicTagsValidationError_one"));
            }
            case "listsubscriptions": {
                if (args == null || args.length == 0) {
                    return this.listSubscriptions();
                }
                if (args.length == 1) {
                    return this.listSubscriptions(Cast._String((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSTopicImpl.class, (String)"ListTopicSubscriptionsValidationError_one"));
            }
        }
        Object val = super.invoke(methodName, args, pageContext);
        if (val != ObjectHandledInvokable.OBJECT_METHOD_NOT_FOUND) {
            return val;
        }
        throw new SNSAPIException(RB.getString(SNSTopicImpl.class, (String)"TopicMethodNotDefinedError", (Object)methodName));
    }

    public Object invoke(String methodName, Map args, PageContext pageContext) throws Throwable {
        NamedMethodInvoker NamedMethodInvoker2 = __InvokeNamedMethodInvocationMap.get((Object)methodName);
        if (NamedMethodInvoker2 == null) {
            throw new CfJspPage.UnsupportedBaseTypeException(methodName, (Object)this);
        }
        this.logger.info((Object)("sns service method " + methodName + " invoked and started excecution... "));
        long startTime = System.currentTimeMillis();
        Object invokeObject = NamedMethodInvoker2.invoke((Object)this, args);
        long endTime = System.currentTimeMillis();
        long timeElapsed = endTime - startTime;
        this.logger.info((Object)("sns service method " + methodName + " finished execution successfully. Turn around time : " + timeElapsed + " milli secs"));
        return invokeObject;
    }

    static {
        __InvokeNamedMethodInvocationMap.put((Object)"publish", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"message"}, args);
                    return obj.publish(Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("publish", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getTopicArn", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getTopicArn();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getTopicArn", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getAttributes", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getAttributes();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getAttributes", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"setAttributes", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"attributes"}, args);
                    return obj.setAttributes(Cast._Map((Object)argColl.get((Object)"attributes")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("setAttributes", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"tag", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"tags"}, args);
                    return obj.tag(Cast._Map((Object)argColl.get((Object)"tags")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("tag", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"untag", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"tags"}, args);
                    return obj.untag(Cast._Map((Object)argColl.get((Object)"tags")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("untag", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"listTags", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.listTags();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("listTags", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"subscribe", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"subscription"}, args);
                    return obj.subscribe(Cast._Map((Object)argColl.get((Object)"subscription")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("subscribe", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"listSubscriptions", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.listSubscriptions();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"nextToken"}, args);
                    return obj.listSubscriptions(Cast._String((Object)argColl.get((Object)"nextToken")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("listSubscriptions", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"addPermission", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"permission"}, args);
                    return obj.addPermission(Cast._Map((Object)argColl.get((Object)"permission")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("addPermission", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"removePermission", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"permissionLabel"}, args);
                    return obj.removePermission(Cast._String((Object)argColl.get((Object)"permissionLabel")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("removePermission", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"confirmSubscription", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"subscription"}, args);
                    return obj.confirmSubscription(Cast._Map((Object)argColl.get((Object)"subscription")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("confirmSubscription", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"invoke", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"methodName", "args", "pageContext"}, args);
                    return obj.invoke(Cast._String((Object)argColl.get((Object)"methodName")), (Object[])Cast._castForInvokeGen((Object)argColl.get((Object)"args"), Object[].class), (PageContext)Cast._castForInvokeGen((Object)argColl.get((Object)"pageContext"), PageContext.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("invoke", obj);
        });
    }
}

