/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.aws.sns;

import coldfusion.cloud.CloudServiceName;
import coldfusion.cloud.aws.AWSCredential;
import coldfusion.cloud.aws.sns.SNSAPIException;
import coldfusion.cloud.aws.sns.SNSAddPermissionMetadata;
import coldfusion.cloud.aws.sns.SNSClient;
import coldfusion.cloud.aws.sns.SNSConfirmSubscriptionMetadata;
import coldfusion.cloud.aws.sns.SNSCreatePlatformApplicationMetadata;
import coldfusion.cloud.aws.sns.SNSCreatePlatformEndpointMetadata;
import coldfusion.cloud.aws.sns.SNSCreateTopicMetadata;
import coldfusion.cloud.aws.sns.SNSGetSubscriptionAttributesMetadata;
import coldfusion.cloud.aws.sns.SNSGetTopicAttributesMetadata;
import coldfusion.cloud.aws.sns.SNSPublishMetadata;
import coldfusion.cloud.aws.sns.SNSServiceConfig;
import coldfusion.cloud.aws.sns.SNSSetSmsAttributesMetadata;
import coldfusion.cloud.aws.sns.SNSSetSubscriptionAttributesMetadata;
import coldfusion.cloud.aws.sns.SNSSetTopicAttributesMetadata;
import coldfusion.cloud.aws.sns.SNSSubscribeMetadata;
import coldfusion.cloud.aws.sns.SNSSubscription;
import coldfusion.cloud.aws.sns.SNSSubscriptionImpl;
import coldfusion.cloud.aws.sns.SNSTagTopicMetadata;
import coldfusion.cloud.aws.sns.SNSTopic;
import coldfusion.cloud.aws.sns.SNSTopicImpl;
import coldfusion.cloud.aws.sns.SNSUnsubscribeMetadata;
import coldfusion.cloud.aws.sns.SNSUntagTopicMetadata;
import coldfusion.cloud.aws.sns.SNSUtils;
import coldfusion.cloud.util.CloudDeserializationUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.monitor.util.CloudMonitoringUtil;
import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.GenerateCFInvoke;
import coldfusion.runtime.GenerateCFNamedInvoke;
import coldfusion.runtime.InvokeNamedMethodInvocationMap;
import coldfusion.runtime.NamedInvokable;
import coldfusion.runtime.NamedMethodInvoker;
import coldfusion.runtime.ObjectHandledInvokable;
import coldfusion.runtime.Struct;
import coldfusion.util.RB;
import jakarta.servlet.jsp.PageContext;
import java.util.Map;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.SnsClientBuilder;
import software.amazon.awssdk.services.sns.model.AddPermissionRequest;
import software.amazon.awssdk.services.sns.model.AddPermissionResponse;
import software.amazon.awssdk.services.sns.model.CheckIfPhoneNumberIsOptedOutRequest;
import software.amazon.awssdk.services.sns.model.CheckIfPhoneNumberIsOptedOutResponse;
import software.amazon.awssdk.services.sns.model.ConfirmSubscriptionRequest;
import software.amazon.awssdk.services.sns.model.ConfirmSubscriptionResponse;
import software.amazon.awssdk.services.sns.model.CreatePlatformApplicationRequest;
import software.amazon.awssdk.services.sns.model.CreatePlatformApplicationResponse;
import software.amazon.awssdk.services.sns.model.CreatePlatformEndpointRequest;
import software.amazon.awssdk.services.sns.model.CreatePlatformEndpointResponse;
import software.amazon.awssdk.services.sns.model.CreateTopicRequest;
import software.amazon.awssdk.services.sns.model.CreateTopicResponse;
import software.amazon.awssdk.services.sns.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.sns.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.sns.model.DeletePlatformApplicationRequest;
import software.amazon.awssdk.services.sns.model.DeletePlatformApplicationResponse;
import software.amazon.awssdk.services.sns.model.DeleteTopicRequest;
import software.amazon.awssdk.services.sns.model.DeleteTopicResponse;
import software.amazon.awssdk.services.sns.model.GetEndpointAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetEndpointAttributesResponse;
import software.amazon.awssdk.services.sns.model.GetSmsAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetSmsAttributesResponse;
import software.amazon.awssdk.services.sns.model.GetSubscriptionAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetSubscriptionAttributesResponse;
import software.amazon.awssdk.services.sns.model.GetTopicAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetTopicAttributesResponse;
import software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutRequest;
import software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutResponse;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicRequest;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicResponse;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsRequest;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsResponse;
import software.amazon.awssdk.services.sns.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.sns.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.sns.model.ListTopicsRequest;
import software.amazon.awssdk.services.sns.model.ListTopicsResponse;
import software.amazon.awssdk.services.sns.model.OptInPhoneNumberRequest;
import software.amazon.awssdk.services.sns.model.OptInPhoneNumberResponse;
import software.amazon.awssdk.services.sns.model.PublishRequest;
import software.amazon.awssdk.services.sns.model.PublishResponse;
import software.amazon.awssdk.services.sns.model.RemovePermissionRequest;
import software.amazon.awssdk.services.sns.model.RemovePermissionResponse;
import software.amazon.awssdk.services.sns.model.SetSmsAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetSmsAttributesResponse;
import software.amazon.awssdk.services.sns.model.SetSubscriptionAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetSubscriptionAttributesResponse;
import software.amazon.awssdk.services.sns.model.SetTopicAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetTopicAttributesResponse;
import software.amazon.awssdk.services.sns.model.SubscribeRequest;
import software.amazon.awssdk.services.sns.model.SubscribeResponse;
import software.amazon.awssdk.services.sns.model.TagResourceRequest;
import software.amazon.awssdk.services.sns.model.TagResourceResponse;
import software.amazon.awssdk.services.sns.model.UnsubscribeRequest;
import software.amazon.awssdk.services.sns.model.UnsubscribeResponse;
import software.amazon.awssdk.services.sns.model.UntagResourceRequest;
import software.amazon.awssdk.services.sns.model.UntagResourceResponse;
import software.amazon.awssdk.utils.StringUtils;

@GenerateCFInvoke
@GenerateCFNamedInvoke
public class SNSClientImpl
implements SNSClient,
ObjectHandledInvokable,
NamedInvokable {
    private Logger logger = CFLogs.SERVER_LOG;
    SnsClient snsClient;
    SnsClientBuilder snsClientBuilder = SnsClient.builder();
    private TagAttributeList tagAttributeList = new TagAttributeList("service", (Object)CloudServiceName.SNS.name());
    private static InvokeNamedMethodInvocationMap<SNSClientImpl> __InvokeNamedMethodInvocationMap = new InvokeNamedMethodInvocationMap();

    public SNSClientImpl(AWSCredential credential, SNSServiceConfig config) {
        this.logger.debug((Object)"creating sns client");
        if (StringUtils.isNotBlank((CharSequence)credential.getAccessKeyId())) {
            this.snsClientBuilder.credentialsProvider(SNSUtils.getAWSCredential(credential));
        }
        if (StringUtils.isNotBlank((CharSequence)credential.getRegion())) {
            this.snsClientBuilder.region(Region.of((String)credential.getRegion()));
        }
        SNSUtils.configureSNSClientBuilder(this.snsClientBuilder, config);
        this.snsClient = (SnsClient)this.snsClientBuilder.build();
    }

    public SNSClientImpl(SnsClient snsClient) {
        this.snsClient = snsClient;
    }

    @Override
    public SNSTopic createTopic(String topicName, Map topicCreateOptions) {
        SNSTopicImpl res;
        RequestMonitorEventProcessor.onFunctionStart((String)"createTopic", (boolean)true);
        String statusCode = "Success";
        try {
            CreateTopicRequest.Builder createTopicRequestBuilder = CreateTopicRequest.builder().name(topicName);
            ValidatorFiller.INSTANCE.fillObject((Object)createTopicRequestBuilder, topicCreateOptions, SNSCreateTopicMetadata.getInstance().getConsumerMap());
            CreateTopicResponse createTopicResponse = this.snsClient.createTopic((CreateTopicRequest)createTopicRequestBuilder.build());
            this.logger.debug((Object)"SNS : createTopic operation successful.");
            res = new SNSTopicImpl(this, createTopicResponse.topicArn());
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"CreateTopicError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"createTopic", null, (Object)statusCode, (String)topicName, (boolean)true, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    @Override
    public SNSTopic createTopic(String topicName) {
        SNSTopicImpl res;
        RequestMonitorEventProcessor.onFunctionStart((String)"createTopic", (boolean)true);
        String statusCode = "Success";
        try {
            CreateTopicRequest.Builder createTopicRequestBuilder = CreateTopicRequest.builder().name(topicName);
            CreateTopicResponse createTopicResponse = this.snsClient.createTopic((CreateTopicRequest)createTopicRequestBuilder.build());
            this.logger.debug((Object)"SNS : createTopic operation successful.");
            res = new SNSTopicImpl(this, createTopicResponse.topicArn());
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"CreateTopicError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"createTopic", null, (Object)statusCode, (String)topicName, (boolean)true, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    @Override
    public Struct addPermission(String topicArn, Map permission) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"addPermission", (boolean)true);
        String statusCode = "Success";
        AddPermissionRequest.Builder addPermissionRequestBuilder = AddPermissionRequest.builder().topicArn(topicArn);
        try {
            ValidatorFiller.INSTANCE.fillObject((Object)addPermissionRequestBuilder, (Map)((Struct)permission), SNSAddPermissionMetadata.getInstance().getConsumerMap());
            AddPermissionResponse addPermissionResponse = this.snsClient.addPermission((AddPermissionRequest)addPermissionRequestBuilder.build());
            this.logger.debug((Object)("SNS : topic " + topicArn + " added permission."));
            res = this.prepareAddPermissionReponse(addPermissionResponse);
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"AddPermissionError", (Object)topicArn), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"addPermission", null, (Object)statusCode, (String)topicArn, (boolean)true, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareAddPermissionReponse(AddPermissionResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Struct removePermission(String topicArn, String permissionLabel) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"removePermission", (boolean)true);
        String statusCode = "Success";
        try {
            RemovePermissionRequest removePermissionRequest = (RemovePermissionRequest)RemovePermissionRequest.builder().topicArn(topicArn).label(permissionLabel).build();
            RemovePermissionResponse removePermissionResponse = this.snsClient.removePermission(removePermissionRequest);
            this.logger.debug((Object)("SNS : topic " + topicArn + " removed permission " + permissionLabel + "."));
            res = this.prepareRemovePermissionReponse(removePermissionResponse);
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"RemovePermissionError", (Object)topicArn), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"removePermission", null, (Object)statusCode, (String)topicArn, (boolean)true, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareRemovePermissionReponse(RemovePermissionResponse removePermissionResponse) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)removePermissionResponse);
    }

    @Override
    public SNSSubscription subscribe(Map subscription) {
        RequestMonitorEventProcessor.onFunctionStart((String)"subscribe", (boolean)true);
        SNSSubscription snsSubscription = null;
        String statusCode = "Success";
        String topicArn = (String)subscription.get("topicArn");
        try {
            SubscribeRequest.Builder subscribeRequestBuilder = SubscribeRequest.builder();
            ValidatorFiller.INSTANCE.fillObject((Object)subscribeRequestBuilder, subscription, SNSSubscribeMetadata.getInstance().getConsumerMap());
            SubscribeResponse subscribeResponse = this.snsClient.subscribe((SubscribeRequest)subscribeRequestBuilder.build());
            this.logger.debug((Object)"SNS : subscribe operation successful.");
            snsSubscription = new SNSSubscriptionImpl(this, subscribeResponse.subscriptionArn());
            CloudMonitoringUtil.onCloudFunctionEnd((String)"subscribe", null, (Object)statusCode, (String)topicArn, (boolean)true, (String)(snsSubscription != null ? snsSubscription.getSubscriptionArn() : null), (TagAttributeList)this.tagAttributeList);
        }
        catch (SdkException ex) {
            try {
                statusCode = "Failure";
                throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"CreateSubscriptionError"), ex);
            }
            catch (Throwable throwable) {
                CloudMonitoringUtil.onCloudFunctionEnd((String)"subscribe", null, (Object)statusCode, (String)topicArn, (boolean)true, (String)(snsSubscription != null ? snsSubscription.getSubscriptionArn() : null), (TagAttributeList)this.tagAttributeList);
                throw throwable;
            }
        }
        return snsSubscription;
    }

    @Override
    public Struct confirmSubscription(String topicArn, Map subscription) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"confirmSubscription", (boolean)true);
        String statusCode = "Success";
        ConfirmSubscriptionRequest.Builder builder = ConfirmSubscriptionRequest.builder().topicArn(topicArn);
        try {
            ValidatorFiller.INSTANCE.fillObject((Object)builder, subscription, SNSConfirmSubscriptionMetadata.getInstance().getConsumerMap());
            ConfirmSubscriptionResponse response = this.snsClient.confirmSubscription((ConfirmSubscriptionRequest)builder.build());
            Struct structResponse = this.prepareConfirmSubscriptionResponse(response);
            this.logger.debug((Object)"SNS : confirmSubscription operation successful.");
            res = structResponse;
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"ConfirmSubscriptionError", (Object)topicArn), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"confirmSubscription", null, (Object)statusCode, (String)topicArn, (boolean)true, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareConfirmSubscriptionResponse(ConfirmSubscriptionResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Struct listTopics() {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"listTopics", (boolean)true);
        String statusCode = "Success";
        try {
            ListTopicsResponse listTopicsResponse = this.snsClient.listTopics();
            Struct structResponse = this.prepareListTopicsResponse(listTopicsResponse);
            this.logger.debug((Object)"SNS : listTopics operation successful.");
            res = structResponse;
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"ListTopicsError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"listTopics", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    @Override
    public Struct listTopics(String nextToken) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"listTopics", (boolean)true);
        String statusCode = "Success";
        try {
            ListTopicsResponse listTopicsResponse = this.snsClient.listTopics((ListTopicsRequest)ListTopicsRequest.builder().nextToken(nextToken).build());
            Struct structResponse = this.prepareListTopicsResponse(listTopicsResponse);
            this.logger.debug((Object)"SNS : listTopics operation successful.");
            res = structResponse;
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"ListTopicsError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"listTopics", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareListTopicsResponse(ListTopicsResponse listTopicsResponse) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)listTopicsResponse);
    }

    @Override
    public Struct listTopicSubscriptions(String topicArn) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"listTopicSubscriptions", (boolean)true);
        String statusCode = "Success";
        try {
            ListSubscriptionsByTopicResponse listSubscriptionsResponse = this.snsClient.listSubscriptionsByTopic((ListSubscriptionsByTopicRequest)ListSubscriptionsByTopicRequest.builder().topicArn(topicArn).build());
            res = this.prepareListSubscriptionsByTopicResponse(listSubscriptionsResponse);
            this.logger.debug((Object)"SNS : listTopicSubscriptions operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"ListTopicSubscriptionsError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"listTopicSubscriptions", null, (Object)statusCode, (String)topicArn, (boolean)true, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    @Override
    public Struct listTopicSubscriptions(String topicArn, String nextToken) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"listTopicSubscriptions", (boolean)true);
        String statusCode = "Success";
        try {
            ListSubscriptionsByTopicResponse listSubscriptionsResponse = this.snsClient.listSubscriptionsByTopic((ListSubscriptionsByTopicRequest)ListSubscriptionsByTopicRequest.builder().topicArn(topicArn).nextToken(nextToken).build());
            res = this.prepareListSubscriptionsByTopicResponse(listSubscriptionsResponse);
            this.logger.debug((Object)"SNS : listTopicSubscriptions operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"ListTopicSubscriptionsError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"listTopicSubscriptions", null, (Object)statusCode, (String)topicArn, (boolean)true, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareListSubscriptionsByTopicResponse(ListSubscriptionsByTopicResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Struct listSubscriptions() {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"listSubscriptions", (boolean)true);
        String statusCode = "Success";
        try {
            ListSubscriptionsResponse listSubscriptionsResponse = this.snsClient.listSubscriptions();
            res = this.prepareListSubscriptionsResponse(listSubscriptionsResponse);
            this.logger.debug((Object)"SNS : listSubscriptions operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"ListSubscriptionsError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"listSubscriptions", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    @Override
    public Struct listSubscriptions(String nextToken) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"listSubscriptions", (boolean)true);
        String statusCode = "Success";
        try {
            ListSubscriptionsResponse listSubscriptionsResponse = this.snsClient.listSubscriptions((ListSubscriptionsRequest)ListSubscriptionsRequest.builder().nextToken(nextToken).build());
            res = this.prepareListSubscriptionsResponse(listSubscriptionsResponse);
            this.logger.debug((Object)"SNS : listSubscriptions operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"ListSubscriptionsError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"listSubscriptions", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareListSubscriptionsResponse(ListSubscriptionsResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Struct publish(Map message) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"publish", (boolean)true);
        String statusCode = "Success";
        String topicArn = "";
        try {
            PublishRequest.Builder publishRequestBuilder = PublishRequest.builder();
            ValidatorFiller.INSTANCE.fillObject((Object)publishRequestBuilder, message, SNSPublishMetadata.getInstance().getConsumerMap());
            PublishRequest publishRequest = (PublishRequest)publishRequestBuilder.build();
            topicArn = publishRequest.topicArn();
            PublishResponse publishResponse = this.snsClient.publish(publishRequest);
            res = this.preparePublishResponse(publishResponse);
            this.logger.debug((Object)"SNS : publish operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"PublishMessageError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"publish", null, (Object)statusCode, (String)topicArn, (boolean)true, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct preparePublishResponse(PublishResponse publishResponse) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)publishResponse);
    }

    @Override
    public Struct getSubscriptionAttributes(Object subscription) {
        if (subscription instanceof String) {
            return this.getSubscriptionAttributesByName(Cast._String((Object)subscription));
        }
        if (subscription instanceof Map) {
            return this.getSubscriptionAttributesByMetadata(Cast._Map((Object)subscription));
        }
        throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"GetSubscriptionAttributesValidationError"));
    }

    private Struct getSubscriptionAttributesByMetadata(Map metadata) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"getSubscriptionAttributes", (boolean)true);
        String statusCode = "Success";
        String subscriptionArn = "";
        try {
            GetSubscriptionAttributesRequest.Builder getSubscriptionAttributesBuilder = GetSubscriptionAttributesRequest.builder();
            ValidatorFiller.INSTANCE.fillObject((Object)getSubscriptionAttributesBuilder, metadata, SNSGetSubscriptionAttributesMetadata.getInstance().getConsumerMap());
            GetSubscriptionAttributesRequest getSubscriptionAttributesRequest = (GetSubscriptionAttributesRequest)getSubscriptionAttributesBuilder.build();
            GetSubscriptionAttributesResponse getSubscriptionAttributesResponse = this.snsClient.getSubscriptionAttributes(getSubscriptionAttributesRequest);
            subscriptionArn = getSubscriptionAttributesRequest.subscriptionArn();
            res = this.prepareGetSubscriptionAttributesResponse(getSubscriptionAttributesResponse);
            this.logger.debug((Object)"SNS : getSubscriptionAttributes operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"GetSubscriptionAttributesError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"getSubscriptionAttributes", null, (Object)statusCode, (String)subscriptionArn, (boolean)false, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct getSubscriptionAttributesByName(String subscriptionArn) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"getSubscriptionAttributes", (boolean)true);
        String statusCode = "Success";
        try {
            GetSubscriptionAttributesRequest.Builder getSubscriptionAttributesBuilder = GetSubscriptionAttributesRequest.builder().subscriptionArn(subscriptionArn);
            GetSubscriptionAttributesRequest getSubscriptionAttributesRequest = (GetSubscriptionAttributesRequest)getSubscriptionAttributesBuilder.build();
            GetSubscriptionAttributesResponse getSubscriptionAttributesResponse = this.snsClient.getSubscriptionAttributes(getSubscriptionAttributesRequest);
            subscriptionArn = getSubscriptionAttributesRequest.subscriptionArn();
            res = this.prepareGetSubscriptionAttributesResponse(getSubscriptionAttributesResponse);
            this.logger.debug((Object)"SNS : getSubscriptionAttributes operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"GetSubscriptionAttributesError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"getSubscriptionAttributes", null, (Object)statusCode, (String)subscriptionArn, (boolean)false, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareGetSubscriptionAttributesResponse(GetSubscriptionAttributesResponse getSubscriptionAttributesResponse) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)getSubscriptionAttributesResponse);
    }

    @Override
    public Struct setSubscriptionAttributes(Map subscriptionAttributes) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"setSubscriptionAttributes", (boolean)true);
        String statusCode = "Success";
        String subscriptionArn = "";
        try {
            SetSubscriptionAttributesRequest.Builder setSubscriptionAttributesBuilder = SetSubscriptionAttributesRequest.builder();
            ValidatorFiller.INSTANCE.fillObject((Object)setSubscriptionAttributesBuilder, subscriptionAttributes, SNSSetSubscriptionAttributesMetadata.getInstance().getConsumerMap());
            SetSubscriptionAttributesRequest setSubscriptionAttributesRequest = (SetSubscriptionAttributesRequest)setSubscriptionAttributesBuilder.build();
            SetSubscriptionAttributesResponse setSubscriptionAttributesResponse = this.snsClient.setSubscriptionAttributes(setSubscriptionAttributesRequest);
            subscriptionArn = ((SetSubscriptionAttributesRequest)setSubscriptionAttributesBuilder.build()).subscriptionArn();
            res = this.prepareSetSubscriptionAttributesResponse(setSubscriptionAttributesResponse);
            this.logger.debug((Object)"SNS : setSubscriptionAttributes operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"SetSubscriptionAttributesError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"setSubscriptionAttributes", null, (Object)statusCode, (String)subscriptionArn, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareSetSubscriptionAttributesResponse(SetSubscriptionAttributesResponse setSubscriptionAttributesResponse) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)setSubscriptionAttributesResponse);
    }

    @Override
    public Struct getTopicAttributes(String topicARN) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"getTopicAttributes", (boolean)true);
        String statusCode = "Success";
        String topicArn = "";
        Struct metadata = new Struct();
        try {
            metadata.put("topicArn", topicARN);
            GetTopicAttributesRequest.Builder getTopicAttributesBuilder = GetTopicAttributesRequest.builder();
            ValidatorFiller.INSTANCE.fillObject((Object)getTopicAttributesBuilder, (Map)metadata, SNSGetTopicAttributesMetadata.getInstance().getConsumerMap());
            GetTopicAttributesRequest getTopicAttributesRequest = (GetTopicAttributesRequest)getTopicAttributesBuilder.build();
            GetTopicAttributesResponse getTopicAttributesResponse = this.snsClient.getTopicAttributes(getTopicAttributesRequest);
            topicArn = getTopicAttributesRequest.topicArn();
            res = this.prepareGetTopicAttributesResponse(getTopicAttributesResponse);
            this.logger.debug((Object)"SNS : getTopicAttributes operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"GetTopicAttributesError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"getTopicAttributes", null, (Object)statusCode, (String)topicArn, (boolean)true, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareGetTopicAttributesResponse(GetTopicAttributesResponse getTopicAttributesResponse) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)getTopicAttributesResponse);
    }

    @Override
    public Struct setTopicAttributes(Map topicAttributes) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"setTopicAttributes", (boolean)true);
        String statusCode = "Success";
        String topicArn = "";
        try {
            SetTopicAttributesRequest.Builder setTopicAttributesBuilder = SetTopicAttributesRequest.builder();
            ValidatorFiller.INSTANCE.fillObject((Object)setTopicAttributesBuilder, topicAttributes, SNSSetTopicAttributesMetadata.getInstance().getConsumerMap());
            SetTopicAttributesRequest setTopicAttributesRequest = (SetTopicAttributesRequest)setTopicAttributesBuilder.build();
            SetTopicAttributesResponse setTopicAttributesResponse = this.snsClient.setTopicAttributes(setTopicAttributesRequest);
            topicArn = setTopicAttributesRequest.topicArn();
            res = this.prepareSetTopicAttributesResponse(setTopicAttributesResponse);
            this.logger.debug((Object)"SNS : setTopicAttributes operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"SetTopicAttributesError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"setTopicAttributes", null, (Object)statusCode, (String)topicArn, (boolean)true, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    @Override
    public Struct setSMSAttributes(Map smsAttributes) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"setSMSAttributes", (boolean)true);
        String statusCode = "Success";
        try {
            SetSmsAttributesRequest.Builder setSmsAttributesBuilder = SetSmsAttributesRequest.builder();
            ValidatorFiller.INSTANCE.fillObject((Object)setSmsAttributesBuilder, smsAttributes, SNSSetSmsAttributesMetadata.getInstance().getConsumerMap());
            SetSmsAttributesRequest setSmsAttributesRequest = (SetSmsAttributesRequest)setSmsAttributesBuilder.build();
            SetSmsAttributesResponse setSmsAttributesResponse = this.snsClient.setSMSAttributes(setSmsAttributesRequest);
            res = this.prepareSetSmsAttributesResponse(setSmsAttributesResponse);
            this.logger.debug((Object)"SNS : setSMSAttributes operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"SetSMSAttributesError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"setSMSAttributes", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareSetSmsAttributesResponse(SetSmsAttributesResponse setSmsAttributesResponse) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)setSmsAttributesResponse);
    }

    private Struct prepareSetTopicAttributesResponse(SetTopicAttributesResponse setTopicAttributesResponse) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)setTopicAttributesResponse);
    }

    @Override
    public Struct getSMSAttributes() {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"getSMSAttributes", (boolean)true);
        String statusCode = "Success";
        try {
            GetSmsAttributesRequest.Builder getSmsAttributesBuilder = GetSmsAttributesRequest.builder();
            GetSmsAttributesResponse getSmsAttributesResponse = this.snsClient.getSMSAttributes((GetSmsAttributesRequest)getSmsAttributesBuilder.build());
            res = this.prepareGetSmsAttributesResponse(getSmsAttributesResponse);
            this.logger.debug((Object)"SNS : getSMSAttributes operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"GetSMSAttributesError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"getSMSAttributes", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareGetSmsAttributesResponse(GetSmsAttributesResponse getSmsAttributesResponse) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)getSmsAttributesResponse);
    }

    @Override
    public Struct unsubscribe(Object subscription) {
        if (subscription instanceof String) {
            return this.unsubscribeByName(Cast._String((Object)subscription));
        }
        if (subscription instanceof Map) {
            return this.unsubscribeByMetadata(Cast._Map((Object)subscription));
        }
        throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"UnsubscribeValidationError"));
    }

    private Struct unsubscribeByMetadata(Map metadata) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"unsubscribe", (boolean)true);
        String statusCode = "Success";
        try {
            UnsubscribeRequest.Builder unsubscribeRequestBuilder = UnsubscribeRequest.builder();
            ValidatorFiller.INSTANCE.fillObject((Object)unsubscribeRequestBuilder, metadata, SNSUnsubscribeMetadata.getInstance().getConsumerMap());
            UnsubscribeResponse unsubscribeResponse = this.snsClient.unsubscribe((UnsubscribeRequest)unsubscribeRequestBuilder.build());
            res = this.prepareUnsubscribeResponse(unsubscribeResponse);
            this.logger.debug((Object)"SNS : unsubscribe operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"UnsubscribeError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"unsubscribe", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct unsubscribeByName(String subscriptionArn) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"unsubscribe", (boolean)true);
        String statusCode = "Success";
        try {
            UnsubscribeRequest.Builder unsubscribeRequestBuilder = UnsubscribeRequest.builder().subscriptionArn(subscriptionArn);
            UnsubscribeResponse unsubscribeResponse = this.snsClient.unsubscribe((UnsubscribeRequest)unsubscribeRequestBuilder.build());
            res = this.prepareUnsubscribeResponse(unsubscribeResponse);
            this.logger.debug((Object)"SNS : unsubscribe operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"UnsubscribeError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"unsubscribe", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareUnsubscribeResponse(UnsubscribeResponse unsubscribeResponse) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)unsubscribeResponse);
    }

    @Override
    public Struct tagTopic(String topicArn, Map tags) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"tagTopic", (boolean)true);
        String statusCode = "Success";
        try {
            TagResourceRequest.Builder tagRequestBuilder = TagResourceRequest.builder().resourceArn(topicArn);
            ValidatorFiller.INSTANCE.fillObject((Object)tagRequestBuilder, tags, SNSTagTopicMetadata.getInstance().getConsumerMap());
            TagResourceResponse tagTopicResponse = this.snsClient.tagResource((TagResourceRequest)tagRequestBuilder.build());
            res = this.prepareTagTopicResponse(tagTopicResponse);
            this.logger.debug((Object)"SNS : tagTopic operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"TagTopicError", (Object)topicArn), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"tagTopic", null, (Object)statusCode, (String)topicArn, (boolean)true, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareTagTopicResponse(TagResourceResponse tagTopicResponse) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)tagTopicResponse);
    }

    @Override
    public Struct untagTopic(String topicArn, Map tags) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"untagTopic", (boolean)true);
        String statusCode = "Success";
        try {
            UntagResourceRequest.Builder untagRequestBuilder = UntagResourceRequest.builder().resourceArn(topicArn);
            ValidatorFiller.INSTANCE.fillObject((Object)untagRequestBuilder, tags, SNSUntagTopicMetadata.getInstance().getConsumerMap());
            UntagResourceResponse untagTopicResponse = this.snsClient.untagResource((UntagResourceRequest)untagRequestBuilder.build());
            res = this.prepareUntagTopicResponse(untagTopicResponse);
            this.logger.debug((Object)"SNS : untagTopic operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"UntagTopicError", (Object)topicArn), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"untagTopic", null, (Object)statusCode, (String)topicArn, (boolean)true, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareUntagTopicResponse(UntagResourceResponse untagTopicResponse) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)untagTopicResponse);
    }

    @Override
    public Struct listTopicTags(String topicArn) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"listTopicTags", (boolean)true);
        String statusCode = "Success";
        try {
            ListTagsForResourceRequest.Builder listTagsRequestBuilder = ListTagsForResourceRequest.builder().resourceArn(topicArn);
            ListTagsForResourceResponse listTopicTagsResponse = this.snsClient.listTagsForResource((ListTagsForResourceRequest)listTagsRequestBuilder.build());
            res = this.prepareListTopicTagsResponse(listTopicTagsResponse);
            this.logger.debug((Object)"SNS : listTopicTags operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"ListTopicTagsError", (Object)topicArn), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"listTopicTags", null, (Object)statusCode, (String)topicArn, (boolean)true, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareListTopicTagsResponse(ListTagsForResourceResponse listTopicTagsResponse) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)listTopicTagsResponse);
    }

    @Override
    public Struct deleteTopic(String topicArn) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"deleteTopic", (boolean)true);
        String statusCode = "Success";
        try {
            DeleteTopicRequest.Builder deleteTopicRequestBuilder = DeleteTopicRequest.builder().topicArn(topicArn);
            DeleteTopicRequest deleteTopicRequest = (DeleteTopicRequest)deleteTopicRequestBuilder.build();
            DeleteTopicResponse deleteTopicResponse = this.snsClient.deleteTopic(deleteTopicRequest);
            res = this.prepareDeleteTopicResponse(deleteTopicResponse);
            this.logger.debug((Object)"SNS : deleteTopic operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"DeleteTopicError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"deleteTopic", null, (Object)statusCode, (String)topicArn, (boolean)true, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareDeleteTopicResponse(DeleteTopicResponse deleteTopicResponse) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)deleteTopicResponse);
    }

    @Override
    public Struct createPlatformEndpoint(Map platformEndpoint) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"createPlatformEndpoint", (boolean)true);
        String statusCode = "Success";
        try {
            CreatePlatformEndpointRequest.Builder builder = CreatePlatformEndpointRequest.builder();
            ValidatorFiller.INSTANCE.fillObject((Object)builder, platformEndpoint, SNSCreatePlatformEndpointMetadata.getInstance().getConsumerMap());
            CreatePlatformEndpointResponse response = this.snsClient.createPlatformEndpoint((CreatePlatformEndpointRequest)builder.build());
            res = this.prepareCreatePlatformEndpointResponse(response);
            this.logger.debug((Object)"SNS : createPlatformEndpoint operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"CreatePlatformEndpointError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"createPlatformEndpoint", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareCreatePlatformEndpointResponse(CreatePlatformEndpointResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Struct deleteEndpoint(String endpointArn) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"deleteEndpoint", (boolean)true);
        String statusCode = "Success";
        try {
            DeleteEndpointResponse response = this.snsClient.deleteEndpoint((DeleteEndpointRequest)DeleteEndpointRequest.builder().endpointArn(endpointArn).build());
            res = this.prepareDeleteEndpointResponse(response);
            this.logger.debug((Object)"SNS : deleteEndpoint operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"DeleteEndpointError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"deleteEndpoint", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareDeleteEndpointResponse(DeleteEndpointResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Struct getEndpointAttributes(String endpointArn) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"getEndpointAttributes", (boolean)true);
        String statusCode = "Success";
        try {
            GetEndpointAttributesResponse response = this.snsClient.getEndpointAttributes((GetEndpointAttributesRequest)GetEndpointAttributesRequest.builder().endpointArn(endpointArn).build());
            res = this.prepareGetEndpointAttributesResponse(response);
            this.logger.debug((Object)"SNS : deleteEndpoint operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"GetEndpointAttributesError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"getEndpointAttributes", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareGetEndpointAttributesResponse(GetEndpointAttributesResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Struct createPlatformApplication(Map platformApplication) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"createPlatformApplication", (boolean)true);
        String statusCode = "Success";
        try {
            CreatePlatformApplicationRequest.Builder builder = CreatePlatformApplicationRequest.builder();
            ValidatorFiller.INSTANCE.fillObject((Object)builder, platformApplication, SNSCreatePlatformApplicationMetadata.getInstance().getConsumerMap());
            CreatePlatformApplicationResponse response = this.snsClient.createPlatformApplication((CreatePlatformApplicationRequest)builder.build());
            res = this.prepareCreatePlatformApplicationResponse(response);
            this.logger.debug((Object)"SNS : createPlatformApplication operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"CreatePlatformApplicationError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"createPlatformApplication", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareCreatePlatformApplicationResponse(CreatePlatformApplicationResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Struct deletePlatformApplication(String platformApplicationArn) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"deletePlatformApplication", (boolean)true);
        String statusCode = "Success";
        try {
            DeletePlatformApplicationResponse response = this.snsClient.deletePlatformApplication((DeletePlatformApplicationRequest)DeletePlatformApplicationRequest.builder().platformApplicationArn(platformApplicationArn).build());
            res = this.prepareDeletePlatformApplicationResponse(response);
            this.logger.debug((Object)"SNS : deletePlatformApplication operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"DeletePlatformApplicationError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"DeletePlatformApplication", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareDeletePlatformApplicationResponse(DeletePlatformApplicationResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Map listTagsForResource(String resourceArn) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"listTagsForResource", (boolean)true);
        String statusCode = "Success";
        try {
            ListTagsForResourceResponse response = this.snsClient.listTagsForResource((ListTagsForResourceRequest)ListTagsForResourceRequest.builder().resourceArn(resourceArn).build());
            res = this.prepareListTagsForResourceResponse(response);
            this.logger.debug((Object)"SNS : listTagsForResource operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"ListTagsForResourceError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"listTagsForResource", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareListTagsForResourceResponse(ListTagsForResourceResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Map optInPhoneNumber(String phoneNumber) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"optInPhoneNumber", (boolean)true);
        String statusCode = "Success";
        try {
            OptInPhoneNumberResponse response = this.snsClient.optInPhoneNumber((OptInPhoneNumberRequest)OptInPhoneNumberRequest.builder().phoneNumber(phoneNumber).build());
            res = this.prepareOptInPhoneNumberResponse(response);
            this.logger.debug((Object)"SNS : optInPhoneNumber operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"OptInPhoneNumberError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"optInPhoneNumber", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareOptInPhoneNumberResponse(OptInPhoneNumberResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Map listPhoneNumbersOptedOut() {
        return this.listPhoneNumbersOptedOut(null);
    }

    @Override
    public Map listPhoneNumbersOptedOut(String nextToken) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"listPhoneNumbersOptedOut", (boolean)true);
        String statusCode = "Success";
        try {
            ListPhoneNumbersOptedOutRequest.Builder builder = ListPhoneNumbersOptedOutRequest.builder();
            if (nextToken != null) {
                builder.nextToken(nextToken);
            }
            ListPhoneNumbersOptedOutResponse response = this.snsClient.listPhoneNumbersOptedOut((ListPhoneNumbersOptedOutRequest)builder.build());
            res = this.prepareListPhoneNumbersOptedOutResponse(response);
            this.logger.debug((Object)"SNS : listPhoneNumbersOptedOut operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"ListPhoneNumbersOptedOutError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"listPhoneNumbersOptedOut", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareListPhoneNumbersOptedOutResponse(ListPhoneNumbersOptedOutResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Map checkIfPhoneNumberIsOptedOut(String phoneNumber) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"checkIfPhoneNumberIsOptedOut", (boolean)true);
        String statusCode = "Success";
        try {
            CheckIfPhoneNumberIsOptedOutResponse response = this.snsClient.checkIfPhoneNumberIsOptedOut((CheckIfPhoneNumberIsOptedOutRequest)CheckIfPhoneNumberIsOptedOutRequest.builder().phoneNumber(phoneNumber).build());
            res = this.prepareCheckIfPhoneNumberIsOptedOutResponse(response);
            this.logger.debug((Object)"SNS : checkIfPhoneNumberIsOptedOut operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"CheckIfPhoneNumberIsOptedOutError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"checkIfPhoneNumberIsOptedOut", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareCheckIfPhoneNumberIsOptedOutResponse(CheckIfPhoneNumberIsOptedOutResponse response) {
        Struct mapResponse = CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
        if (mapResponse != null) {
            mapResponse.remove((Object)"optedOut");
        }
        return mapResponse;
    }

    public Object invoke(String methodName, Object[] args, PageContext pageContext) throws Throwable {
        switch (methodName.toLowerCase()) {
            case "createtopic": {
                if (args != null && args.length == 1) {
                    return this.createTopic(Cast._String((Object)args[0]));
                }
                if (args != null && args.length == 2) {
                    return this.createTopic(Cast._String((Object)args[0]), Cast._Map((Object)args[1]));
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"CreateTopicValidationError"));
            }
            case "deletetopic": {
                if (args != null && args.length == 1) {
                    return this.deleteTopic(Cast._String((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"DeleteTopicValidationError"));
            }
            case "addpermission": {
                if (args != null && args.length == 2) {
                    return this.addPermission(Cast._String((Object)args[0]), Cast._Map((Object)args[1]));
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"AddPermissionValidationError"));
            }
            case "removepermission": {
                if (args != null && args.length == 2) {
                    return this.removePermission(Cast._String((Object)args[0]), Cast._String((Object)args[1]));
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"RemovePermissionValidationError"));
            }
            case "publish": {
                if (args != null && args.length == 1) {
                    return this.publish(Cast._Map((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"PublishValidationError"));
            }
            case "subscribe": {
                if (args != null && args.length == 1) {
                    return this.subscribe(Cast._Map((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"SubscribeValidationError"));
            }
            case "createplatformendpoint": {
                if (args != null && args.length == 1) {
                    return this.createPlatformEndpoint(Cast._Map((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"CreatePlatformEndpointValidationError"));
            }
            case "deleteendpoint": {
                if (args != null && args.length == 1) {
                    return this.deleteEndpoint(Cast._String((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"DeleteEndpointValidationError"));
            }
            case "getendpointattributes": {
                if (args != null && args.length == 1) {
                    return this.getEndpointAttributes(Cast._String((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"GetEndpointAttributesValidationError"));
            }
            case "createplatformapplication": {
                if (args != null && args.length == 1) {
                    return this.createPlatformApplication(Cast._Map((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"CreatePlatformEndpointValidationError"));
            }
            case "deleteplatformapplication": {
                if (args != null && args.length == 1) {
                    return this.deletePlatformApplication(Cast._String((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"DeleteEndpointValidationError"));
            }
            case "confirmsubscription": {
                if (args != null && args.length == 2) {
                    return this.confirmSubscription(Cast._String((Object)args[0]), Cast._Map((Object)args[1]));
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"ConfirmSubscriptionValidationError"));
            }
            case "unsubscribe": {
                if (args != null && args.length == 1) {
                    if (args[0] instanceof String) {
                        return this.unsubscribe(Cast._String((Object)args[0]));
                    }
                    return this.unsubscribe(Cast._Map((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"UnSubscribeValidationError"));
            }
            case "getsubscriptionattributes": {
                if (args != null && args.length == 1) {
                    if (args[0] instanceof String) {
                        return this.getSubscriptionAttributes(Cast._String((Object)args[0]));
                    }
                    return this.getSubscriptionAttributes(Cast._Map((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"GetSubscriptionAttributesValidationError"));
            }
            case "setsubscriptionattributes": {
                if (args != null && args.length == 1) {
                    return this.setSubscriptionAttributes(Cast._Map((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"SetSubscriptionAttributesValidationError"));
            }
            case "gettopicattributes": {
                if (args != null && args.length == 1) {
                    return this.getTopicAttributes(Cast._String((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"SetTopicAttributesValidationError"));
            }
            case "settopicattributes": {
                if (args != null && args.length == 1) {
                    return this.setTopicAttributes(Cast._Map((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"SetTopicAttributesValidationError"));
            }
            case "tagtopic": {
                if (args != null && args.length == 2) {
                    return this.tagTopic(Cast._String((Object)args[0]), Cast._Map((Object)args[1]));
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"TagTopicValidationError"));
            }
            case "untagtopic": {
                if (args != null && args.length == 2) {
                    return this.untagTopic(Cast._String((Object)args[0]), Cast._Map((Object)args[1]));
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"UntagTopicValidationError"));
            }
            case "listtopics": {
                if (args == null || args.length == 0) {
                    return this.listTopics();
                }
                if (args.length == 1) {
                    return this.listTopics(Cast._String((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"ListTopicsValidationError"));
            }
            case "listtopictags": {
                if (args != null && args.length == 1) {
                    return this.listTopicTags(Cast._String((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"ListTopicTagsValidationError"));
            }
            case "listtopicsubscriptions": {
                if (args != null && args.length == 1) {
                    return this.listTopicSubscriptions(Cast._String((Object)args[0]));
                }
                if (args != null && args.length == 2) {
                    return this.listTopicSubscriptions(Cast._String((Object)args[0]), Cast._String((Object)args[1]));
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"ListTopicSubscriptionsValidationError"));
            }
            case "listsubscriptions": {
                if (args == null || args.length == 0) {
                    return this.listSubscriptions();
                }
                if (args.length == 1) {
                    return this.listSubscriptions(Cast._String((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSTopicImpl.class, (String)"ListTopicSubscriptionsValidationError_one"));
            }
            case "setsmsattributes": {
                if (args != null && args.length == 1) {
                    return this.setSMSAttributes(Cast._Map((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"SetSMSAttributesValidationError"));
            }
            case "getsmsattributes": {
                if (args == null || args.length == 0) {
                    return this.getSMSAttributes();
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"GetSMSAttributesValidationError"));
            }
            case "getclass": {
                if (args == null || args.length == 0) {
                    return this.getClass();
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"GetClassValidationError"));
            }
            case "listtagsforresource": {
                if (args != null && args.length == 1) {
                    return this.listTagsForResource(Cast._String((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"ListTagsForResourceValidationError"));
            }
            case "optinphonenumber": {
                if (args != null && args.length == 1) {
                    return this.optInPhoneNumber(Cast._String((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"OptInPhoneNumberValidationError"));
            }
            case "listphonenumbersoptedout": {
                if (args != null && args.length <= 1) {
                    if (args.length == 0) {
                        return this.listPhoneNumbersOptedOut();
                    }
                    return this.listPhoneNumbersOptedOut(Cast._String((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"ListPhoneNumbersOptedOutValidationError"));
            }
            case "checkifphonenumberisoptedout": {
                if (args != null && args.length == 1) {
                    return this.checkIfPhoneNumberIsOptedOut(Cast._String((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSClientImpl.class, (String)"CheckIfPhoneNumberIsOptedOutValidationError"));
            }
        }
        Object val = super.invoke(methodName, args, pageContext);
        if (val != ObjectHandledInvokable.OBJECT_METHOD_NOT_FOUND) {
            return val;
        }
        throw new SNSAPIException(RB.getString(SNSClientImpl.class, (String)"MethodNotDefinedError", (Object)methodName));
    }

    public Object invoke(String methodName, Map args, PageContext pageContext) throws Throwable {
        NamedMethodInvoker NamedMethodInvoker2 = __InvokeNamedMethodInvocationMap.get((Object)methodName);
        if (NamedMethodInvoker2 == null) {
            throw new CfJspPage.UnsupportedBaseTypeException(methodName, (Object)this);
        }
        this.logger.info((Object)("sns service method " + methodName + " invoked and started excecution... "));
        long startTime = System.currentTimeMillis();
        Object invokeObject = NamedMethodInvoker2.invoke((Object)this, args);
        long endTime = System.currentTimeMillis();
        long timeElapsed = endTime - startTime;
        this.logger.info((Object)("sns service method " + methodName + " finished execution successfully. Turn around time : " + timeElapsed + " milli secs"));
        return invokeObject;
    }

    static {
        __InvokeNamedMethodInvocationMap.put((Object)"createTopic", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicName", "topicCreateOptions"}, args);
                    return obj.createTopic(Cast._String((Object)argColl.get((Object)"topicName")), Cast._Map((Object)argColl.get((Object)"topicCreateOptions")));
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicName"}, args);
                    return obj.createTopic(Cast._String((Object)argColl.get((Object)"topicName")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("createTopic", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"addPermission", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicArn", "permission"}, args);
                    return obj.addPermission(Cast._String((Object)argColl.get((Object)"topicArn")), Cast._Map((Object)argColl.get((Object)"permission")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("addPermission", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"removePermission", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicArn", "permissionLabel"}, args);
                    return obj.removePermission(Cast._String((Object)argColl.get((Object)"topicArn")), Cast._String((Object)argColl.get((Object)"permissionLabel")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("removePermission", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"subscribe", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"subscription"}, args);
                    return obj.subscribe(Cast._Map((Object)argColl.get((Object)"subscription")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("subscribe", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"confirmSubscription", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicArn", "subscription"}, args);
                    return obj.confirmSubscription(Cast._String((Object)argColl.get((Object)"topicArn")), Cast._Map((Object)argColl.get((Object)"subscription")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("confirmSubscription", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"listTopics", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.listTopics();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"nextToken"}, args);
                    return obj.listTopics(Cast._String((Object)argColl.get((Object)"nextToken")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("listTopics", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"listTopicSubscriptions", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicArn"}, args);
                    return obj.listTopicSubscriptions(Cast._String((Object)argColl.get((Object)"topicArn")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicArn", "nextToken"}, args);
                    return obj.listTopicSubscriptions(Cast._String((Object)argColl.get((Object)"topicArn")), Cast._String((Object)argColl.get((Object)"nextToken")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("listTopicSubscriptions", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"listSubscriptions", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.listSubscriptions();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"nextToken"}, args);
                    return obj.listSubscriptions(Cast._String((Object)argColl.get((Object)"nextToken")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("listSubscriptions", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"publish", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"message"}, args);
                    return obj.publish(Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("publish", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getSubscriptionAttributes", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"subscription"}, args);
                    return obj.getSubscriptionAttributes(argColl.get((Object)"subscription"));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getSubscriptionAttributes", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"setSubscriptionAttributes", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"subscriptionAttributes"}, args);
                    return obj.setSubscriptionAttributes(Cast._Map((Object)argColl.get((Object)"subscriptionAttributes")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("setSubscriptionAttributes", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getTopicAttributes", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicARN"}, args);
                    return obj.getTopicAttributes(Cast._String((Object)argColl.get((Object)"topicARN")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getTopicAttributes", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"setTopicAttributes", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicAttributes"}, args);
                    return obj.setTopicAttributes(Cast._Map((Object)argColl.get((Object)"topicAttributes")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("setTopicAttributes", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"setSMSAttributes", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"smsAttributes"}, args);
                    return obj.setSMSAttributes(Cast._Map((Object)argColl.get((Object)"smsAttributes")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("setSMSAttributes", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getSMSAttributes", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getSMSAttributes();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getSMSAttributes", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"unsubscribe", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"subscription"}, args);
                    return obj.unsubscribe(argColl.get((Object)"subscription"));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("unsubscribe", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"tagTopic", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicArn", "tags"}, args);
                    return obj.tagTopic(Cast._String((Object)argColl.get((Object)"topicArn")), Cast._Map((Object)argColl.get((Object)"tags")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("tagTopic", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"untagTopic", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicArn", "tags"}, args);
                    return obj.untagTopic(Cast._String((Object)argColl.get((Object)"topicArn")), Cast._Map((Object)argColl.get((Object)"tags")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("untagTopic", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"listTopicTags", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicArn"}, args);
                    return obj.listTopicTags(Cast._String((Object)argColl.get((Object)"topicArn")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("listTopicTags", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"deleteTopic", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicArn"}, args);
                    return obj.deleteTopic(Cast._String((Object)argColl.get((Object)"topicArn")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("deleteTopic", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"createPlatformEndpoint", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"platformEndpoint"}, args);
                    return obj.createPlatformEndpoint(Cast._Map((Object)argColl.get((Object)"platformEndpoint")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("createPlatformEndpoint", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"deleteEndpoint", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"endpointArn"}, args);
                    return obj.deleteEndpoint(Cast._String((Object)argColl.get((Object)"endpointArn")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("deleteEndpoint", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getEndpointAttributes", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"endpointArn"}, args);
                    return obj.getEndpointAttributes(Cast._String((Object)argColl.get((Object)"endpointArn")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getEndpointAttributes", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"createPlatformApplication", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"platformApplication"}, args);
                    return obj.createPlatformApplication(Cast._Map((Object)argColl.get((Object)"platformApplication")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("createPlatformApplication", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"deletePlatformApplication", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"platformApplicationArn"}, args);
                    return obj.deletePlatformApplication(Cast._String((Object)argColl.get((Object)"platformApplicationArn")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("deletePlatformApplication", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"listTagsForResource", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"resourceArn"}, args);
                    return obj.listTagsForResource(Cast._String((Object)argColl.get((Object)"resourceArn")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("listTagsForResource", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"optInPhoneNumber", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"phoneNumber"}, args);
                    return obj.optInPhoneNumber(Cast._String((Object)argColl.get((Object)"phoneNumber")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("optInPhoneNumber", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"listPhoneNumbersOptedOut", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.listPhoneNumbersOptedOut();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"nextToken"}, args);
                    return obj.listPhoneNumbersOptedOut(Cast._String((Object)argColl.get((Object)"nextToken")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("listPhoneNumbersOptedOut", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"checkIfPhoneNumberIsOptedOut", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"phoneNumber"}, args);
                    return obj.checkIfPhoneNumberIsOptedOut(Cast._String((Object)argColl.get((Object)"phoneNumber")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("checkIfPhoneNumberIsOptedOut", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"invoke", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"methodName", "args", "pageContext"}, args);
                    return obj.invoke(Cast._String((Object)argColl.get((Object)"methodName")), (Object[])Cast._castForInvokeGen((Object)argColl.get((Object)"args"), Object[].class), (PageContext)Cast._castForInvokeGen((Object)argColl.get((Object)"pageContext"), PageContext.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("invoke", obj);
        });
    }
}

