/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.eventgateway.cfml;

import coldfusion.eventgateway.CFEvent;
import coldfusion.eventgateway.Gateway;
import coldfusion.eventgateway.GatewayHelper;
import coldfusion.eventgateway.GatewayServices;
import coldfusion.runtime.Cast;
import java.util.Map;

public class CfmlGateway
implements Gateway {
    private GatewayServices gatewayService = null;
    private String gatewayID = "";
    private String[] listeners = null;
    private int status = 4;

    public CfmlGateway(String gatewayID) {
        this.gatewayID = gatewayID;
        this.gatewayService = GatewayServices.getGatewayServices();
    }

    public String outgoingMessage(CFEvent cfmsg) {
        Map data = cfmsg.getData();
        boolean status = true;
        if (data != null) {
            String originator;
            String method;
            String path;
            CFEvent event = new CFEvent(this.gatewayID);
            event.setData(data);
            event.setGatewayType("CFMLGateway");
            Object timeout = data.get("timeout");
            if (timeout != null) {
                try {
                    int to = Cast._int(timeout, (boolean)false);
                    event.setCfcTimeOut(to);
                }
                catch (Cast.NumberConversionException to) {
                    // empty catch block
                }
            }
            if ((path = (String)data.get("cfcpath")) != null) {
                event.setCfcPath(path);
            }
            if ((method = (String)data.get("method")) != null) {
                event.setCfcMethod(method);
            }
            if ((originator = (String)data.get("originatorid")) != null) {
                event.setOriginatorID(originator);
            } else {
                event.setOriginatorID("CFMLGateway");
            }
            status = this.gatewayService.addEvent(event);
        }
        return Boolean.toString(status);
    }

    public void setCFCListeners(String[] listeners) {
        this.listeners = listeners;
    }

    public GatewayHelper getHelper() {
        return null;
    }

    public void setGatewayID(String id) {
        this.gatewayID = id;
    }

    public String getGatewayID() {
        return this.gatewayID;
    }

    public void start() {
        this.status = 2;
    }

    public void stop() {
        this.status = 4;
    }

    public void restart() {
        this.stop();
        this.start();
    }

    public int getStatus() {
        return this.status;
    }
}

