/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.RegionMetadata;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.internal.BucketUtils;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketRequest;
import software.amazon.awssdk.services.s3.model.ListBucketsRequest;
import software.amazon.awssdk.utils.FunctionalUtils;

@SdkInternalApi
public final class S3EndpointUtils {
    private static final List<Class<?>> ACCELERATE_DISABLED_OPERATIONS = Arrays.asList(ListBucketsRequest.class, CreateBucketRequest.class, DeleteBucketRequest.class);

    private S3EndpointUtils() {
    }

    public static SdkHttpRequest applyEndpointConfiguration(SdkHttpRequest request, Object originalRequest, Region region, S3Configuration serviceConfiguration, String bucketName) {
        SdkHttpRequest.Builder mutableRequest = (SdkHttpRequest.Builder)request.toBuilder();
        URI endpoint = S3EndpointUtils.resolveEndpoint(request, originalRequest, region, serviceConfiguration);
        mutableRequest.uri(endpoint);
        if ((serviceConfiguration == null || !serviceConfiguration.pathStyleAccessEnabled()) && bucketName != null && BucketUtils.isVirtualAddressingCompatibleBucketName(bucketName, false)) {
            S3EndpointUtils.changeToDnsEndpoint(mutableRequest, bucketName);
        }
        return (SdkHttpRequest)mutableRequest.build();
    }

    private static URI resolveEndpoint(SdkHttpRequest request, Object originalRequest, Region region, S3Configuration serviceConfiguration) {
        RegionMetadata regionMetadata = RegionMetadata.of((Region)region);
        String protocol = request.protocol();
        if (S3EndpointUtils.isAccelerateEnabled(serviceConfiguration) && S3EndpointUtils.isAccelerateSupported(originalRequest)) {
            return S3EndpointUtils.accelerateEndpoint(serviceConfiguration, regionMetadata, protocol);
        }
        if (serviceConfiguration != null && serviceConfiguration.dualstackEnabled()) {
            return S3EndpointUtils.dualstackEndpoint(regionMetadata, protocol);
        }
        return (URI)FunctionalUtils.invokeSafely(() -> new URI(request.protocol(), null, request.host(), request.port(), null, null, null));
    }

    private static void changeToDnsEndpoint(SdkHttpRequest.Builder mutableRequest, String bucketName) {
        if (mutableRequest.host().startsWith("s3")) {
            String newHost = mutableRequest.host().replaceFirst("s3", bucketName + ".s3");
            String newPath = mutableRequest.encodedPath().replaceFirst("/" + bucketName, "");
            mutableRequest.host(newHost).encodedPath(newPath);
        }
    }

    private static URI dualstackEndpoint(RegionMetadata metadata, String protocol) {
        String serviceEndpoint = String.format("%s.%s.%s.%s", "s3", "dualstack", metadata.id(), metadata.domain());
        return S3EndpointUtils.toUri(protocol, serviceEndpoint);
    }

    private static boolean isAccelerateEnabled(S3Configuration serviceConfiguration) {
        return serviceConfiguration != null && serviceConfiguration.accelerateModeEnabled();
    }

    private static boolean isAccelerateSupported(Object originalRequest) {
        return !ACCELERATE_DISABLED_OPERATIONS.contains(originalRequest.getClass());
    }

    private static URI accelerateEndpoint(S3Configuration serviceConfiguration, RegionMetadata metadata, String protocol) {
        if (serviceConfiguration.dualstackEnabled()) {
            return S3EndpointUtils.toUri(protocol, "s3-accelerate.dualstack." + metadata.domain());
        }
        return S3EndpointUtils.toUri(protocol, "s3-accelerate." + metadata.domain());
    }

    private static URI toUri(String protocol, String endpoint) {
        try {
            return new URI(String.format("%s://%s", protocol, endpoint));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

