/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.mapping;

import coldfusion.orm.mapping.CFCPersistenceMetadata;
import coldfusion.orm.mapping.RelationField;
import coldfusion.runtime.ApplicationException;
import coldfusion.sql.DBMetaData;
import coldfusion.sql.ForeignKeyMetaData;
import coldfusion.sql.TableMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;

public class OneToOneField
extends RelationField {
    protected boolean constrained;
    private boolean resolved;
    private String fkName;
    private boolean missingRowIgnored;

    public boolean isConstrained() {
        return this.constrained;
    }

    public void setConstrained(boolean constrained) {
        this.constrained = constrained;
    }

    @Override
    public void resolve(CFCPersistenceMetadata cfcPmd, Map<String, CFCPersistenceMetadata> cfcMetaDataMap, DBMetaData dbMetaData) {
        if (this.resolved || this.mappedBy != null || this.linkTable != null) {
            return;
        }
        try {
            CFCPersistenceMetadata targetCfcPmd = cfcMetaDataMap.get(this.targetComponent);
            if (targetCfcPmd == null) {
                return;
            }
            if (cfcPmd == targetCfcPmd) {
                if (this.fkColumns != null || this.constrained) {
                    this.resolved = true;
                }
                return;
            }
            OneToOneField targetOneToOneField = (OneToOneField)targetCfcPmd.getRelationField(cfcPmd.getCfcName(), 1);
            if (targetOneToOneField != null && targetOneToOneField.getFkColumns() != null && this.fkColumns != null) {
                throw new OneToOneResolutionException(cfcPmd.getCfcName(), targetCfcPmd.getCfcName());
            }
            if (this.fkColumns != null) {
                return;
            }
            if (this.constrained) {
                if (targetOneToOneField != null) {
                    targetOneToOneField.setResolved(true);
                }
                return;
            }
            if (targetOneToOneField != null && targetOneToOneField.isConstrained()) {
                this.resolved = true;
                return;
            }
            if (dbMetaData == null) {
                return;
            }
            TableMetaData thisTableMetadata = dbMetaData.getTableMetaData(cfcPmd.getTableName(), cfcPmd.getSchema(), cfcPmd.getCatalog());
            if (thisTableMetadata == null) {
                return;
            }
            Map fkMap = thisTableMetadata.getForeignKeys();
            for (ForeignKeyMetaData fkMetaData : fkMap.values()) {
                if (!fkMetaData.getPktableName().equalsIgnoreCase(targetCfcPmd.getTableName())) continue;
                String fkcolumn = fkMetaData.getFkColName();
                Set pkColumns = thisTableMetadata.getPkColumns();
                if (pkColumns.size() == 1 && pkColumns.contains(fkcolumn)) {
                    this.constrained = true;
                    if (targetOneToOneField != null) {
                        targetOneToOneField.setResolved(true);
                    }
                } else {
                    this.fkColumns = new String[]{fkcolumn};
                    if (targetOneToOneField != null && targetOneToOneField.getMappedBy() == null) {
                        targetOneToOneField.setMappedBy(this.getName());
                    }
                }
                return;
            }
            TableMetaData thatTableMetadata = dbMetaData.getTableMetaData(targetCfcPmd.getTableName(), targetCfcPmd.getSchema(), targetCfcPmd.getCatalog());
            if (thatTableMetadata == null) {
                return;
            }
            fkMap = thatTableMetadata.getForeignKeys();
            for (ForeignKeyMetaData fkMetaData : fkMap.values()) {
                if (!fkMetaData.getPktableName().equalsIgnoreCase(cfcPmd.getTableName())) continue;
                String fkcolumn = fkMetaData.getFkColName();
                Set pkColumns = thatTableMetadata.getPkColumns();
                if (pkColumns.size() == 1 && pkColumns.contains(fkcolumn)) {
                    if (targetOneToOneField != null) {
                        targetOneToOneField.setConstrained(true);
                        targetOneToOneField.setResolved(true);
                    }
                    this.resolved = true;
                } else if (targetOneToOneField != null) {
                    targetOneToOneField.setFkColumns(new String[]{fkcolumn});
                    this.mappedBy = targetOneToOneField.getName();
                }
                return;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public boolean isResolved() {
        return this.resolved || this.fkColumns != null || this.mappedBy != null || this.constrained;
    }

    private void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    @Override
    public int getRelationType() {
        return 1;
    }

    public void setForeignKeyName(String fkName) {
        this.fkName = fkName;
    }

    public String getForeignKeyName() {
        return this.fkName;
    }

    public void setMissingRowIgnored(boolean missingRowIgnored) {
        this.missingRowIgnored = missingRowIgnored;
    }

    public boolean isMissingRowIgnored() {
        return this.missingRowIgnored;
    }

    public static class OneToOneResolutionException
    extends ApplicationException {
        public String cfc1;
        public String cfc2;

        public OneToOneResolutionException(String cfc1, String cfc2) {
            this.cfc1 = cfc1;
            this.cfc2 = cfc2;
        }
    }
}

