/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.hibernate;

import coldfusion.orm.ORMUtils;
import coldfusion.orm.PersistentTemplateProxy;
import coldfusion.util.RB;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.internal.MapMember;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.type.Type;

public class CFCPropertyGetter
implements Getter {
    private String propertyName;
    private Type propertyType;
    private String entityOrCFCName;

    public CFCPropertyGetter(String propertyName, Type propertyType, String entityName) {
        this.propertyName = propertyName;
        this.propertyType = propertyType;
        this.entityOrCFCName = entityName;
    }

    public Object get(Object owner) throws HibernateException {
        if (!(owner instanceof PersistentTemplateProxy)) {
            throw new HibernateException(RB.getString((Object)this, (String)"UnknownObjectType_Getter", (Object)owner.getClass().getName(), (Object)this.propertyName, (Object)this.entityOrCFCName));
        }
        Object value = ((PersistentTemplateProxy)((Object)owner)).getProperty(this.propertyName);
        try {
            if (this.propertyType != null && this.propertyType.getReturnedClass() != Map.class) {
                Object typedValue = ORMUtils.getTypedValue(value, this.propertyType.getReturnedClass());
                if (value != null && value != typedValue && !value.equals(typedValue)) {
                    ((PersistentTemplateProxy)((Object)owner)).setProperty(this.propertyName, typedValue);
                }
                return typedValue;
            }
            return value;
        }
        catch (Throwable throwable) {
            throw new HibernateException("Property : " + this.propertyName + " - " + throwable.getMessage(), throwable);
        }
    }

    public Object getForInsert(Object owner, Map mergeMap, SharedSessionContractImplementor session) throws HibernateException {
        return this.get(owner);
    }

    public Class getReturnType() {
        return Object.class;
    }

    public String getMethodName() {
        return null;
    }

    public Method getMethod() {
        return null;
    }

    public Member getMember() {
        return new MapMember(this.propertyName, this.propertyType.getReturnedClass());
    }
}

