/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.core.models;

import com.microsoft.graph.core.CoreConstants;
import com.microsoft.kiota.Compatibility;
import com.microsoft.kiota.http.middleware.UrlReplaceHandler;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import okhttp3.Request;

public class BatchRequestStep {
    private final String requestId;
    private final Request request;
    private List<String> dependsOn;

    public BatchRequestStep(@Nonnull String requestId, @Nonnull Request request) {
        Objects.requireNonNull(request, "The following parameter cannot be null: request");
        if (Compatibility.isBlank((String)requestId)) {
            throw new IllegalArgumentException("requestId cannot be null or empty.");
        }
        this.requestId = requestId;
        this.request = UrlReplaceHandler.replaceRequestUrl((Request)request, CoreConstants.ReplacementConstants.getDefaultReplacementPairs());
    }

    public BatchRequestStep(@Nonnull String requestId, @Nonnull Request request, @Nonnull List<String> dependsOn) {
        this(requestId, request);
        this.dependsOn = new ArrayList<String>(dependsOn);
    }

    @Nonnull
    public Request getRequest() {
        return this.request;
    }

    @Nonnull
    public String getRequestId() {
        return this.requestId;
    }

    @Nonnull
    public List<String> getDependsOn() {
        if (this.dependsOn == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(this.dependsOn);
    }

    public void setDependsOn(@Nonnull List<String> dependsOn) {
        this.dependsOn = new ArrayList<String>(dependsOn);
    }

    public void addDependsOnId(@Nonnull String id) {
        if (Compatibility.isBlank((String)id)) {
            throw new IllegalArgumentException("id cannot be null or empty");
        }
        if (this.dependsOn == null) {
            this.dependsOn = new ArrayList<String>();
        }
        this.dependsOn.add(id);
    }

    public boolean removeDependsOnId(@Nonnull String id) {
        Objects.requireNonNull(id);
        if (this.dependsOn != null) {
            if (!this.dependsOn.contains(id) || id.isEmpty()) {
                throw new IllegalArgumentException("id is not present in the dependsOn collection or is empty");
            }
            this.dependsOn.removeAll(Collections.singleton(id));
            return true;
        }
        return false;
    }
}

