/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.retry;

import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.internal.retry.SdkDefaultRetrySetting;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.conditions.AndRetryCondition;
import software.amazon.awssdk.core.retry.conditions.MaxNumberOfRetriesCondition;
import software.amazon.awssdk.core.retry.conditions.RetryCondition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Immutable
@SdkPublicApi
public final class RetryPolicy
implements ToCopyableBuilder<Builder, RetryPolicy> {
    private final RetryCondition retryConditionFromBuilder;
    private final RetryCondition retryCondition;
    private final BackoffStrategy backoffStrategy;
    private final BackoffStrategy throttlingBackoffStrategy;
    private final Integer numRetries;

    private RetryPolicy(BuilderImpl builder) {
        this.backoffStrategy = builder.backoffStrategy;
        this.throttlingBackoffStrategy = builder.throttlingBackoffStrategy;
        this.numRetries = builder.numRetries;
        this.retryConditionFromBuilder = builder.retryCondition;
        this.retryCondition = AndRetryCondition.create(MaxNumberOfRetriesCondition.create(this.numRetries), this.retryConditionFromBuilder);
    }

    public RetryCondition retryCondition() {
        return this.retryCondition;
    }

    public BackoffStrategy backoffStrategy() {
        return this.backoffStrategy;
    }

    public BackoffStrategy throttlingBackoffStrategy() {
        return this.throttlingBackoffStrategy;
    }

    public Integer numRetries() {
        return this.numRetries;
    }

    public Builder toBuilder() {
        return RetryPolicy.builder().numRetries(this.numRetries).retryCondition(this.retryConditionFromBuilder).backoffStrategy(this.backoffStrategy).throttlingBackoffStrategy(this.throttlingBackoffStrategy);
    }

    public String toString() {
        return ToString.builder((String)"RetryPolicy").add("numRetries", (Object)this.numRetries).add("retryCondition", (Object)this.retryCondition).add("backoffStrategy", (Object)this.backoffStrategy).add("throttlingBackoffStrategy", (Object)this.throttlingBackoffStrategy).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetryPolicy that = (RetryPolicy)o;
        if (!this.retryCondition.equals(that.retryCondition)) {
            return false;
        }
        if (!this.backoffStrategy.equals(that.backoffStrategy)) {
            return false;
        }
        if (!this.throttlingBackoffStrategy.equals(that.throttlingBackoffStrategy)) {
            return false;
        }
        return this.numRetries.equals(that.numRetries);
    }

    public int hashCode() {
        int result = this.retryCondition.hashCode();
        result = 31 * result + this.backoffStrategy.hashCode();
        result = 31 * result + this.throttlingBackoffStrategy.hashCode();
        result = 31 * result + this.numRetries.hashCode();
        return result;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static RetryPolicy defaultRetryPolicy() {
        return RetryPolicy.builder().backoffStrategy(BackoffStrategy.defaultStrategy()).throttlingBackoffStrategy(BackoffStrategy.defaultThrottlingStrategy()).numRetries(SdkDefaultRetrySetting.DEFAULT_MAX_RETRIES).retryCondition(RetryCondition.defaultRetryCondition()).build();
    }

    public static RetryPolicy none() {
        return RetryPolicy.builder().numRetries(0).backoffStrategy(BackoffStrategy.none()).throttlingBackoffStrategy(BackoffStrategy.none()).retryCondition(RetryCondition.none()).build();
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer numRetries = SdkDefaultRetrySetting.DEFAULT_MAX_RETRIES;
        private BackoffStrategy backoffStrategy = BackoffStrategy.defaultStrategy();
        private BackoffStrategy throttlingBackoffStrategy = BackoffStrategy.defaultThrottlingStrategy();
        private RetryCondition retryCondition = RetryCondition.defaultRetryCondition();

        private BuilderImpl() {
        }

        @Override
        public Builder numRetries(Integer numRetries) {
            this.numRetries = numRetries;
            return this;
        }

        public void setNumRetries(Integer numRetries) {
            this.numRetries(numRetries);
        }

        @Override
        public Integer numRetries() {
            return this.numRetries;
        }

        @Override
        public Builder backoffStrategy(BackoffStrategy backoffStrategy) {
            this.backoffStrategy = backoffStrategy;
            return this;
        }

        public void setBackoffStrategy(BackoffStrategy backoffStrategy) {
            this.backoffStrategy(backoffStrategy);
        }

        @Override
        public BackoffStrategy backoffStrategy() {
            return this.backoffStrategy;
        }

        @Override
        public Builder throttlingBackoffStrategy(BackoffStrategy throttlingBackoffStrategy) {
            this.throttlingBackoffStrategy = throttlingBackoffStrategy;
            return this;
        }

        @Override
        public BackoffStrategy throttlingBackoffStrategy() {
            return this.throttlingBackoffStrategy;
        }

        public void setThrottlingBackoffStrategy(BackoffStrategy throttlingBackoffStrategy) {
            this.throttlingBackoffStrategy = throttlingBackoffStrategy;
        }

        @Override
        public Builder retryCondition(RetryCondition retryCondition) {
            this.retryCondition = retryCondition;
            return this;
        }

        public void setRetryCondition(RetryCondition retryCondition) {
            this.retryCondition(retryCondition);
        }

        @Override
        public RetryCondition retryCondition() {
            return this.retryCondition;
        }

        @Override
        public RetryPolicy build() {
            return new RetryPolicy(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RetryPolicy> {
        public Builder numRetries(Integer var1);

        public Integer numRetries();

        public Builder backoffStrategy(BackoffStrategy var1);

        public BackoffStrategy backoffStrategy();

        public Builder throttlingBackoffStrategy(BackoffStrategy var1);

        public BackoffStrategy throttlingBackoffStrategy();

        public Builder retryCondition(RetryCondition var1);

        public RetryCondition retryCondition();

        public RetryPolicy build();
    }
}

