/*
 * Decompiled with CFR 0.152.
 */
package macromedia.slutil;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import macromedia.slutil.UtilException;
import macromedia.slutil.UtilTransliterator;

public class UtilTransliteratorUsingVM
extends UtilTransliterator {
    private String encoding;

    public UtilTransliteratorUsingVM(String string) throws UtilException {
        try {
            " ".getBytes(string);
            this.encoding = string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UtilException(1007, string);
        }
        this.setDefaultCacheSize();
    }

    public boolean isFixedBytesPerChar() {
        return false;
    }

    public int getMaxBytesPerChar() {
        return 0;
    }

    public int getMaxCharsPerByte() {
        return 1;
    }

    public byte[] encode(String string) throws UtilException {
        try {
            return string.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw UtilException.createTransliterationFailedException(unsupportedEncodingException.getMessage());
        }
    }

    public byte[] encode(String string, int[] nArray) throws UtilException {
        byte[] byArray = this.encode(string);
        nArray[0] = byArray.length;
        return byArray;
    }

    public void encode(InputStream inputStream, int n2, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.encoding);
            while (n2 > 0) {
                int n3 = Math.min(n2, this.streamChunkSize);
                int n4 = inputStream.read(this.bytesCache, 0, n3);
                if (n4 == -1) {
                    throw new UtilException(1002);
                }
                for (int i2 = 0; i2 < n4; ++i2) {
                    this.charsCache[i2] = (char)(this.bytesCache[i2] & 0xFF);
                }
                outputStreamWriter.write(this.charsCache, 0, n4);
                n2 -= n4;
            }
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    public void encode(Reader reader, int n2, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.encoding);
            while (n2 > 0) {
                int n3 = Math.min(n2, this.streamChunkSize);
                int n4 = reader.read(this.charsCache, 0, n3);
                if (n4 == -1) {
                    throw new UtilException(1002);
                }
                outputStreamWriter.write(this.charsCache, 0, n4);
                n2 -= n4;
            }
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    public String decode(byte[] byArray, int n2, int n3) throws UtilException {
        if (n3 == 0) {
            return EMPTY_STRING;
        }
        try {
            return new String(byArray, n2, n3, this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw UtilException.createTransliterationFailedException(unsupportedEncodingException.getMessage());
        }
    }

    public int decode(byte[] byArray, int n2, int n3, char[] cArray) throws UtilException {
        if (n3 == 0) {
            return 0;
        }
        try {
            String string = new String(byArray, n2, n3, this.encoding);
            int n4 = string.length();
            if (n4 > cArray.length) {
                n4 = cArray.length;
            }
            string.getChars(0, n4, cArray, 0);
            return n4;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw UtilException.createTransliterationFailedException(unsupportedEncodingException.getMessage());
        }
    }

    public String decode(byte[] byArray, int n2, int n3, int n4) throws UtilException {
        try {
            String string = new String(byArray, n2, n3, this.encoding);
            n3 = string.length();
            int n5 = Math.max(n3, n4);
            this.setCacheSize(n5);
            string.getChars(0, n3, this.charsCache, 0);
            for (int i2 = n3; i2 < n4; ++i2) {
                this.charsCache[i2] = 32;
            }
            return new String(this.charsCache, 0, n4);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw UtilException.createTransliterationFailedException(unsupportedEncodingException.getMessage());
        }
    }

    public Reader decodeAsReader(InputStream inputStream) throws UtilException {
        try {
            return new InputStreamReader(inputStream, this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UtilException(1007, this.encoding);
        }
    }
}

