/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.io.feed;

import coldfusion.runtime.CFVariableLexer;
import coldfusion.runtime.RequestMonitor;
import coldfusion.runtime.Struct;
import coldfusion.sql.QueryTable;
import coldfusion.syndication.FeedHandlerFactory;
import coldfusion.syndication.FeedInterface;
import coldfusion.syndication.FeedSyndicationException;
import coldfusion.tagext.GenericTag;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import jakarta.servlet.jsp.JspTagException;
import jakarta.servlet.jsp.PageContext;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.List;

public class FeedTag
extends GenericTag {
    private static final int DEF_PORT = 80;
    String action = null;
    Object name = null;
    String source = null;
    String enclosureDir = null;
    boolean overwrite = false;
    Object query = null;
    Object properties = null;
    Object feed = null;
    Struct columnMap = null;
    String xmlVar = null;
    File outputFile = null;
    boolean overwriteEnclosure = false;
    boolean ignoreEnclosureError = false;
    private String userAgent;
    private int timeout = -1;
    private String proxyserver;
    private int proxyport = 80;
    private String proxyUser;
    private String proxyPassword;
    boolean escapeChars = false;
    private String charset = "UTF-8";
    private static FeedHandlerFactory factory = new FeedHandlerFactory();
    private FeedInterface feedInterface = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doStartTag() throws JspTagException {
        this.feedInterface = factory.createFeedHandler(this, this.pageContext);
        this.onTagStart();
        if (this.action == null) {
            this.action = "read";
        }
        if (this.action.equalsIgnoreCase("read")) {
            Object fr = this.feedInterface.getFeedReader(this, this.tagNameFromClass());
            if (this.properties != null) {
                if (!(this.properties instanceof String)) {
                    throw new InvalidAttributeTypeException(this.action, "properties", "String");
                }
                if (!CFVariableLexer.isValidVariableName((String)((String)this.properties)) || ((String)this.properties).length() == 0) {
                    throw new IllegalVariableNameException((String)this.properties, "properties");
                }
                this.pageContext.setAttribute((String)this.properties, this.feedInterface.getFeedMetadataStruct(fr));
            }
            if (this.name != null) {
                if (!(this.name instanceof String)) {
                    throw new InvalidAttributeTypeException(this.action, "name", "String");
                }
                if (!CFVariableLexer.isValidVariableName((String)((String)this.name)) || ((String)this.name).length() == 0) {
                    throw new IllegalVariableNameException((String)this.name, "name");
                }
                this.pageContext.setAttribute((String)this.name, this.feedInterface.getFeedStruct(fr));
            }
            if (this.query != null) {
                if (!(this.query instanceof String)) {
                    throw new InvalidAttributeTypeException(this.action, "query", "String");
                }
                if (!CFVariableLexer.isValidVariableName((String)((String)this.query)) || ((String)this.query).length() == 0) {
                    throw new IllegalVariableNameException((String)this.query, "query");
                }
                this.pageContext.setAttribute((String)this.query, this.feedInterface.getFeedEntriesQuery(fr));
            }
            if (this.xmlVar != null) {
                if (!CFVariableLexer.isValidVariableName((String)this.xmlVar) || this.xmlVar.length() == 0) {
                    throw new IllegalVariableNameException(this.xmlVar, "xmlVar");
                }
                String feedXML = this.feedInterface.getFeedXML(fr);
                this.pageContext.setAttribute(this.xmlVar, (Object)feedXML);
            }
            if (this.outputFile != null) {
                if (this.outputFile.exists() && !this.overwrite) {
                    throw new FeedFileAlreadyExistsException(this.outputFile.getAbsolutePath());
                }
                this.printToFile(this.feedInterface.getFeedXML(fr));
            }
            if (this.enclosureDir != null) {
                this.feedInterface.saveEnclosures(fr, this.enclosureDir, this.overwriteEnclosure, this.ignoreEnclosureError);
            }
        } else if (this.action.equalsIgnoreCase("create")) {
            Object fg = this.feedInterface.getFeedGenerator();
            this.feedInterface.setEscapeChars(fg, this.escapeChars);
            if (this.name != null) {
                if (!(this.name instanceof Struct)) throw new InvalidAttributeTypeException(this.action, "name", "Struct");
                this.feed = this.feedInterface.createFeed(fg, (Struct)this.name);
            } else if (this.query != null) {
                if (!(this.query instanceof QueryTable)) throw new InvalidAttributeTypeException(this.action, "query", "CFML Query object");
                if (this.properties == null || !(this.properties instanceof Struct)) throw new InvalidAttributeTypeException(this.action, "properties", "Struct");
                this.feed = this.columnMap != null ? this.feedInterface.createFeed(fg, (QueryTable)this.query, (Struct)this.properties, this.columnMap) : this.feedInterface.createFeed(fg, (QueryTable)this.query, (Struct)this.properties, null);
            }
            if (this.xmlVar != null) {
                if (!CFVariableLexer.isValidVariableName((String)this.xmlVar) || this.xmlVar.length() == 0) {
                    throw new IllegalVariableNameException(this.xmlVar, "xmlVar");
                }
                String feedXML = this.feedInterface.getFeedGeneratorXML(fg);
                this.pageContext.setAttribute(this.xmlVar, (Object)feedXML);
            }
            if (this.outputFile != null) {
                if (this.outputFile.exists() && !this.overwrite) {
                    throw new FeedFileAlreadyExistsException(this.outputFile.getAbsolutePath());
                }
                this.printToFile(this.feedInterface.getFeedGeneratorXML(fg));
            }
        }
        List tagAttributes = this.captureAttributes(Arrays.asList("action", "source"), Arrays.asList(this.convertUpperCase(this.action), this.source));
        this.onTagEnd(tagAttributes);
        return 0;
    }

    private void printToFile(String feedXML) {
        try {
            OutputStream out = VFSFileFactory.getOutputStream((String)this.outputFile.getAbsolutePath());
            BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter(out, this.charset));
            outWriter.write(feedXML);
            outWriter.flush();
            outWriter.close();
        }
        catch (IOException iex) {
            throw new UnableToCreateFileException(this.outputFile.getAbsolutePath(), iex.getLocalizedMessage());
        }
        finally {
            try {
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void release() {
        this.action = null;
        this.name = null;
        this.source = null;
        this.enclosureDir = null;
        this.overwrite = false;
        this.query = null;
        this.properties = null;
        this.proxyserver = null;
        this.proxyport = 80;
        this.proxyUser = null;
        this.proxyPassword = null;
        this.userAgent = "ColdFusion";
        this.timeout = -1;
    }

    public void setEnclosureDir(String enclosureDir) {
        if (enclosureDir != null && enclosureDir.length() == 0) {
            throw new BlankEnclosureDirException();
        }
        this.enclosureDir = Utils.getFileFullPath((String)enclosureDir, (PageContext)this.pageContext, (boolean)true);
    }

    public void setOutputFile(String outputFile) {
        if (outputFile == null || outputFile.trim().length() == 0) {
            throw new BlankOutputFileNameException();
        }
        File oFile = VFSFileFactory.getFileObject((String)Utils.getFileFullPath((String)outputFile, (PageContext)this.pageContext, (boolean)true));
        if (!oFile.getParentFile().isDirectory()) {
            throw new FeedFileParentException(oFile.getParent(), "outputfile");
        }
        this.outputFile = oFile;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setOverwriteEnclosure(boolean overwriteEnclosure) {
        this.overwriteEnclosure = overwriteEnclosure;
    }

    public void setIgnoreEnclosureError(boolean ignoreEnclosureError) {
        this.ignoreEnclosureError = ignoreEnclosureError;
    }

    public void setXmlVar(String xmlVar) {
        this.xmlVar = xmlVar;
    }

    public void setColumnMap(Struct map) {
        this.columnMap = map;
    }

    public void setAction(String action) {
        this.action = action.toLowerCase();
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        if (source == null || source.trim().equalsIgnoreCase("")) {
            throw new EmptySourceAttributeException();
        }
        this.source = source.startsWith("http://") || source.startsWith("https://") ? source.trim() : Utils.getFileFullPath((String)source.trim(), (PageContext)this.pageContext, (boolean)true);
    }

    public void setName(Object name) {
        this.name = name;
    }

    public void setQuery(Object query) {
        this.query = query;
    }

    public void setProperties(Object properties) {
        this.properties = properties;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public int getTimeout() {
        long ret = 0L;
        long requestTimeout = RequestMonitor.getRequestTimeout() * 1000L;
        if (this.timeout > 0) {
            ret = this.timeout;
            if (requestTimeout > 0L) {
                ret = Math.min((long)this.timeout, requestTimeout);
            }
        } else if (requestTimeout > 0L) {
            ret = requestTimeout;
        }
        return (int)ret;
    }

    public void setTimeout(int t) {
        if (t > 0) {
            this.timeout = t * 1000;
        }
    }

    public void setProxyserver(String o) {
        this.proxyserver = o;
    }

    public String getProxyserver() {
        return this.proxyserver;
    }

    public void setProxyport(int p) {
        this.proxyport = p;
    }

    public void setEscapeChars(boolean escapeChars) {
        this.escapeChars = escapeChars;
    }

    public boolean isEscapeChars() {
        return this.escapeChars;
    }

    public int getProxyport() {
        return this.proxyport;
    }

    public void setProxyUser(String o) {
        this.proxyUser = o;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyPassword(String o) {
        this.proxyPassword = o;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public static class InvalidAttributeTypeException
    extends FeedSyndicationException {
        public String action;
        public String attribute;
        public String attributeType;

        public InvalidAttributeTypeException(String action, String attribute, String attributeType) {
            this.action = action;
            this.attribute = attribute;
            this.attributeType = attributeType;
        }

        public String getAction() {
            return this.action;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public String getAttributeType() {
            return this.attributeType;
        }
    }

    public class IllegalVariableNameException
    extends FeedSyndicationException {
        public String attrName;
        public String attribute;

        public IllegalVariableNameException(String attrName, String attribute) {
            this.attrName = attrName;
            this.attribute = attribute;
        }
    }

    public class FeedFileAlreadyExistsException
    extends FeedSyndicationException {
        public String file;

        public FeedFileAlreadyExistsException(String file) {
            this.file = file;
        }
    }

    public class UnableToCreateFileException
    extends FeedSyndicationException {
        public String file;
        public String cause;

        public UnableToCreateFileException(String file, String cause) {
            this.file = file;
            this.cause = cause;
        }
    }

    public static class BlankEnclosureDirException
    extends FeedSyndicationException {
    }

    public static class BlankOutputFileNameException
    extends FeedSyndicationException {
    }

    public class FeedFileParentException
    extends FeedSyndicationException {
        public String dir;
        public String attrName;

        public FeedFileParentException(String file, String attrName) {
            this.dir = file;
            this.attrName = attrName;
        }
    }

    public class EmptySourceAttributeException
    extends FeedSyndicationException {
    }

    public class InvalidFeedActionException
    extends FeedSyndicationException {
        public String action;

        public InvalidFeedActionException(String action) {
            this.action = action;
        }
    }
}

