/*
 * Decompiled with CFR 0.152.
 */
package ice.authentication;

import ice.authentication.Authentication;
import ice.authentication.AuthenticationHandler;
import ice.authentication.AuthenticationManager;
import ice.authentication.AuthenticationUtils;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class AbstractAuthenticationHandler
implements AuthenticationHandler {
    protected Hashtable authenticationMap = new Hashtable();
    protected AuthenticationManager authenticationManager;

    public void addAuthentication(Authentication authentication) {
        if (authentication != null) {
            this.authenticationMap.put(AuthenticationUtils.getRootPath(authentication.getRequestUri()), authentication);
        }
    }

    public void clearAuthentications() {
        this.authenticationMap.clear();
    }

    public Authentication[] getAllAuthentications() {
        Authentication[] _authentications = new Authentication[this.authenticationMap.size()];
        Enumeration _elements = this.authenticationMap.elements();
        for (int i = 0; i < _authentications.length; ++i) {
            _authentications[i] = (Authentication)_elements.nextElement();
        }
        return _authentications;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void removeAuthentication(Authentication authentication) {
        if (authentication != null) {
            this.authenticationMap.remove(AuthenticationUtils.getRootPath(authentication.getRequestUri()));
        }
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    protected AbstractAuthenticationHandler() {
    }

    protected Authentication findAuthentication(String rootPath, Class authenticationClass) {
        Enumeration _keys = this.authenticationMap.keys();
        int _size = this.authenticationMap.size();
        for (int i = 0; i < _size; ++i) {
            Authentication _authentication;
            String _key = (String)_keys.nextElement();
            if (!rootPath.startsWith(_key) || !authenticationClass.isInstance(_authentication = (Authentication)this.authenticationMap.get(_key))) continue;
            return _authentication;
        }
        return null;
    }
}

