/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer.util;

import com.zerog.ia.installer.InstallPiece;
import java.util.StringTokenizer;

public class ComponentVersion
extends InstallPiece {
    private int ad = 1;
    private int ae = 0;
    private int af = 0;
    private int ag = 0;

    public ComponentVersion() {
    }

    public ComponentVersion(String string) throws NumberFormatException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            this.setVersionMajor(new Integer(stringTokenizer.nextToken()));
            this.setVersionMinor(new Integer(stringTokenizer.nextToken()));
            this.setVersionRevision(new Integer(stringTokenizer.nextToken()));
            this.setVersionSubrevision(new Integer(stringTokenizer.nextToken()));
        }
        catch (Exception exception) {
            throw new NumberFormatException("parsing " + string + " " + exception.getMessage());
        }
    }

    public int getVersionMajor() {
        return this.ad;
    }

    public void setVersionMajor(int n) {
        this.ad = n;
    }

    public void setVersionMinor(int n) {
        this.ae = n;
    }

    public int getVersionMinor() {
        return this.ae;
    }

    public void setVersionRevision(int n) {
        this.af = n;
    }

    public int getVersionRevision() {
        return this.af;
    }

    public void setVersionSubrevision(int n) {
        this.ag = n;
    }

    public int getVersionSubrevision() {
        return this.ag;
    }

    public static String[] getSerializableProperties() {
        String[] stringArray = new String[4];
        stringArray[0] = "versionMajor";
        stringArray[1] = "versionMinor";
        stringArray[2] = "versionRevision";
        stringArray[3] = "versionSubrevision";
        return stringArray;
    }

    @Override
    public String getVisualNameSelf() {
        return "Component Version";
    }

    public boolean atMost(ComponentVersion componentVersion) {
        return componentVersion.atLeast(this);
    }

    public boolean atLeast(ComponentVersion componentVersion) {
        if (this.getVersionMajor() > componentVersion.getVersionMajor()) {
            return true;
        }
        if (this.getVersionMajor() < componentVersion.getVersionMajor()) {
            return false;
        }
        if (this.getVersionMinor() > componentVersion.getVersionMinor()) {
            return true;
        }
        if (this.getVersionMinor() < componentVersion.getVersionMinor()) {
            return false;
        }
        if (this.getVersionRevision() > componentVersion.getVersionRevision()) {
            return true;
        }
        if (this.getVersionRevision() < componentVersion.getVersionRevision()) {
            return false;
        }
        return this.getVersionSubrevision() >= componentVersion.getVersionSubrevision();
    }
}

