/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer.rules;

import com.zerog.ia.installer.IAStatus;
import com.zerog.ia.installer.IAStatusLog;
import com.zerog.ia.installer.rules.CompareVariable;
import com.zerog.ia.installer.util.ClassInfoManager;
import com.zerog.ia.installer.util.VariableFacade;
import com.zerog.ia.installer.util.VariableManager;
import com.zerog.util.IAResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CompareRegExpression
extends CompareVariable {
    private boolean ap = true;
    public static final String DESCRIPTION = IAResourceBundle.getValue("Designer.Rule.CompareRegExpression.visualName");
    private static VariableFacade aq = VariableFacade.getInstance();
    public static final String GENERIC_RULE_DISP_STRING = "MRE";
    public static final String COMPILE_ERROR_DESCRIPTION = "Match Regular Expression Failed: Invalid regular expression";

    @Override
    public String getGenericDisplayString() {
        return GENERIC_RULE_DISP_STRING;
    }

    @Override
    public String getVisualNameSelf() {
        return DESCRIPTION;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean resolveAnswer() {
        boolean bl;
        VariableManager variableManager = VariableManager.getInstance();
        Character c = (Character)VariableManager.supportedOperations.get(this.ao);
        if (this.getOperandOne().equals("")) {
            this.setOperandOne("$EMPTY_STRING$");
        }
        if (this.getOperandTwo().equals("")) {
            this.setOperandTwo("$EMPTY_STRING$");
        }
        if (this.getOperandOne() != "") {
            if (this.getOperandTwo() != "") {
                String string = aq.substitute(this.getOperandOne());
                String string2 = aq.substitute(this.getOperandTwo());
                try {
                    Pattern pattern = Pattern.compile(string2);
                    Matcher matcher = pattern.matcher(string);
                    bl = matcher.find();
                    if (this.ap) return bl;
                    if (bl) return false;
                    return true;
                }
                catch (Exception exception) {
                    bl = false;
                    IAStatus iAStatus = new IAStatus((Object)this.getVisualParent(), "Match Regular Expression Failed: Invalid regular expression: " + string2, 98);
                    IAStatusLog.getInstance().addStatus(iAStatus);
                    return bl;
                }
            }
        }
        bl = false;
        System.err.println("CompareVariable: You must set the operands before requesting an answer.");
        System.err.println(" Try using $EMPTY_STRING$ or $VARIABLE_NOT_SET$ in your rule.");
        return bl;
    }

    public void setPositive(boolean bl) {
        this.ap = bl;
    }

    public boolean getPositive() {
        return this.ap;
    }

    public static String[] getSerializableProperties() {
        String[] stringArray = new String[6];
        stringArray[0] = "positive";
        stringArray[1] = "operation";
        stringArray[2] = "operandOne";
        stringArray[3] = "operandTwo";
        stringArray[4] = "ruleId";
        stringArray[5] = "expressionID";
        return stringArray;
    }

    @Override
    public String[] getExternalizedProperties() {
        String[] stringArray = new String[2];
        stringArray[0] = "operandOne";
        stringArray[1] = "operandTwo";
        return stringArray;
    }

    public static boolean canBeDisplayed() {
        return Flexeraajj.ae(Flexeraajj.a6);
    }

    @Override
    public boolean hasInstallPermissions() {
        return Flexeraajj.ae(Flexeraajj.a6);
    }

    static {
        ClassInfoManager.aa(CompareRegExpression.class, DESCRIPTION, null);
    }
}

