/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer;

import com.zerog.common.java.io.FileUtil;
import com.zerog.ia.installer.InstallPiece;
import com.zerog.ia.installer.util.ZGPathManager;
import com.zerog.util.ZGUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class SolutionInstallPackage
extends InstallPiece {
    private String ad = "";

    public static String[] getSerializableProperties() {
        String[] stringArray = new String[1];
        stringArray[0] = "projectPath";
        return stringArray;
    }

    @Override
    public String getVisualNameSelf() {
        return this.getDesignerText("VisualName") + ": " + this.getProjectName();
    }

    public String getProjectPath() {
        return this.ad;
    }

    public String getProjectAbsolutePath() {
        return ZGPathManager.getInstance().getSubstitutedFilePath(this.ad);
    }

    public void setProjectPath(String string) {
        this.ad = FileUtil.convertToOsAppropriateSeparators(string);
    }

    public String getProjectName() {
        return new File(this.ad).getName();
    }

    public String getPackageName() {
        int n = this.getProjectName().lastIndexOf(46);
        return (n >= 0 ? this.getProjectName().substring(0, n) : this.getProjectName()) + ".zip";
    }

    public String getPackagePath() {
        return new File(this.ad).getParent() + File.separator + this.getPackageName();
    }

    public String getPackageAbsolutePath() {
        return ZGPathManager.getInstance().getSubstitutedFilePath(this.getPackagePath());
    }

    public boolean projectExists() {
        return new File(this.getProjectAbsolutePath()).exists();
    }

    public void preflight() {
        block6: {
            block8: {
                block7: {
                    if (ZGUtil.WIN32) break block7;
                    if (!this.ad.equals("")) break block8;
                }
                return;
            }
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("InstallerData/" + this.getPackageName());
            if (inputStream == null) {
                Flexeraavf.aj("Unable to find SI package: " + this.getPackageName());
                return;
            }
            try {
                Flexeraavt.aa(inputStream, new FileOutputStream(this.getPackageInstallPath()));
            }
            catch (IOException iOException) {
                Flexeraavf.aj("Unable to create SI package: " + this.getPackageInstallPath());
                if (!Flexeraavf.ar()) break block6;
                iOException.printStackTrace();
            }
        }
    }

    public File getPackageInstallPath() {
        Object object = System.getProperty("user.dir");
        if (ZGUtil.WIN32) {
            object = (String)object + File.separator + "..";
        }
        File file = new File((String)object, "InstallerData");
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            file = file.getAbsoluteFile();
        }
        return new File(file, this.getPackageName());
    }
}

