/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.common.java.io;

import com.zerog.util.ZGUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Vector;

public class FileUtil {
    public static String getPlainName(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n > -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String getExtension(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n > -1 && n < string.length() - 1) {
            return string.substring(n + 1);
        }
        return "";
    }

    public static void deleteRecursively(File file) throws IOException {
        int n;
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                FileUtil.deleteRecursively(new File(file.getCanonicalPath() + File.separator + stringArray[n]));
            }
        }
        n = file.delete();
    }

    public static void emptyOrCreateDirectory(File file) throws IOException {
        if (file.exists()) {
            FileUtil.deleteRecursively(file);
        }
        file.mkdirs();
    }

    public static File[] getAllFilesFromDirTree(File file) {
        if (file == null || !file.isDirectory()) {
            throw new IllegalArgumentException("The specified parameter is NOT a directory: " + file);
        }
        Vector vector = new Vector();
        FileUtil.aa(file, vector);
        File[] fileArray = new File[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            fileArray[i] = (File)vector.elementAt(i);
        }
        return fileArray;
    }

    private static void aa(File file, Vector vector) {
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                FileUtil.aa(file2, vector);
                continue;
            }
            vector.addElement(file2);
        }
    }

    public static String appendFileSeparator(String object) {
        if (object != null) {
            object = ((String)object).trim();
            if (!((String)object).endsWith("/")) {
                if (!((String)object).endsWith("\\")) {
                    object = (String)object + File.separator;
                }
            }
        }
        return object;
    }

    public static String removeTrailingSeparators(String string) {
        block4: {
            int n;
            block6: {
                block5: {
                    if (string == null) break block4;
                    string = string.trim();
                    n = 0;
                    if (string.endsWith("/")) break block5;
                    if (!string.endsWith("\\")) break block6;
                }
                ++n;
            }
            if (n > 0) {
                string = string.substring(0, string.length() - n);
            }
        }
        return string;
    }

    public static String convertToOsAppropriateSeparators(String string) {
        if (string != null) {
            string = string.replace('\\', '/');
            string = string.replace('/', File.separatorChar);
        }
        return string;
    }

    public static File findLastDirectory(String string) {
        return FileUtil.findLastDirectory(new File(string));
    }

    public static File findFirstNonExistingDirectory(String string) {
        return FileUtil.findFirstNonExistingDirectory(new File(string));
    }

    public static File findLastDirectory(File file) {
        return file.isFile() ? new File(file.getParent()) : file;
    }

    public static File findFirstNonExistingDirectory(File file) {
        File file2 = FileUtil.findLastDirectory(file);
        File file3 = null;
        while (!file2.isDirectory()) {
            file3 = file2;
            file2 = new File(file2.getParent());
        }
        return file3;
    }

    public static boolean isValidPath(String string) {
        return string != null && string.trim().length() > 0 && FileUtil.isValidPath(new File(string));
    }

    public static boolean isInvalidPath(String string) {
        return !FileUtil.isValidPath(string);
    }

    public static boolean isValidPath(File file) {
        boolean bl;
        File file2 = FileUtil.findFirstNonExistingDirectory(file);
        boolean bl2 = bl = file.isDirectory() || file.mkdirs();
        if (file2 != null && file2.exists()) {
            try {
                FileUtil.deleteRecursively(file2);
            }
            catch (IOException iOException) {
                Flexeraavf.aj("Unable to delete directory just created to validate path.");
            }
        }
        return bl;
    }

    public static boolean isInvalidPath(File file) {
        return !FileUtil.isValidPath(file);
    }

    public static boolean isInvalidFileFolderPath(String string) {
        boolean bl = true;
        try {
            Paths.get(string, new String[0]);
        }
        catch (InvalidPathException invalidPathException) {
            bl = false;
        }
        return !bl;
    }

    public static boolean isAbsolute(String string) {
        string = FileUtil.normalizeFileName(string);
        File file = new File(string);
        return string.startsWith(File.separator) || file.isAbsolute();
    }

    public static String normalizeFileName(String string) {
        return FileUtil.normalizeFileName(string, File.separatorChar);
    }

    public static String normalizeFileName(String string, char c) {
        if (string == null) {
            throw new NullPointerException("fileName cannot be null");
        }
        return string.replace('/', c).replace('\\', c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canReadAndWrite(File file) {
        if (!(!file.exists() || file.canWrite() && file.canRead())) {
            return false;
        }
        boolean bl = !file.exists();
        try {
            new FileOutputStream(file.getAbsolutePath(), true).close();
            new FileInputStream(file.getAbsolutePath()).close();
            boolean bl2 = true;
            return bl2;
        }
        catch (IOException iOException) {
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (bl) {
                file.delete();
            }
        }
    }

    public static String getMD5OfFile(File file) throws IOException {
        Flexeraavo flexeraavo = new Flexeraavo();
        flexeraavo.ab(new FileInputStream(file));
        return flexeraavo.ae();
    }

    public static String getMD5OfStream(InputStream inputStream) throws IOException {
        Flexeraavo flexeraavo = new Flexeraavo();
        flexeraavo.ab(inputStream);
        return flexeraavo.ae();
    }

    public static String readFileToString(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = System.getProperty("line.separator");
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string2);
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    public static String[] readFileContentsToStringArray(File file) throws IOException {
        String[] stringArray = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string.trim());
        }
        arrayList.add(file.getAbsolutePath());
        stringArray = arrayList.toArray(new String[arrayList.size()]);
        return stringArray;
    }

    public static void replaceSelected(File file, String string, String string2) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string3 = bufferedReader.readLine();
        while (string3 != null) {
            if (string3.contains(string)) {
                string3 = ZGUtil.replaceAll(string3, string, string2);
            }
            arrayList.add(string3);
            string3 = bufferedReader.readLine();
        }
        bufferedReader.close();
        PrintWriter printWriter = new PrintWriter(file);
        for (String string4 : arrayList) {
            printWriter.println(string4);
        }
        printWriter.close();
    }

    public static String detectEncoding(InputStream inputStream) throws IOException {
        String string = null;
        byte[] byArray = new byte[50];
        if (inputStream != null) {
            int n = inputStream.read(byArray, 0, 4);
            if (byArray[0] == 0) {
                if (byArray[1] == 0 && byArray[2] == -2 && byArray[3] == -1) {
                    string = "UTF-32BE";
                } else if (byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 60) {
                    string = "UTF-32BE";
                } else if (byArray[1] == 60 && byArray[2] == 0 && byArray[3] == 63) {
                    string = "UTF-16BE";
                }
            } else if (byArray[0] == -1) {
                if (byArray[1] == -2 && byArray[2] == 0 && byArray[3] == 0) {
                    string = "UTF-32LE";
                } else if (byArray[1] == -2) {
                    string = "UTF-16LE";
                }
            } else if (byArray[0] == 60) {
                if (byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0) {
                    string = "UTF-32LE";
                } else if (byArray[1] == 0 && byArray[2] == 63 && byArray[3] == 0) {
                    string = "UTF-16LE";
                } else if (byArray[1] == 63 && byArray[2] == 120 && byArray[3] == 109) {
                    string = "US-ASCII";
                }
            } else if (byArray[0] == -2) {
                if (byArray[1] == -1) {
                    string = "UTF-16BE";
                }
            } else if (byArray[0] == -17) {
                if (byArray[1] == -69 && byArray[2] == -65) {
                    string = "UTF-8";
                }
            } else if (byArray[0] == 76 && byArray[1] == 111 && byArray[2] == -89 && byArray[3] == -108) {
                string = "IBM037";
            }
            if (string == null) {
                String string2 = "macRoman";
                string = System.getProperty("file.encoding");
                if (string2.equalsIgnoreCase(string)) {
                    string = "UTF-8";
                }
            }
            inputStream.close();
        }
        return string;
    }
}

