/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.macos.toolbox.Handle;
import java.io.IOException;
import java.io.InputStream;

public class HandleInputStream
extends InputStream {
    Handle itsHandle;
    int itsSize;
    int itsOffset;
    int itsMark;

    public HandleInputStream(Handle handle) {
        this.itsHandle = handle;
        this.itsSize = this.itsHandle.getSize();
        this.itsOffset = 0;
        this.itsMark = 0;
    }

    public synchronized void close() {
        if (this.itsHandle != null) {
            this.itsHandle.dispose();
            this.itsHandle = null;
        }
    }

    public synchronized int read() {
        int n = -1;
        if (this.itsOffset < this.itsSize) {
            n = this.itsHandle.readByteAt(this.itsOffset++);
            n &= 0xFF;
        }
        return n;
    }

    public void reset() {
        this.itsOffset = this.itsMark;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return 0;
        }
        int n3 = this.itsSize - this.itsOffset;
        if (n2 > n3) {
            n2 = n3;
        }
        byte[] byArray2 = this.itsHandle.getBytesAt(this.itsOffset, n2);
        System.arraycopy(byArray2, 0, byArray, n, n2);
        this.itsOffset += n2;
        return n2;
    }

    public long skip(long l) throws IOException {
        int n = (int)(l & 0xFFFFFFFFEFFFFFFFL);
        this.itsOffset += n;
        return n;
    }

    public int available() throws IOException {
        return this.itsSize - this.itsOffset;
    }

    public void mark(int n) {
        this.itsMark = n;
    }

    public boolean markSupported() {
        return true;
    }
}

