/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.Handle;
import com.apple.MacOS.MacOSError;
import com.apple.MacOS.MacOSLibraries;
import com.apple.memory.ByteObject;
import com.apple.memory.MemoryObject;
import java.io.File;

public class FSSpec
extends ByteObject {
    public static final int sizeOfFSSpec = 70;
    private static String[] kNativeLibraryNames = MacOSLibraries.kInterfaceLibNames;

    public FSSpec() {
        super(70);
    }

    public FSSpec(String string) {
        this();
        short s = FSSpec.Path2FSSpec(FSSpec.cstring(string), this.getBytes());
        if (s != 0 && s != -43) {
            MacOSError.CheckResult(s);
        }
    }

    public FSSpec(File file) {
        this(file.getPath());
    }

    public FSSpec(short s, int n, String string) {
        this();
        this.setVRefNum(s);
        this.setParID(n);
        this.setName(string);
    }

    public FSSpec(short s, int n) {
        this(s, n, "");
    }

    public FSSpec(MemoryObject memoryObject) {
        this();
        this.setVRefNum(memoryObject.getShortAt(0));
        this.setParID(memoryObject.getIntAt(2));
        this.setName(memoryObject.PStringAt(6));
    }

    public final short getVRefNum() {
        return this.getShortAt(0);
    }

    public final int getParID() {
        return this.getIntAt(2);
    }

    public final String getName() {
        return this.PStringAt(6);
    }

    public final void setVRefNum(short s) {
        this.setShortAt(0, s);
    }

    public final void setParID(int n) {
        this.setIntAt(2, n);
    }

    public final void setName(String string) {
        this.setPStringAt(6, string.length(), string);
    }

    public String toString() {
        return "[" + this.getVRefNum() + ", " + this.getParID() + ", " + this.getName() + "]";
    }

    public File toFile() {
        int n = FSSpec.Spec2FullPath(this.getBytes());
        if (n == 0) {
            throw new OutOfMemoryError();
        }
        Handle handle = new Handle(n);
        File file = new File(handle.CStringAt(0));
        handle.Dispose();
        return file;
    }

    private static byte[] cstring(String string) {
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray.length] = 0;
        return byArray2;
    }

    private static byte[] pstring(String string) {
        byte[] byArray = string.getBytes();
        int n = Math.min(255, byArray.length);
        byte[] byArray2 = new byte[n + 1];
        System.arraycopy(byArray, 0, byArray2, 1, n);
        byArray2[0] = (byte)n;
        return byArray2;
    }

    private static native short FSMakeFSSpec(short var0, int var1, byte[] var2, byte[] var3);

    private static native int Spec2FullPath(byte[] var0);

    private static native short Path2FSSpec(byte[] var0, byte[] var1);
}

