/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.ClipboardEnumerator;
import com.apple.MacOS.Handle;
import com.apple.MacOS.HandleInputStream;
import com.apple.MacOS.MacOSError;
import com.apple.MacOS.MacOSLibraries;
import com.apple.MacOS.OSUtils;
import com.apple.MacOS.ScrapHandle;
import com.apple.MacOS.ScrapInfo;
import com.apple.NativeObject;
import java.awt.datatransfer.DataFlavor;
import java.io.InputStream;

public class Clipboard
implements NativeObject {
    private ScrapInfo info = new ScrapInfo();
    static String[] kNativeLibraryNames = MacOSLibraries.kInterfaceLibNames;

    public String convertMime(DataFlavor dataFlavor) {
        if (dataFlavor == DataFlavor.plainTextFlavor || dataFlavor == DataFlavor.stringFlavor) {
            return "TEXT";
        }
        String string = dataFlavor.getMimeType();
        if (string == "image/jpeg") {
            return "JPEG";
        }
        if (string == "image/gif") {
            return "GIFf";
        }
        return null;
    }

    public ClipboardEnumerator getTypes() {
        return new ClipboardEnumerator(this.info);
    }

    public InputStream getScrap(String string) {
        try {
            return new HandleInputStream(new ScrapHandle(string));
        }
        catch (MacOSError macOSError) {
            return null;
        }
    }

    public Handle getScrapHandle(String string) {
        try {
            return new ScrapHandle(string);
        }
        catch (MacOSError macOSError) {
            return null;
        }
    }

    public byte[] getScrapData(String string) {
        Handle handle = this.getScrapHandle(string);
        if (handle != null) {
            return handle.getBytes();
        }
        return null;
    }

    public void putScrap(String string, byte[] byArray) {
        Clipboard.PutScrap(byArray.length, OSUtils.makeOSType(string), byArray);
        this.info = new ScrapInfo();
    }

    public void putScrap(String string, Handle handle) {
        this.putScrap(string, handle.getBytes());
    }

    public void clearScrap() {
        Clipboard.ZeroScrap();
        this.info = new ScrapInfo();
    }

    private static native void ZeroScrap();

    private static native int PutScrap(int var0, int var1, byte[] var2);
}

