/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.AEArrayDataPointer;
import com.apple.MacOS.AEDesc;
import com.apple.MacOS.MacOSError;
import com.apple.MacOS.ae;
import com.apple.memory.MemoryObject;
import com.apple.memory.StructObject;

public class AEDescList
extends AEDesc {
    public static final int kAEDataArray = 0;
    public static final int kAEPackedArray = 1;
    public static final int kAEHandleArray = 2;
    public static final int kAEDescArray = 3;
    public static final int kAEKeyDescArray = 4;

    public AEDescList() {
    }

    public AEDescList(AEDesc aEDesc) {
        super(aEDesc);
    }

    protected AEDescList(MemoryObject memoryObject) {
        super(memoryObject);
    }

    public int countElements() {
        int[] nArray = new int[1];
        MacOSError.CheckResult(AEDescList.AECountItems(this, nArray));
        return nArray[0];
    }

    public AEDesc getElement(int n, int n2) {
        int[] nArray = new int[1];
        AEDesc aEDesc = new AEDesc();
        MacOSError.CheckResult(AEDescList.AEGetNthDesc(this, n, n2, nArray, aEDesc));
        return aEDesc;
    }

    public AEDesc getElement(int n) {
        return this.getElement(n, ae.typeWildCard);
    }

    public void getElement(int n, int n2, byte[] byArray) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        MacOSError.CheckResult(AEDescList.AEGetNthPtr(this, n, n2, nArray, nArray2, byArray, byArray.length, nArray3));
    }

    public int getElementType(int n) {
        return this.getElement(n).getDescriptorType();
    }

    private final void Create() {
        MacOSError.CheckResult(AEDescList.AECreateList(0, 0, false, this));
    }

    public void putElement(int n, AEDesc aEDesc) {
        if (this.getDescriptorType() == ae.typeNull) {
            this.Create();
        }
        MacOSError.CheckResult(AEDescList.AEPutDesc(this, n, aEDesc));
    }

    public void putElement(int n, int n2, byte[] byArray) {
        if (this.getDescriptorType() == ae.typeNull) {
            this.Create();
        }
        MacOSError.CheckResult(AEDescList.AEPutPtr(this, n, n2, byArray, byArray.length));
    }

    public String asString() {
        String string = "";
        int n = this.countElements();
        int n2 = 1;
        while (n2 <= n) {
            try {
                String string2 = this.getElement(n2).toString();
                if (string2 != null) {
                    string = String.valueOf(string) + ", " + string2;
                }
            }
            catch (Error error) {}
            ++n2;
        }
        return string;
    }

    protected static native int AECreateList(int var0, int var1, boolean var2, AEDescList var3);

    protected static native int AECountItems(AEDescList var0, int[] var1);

    protected static native int AEPutPtr(AEDescList var0, int var1, int var2, byte[] var3, int var4);

    protected static native int AEPutDesc(AEDescList var0, int var1, AEDesc var2);

    protected static native int AEGetNthPtr(AEDescList var0, int var1, int var2, int[] var3, int[] var4, byte[] var5, int var6, int[] var7);

    protected static native int AEGetNthPtr(AEDescList var0, int var1, int var2, int[] var3, int[] var4, StructObject var5, int var6, int[] var7);

    protected static native int AEGetNthDesc(AEDescList var0, int var1, int var2, int[] var3, AEDesc var4);

    protected static native int AESizeOfNthItem(AEDescList var0, int var1, int[] var2, int[] var3);

    protected static native int AEGetArray(AEDescList var0, int var1, AEArrayDataPointer var2, int var3, int[] var4, int[] var5, int[] var6);

    protected static native int AEPutArray(AEDescList var0, int var1, AEArrayDataPointer var2, int var3, int var4, int var5);

    protected static native int AEDeleteItem(AEDescList var0, int var1);
}

