/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.utils;

import com.adobe.utils.CopyUtils;
import com.adobe.utils.InstanceList;
import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.CustomError;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.UninstallerProxy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Logger
extends CustomCodeAction {
    public static List<File> getFileListing(File aStartingDir) throws FileNotFoundException {
        Logger.validateDirectory(aStartingDir);
        List<File> result = Logger.getFileListingNoSort(aStartingDir);
        Collections.sort(result);
        return result;
    }

    private static List<File> getFileListingNoSort(File aStartingDir) throws FileNotFoundException {
        ArrayList<File> result = new ArrayList<File>();
        String osName = System.getProperty("os.name").toLowerCase();
        IOFileFilter filter = null;
        File[] filesAndDirs = null;
        String suffixesToExclude = installerProxy.substitute("$DO_NOT_INSTALL_FILELIST_SUFFIX$");
        if (suffixesToExclude != null && !suffixesToExclude.equals("") && osName != null && (osName.contains("sunos") || osName.contains("solaris"))) {
            filter = FileFilterUtils.suffixFileFilter(suffixesToExclude);
            filesAndDirs = aStartingDir.listFiles(filter);
            for (int i = 0; i < filesAndDirs.length; ++i) {
                FileUtils.deleteQuietly(filesAndDirs[i]);
            }
        }
        filesAndDirs = aStartingDir.listFiles();
        List<File> filesDirs = Arrays.asList(filesAndDirs);
        for (File file : filesDirs) {
            result.add(file);
            if (file.isFile()) continue;
            List<File> deeperList = Logger.getFileListingNoSort(file);
            result.addAll(deeperList);
        }
        return result;
    }

    private static void validateDirectory(File aDirectory) throws FileNotFoundException {
        if (aDirectory == null) {
            throw new IllegalArgumentException("Directory should not be null.");
        }
        if (!aDirectory.exists()) {
            throw new FileNotFoundException("Directory does not exist: " + aDirectory);
        }
        if (!aDirectory.isDirectory()) {
            throw new IllegalArgumentException("Is not a directory: " + aDirectory);
        }
        if (!aDirectory.canRead()) {
            throw new IllegalArgumentException("Directory cannot be read: " + aDirectory);
        }
    }

    @Override
    public String getInstallStatusMessage() {
        return null;
    }

    @Override
    public String getUninstallStatusMessage() {
        return null;
    }

    @Override
    public void install(InstallerProxy arg0) throws InstallException {
        Map<Object, Object> instMap = null;
        String osName = System.getProperty("os.name").toLowerCase();
        String installerType = installerProxy.substitute("$INSTALLER_TYPE_1$");
        String j2eeConst = installerProxy.substitute("$J2EE_CONST$");
        String cfInstRoot = installerProxy.substitute("$CF_INSTANCE_ROOT$");
        String defaultInstName = installerProxy.substitute("$CF_DEF_INST_NAME$");
        Boolean isSolrUpdated = false;
        if (j2eeConst.equals(installerType)) {
            instMap = new HashMap<String, String>();
            instMap.put(defaultInstName, cfInstRoot);
        } else {
            String servInstXML = installerProxy.substitute("$SERVER_INST_XML$");
            instMap = InstanceList.getInst(servInstXML);
        }
        String distPath = installerProxy.substitute("$INSTALLER_DATA_DIR$");
        String instList = installerProxy.substitute("$INSTANCE_LIST$");
        StringTokenizer instTokens = new StringTokenizer(instList, ",");
        while (instTokens.hasMoreTokens()) {
            String instanceName = instTokens.nextToken();
            String currentInstRoot = (String)instMap.get(instanceName);
            String destUpdatesHotFix = installerProxy.substitute("$UPDATES_HOTFIX$");
            String destDocrootHotFix = installerProxy.substitute("$DOC_ROOT$");
            String destLibHotFix = installerProxy.substitute("$LIB_HOTFIX$");
            String destCfSetupHotFix = installerProxy.substitute("$CFSETUP_HOTFIX$");
            String destUpdatesFile = installerProxy.substitute("$DEST_UPDATES_FILE$");
            String destUpdatesDir = installerProxy.substitute("$INSTALL_UPDATES_DIR$");
            String hotfixFile = installerProxy.substitute("$INSTALL_LOG_FILE$");
            String hotfixBackUpDirS = installerProxy.substitute("$USER_MAGIC_FOLDER_5$");
            String hotfixWebRootBackUpDirS = installerProxy.substitute("$WEBROOT_BACKUP_DIR$");
            String hotfixCfsetupBackUpDirS = installerProxy.substitute("$CFSETUP_BACKUP_DIR$");
            destUpdatesHotFix = destUpdatesHotFix.replace(cfInstRoot, currentInstRoot);
            destDocrootHotFix = destDocrootHotFix.replace(cfInstRoot, currentInstRoot);
            destLibHotFix = destLibHotFix.replace(cfInstRoot, currentInstRoot);
            hotfixBackUpDirS = hotfixBackUpDirS.replace(cfInstRoot, currentInstRoot);
            hotfixFile = hotfixFile.replace(cfInstRoot, currentInstRoot);
            try {
                String curntUpdatesBackupFilePath;
                String jettyPathServerConfigured;
                StringTokenizer filesForDel;
                FileWriter filewrite;
                List<File> files;
                block53: {
                    File hotfixBackupDirF = new File(hotfixBackUpDirS);
                    CopyUtils.deleteDir(hotfixBackUpDirS, installerProxy);
                    FileUtils.forceMkdir(hotfixBackupDirF);
                    File startingDirectory = new File(distPath);
                    files = Logger.getFileListing(startingDirectory);
                    File hotfixLog = new File(hotfixFile);
                    filewrite = new FileWriter(hotfixLog);
                    File updatesDirectory = new File(destUpdatesHotFix);
                    List<File> updatesFiles = Logger.getFileListing(updatesDirectory);
                    for (File file : updatesFiles) {
                        String filePath;
                        String curntUpdatesBackupFilePath2;
                        if (!file.isFile() || new File(curntUpdatesBackupFilePath2 = (filePath = file.toString()).replace(currentInstRoot, hotfixBackUpDirS)).exists()) continue;
                        CopyUtils.moveFileToNewFilePath(filePath, curntUpdatesBackupFilePath2, installerProxy);
                        filewrite.write("Removed:\t" + filePath + "\r\n");
                    }
                    String filesForDelList = installerProxy.substitute("$DELETE_FILES_LIB$");
                    filesForDel = new StringTokenizer(filesForDelList, ",");
                    jettyPathServerConfigured = "";
                    if (instanceName.equalsIgnoreCase("cfusion")) {
                        String neoSolrXmlPath = currentInstRoot + "/lib/neo-solr.xml";
                        try {
                            File fXmlFile = new File(neoSolrXmlPath);
                            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                            Document doc = dBuilder.parse(fXmlFile);
                            doc.getDocumentElement().normalize();
                            NodeList nList = doc.getElementsByTagName("string");
                            if (nList.getLength() < 1) break block53;
                            for (int temp = 0; temp < nList.getLength(); ++temp) {
                                Node nNode = nList.item(temp);
                                String nodeContent = nNode.getTextContent();
                                if (nodeContent == null || !nodeContent.contains("multicore")) continue;
                                jettyPathServerConfigured = new File(nodeContent).getParent();
                                if (jettyPathServerConfigured != null && jettyPathServerConfigured.length() > 0 && new File(jettyPathServerConfigured).exists()) {
                                    installerProxy.setVariable("$JETTY_PATH$", jettyPathServerConfigured);
                                    break;
                                }
                                jettyPathServerConfigured = "";
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                while (filesForDel.hasMoreTokens()) {
                    String fileForDelToken = filesForDel.nextToken();
                    Object filePath = currentInstRoot + fileForDelToken;
                    String filePathInstance = currentInstRoot + fileForDelToken;
                    if (instanceName.equalsIgnoreCase("cfusion") && (((String)filePath).contains("\\jetty\\") || ((String)filePath).contains("/jetty/")) && jettyPathServerConfigured != null && jettyPathServerConfigured.length() > 0 && new File(jettyPathServerConfigured).exists()) {
                        filePath = ((String)filePath).replace(currentInstRoot + "/jetty", jettyPathServerConfigured);
                    }
                    if (new File((String)filePath).exists()) {
                        filewrite.write("Removed:\t" + (String)filePath + "\r\n");
                    }
                    if (new File(curntUpdatesBackupFilePath = filePathInstance.replace(currentInstRoot, hotfixBackUpDirS)).exists() || ((String)filePath).endsWith(".dll") && !osName.contains("windows")) continue;
                    if (new File((String)filePath).isFile()) {
                        CopyUtils.moveFileToNewFilePath((String)filePath, curntUpdatesBackupFilePath, installerProxy);
                        continue;
                    }
                    CopyUtils.moveFilesToFolder((String)filePath, curntUpdatesBackupFilePath, installerProxy);
                }
                String webFilesFordelList = installerProxy.substitute("$DELETE_FILES_WROOT$");
                StringTokenizer webFilesForDel = new StringTokenizer(webFilesFordelList, ",");
                while (webFilesForDel.hasMoreTokens()) {
                    String filePath = destDocrootHotFix + webFilesForDel.nextToken();
                    curntUpdatesBackupFilePath = filePath.replace(destDocrootHotFix, hotfixWebRootBackUpDirS);
                    if (!new File(curntUpdatesBackupFilePath).exists()) {
                        CopyUtils.moveFileToNewFilePath(filePath, curntUpdatesBackupFilePath, installerProxy);
                    }
                    filewrite.write("Removed:\t" + filePath + "\r\n");
                }
                String webDirsForDelList = installerProxy.substitute("$DELETE_DIRS_WROOT$");
                StringTokenizer webDirsForDel = new StringTokenizer(webDirsForDelList, ",");
                while (webDirsForDel.hasMoreTokens()) {
                    String filePath = destDocrootHotFix + webDirsForDel.nextToken();
                    String curntUpdatesBackupFilePath3 = filePath.replace(destDocrootHotFix, hotfixWebRootBackUpDirS);
                    CopyUtils.moveFilesToFolder(filePath, curntUpdatesBackupFilePath3, installerProxy);
                    filewrite.write("Removed:\t" + filePath + "\r\n");
                }
                Boolean doNotBackup = false;
                for (File file : files) {
                    String curntBackupFilePath;
                    String filePath;
                    block54: {
                        block57: {
                            block55: {
                                block56: {
                                    String distDataDir;
                                    String wwwrootBackupPath;
                                    doNotBackup = false;
                                    if (!file.isFile()) continue;
                                    filePath = file.toString();
                                    if (filePath.contains("updates") && !filePath.contains("CFIDE")) {
                                        filePath = filePath.replace(installerProxy.substitute("$UPDATES_DATA_DIR$"), destUpdatesHotFix);
                                    } else if (filePath.contains("cfusion")) {
                                        filePath = filePath.replace(installerProxy.substitute("$CFUSION_DATA_DIR$"), destLibHotFix);
                                    } else if (filePath.contains("config" + File.separatorChar + "cfsetup")) {
                                        String cfSetupBackupPath;
                                        if (instanceName.equals(defaultInstName) && !new File(cfSetupBackupPath = (filePath = filePath.replace(installerProxy.substitute("$CFSETUP_DATA_DIR$"), destCfSetupHotFix)).replace(destCfSetupHotFix, hotfixCfsetupBackUpDirS)).exists()) {
                                            CopyUtils.copyFile(filePath, cfSetupBackupPath, installerProxy);
                                        }
                                    } else if (filePath.contains("wwwroot") && !new File(wwwrootBackupPath = (filePath = filePath.replace(distDataDir = installerProxy.substitute("$DOC_DATA_DIR$"), destDocrootHotFix)).replace(destDocrootHotFix, hotfixWebRootBackUpDirS)).exists()) {
                                        CopyUtils.copyFile(filePath, wwwrootBackupPath, installerProxy);
                                    }
                                    curntBackupFilePath = filePath.replace(currentInstRoot, hotfixBackUpDirS);
                                    if (!instanceName.equalsIgnoreCase("cfusion") || !filePath.contains("\\jetty\\") && !filePath.contains("/jetty/")) break block54;
                                    if (!instanceName.equalsIgnoreCase("cfusion") || jettyPathServerConfigured == null || jettyPathServerConfigured.length() <= 0 || !new File(jettyPathServerConfigured).exists()) break block55;
                                    if (filePath.contains("webapps" + File.separator + "solr.war") || filePath.contains("solr" + File.separator + "solr.xml")) break block56;
                                    if (!filePath.contains("template" + File.separator + "conf" + File.separator + "schema.xml")) break block57;
                                }
                                String SolrInstalledVersion = Logger.getSolrWarVersion(currentInstRoot + File.separator + "jetty" + File.separator + "webapps" + File.separator + "solr.war");
                                String SolrHFVersion = Logger.getSolrWarVersion(installerProxy.substitute("$CFUSION_DATA_DIR$") + File.separator + "jetty" + File.separator + "webapps" + File.separator + "solr.war");
                                if (Logger.versionCompare(SolrInstalledVersion, SolrHFVersion) > 0) {
                                    if (!isSolrUpdated.booleanValue()) {
                                        isSolrUpdated = true;
                                        this.logMessage("New Solr Version detected.", "Skipping Solr update.", installerProxy);
                                    }
                                    doNotBackup = true;
                                }
                                break block57;
                            }
                            doNotBackup = true;
                        }
                        if (doNotBackup.booleanValue()) {
                            filePath = filePath.replace(destLibHotFix, installerProxy.substitute("$CFUSION_DATA_DIR$"));
                            CopyUtils.deleteFile(filePath, installerProxy);
                        } else {
                            filePath = filePath.replace(currentInstRoot + File.separator + "jetty", jettyPathServerConfigured);
                        }
                    }
                    if (filePath.contains("cfinstall.jar")) {
                        doNotBackup = true;
                    }
                    if (!(filePath.contentEquals(curntBackupFilePath) || new File(curntBackupFilePath).exists() || doNotBackup.booleanValue())) {
                        CopyUtils.copyFile(filePath, curntBackupFilePath, installerProxy);
                    }
                    if (new File(filePath).exists()) {
                        filewrite.write("Modified:\t" + filePath + "\r\n");
                        continue;
                    }
                    if (doNotBackup.booleanValue()) continue;
                    filewrite.write("Added:\t" + filePath + "\r\n");
                }
                if (jettyPathServerConfigured == "") {
                    String jettyPathOnHotfix = installerProxy.substitute("$CFUSION_DATA_DIR$") + File.separator + "jetty";
                    CopyUtils.deleteDir(jettyPathOnHotfix, installerProxy);
                }
                filewrite.flush();
                filewrite.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (installerProxy.substitute("$HOTFIX_APIMANAGER$").equals("true") && installerProxy.substitute("$APIMANAGER_EXISTS$").equals("true")) {
            try {
                Object filePath;
                String apiManagerInstHomePath = installerProxy.substitute("$APIMANAGER_PATH$");
                apiManagerInstHomePath = new File(apiManagerInstHomePath).getCanonicalPath();
                String apiManagerBackUpPathHome = installerProxy.substitute("$APIMANAGER_BACKUP_PATH$");
                apiManagerBackUpPathHome = new File(apiManagerBackUpPathHome).getCanonicalPath();
                String apiMgrBackUpDirNameRelatHome = installerProxy.substitute("$APIMANAGER_BACKUP_DIRNAME$");
                String apiManagerInstFilesSrcPath = installerProxy.substitute("$APIMANAGER_DATA_DIR$");
                apiManagerInstFilesSrcPath = new File(apiManagerInstFilesSrcPath).getCanonicalPath();
                String logFile = apiManagerBackUpPathHome + "/hotfix_filelist.log";
                String apimanagerUpdatesPath = apiManagerInstHomePath + "/lib/updates";
                File apiMgrBackupPathHomeF = new File(apiManagerBackUpPathHome);
                if (apiMgrBackupPathHomeF.exists()) {
                    CopyUtils.deleteDir(apiManagerBackUpPathHome, installerProxy);
                }
                apiMgrBackupPathHomeF.mkdirs();
                FileWriter apifilewrite = new FileWriter(logFile);
                File startingDirectoryUpds = new File(apimanagerUpdatesPath);
                List<File> updateDirfiles = null;
                try {
                    updateDirfiles = Logger.getFileListing(startingDirectoryUpds);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                for (File file : updateDirfiles) {
                    String filePath2 = file.toString();
                    String backup = filePath2.replace(apiManagerInstHomePath, apiManagerBackUpPathHome);
                    if (!file.isFile()) continue;
                    CopyUtils.moveFileToNewFilePath(filePath2, backup, installerProxy);
                    apifilewrite.write("Removed:\t" + filePath2 + "\r\n");
                }
                File startingDirectory = new File(apiManagerInstFilesSrcPath);
                List<File> files = null;
                try {
                    files = Logger.getFileListing(startingDirectory);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                if (files != null) {
                    for (File file : files) {
                        filePath = file.toString();
                        if (!file.isFile()) continue;
                        String apiInstallFilePath = ((String)filePath).replace(apiManagerInstFilesSrcPath, apiManagerInstHomePath);
                        String apiMgrBackUpFilePath = apiInstallFilePath.replace(apiManagerInstHomePath, apiManagerBackUpPathHome);
                        if (apiInstallFilePath.contains("updates")) {
                            CopyUtils.moveFileToNewFilePath(apiInstallFilePath, apiMgrBackUpFilePath, installerProxy);
                            if (new File(apiInstallFilePath).exists()) {
                                apifilewrite.write("Modified:\t" + apiInstallFilePath + "\r\n");
                                continue;
                            }
                            apifilewrite.write("Added:\t" + apiInstallFilePath + "\r\n");
                            continue;
                        }
                        CopyUtils.copyFile(apiInstallFilePath, apiMgrBackUpFilePath, installerProxy);
                        if (new File(apiInstallFilePath).exists()) {
                            apifilewrite.write("Modified:\t" + apiInstallFilePath + "\r\n");
                            continue;
                        }
                        apifilewrite.write("Added:\t" + apiInstallFilePath + "\r\n");
                    }
                }
                String filesForDelListApi = installerProxy.substitute("$DELETE_FILES_LIB_APIM$");
                StringTokenizer filesForDelApi = new StringTokenizer(filesForDelListApi, ",");
                while (filesForDelApi.hasMoreTokens()) {
                    filePath = apiManagerInstHomePath + filesForDelApi.nextToken();
                    String curntUpdatesBackupFilePath = ((String)filePath).replace(apiManagerInstHomePath, apiManagerBackUpPathHome);
                    if (new File(curntUpdatesBackupFilePath).exists()) continue;
                    CopyUtils.moveFileToNewFilePath((String)filePath, curntUpdatesBackupFilePath, installerProxy);
                    apifilewrite.write("Removed:\t" + (String)filePath + "\r\n");
                }
                apifilewrite.flush();
                apifilewrite.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void uninstall(UninstallerProxy arg0) throws InstallException {
    }

    public static String getSolrWarVersion(String solrWarPath) throws IOException {
        ZipFile zipFile = new ZipFile(solrWarPath);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        String version = null;
        while (enumeration.hasMoreElements()) {
            ZipEntry entry = enumeration.nextElement();
            Pattern p = Pattern.compile("WEB-INF/lib/solr-core-([\\d.]*)(?:-SNAPSHOT)?.jar");
            Matcher m = p.matcher(entry.getName());
            if (!m.matches()) continue;
            version = m.group(1);
            break;
        }
        zipFile.close();
        return version;
    }

    static int versionCompare(String v1, String v2) {
        int vnum1 = 0;
        int vnum2 = 0;
        int i = 0;
        for (int j = 0; i < v1.length() || j < v2.length(); ++i, ++j) {
            while (i < v1.length() && v1.charAt(i) != '.') {
                vnum1 = vnum1 * 10 + (v1.charAt(i) - 48);
                ++i;
            }
            while (j < v2.length() && v2.charAt(j) != '.') {
                vnum2 = vnum2 * 10 + (v2.charAt(j) - 48);
                ++j;
            }
            if (vnum1 > vnum2) {
                return 1;
            }
            if (vnum2 > vnum1) {
                return -1;
            }
            vnum2 = 0;
            vnum1 = 0;
        }
        return 0;
    }

    public void logMessage(String profilesTitle, String profileName, InstallerProxy installerproxy) {
        CustomError customMsg = null;
        if (installerproxy != null) {
            customMsg = (CustomError)installerproxy.getService(CustomError.class);
        }
        if (customMsg != null) {
            customMsg.setLogDescription(profilesTitle);
            customMsg.appendMessage(profileName);
            customMsg.log();
        }
    }
}

