/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.scheduling.mod;

import coldfusion.centralconfig.client.CentralConfigClientUtil;
import coldfusion.featurerouter.EFRConstants;
import coldfusion.featurerouter.FeatureRouter;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.osgi.services.CronService;
import coldfusion.osgi.services.ServiceException;
import coldfusion.osgi.to.ScheduleTagTO;
import coldfusion.runtime.Cast;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.scheduling.SchedulingNoSuchTaskException;
import coldfusion.scheduling.mod.CronListener;
import coldfusion.scheduling.mod.CronUtil;
import coldfusion.scheduling.mod.ScheduleTagData;
import coldfusion.security.ESAPIUtils;
import coldfusion.server.ConfigMap;
import coldfusion.server.SchedulerService;
import coldfusion.server.SecurityService;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.CFDataSource;
import coldfusion.sql.DataSourceDef;
import coldfusion.sql.DataSourceFactory;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.lang.ScheduleTag;
import coldfusion.util.PasswordUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.quartz.CronTrigger;
import org.quartz.DailyTimeIntervalTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.TriggerListener;
import org.quartz.TriggerUtils;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.OperableTrigger;

public class CronServiceImpl
extends ServiceBase
implements CronService,
Observer {
    protected Logger _schlogger = null;
    protected File _file;
    protected ConfigMap _main = null;
    protected ConfigMap _mainClustered = null;
    protected ConfigMap _props = null;
    protected SchedulerService _sscheduler = null;
    protected static boolean _logFlag = false;
    public static final String OLDSEEDVAL = "4p0L@r1$4p0L@r1$4p0L@r1$";
    private static String DSNAME = "dsname";
    private static String QUARTZ_PROPERTY_FILE = "quartz/quartz.properties";
    private static String QUARTZ_PROPERTY_FILE_CCS = "quartz.properties";
    private String seed;
    public static String dsname = "";
    public static String extensions;
    private static Scheduler cScheduler;
    private static Scheduler ncScheduler;
    private static final Map<String, String> DBNAMEMAP;
    private static final Set<String> SUPPORTED_CLUSTER_DBS;

    public CronServiceImpl(File file) throws ServiceException {
        this._file = file;
        this._props = new ConfigMap();
        this._schlogger = ServiceFactory.getLoggingService().getLogger("coldfusion.scheduler");
        if (ServiceFactory.getRuntimeService().isCommandLineCompile()) {
            this._schlogger.setLoggingEnabled(false);
        }
    }

    public void setLogFlag(boolean b) throws ServiceException {
        _logFlag = b;
        try {
            this.store();
        }
        catch (Exception ex) {
            CFLogs.SCHEDULER_LOG.error((Throwable)ex);
            throw new ServiceException((Throwable)ex);
        }
    }

    public boolean getLogFlag() {
        return _logFlag;
    }

    public void start() {
        try {
            super.start();
        }
        catch (coldfusion.server.ServiceException e) {
            e.printStackTrace();
        }
        try {
            PasswordUtils.getInstance().addObserver((Observer)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void load() {
        try {
            Vector v = (Vector)this.deserialize(this._file);
            ConfigMap map = (ConfigMap)v.elementAt(0);
            this.deleteTasks();
            Boolean flag = (Boolean)v.elementAt(1);
            _logFlag = flag == null ? false : flag;
            File fileLocal = new File(ServiceFactory.getRuntimeService().getLibDir() + "/" + QUARTZ_PROPERTY_FILE);
            File fileCCS = CentralConfigClientUtil.pullFromCCSFile((String)QUARTZ_PROPERTY_FILE_CCS);
            if (fileCCS != null) {
                fileLocal = fileCCS;
            }
            final File f = fileLocal;
            final Properties prop = new Properties();
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws FileNotFoundException, IOException {
                    if (f.exists()) {
                        prop.load(new FileInputStream(f));
                    }
                    return null;
                }
            });
            if (prop.containsKey(DSNAME)) {
                dsname = prop.getProperty(DSNAME);
            }
            if ((dsname == null || dsname.length() == 0) && v.size() > 2) {
                dsname = (String)v.elementAt(2);
            }
            if (null != dsname && dsname.length() > 0) {
                try {
                    cScheduler = CronServiceImpl.getScheduler(true);
                }
                catch (Throwable e) {
                    CFLogs.SCHEDULER_LOG.error(e);
                }
            }
            if (v.size() > 3 && (null == (extensions = (String)v.elementAt(3)) || extensions.length() == 0)) {
                extensions = "txt,log";
            }
            ncScheduler = CronServiceImpl.getScheduler(false);
            this._main = new ConfigMap();
            this._mainClustered = new ConfigMap();
            this.updateTasks(map);
        }
        catch (Exception e) {
            CFLogs.SCHEDULER_LOG.error((Throwable)e);
        }
    }

    public void stop() {
        try {
            super.stop();
        }
        catch (coldfusion.server.ServiceException e1) {
            e1.printStackTrace();
        }
        try {
            if (null != cScheduler) {
                cScheduler.shutdown();
            }
            if (null != ncScheduler) {
                ncScheduler.shutdown();
            }
        }
        catch (Exception e) {
            CFLogs.SCHEDULER_LOG.error((Throwable)e);
        }
    }

    public void updateTasks(List<ScheduleTagTO> list) throws ServiceException {
        try {
            ScheduleTagData cte = null;
            this.pauseScheduler();
            for (ScheduleTagTO to : list) {
                try {
                    Map tmap = this.getScheduleTagDataAsMap(to);
                    cte = new ScheduleTagData(tmap, _logFlag, this.seed);
                    cte.shouldNotMisfire = true;
                    this.createTask(cte);
                    String groupname = CronUtil.stringNullCheck(cte.getGroup()) ? "DEFAULT" : cte.getGroup();
                    String uniquekey = cte.getAppname() + CronUtil.getTasknameDelimiter() + groupname + CronUtil.getTasknameDelimiter() + cte.getTask();
                    this._main.put((Object)uniquekey, (Object)cte);
                    if (!cte.getStatus().equals("Paused")) continue;
                    this.pauseTask(cte.getTask(), cte.getGroup(), cte.getMode(), false);
                }
                catch (Exception ex) {
                    CFLogs.SCHEDULER_LOG.error((Throwable)ex);
                }
            }
            this.resumeScheduler();
            this.store();
            this.loadClusteredTasks();
        }
        catch (Exception ex) {
            CFLogs.SCHEDULER_LOG.error((Throwable)ex);
            throw new ServiceException((Throwable)ex);
        }
    }

    public void updateTasks(ConfigMap map) throws ServiceException {
        try {
            Enumeration enu = map.elements();
            ScheduleTagData cte = null;
            this.pauseScheduler();
            while (enu.hasMoreElements()) {
                try {
                    Map tmap = (Map)enu.nextElement();
                    cte = new ScheduleTagData(tmap, _logFlag, this.seed);
                    cte.shouldNotMisfire = true;
                    this.createTask(cte);
                    String groupname = CronUtil.stringNullCheck(cte.getGroup()) ? "DEFAULT" : cte.getGroup();
                    String uniquekey = cte.getAppname() + CronUtil.getTasknameDelimiter() + groupname + CronUtil.getTasknameDelimiter() + cte.getTask();
                    this._main.put((Object)uniquekey, (Object)cte, false);
                    if (!cte.getStatus().equals("Paused")) continue;
                    this.pauseTask(cte.getTask(), cte.getGroup(), cte.getMode(), false);
                }
                catch (Exception ex) {
                    CFLogs.SCHEDULER_LOG.error((Throwable)ex);
                }
            }
            this.resumeScheduler();
            this.store();
            this.loadClusteredTasks();
        }
        catch (Exception ex) {
            CFLogs.SCHEDULER_LOG.error((Throwable)ex);
            throw new ServiceException((Throwable)ex);
        }
    }

    private Map getScheduleTagDataAsMap(ScheduleTagTO to) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("task", to.getTask());
        map.put("group", to.getGroup());
        map.put("mode", to.getMode());
        map.put("url", to.getUrl());
        map.put("file", to.getFile());
        map.put("path", to.getPath());
        map.put("publish", to.isPublish());
        map.put("start_date", to.getStartdate());
        map.put("exclude", to.getExclude());
        map.put("chained", to.isChained());
        map.put("crontime", to.getCrontime());
        map.put("end_date", to.getEnddate());
        map.put("end_time", to.getEndtime());
        map.put("eventhandler", to.getEventhandler());
        map.put("interval", to.getInterval());
        map.put("last_fire", to.getLastfire());
        map.put("onmisfire", to.getMisfire());
        map.put("onexception", to.getOnexception());
        map.put("overwrite", to.getOverwrite());
        map.put("start_time", to.getStarttime());
        map.put("retrycount", to.getRetrycount());
        map.put("repeat", to.getRepeat());
        map.put("remainingcount", to.getRemainingCount());
        map.put("resolveurl", to.isResolveUrl());
        map.put("priority", to.getPriority());
        map.put("proxy_password", to.getProxypassword());
        map.put("http_proxy_port", to.getProxyport());
        map.put("proxy_server", to.getProxyserver());
        map.put("proxy_user", to.getProxyuser());
        map.put("username", to.getUsername());
        map.put("password", to.getPassword());
        map.put("clustered", to.isClustered());
        map.put("eventhandler", to.getEventhandler());
        map.put("http_port", to.getPort());
        map.put("oncomplete", to.getChianedtasks());
        map.put("request_time_out", to.getRequestTimeOut());
        map.put("eventhandlerrp", to.getEventhandlerrp());
        map.put("status", to.getStatus());
        return map;
    }

    private void loadClusteredTasks() throws Exception {
        Scheduler csched = null;
        try {
            csched = CronServiceImpl.getSchedulerInstance(true);
        }
        catch (Exception exc) {
            return;
        }
        List groups = csched.getJobGroupNames();
        for (String group : groups) {
            Set jobs = csched.getJobKeys(GroupMatcher.jobGroupContains((String)group));
            for (JobKey j : jobs) {
                JobDetail detail = csched.getJobDetail(j);
                ScheduleTagData std = (ScheduleTagData)((Object)detail.getJobDataMap().get((Object)"metadata"));
                this._mainClustered.put((Object)(std.getAppname() + CronUtil.getTasknameDelimiter() + std.getGroupName() + CronUtil.getTasknameDelimiter() + std.getTask()), (Object)std);
            }
        }
    }

    public void ramToJdbcMigration(String task, String group, String mode) {
        Scheduler cSched = CronServiceImpl.getSchedulerInstance(true);
        try {
            ScheduleTagData metadata = this.findTask2(task, group, mode);
            metadata.setClustered(true);
            this.deleteTask(task, group, mode);
            cSched.scheduleJob(metadata.getJobdetail(), metadata.getTrigger());
        }
        catch (SchedulerException ex) {
            CFLogs.SCHEDULER_LOG.error((Throwable)ex);
        }
        catch (ServiceException ex) {
            CFLogs.SCHEDULER_LOG.error((Throwable)ex);
        }
    }

    public void createTablesForCluster() throws Exception {
        CFDataSource datasource = CronServiceImpl.getDatasource();
        String dbtype = datasource.getConnection().getMetaData().getDatabaseProductName();
        String type = DBNAMEMAP.get(dbtype);
        this.executeSqlFile(ServiceFactory.getRuntimeService().getLibDir() + "/quartz/scripts/tables_" + type + ".sql", datasource.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSqlFile(String path, Connection con) throws Exception {
        File file = new File(path);
        BufferedReader bis = null;
        try {
            String line;
            bis = new BufferedReader(new FileReader(file));
            StringBuffer sb = new StringBuffer();
            while ((line = bis.readLine()) != null) {
                sb.append(line);
            }
            String[] splits = sb.toString().split(";");
            Statement st = con.createStatement();
            for (int i = 0; i < splits.length; ++i) {
                if (splits[i].trim().equals("")) continue;
                try {
                    st.executeUpdate(splits[i]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            if (null != bis) {
                bis.close();
            }
        }
    }

    private static CFDataSource getDatasource() throws Exception {
        Class[] paramclass = new Class[]{String.class};
        Method m = DataSourceFactory.getInstance().getClass().getDeclaredMethod("getDataSource", paramclass);
        m.setAccessible(true);
        Object[] params = new Object[]{dsname};
        CFDataSource datasource = (CFDataSource)m.invoke((Object)DataSourceFactory.getInstance(), params);
        m.setAccessible(false);
        return datasource;
    }

    public void store() {
        Vector<Object> v = new Vector<Object>();
        v.addElement(this._main);
        v.addElement(_logFlag ? Boolean.TRUE : Boolean.FALSE);
        v.addElement(dsname);
        v.addElement(extensions);
        try {
            this.serialize(v, this._file, false);
        }
        catch (RuntimeServiceImpl.FileNotFoundException fne) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.serialize(v, this._file, false);
        }
    }

    public void saveCronEntries() {
        this.store();
    }

    public List listAll() {
        ArrayList<? extends ScheduleTagData> list = new ArrayList<ScheduleTagData>();
        list.addAll(this._listAll(this._main));
        try {
            list.addAll(this._listAllClustered());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    private List<? extends ScheduleTagData> _listAllClustered() throws SchedulerException {
        ArrayList<ScheduleTagData> newlist = new ArrayList<ScheduleTagData>();
        Scheduler csched = CronServiceImpl.getSchedulerInstance(true);
        List groups = csched.getJobGroupNames();
        JobDetail job = null;
        for (String group : groups) {
            Set jobs = csched.getJobKeys(GroupMatcher.jobGroupContains((String)group));
            for (JobKey j : jobs) {
                job = csched.getJobDetail(j);
                ScheduleTagData tagdata = (ScheduleTagData)((Object)job.getJobDataMap().get((Object)"metadata"));
                try {
                    if (!this.isAccessAllowed(tagdata)) continue;
                    this.setOtherAttributes(tagdata, csched);
                    newlist.add(tagdata);
                }
                catch (Exception exception) {}
            }
        }
        return newlist;
    }

    public List _listAll(ConfigMap map) {
        ArrayList list = new ArrayList(map.values());
        ArrayList<ScheduleTagData> newlist = new ArrayList<ScheduleTagData>();
        for (ScheduleTagData std : list) {
            if (!this.isAccessAllowed(std)) continue;
            Scheduler sched = CronServiceImpl.getSchedulerInstance(std.isClustered());
            try {
                this.setOtherAttributes(std, sched);
                newlist.add(std);
            }
            catch (SchedulerException ex) {
                CFLogs.SCHEDULER_LOG.error((Throwable)ex);
            }
        }
        return newlist;
    }

    private boolean isAccessAllowed(ScheduleTagData std) {
        boolean isAdmin;
        if (std.getTask().toLowerCase().startsWith("cfprobe___")) {
            return false;
        }
        String appname = CronUtil.getApplicationName();
        boolean bl = isAdmin = FusionContext.getCurrent() != null && ServiceFactory.getSecurityService().isAdminUser();
        return std.getMode().equalsIgnoreCase("server") || std.getAppname().equalsIgnoreCase(appname) || isAdmin;
    }

    private void setOtherAttributes(ScheduleTagData std, Scheduler sched) throws SchedulerException {
        Trigger trig = sched.getTrigger(this.triggerKey(CronUtil.getTriggername(std.getTask()), CronUtil.getFullGroupName(std.getGroup(), std.getAppname())));
        Object remainingCount = "0";
        if (null != trig) {
            List x;
            Date d;
            Date enddate = trig.getEndTime();
            int repeat = 0;
            if (trig instanceof SimpleTrigger) {
                repeat = ((SimpleTrigger)trig).getRepeatCount();
            } else if (trig instanceof DailyTimeIntervalTrigger) {
                repeat = ((DailyTimeIntervalTrigger)trig).getRepeatCount();
            } else if (trig instanceof CronTrigger && null == (d = ((CronTrigger)trig).getEndTime())) {
                repeat = -1;
            }
            remainingCount = repeat == -1 && enddate == null ? "Infinite" : ((x = TriggerUtils.computeFireTimes((OperableTrigger)((OperableTrigger)trig), null, (int)100)).size() == 100 ? "100+" : "" + x.size());
            Date lastfire = trig.getPreviousFireTime();
            std.setLastfire(lastfire);
            Date nextfire = trig.getNextFireTime();
            std.setNextfire(nextfire);
            std.setLastfire(lastfire);
            if (nextfire == null) {
                std.setStatus("Expired");
                if (std.getMode().equalsIgnoreCase("server")) {
                    remainingCount = "0";
                }
            }
            if (std.getStarttime() == null) {
                std.setStarttime(trig.getStartTime());
            }
            if (std.getEndtime() == null) {
                std.setEndtime(trig.getEndTime());
            }
        } else if (!(null != trig && null != std.getNextfire() || std.isChained())) {
            std.setStatus("Expired");
            std.setNextfire(null);
        }
        std.setRemainingCount((String)remainingCount);
        if (null == std.getGroup() || std.getGroup().equals("")) {
            std.setGroup("DEFAULT");
        }
        if (null != std.getTrigger() && sched.getTriggerState(std.getTrigger().getKey()) == Trigger.TriggerState.PAUSED) {
            std.setStatus("Paused");
        }
        if ("0".equals(std.getInterval())) {
            std.setInterval("ONCE");
        }
    }

    private TriggerKey triggerKey(String triggername, String fullGroupName) {
        return new TriggerKey(triggername, fullGroupName);
    }

    public QueryTable listTasks(String task, String group, String mode) throws ServiceException {
        List<Object> tasksdata = null;
        if (null != task) {
            tasksdata = new ArrayList();
            for (String t : task.split(",")) {
                ScheduleTagData data = this.findTask2(t, group, mode);
                if (null == data) continue;
                try {
                    this.setOtherAttributes(data, CronServiceImpl.getSchedulerInstance(data.isClustered()));
                    tasksdata.add((Object)data);
                }
                catch (SchedulerException ex) {
                    CFLogs.SCHEDULER_LOG.error((Throwable)ex);
                }
            }
        } else {
            tasksdata = group != null ? this.listAllTasksByGroups2().get(CronUtil.getFullGroupName(group, mode)) : this.listAll();
        }
        String[] columnnames = new String[]{"task".toUpperCase(), "group".toUpperCase(), "mode".toUpperCase(), "INTERVAL", "EXCLUDE", "ONCOMPLETE", "CRONTIME", "ENDDATE", "ENDTIME", "STARTDATE", "STARTTIME", "EVENTHANDLER", "ONEXCEPTION", "ONMISFIRE", "REPEAT", "STATUS", "url".toUpperCase(), "clustered".toUpperCase(), "LASTFIRE", "PRIORITY", "REMAININGCOUNT", "OVERWRITE", "CHAINEDTASK", "FILE", "PATH", "PUBLISH", "RETRYCOUNT", "RESOLVEURL", "PROXYSERVER", "PROXYPORT", "PROXYUSER", "USERNAME", "PORT", "CLUSTER", "PROXYPASSWORD", "PASSWORD", "REQUESTTIMEOUT"};
        int colLength = columnnames.length;
        int[] columnTypes = new int[colLength];
        String[] columnTypeNames = new String[colLength];
        for (int j = 0; j < colLength; ++j) {
            columnTypes[j] = 12;
            columnTypeNames[j] = "VARCHAR";
        }
        int size = 0;
        ArrayList<ScheduleTagTO> tasksTO = new ArrayList<ScheduleTagTO>();
        if (null != tasksdata) {
            for (ScheduleTagData data : tasksdata) {
                if (!this.canListTask(data, mode)) continue;
                ++size;
                tasksTO.add(this.stdToTO(data));
            }
        }
        int row = 1;
        QueryTable resultQuery = new QueryTable(size, columnnames, columnTypeNames, columnTypes);
        if (null != tasksdata) {
            for (ScheduleTagData data : tasksdata) {
                if (!this.canListTask(data, mode)) continue;
                int col = 1;
                resultQuery.setField(row, col++, (Object)data.getTask());
                resultQuery.setField(row, col++, (Object)data.getGroup());
                resultQuery.setField(row, col++, (Object)data.getMode());
                resultQuery.setField(row, col++, (Object)data.getInterval());
                resultQuery.setField(row, col++, data.getExclude());
                resultQuery.setField(row, col++, (Object)data.getChianedtasks());
                resultQuery.setField(row, col++, (Object)data.getCrontime());
                resultQuery.setField(row, col++, (Object)data.getEnddate());
                resultQuery.setField(row, col++, (Object)data.getEndtime());
                resultQuery.setField(row, col++, (Object)data.getStartdate());
                resultQuery.setField(row, col++, (Object)data.getStarttime());
                resultQuery.setField(row, col++, (Object)data.getEventhandlerrp());
                resultQuery.setField(row, col++, (Object)data.getOnexception());
                resultQuery.setField(row, col++, (Object)data.getMisfire());
                resultQuery.setField(row, col++, (Object)data.getRepeat());
                resultQuery.setField(row, col++, (Object)data.getStatus());
                resultQuery.setField(row, col++, (Object)data.getUrl());
                resultQuery.setField(row, col++, (Object)data.isClustered());
                resultQuery.setField(row, col++, (Object)data.getLastfire());
                resultQuery.setField(row, col++, (Object)data.getPriority());
                resultQuery.setField(row, col++, (Object)data.getRemainingCount());
                resultQuery.setField(row, col++, (Object)data.getOverwrite());
                resultQuery.setField(row, col++, (Object)data.isChained());
                resultQuery.setField(row, col++, (Object)data.getFile());
                resultQuery.setField(row, col++, (Object)data.getPath());
                resultQuery.setField(row, col++, (Object)data.isPublish());
                resultQuery.setField(row, col++, (Object)data.getRetrycount());
                resultQuery.setField(row, col++, (Object)data.isResolveUrl());
                resultQuery.setField(row, col++, (Object)data.getProxyserver());
                resultQuery.setField(row, col++, (Object)data.getProxyport());
                resultQuery.setField(row, col++, (Object)data.getProxyuser());
                resultQuery.setField(row, col++, (Object)data.getUsername());
                resultQuery.setField(row, col++, (Object)data.getPort());
                resultQuery.setField(row, col++, (Object)data.isClustered());
                resultQuery.setField(row, col++, (Object)data.getProxypassword());
                resultQuery.setField(row, col++, (Object)data.getPassword());
                resultQuery.setField(row, col++, (Object)data.getReqtimeout());
                ++row;
            }
        }
        return resultQuery;
    }

    private boolean canListTask(ScheduleTagData data, String mode) {
        String m = data.getMode();
        return (!mode.equalsIgnoreCase("server") || m.equalsIgnoreCase("server")) && (!mode.equalsIgnoreCase("application") || !m.equalsIgnoreCase("server"));
    }

    public Map<String, List<ScheduleTagTO>> listAllTasksByGroups() {
        Map<String, List<ScheduleTagData>> map = this.listAllTasksByGroups2();
        HashMap<String, List<ScheduleTagTO>> fmap = new HashMap<String, List<ScheduleTagTO>>();
        for (Map.Entry<String, List<ScheduleTagData>> entry : map.entrySet()) {
            List<ScheduleTagData> stdlist = entry.getValue();
            ArrayList<ScheduleTagTO> tolist = new ArrayList<ScheduleTagTO>();
            for (ScheduleTagData std : stdlist) {
                tolist.add(this.stdToTO(std));
            }
            fmap.put(entry.getKey(), tolist);
        }
        return fmap;
    }

    public Map<String, List<ScheduleTagData>> listAllTasksByGroups2() {
        Scheduler sched = CronServiceImpl.getSchedulerInstance(false);
        ArrayList<ScheduleTagData> list = new ArrayList<ScheduleTagData>();
        TreeMap<String, List<ScheduleTagData>> map = new TreeMap<String, List<ScheduleTagData>>();
        try {
            List groups = sched.getJobGroupNames();
            for (String group : groups) {
                ArrayList<ScheduleTagData> innerlist = new ArrayList<ScheduleTagData>();
                Set jobnames = sched.getJobKeys(GroupMatcher.jobGroupEquals((String)group));
                for (JobKey key : jobnames) {
                    JobDetail job = sched.getJobDetail(key);
                    ScheduleTagData task = (ScheduleTagData)((Object)job.getJobDataMap().get((Object)"metadata"));
                    list.add(task);
                    innerlist.add(task);
                }
                map.put(group, innerlist);
            }
        }
        catch (SchedulerException e) {
            CFLogs.SCHEDULER_LOG.error((Throwable)e);
        }
        return map;
    }

    public String list() {
        return null;
    }

    public ScheduleTagTO findTask(String taskname) {
        return this.findTask(taskname, null, "server");
    }

    public ScheduleTagTO findTask(String taskname, String groupname) {
        return this.findTask(taskname, groupname, "server");
    }

    public ScheduleTagTO findTask(String taskname, String groupname, String mode) {
        ScheduleTagData std = this.findTask2(taskname, groupname, mode);
        return this.stdToTO(std);
    }

    private ScheduleTagTO stdToTO(ScheduleTagData to) {
        if (null == to) {
            return null;
        }
        ScheduleTagTO std = new ScheduleTagTO();
        std.setTask(to.getTask());
        std.setGroup(to.getGroup());
        std.setMode(to.getMode());
        std.setUrl(to.getUrl());
        std.setAppname(to.getAppname());
        std.setChained(to.isChained());
        std.setChianedtasks(to.getChianedtasks());
        std.setClustered(to.isClustered());
        if (to.getInterval() == null || to.getInterval().length() <= 0) {
            std.setCrontime(to.getCrontime());
        }
        std.setEncrypted(to.isEncrypted());
        std.setEnddate(to.getEnddate());
        std.setEndtime(to.getEndtime());
        std.setEventhandler(to.getEventhandler());
        std.setEventhandlerrp(to.getEventhandlerrp());
        std.setExclude(to.getExclude());
        std.setFile(to.getFile());
        std.setGroup(to.getGroup());
        std.setInterval(to.getInterval());
        std.setLastfire(to.getLastfire());
        std.setMisfire(to.getMisfire());
        std.setNextfire(to.getNextfire());
        std.setOnexception(to.getOnexception());
        std.setOverwrite(to.getOverwrite().booleanValue());
        std.setPassword(to.getPassword());
        std.setPath(to.getPath());
        std.setPort(to.getPort());
        std.setPriority(to.getPriority());
        std.setProxypassword(to.getProxypassword());
        std.setProxypasswordencrypted(to.isProxypasswordencrypted());
        std.setProxyport(to.getProxyport());
        std.setProxyserver(to.getProxyserver());
        std.setProxyuser(to.getProxyuser());
        std.setPublish(to.isPublish());
        std.setRemainingCount(to.getRemainingCount());
        std.setRepeat(to.getRepeat());
        std.setResolveUrl(to.isResolveUrl());
        std.setRetrycount(to.getRetrycount());
        std.setUsername(to.getUsername());
        std.setStatus(to.getStatus());
        std.setStarttime(to.getStarttime());
        std.setStartdate(to.getStartdate());
        std.setShouldNotMisfire(to.shouldNotMisfire);
        std.setSeed(to.getSeed());
        std.setRequestTimeOut(to.getReqtimeout());
        return std;
    }

    public ScheduleTagData findTask2(String taskname, String groupname, String mode) {
        try {
            JobKey jobKey;
            Scheduler csched;
            boolean exist;
            JobDetail job = null;
            ScheduleTagData tagdata = (ScheduleTagData)((Object)this._main.get((Object)this.getUniqueKey(taskname, groupname, mode)));
            if (null != tagdata) {
                return tagdata;
            }
            if (null == job && null != cScheduler && (exist = (csched = CronServiceImpl.getSchedulerInstance(true)).checkExists(jobKey = new JobKey(CronUtil.getJobname(taskname), CronUtil.getFullGroupName(groupname, mode))))) {
                job = csched.getJobDetail(jobKey);
                tagdata = (ScheduleTagData)((Object)job.getJobDataMap().get((Object)"metadata"));
            }
            return tagdata;
        }
        catch (Exception e) {
            CFLogs.SCHEDULER_LOG.error((Throwable)e);
            return null;
        }
    }

    public ScheduleTagTO findTask(String taskname, String group, String mode, String appname) {
        return this.stdToTO(this.findTask2(taskname, group, mode, appname));
    }

    public ScheduleTagData findTask2(String taskname, String group, String mode, String appname) {
        try {
            Object job = null;
            group = CronUtil.stringNullCheck(group) ? "DEFAULT" : group;
            String key = appname + CronUtil.getTasknameDelimiter() + group + CronUtil.getTasknameDelimiter() + taskname;
            ScheduleTagData tagdata = (ScheduleTagData)((Object)this._main.get((Object)key));
            if (null != tagdata) {
                return tagdata;
            }
            if (null == job) {
                tagdata = (ScheduleTagData)((Object)this._mainClustered.get((Object)key));
            }
            return tagdata;
        }
        catch (Exception e) {
            CFLogs.SCHEDULER_LOG.error((Throwable)e);
            return null;
        }
    }

    public void deleteTask(String taskname, String groupname, String mode) throws ServiceException {
        ScheduleTagData taskdata = this.findTask2(taskname = ESAPIUtils.decodeForHTML((String)taskname), groupname = ESAPIUtils.decodeForHTML((String)groupname), mode);
        if (taskdata == null) {
            taskdata = (ScheduleTagData)((Object)this._main.get((Object)this.getUniqueKey(taskname, groupname, mode)));
            if (null != taskdata) {
                this._main.remove((Object)this.getUniqueKey(taskname, groupname, mode));
                this.store();
                return;
            }
            throw new SchedulingNoSuchTaskException(taskname);
        }
        Scheduler sched = CronServiceImpl.getSchedulerInstance(taskdata.isClustered());
        try {
            sched.deleteJob(this.jobKey(CronUtil.getJobname(taskname), CronUtil.getFullGroupName(groupname, mode)));
            sched.unscheduleJob(this.triggerKey(CronUtil.getTriggername(taskname), CronUtil.getFullGroupName(groupname, mode)));
        }
        catch (SchedulerException e) {
            CFLogs.SCHEDULER_LOG.error((Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        if (!taskdata.isClustered()) {
            this._main.remove((Object)this.getUniqueKey(taskname, groupname, mode));
            this.store();
        } else {
            this._mainClustered.remove((Object)this.getUniqueKey(taskname, groupname, mode));
        }
    }

    private JobKey jobKey(String jobname, String fullGroupName) {
        return new JobKey(jobname, fullGroupName);
    }

    private String getUniqueKey(String taskname, String groupname, String mode) {
        return CronUtil.getFullGroupName(groupname, mode).toUpperCase() + CronUtil.getTasknameDelimiter() + taskname.toUpperCase();
    }

    public void runCall(String task, String groupname, String mode) throws ServiceException {
        ScheduleTagData taskdata = this.findTask2(task, groupname, mode);
        if (this.isTaskPaused(task, groupname, mode)) {
            throw new ScheduleTag.TaskPausedException(task);
        }
        if (taskdata == null) {
            throw new SchedulingNoSuchTaskException(task);
        }
        Scheduler sched = CronServiceImpl.getSchedulerInstance(taskdata.isClustered());
        try {
            JobDetail job = sched.getJobDetail(this.jobKey(CronUtil.getJobname(task), CronUtil.getFullGroupName(groupname, mode)));
            if (job != null) {
                if (_logFlag) {
                    if (_logFlag && !this.isTaskPaused(task, groupname, mode)) {
                        this._schlogger.info((Object)("[" + task + "] Executing because of user request at " + new Date()));
                    } else {
                        this._schlogger.info((Object)("[" + task + "] Will not execute paused task because of user request at " + new Date()));
                    }
                }
            } else {
                throw new SchedulingNoSuchTaskException(task);
            }
            sched.triggerJob(this.jobKey(CronUtil.getJobname(task), CronUtil.getFullGroupName(groupname, mode)));
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        catch (Throwable e1) {
            throw new ServiceException(e1);
        }
    }

    public void updateTask(ScheduleTagTO newtask) throws ServiceException {
        this.updateTask(this.getScheduleTagDataFromTO(newtask));
    }

    private ScheduleTagData getScheduleTagDataFromTO(ScheduleTagTO to) {
        ScheduleTagData std = new ScheduleTagData();
        std.setTask(to.getTask());
        std.setGroup(to.getGroup());
        std.setMode(to.getMode());
        std.setUrl(to.getUrl());
        std.setAppname(to.getAppname());
        std.setChained(to.isChained());
        std.setChianedtasks(to.getChianedtasks());
        std.setClustered(to.isClustered());
        std.setCrontime(to.getCrontime());
        std.setEncrypted(to.isEncrypted());
        std.setEnddate(to.getEnddate());
        std.setEndtime(to.getEndtime());
        std.setEventhandler(to.getEventhandler());
        std.setEventhandlerrp(to.getEventhandlerrp());
        std.setExclude(to.getExclude());
        std.setFile(to.getFile());
        std.setGroup(to.getGroup());
        std.setInterval(to.getInterval());
        std.setLastfire(to.getLastfire());
        std.setMisfire(to.getMisfire());
        std.setNextfire(to.getNextfire());
        std.setOnexception(to.getOnexception());
        std.setOverwrite(to.getOverwrite());
        std.setPassword(to.getPassword());
        std.setPath(to.getPath());
        std.setPort(to.getPort());
        std.setPriority(to.getPriority());
        std.setProxypassword(to.getProxypassword());
        std.setProxypasswordencrypted(to.isProxypasswordencrypted());
        std.setProxyport(to.getProxyport());
        std.setProxyserver(to.getProxyserver());
        std.setProxyuser(to.getProxyuser());
        std.setPublish(to.isPublish());
        std.setRemainingCount(to.getRemainingCount());
        std.setRepeat(to.getRepeat());
        std.setResolveUrl(to.isResolveUrl());
        std.setRetrycount(to.getRetrycount());
        std.setUsername(to.getUsername());
        std.setStatus(to.getStatus());
        std.setStarttime(to.getStarttime());
        std.setStartdate(to.getStartdate());
        std.setShouldNotMisfire(to.shouldNotMisfire);
        std.setSeed(to.getSeed());
        std.setReqtimeout(to.getRequestTimeOut());
        try {
            std.init();
        }
        catch (coldfusion.server.ServiceException e) {
            e.printStackTrace();
        }
        return std;
    }

    public void updateTask(ScheduleTagData newtask) throws ServiceException {
        String proxypassword;
        boolean proxypasswordencrypted;
        String password;
        newtask.setTask(ESAPIUtils.decodeForHTML((String)newtask.getTask()));
        newtask.setGroup(ESAPIUtils.decodeForHTML((String)newtask.getGroup()));
        if (newtask.isClustered() && null == cScheduler) {
            throw new ScheduleTag.ClusterNotEnabledException();
        }
        ScheduleTagData oldtask = this.findTask2(newtask.getTask(), newtask.getGroup(), newtask.getMode());
        if (oldtask != null) {
            if (!"Expired".equalsIgnoreCase(oldtask.getStatus())) {
                newtask.setStatus(oldtask.getStatus());
            }
            this.deleteTask(newtask.getTask(), newtask.getGroup(), newtask.getMode());
        }
        try {
            Set pausedGrps = CronServiceImpl.getSchedulerInstance(newtask.isClustered()).getPausedTriggerGroups();
            if (pausedGrps.contains(CronUtil.getFullGroupName(newtask.getGroup(), newtask.getMode()))) {
                newtask.setStatus("Paused");
            }
        }
        catch (SchedulerException e) {
            CFLogs.SCHEDULER_LOG.error((Throwable)e);
        }
        boolean encrypted = Cast._boolean((Object)newtask.isEncrypted());
        if (!encrypted && (password = newtask.getPassword()) != null) {
            password = this.encryptPassword(password);
            newtask.setPassword(password);
            newtask.setEncrypted(true);
        }
        if (!(proxypasswordencrypted = Cast._boolean((Object)newtask.isProxypasswordencrypted())) && (proxypassword = newtask.getProxypassword()) != null) {
            proxypassword = this.encryptPassword(proxypassword);
            newtask.setProxypassword(proxypassword);
            newtask.setProxypasswordencrypted(true);
        }
        this.createTask(newtask);
        this.updateAndStore(newtask);
        if (newtask.getStatus().equals("Paused")) {
            this.pauseTask(newtask.getTask(), newtask.getGroup(), newtask.getMode());
        }
        try {
            this.setOtherAttributes(newtask, CronServiceImpl.getSchedulerInstance(newtask.isClustered()));
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
    }

    public String getSeed() {
        return this.seed;
    }

    public void updateAndStore(ScheduleTagData tagdata) throws ServiceException {
        String s = null;
        s = "application".equalsIgnoreCase(tagdata.getMode()) ? tagdata.getAppname() : tagdata.getMode();
        if (!tagdata.isClustered()) {
            this._main.put((Object)this.getUniqueKey(tagdata.getTask(), tagdata.getGroup(), s), (Object)tagdata);
            this.store();
        } else {
            this._mainClustered.put((Object)this.getUniqueKey(tagdata.getTask(), tagdata.getGroup(), s), (Object)tagdata);
        }
    }

    private void createTask(ScheduleTagData metadata) throws ServiceException {
        this.checkEFRForAdvFeatures(metadata);
        JobDetail job = metadata.getJobdetail();
        JobDataMap jobmap = job.getJobDataMap();
        jobmap.put("metadata", (Object)metadata);
        job.getJobBuilder().usingJobData(jobmap);
        Trigger trigger = metadata.getTrigger();
        if (null != trigger) {
            trigger = trigger.getTriggerBuilder().usingJobData(jobmap).build();
        }
        Scheduler sched = CronServiceImpl.getSchedulerInstance(metadata.isClustered());
        try {
            if (null != trigger) {
                sched.scheduleJob(job, trigger);
            } else {
                sched.addJob(job, true);
            }
        }
        catch (SchedulerException e) {
            CFLogs.SCHEDULER_LOG.error((Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    private void checkEFRForAdvFeatures(ScheduleTagData metadata) {
        if (metadata != null && (metadata.isChained() || metadata.isClustered() || metadata.getEventhandler() != null && !metadata.getEventhandler().trim().equals("") || metadata.getOnexception() != null && !metadata.getOnexception().trim().equals("") || metadata.getChianedtasks() != null && !metadata.getChianedtasks().trim().equals("") || metadata.getMisfire() != null && !metadata.getMisfire().trim().equals("") && !metadata.getMisfire().equalsIgnoreCase("ignore") || metadata.getAppname() != null && !metadata.getAppname().equalsIgnoreCase(CronUtil.getServerName()))) {
            FeatureRouter.getInstance().allowFeature(EFRConstants.scheduler_new_features.intValue(), null);
        }
    }

    public void deleteTasks() throws ServiceException {
    }

    public void pauseTask(String task, String groupname, String mode) throws ServiceException {
        this.pauseTask(task, groupname, mode, true);
    }

    public void pauseTask(String task, String groupname, String mode, boolean throwExpiredChainedTaskException) throws ServiceException {
        ScheduleTagData taskdata = this.findTask2(task, groupname, mode);
        if (taskdata == null) {
            taskdata = (ScheduleTagData)((Object)this._main.get((Object)this.getUniqueKey(task, groupname, mode)));
            if (null != taskdata) {
                return;
            }
            throw new SchedulingNoSuchTaskException(task);
        }
        Scheduler sched = CronServiceImpl.getSchedulerInstance(taskdata.isClustered());
        try {
            this.checkExpiry(taskdata);
        }
        catch (ScheduleTag.PauseExpiredTaskException pete) {
            if (throwExpiredChainedTaskException) {
                throw new ScheduleTag.PauseExpiredTaskException(taskdata.getTask());
            }
            return;
        }
        if (taskdata.isChained()) {
            if (throwExpiredChainedTaskException) {
                throw new ScheduleTag.PauseResumeChainedtaskException(task);
            }
            return;
        }
        try {
            if (_logFlag) {
                this._schlogger.info((Object)("[" + task + "] Pausing the task because of user request at " + new Date()));
            }
            sched.pauseJob(this.jobKey(CronUtil.getJobname(task), CronUtil.getFullGroupName(groupname, mode)));
            sched.pauseTrigger(this.triggerKey(CronUtil.getTriggername(task), CronUtil.getFullGroupName(groupname, mode)));
            taskdata.setStatus("Paused");
            JobDetail job = taskdata.getJobdetail();
            JobDataMap jobmap = job.getJobDataMap();
            jobmap.put("metadata", (Object)taskdata);
            job.getJobBuilder().usingJobData(jobmap);
            this.updateAndStore(taskdata);
        }
        catch (SchedulerException e) {
            CFLogs.SCHEDULER_LOG.error((Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    private void checkExpiry(ScheduleTagData taskdata) throws ScheduleTag.PauseExpiredTaskException {
        long finalfiretime;
        Date finalfiredate;
        Trigger t = taskdata.getTrigger();
        if (null != t && null != (finalfiredate = t.getFinalFireTime()) && (finalfiretime = finalfiredate.getTime()) < System.currentTimeMillis()) {
            throw new ScheduleTag.PauseExpiredTaskException(taskdata.getTask());
        }
    }

    private void updateCache(ScheduleTagData taskdata) {
        if (taskdata.isClustered()) {
            this._mainClustered.put((Object)this.getUniqueKey(taskdata.getTask(), taskdata.getGroup(), taskdata.getMode()), (Object)taskdata);
        } else {
            this._main.put((Object)this.getUniqueKey(taskdata.getTask(), taskdata.getGroup(), taskdata.getMode()), (Object)taskdata);
        }
    }

    public void pauseAllTasks(String groupname, String mode, boolean isGroupSpecific) throws ServiceException {
        if (isGroupSpecific && !this.listAllTasksByGroups2().keySet().contains(CronUtil.getFullGroupName(groupname, mode))) {
            throw new ScheduleTag.GroupNotPresentException(CronUtil.stringNullCheck(groupname) ? "DEFAULT" : groupname);
        }
        this._pauseAllTasks(CronServiceImpl.getSchedulerInstance(false), groupname, mode, isGroupSpecific);
        try {
            this._pauseAllTasks(CronServiceImpl.getSchedulerInstance(true), groupname, mode, isGroupSpecific);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<String> getCurrentRunningTasks() throws ServiceException {
        Scheduler sched = CronServiceImpl.getSchedulerInstance(false);
        ArrayList<String> tasks = new ArrayList<String>();
        try {
            List cTasks = sched.getCurrentlyExecutingJobs();
            for (JobExecutionContext ctx : cTasks) {
                JobDetail jd = ctx.getJobDetail();
                String name = jd.getKey().getName();
                String grp = jd.getKey().getGroup();
                tasks.add(grp + CronUtil.getTasknameDelimiter() + name);
            }
        }
        catch (SchedulerException e) {
            CFLogs.APPLICATION_LOG.error((Throwable)e);
        }
        return tasks;
    }

    public void _pauseAllTasks(Scheduler sched, String groupname, String mode, boolean isGroupSpecific) throws ServiceException {
        try {
            if (isGroupSpecific) {
                groupname = CronUtil.getFullGroupName(groupname, mode);
                if (!this.listAllTasksByGroups2().keySet().contains(groupname)) {
                    throw new ScheduleTag.GroupNotPresentException(groupname);
                }
                sched.pauseJobs(GroupMatcher.jobGroupContains((String)groupname));
                sched.pauseTriggers(GroupMatcher.triggerGroupContains((String)groupname));
                this.changeGroupStatus(groupname, "Paused");
            } else {
                List tasks = this.listAll();
                for (ScheduleTagData task : tasks) {
                    String taskmode = task.getMode();
                    if (("server".equals(mode) || groupname == null) && "server".equals(taskmode)) {
                        this.pauseTask(task.getTask(), task.getGroup(), taskmode, false);
                    }
                    if (!"application".equals(mode) && groupname != null) continue;
                    String appname = CronUtil.getApplicationName().toUpperCase();
                    String fullgrpname = task.getFullGroupName();
                    if (!"application".equals(taskmode) || !appname.equalsIgnoreCase("CFADMIN") && !fullgrpname.startsWith(appname + CronUtil.getTasknameDelimiter())) continue;
                    this.pauseTask(task.getTask(), task.getGroup(), task.getAppname(), false);
                }
            }
        }
        catch (SchedulerException e) {
            CFLogs.SCHEDULER_LOG.error((Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    private void changeGroupStatus(String groupname, String state) {
        Map<String, List<ScheduleTagData>> tasksbygroup = this.listAllTasksByGroups2();
        for (ScheduleTagData metadata : tasksbygroup.get(groupname)) {
            metadata.setStatus(state);
            JobDetail job = metadata.getJobdetail();
            JobDataMap jobmap = job.getJobDataMap();
            jobmap.put("metadata", (Object)metadata);
            job.getJobBuilder().usingJobData(jobmap);
            this._main.put((Object)this.getUniqueKey(metadata.getTask(), metadata.getGroup(), metadata.getMode()), (Object)metadata);
        }
        this.store();
    }

    public void resumeTask(String task, String groupname, String mode) throws ServiceException {
        this.resumeTask(task, groupname, mode, true);
    }

    public void resumeTask(String task, String groupname, String mode, boolean throwExpiredChainedTaskException) throws ServiceException {
        ScheduleTagData taskdata = this.findTask2(task, groupname, mode);
        if (taskdata == null) {
            taskdata = (ScheduleTagData)((Object)this._main.get((Object)this.getUniqueKey(task, groupname, mode)));
            if (null != taskdata) {
                return;
            }
            throw new SchedulingNoSuchTaskException(task);
        }
        Scheduler sched = CronServiceImpl.getSchedulerInstance(taskdata.isClustered());
        try {
            this.checkExpiry(taskdata);
        }
        catch (ScheduleTag.PauseExpiredTaskException pete) {
            if (throwExpiredChainedTaskException) {
                throw new ScheduleTag.PauseExpiredTaskException(taskdata.getTask());
            }
            return;
        }
        if (taskdata.isChained()) {
            if (throwExpiredChainedTaskException) {
                throw new ScheduleTag.PauseResumeChainedtaskException(task);
            }
            return;
        }
        try {
            if (_logFlag) {
                this._schlogger.info((Object)("[" + task + "] Resuming the task because of user request at " + new Date()));
            }
            sched.resumeJob(this.jobKey(CronUtil.getJobname(task), CronUtil.getFullGroupName(groupname, mode)));
            sched.resumeTrigger(this.triggerKey(CronUtil.getTriggername(task), CronUtil.getFullGroupName(groupname, mode)));
            ScheduleTagData metadata = this.findTask2(task, groupname, mode);
            metadata.setStatus("Running");
            JobDetail job = metadata.getJobdetail();
            JobDataMap jobmap = job.getJobDataMap();
            jobmap.put("metadata", (Object)metadata);
            job.getJobBuilder().usingJobData(jobmap);
            this.updateAndStore(taskdata);
        }
        catch (SchedulerException e) {
            CFLogs.SCHEDULER_LOG.error((Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public void resumeAllTasks(String groupname, String mode, boolean isGroupSpecific) throws ServiceException {
        if (isGroupSpecific && !this.listAllTasksByGroups2().keySet().contains(CronUtil.getFullGroupName(groupname, mode))) {
            throw new ScheduleTag.GroupNotPresentException(CronUtil.stringNullCheck(groupname) ? "DEFAULT" : groupname);
        }
        this._resumeAllTasks(CronServiceImpl.getSchedulerInstance(false), groupname, mode, isGroupSpecific);
        try {
            this._resumeAllTasks(CronServiceImpl.getSchedulerInstance(true), groupname, mode, isGroupSpecific);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void _resumeAllTasks(Scheduler sched, String groupname, String mode, boolean isGroupSpecific) throws ServiceException {
        try {
            if (isGroupSpecific) {
                groupname = CronUtil.getFullGroupName(groupname, mode);
                sched.resumeJobs(GroupMatcher.jobGroupContains((String)groupname));
                sched.resumeTriggers(GroupMatcher.triggerGroupContains((String)groupname));
                this.changeGroupStatus(groupname, "Running");
            } else {
                List tasks = this.listAll();
                for (ScheduleTagData task : tasks) {
                    String taskmode = task.getMode();
                    if (("server".equals(mode) || groupname == null) && "server".equals(taskmode)) {
                        this.resumeTask(task.getTask(), task.getGroup(), taskmode, false);
                    }
                    if (!"application".equals(mode) && groupname != null) continue;
                    String appname = CronUtil.getApplicationName().toUpperCase();
                    String fullgrpname = task.getFullGroupName();
                    if (!"application".equals(taskmode) || !appname.equalsIgnoreCase("CFADMIN") && !fullgrpname.startsWith(appname + CronUtil.getTasknameDelimiter())) continue;
                    this.resumeTask(task.getTask(), task.getGroup(), task.getAppname(), false);
                }
            }
        }
        catch (SchedulerException e) {
            CFLogs.SCHEDULER_LOG.error((Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public boolean isTaskPaused(String task, String groupname, String mode) throws ServiceException {
        ScheduleTagData taskdata = this.findTask2(task, groupname, mode);
        if (taskdata == null) {
            throw new SchedulingNoSuchTaskException(task);
        }
        try {
            Trigger trig = taskdata.getTrigger();
            return trig != null && CronServiceImpl.getSchedulerInstance(taskdata.isClustered()).getTriggerState(trig.getKey()) == Trigger.TriggerState.PAUSED;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        String seedVal;
        String oldSeed = this.seed;
        if (o instanceof PasswordUtils && arg != null && arg instanceof String && (seedVal = (String)arg) != null && seedVal.length() > 0) {
            this.seed = seedVal;
            if (oldSeed == null) {
                return;
            }
            this.reEncryptPassword(oldSeed);
        }
    }

    public String encryptPassword(String password) {
        return PasswordUtils.encryptPassword((String)password, (String)this.seed);
    }

    public String decryptPassword(String password) {
        return PasswordUtils.decryptPassword((String)password, (String)this.seed);
    }

    private void reEncryptPassword(String oldSeed) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTasksForArchive(List<ScheduleTagTO> list, String archiveSeed, String oldAlgoValue, int majorVersion, int minorVersion) throws ServiceException {
        SecurityService security = ServiceFactory.getSecurityService();
        security.authenticateAdmin();
        String oldSeed = archiveSeed;
        boolean useNoEncodingForDecryption = false;
        if (!PasswordUtils.isAESS((int)majorVersion, (int)minorVersion)) {
            useNoEncodingForDecryption = true;
            oldSeed = OLDSEEDVAL;
        }
        ConfigMap configMap = this._main;
        synchronized (configMap) {
            ScheduleTagData cte = null;
            this.pauseScheduler();
            for (ScheduleTagTO to : list) {
                try {
                    String encProxyPassword;
                    Map tmap = this.getScheduleTagDataAsMap(to);
                    cte = new ScheduleTagData(tmap, _logFlag, this.seed);
                    String encPassword = (String)cte.get("password");
                    if (encPassword != null && encPassword.length() > 0) {
                        String newEncPassword = PasswordUtils.reEncryptWithNewSeed((String)encPassword, (String)oldSeed, (String)this.seed, (boolean)useNoEncodingForDecryption, (String)oldAlgoValue, (int)majorVersion, (int)minorVersion);
                        cte.setPassword(newEncPassword);
                        cte.setSeed(this.seed);
                    }
                    if ((encProxyPassword = (String)cte.get("proxy_password")) != null && encProxyPassword.length() > 0) {
                        encProxyPassword = majorVersion < 9 ? PasswordUtils.encryptPassword((String)encProxyPassword, (String)this.seed) : PasswordUtils.reEncryptWithNewSeed((String)encProxyPassword, (String)oldSeed, (String)this.seed, (String)oldAlgoValue, (int)majorVersion, (int)minorVersion);
                        cte.setProxypassword(encProxyPassword);
                    }
                    cte.setEncrypted(true);
                    this.updateTask(cte);
                }
                catch (Exception ex) {
                    CFLogs.SCHEDULER_LOG.error((Throwable)ex);
                }
            }
            this.resumeScheduler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTaskForMigration(String task, String operation, String url, String file, String path, Date startdate, Date enddate, Date starttime, Date endtime, String interval, boolean publish, String requesttimeout, String password, String username, String proxyserver, String proxyUser, String proxyPassword, boolean resolveurl, String httpport, String httpproxyport, boolean paused, boolean disabled, String oldSeed, String oldAlgoValue, int majorVersion, int minorVersion) throws ServiceException {
        SecurityService security = ServiceFactory.getSecurityService();
        security.authenticateAdmin();
        ConfigMap configMap = this._main;
        synchronized (configMap) {
            try {
                ScheduleTagData scheduleTagData = new ScheduleTagData();
                Object obj = this._main.get((Object)task);
                if (obj instanceof ScheduleTagData) {
                    scheduleTagData = (ScheduleTagData)((Object)obj);
                    this.deleteTask(scheduleTagData.getTask(), scheduleTagData.getGroup(), scheduleTagData.getMode());
                }
                scheduleTagData.setTask(task);
                scheduleTagData.setPublish(publish);
                scheduleTagData.setUsername(username);
                scheduleTagData.setProxyserver(proxyserver);
                scheduleTagData.setProxyuser(proxyUser);
                scheduleTagData.setResolveUrl(resolveurl);
                scheduleTagData.setPort(httpport);
                scheduleTagData.setProxyport(httpproxyport);
                scheduleTagData.setFile(file);
                scheduleTagData.setPath(path);
                scheduleTagData.setUrl(url);
                scheduleTagData.setInterval(interval);
                scheduleTagData.setStartdate(startdate);
                scheduleTagData.setStarttime(starttime);
                scheduleTagData.setEnddate(enddate);
                scheduleTagData.setEndtime(endtime);
                scheduleTagData.setGroup("DEFAULT");
                scheduleTagData.setRepeat("-1");
                scheduleTagData.setClustered(false);
                scheduleTagData.setMode("server");
                scheduleTagData.setOverwrite(true);
                scheduleTagData.setChianedtasks("");
                scheduleTagData.setMisfire("NEXT_REMAINING");
                scheduleTagData.setPriority("5");
                scheduleTagData.init();
                if (paused) {
                    scheduleTagData.setStatus("Paused");
                }
                boolean useNoEncodingForDecryption = false;
                if (!PasswordUtils.isAESS((int)majorVersion, (int)minorVersion)) {
                    useNoEncodingForDecryption = true;
                    oldSeed = OLDSEEDVAL;
                }
                if (password != null) {
                    password = PasswordUtils.reEncryptWithNewSeed((String)password, (String)oldSeed, (String)this.seed, (boolean)useNoEncodingForDecryption, (String)oldAlgoValue, (int)majorVersion, (int)minorVersion);
                }
                if (proxyPassword != null) {
                    proxyPassword = majorVersion < 9 ? PasswordUtils.encryptPassword((String)proxyPassword, (String)this.seed) : PasswordUtils.reEncryptWithNewSeed((String)proxyPassword, (String)oldSeed, (String)this.seed, (String)oldAlgoValue, (int)majorVersion, (int)minorVersion);
                }
                scheduleTagData.setPassword(password);
                scheduleTagData.setProxypassword(proxyPassword);
                scheduleTagData.setEncrypted(true);
                this.updateTask(scheduleTagData);
            }
            catch (Exception ex) {
                CFLogs.SCHEDULER_LOG.error((Throwable)ex);
                throw new ServiceException((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTaskForMigration(String task, String group, String mode, String operation, String url, String file, String path, Date startdate, Date enddate, Date starttime, Date endtime, String interval, boolean publish, String requesttimeout, String password, String username, String proxyserver, String proxyUser, String proxyPassword, boolean resolveurl, String httpport, String httpproxyport, boolean paused, boolean disabled, String crontime, String oldSeed, String oldAlgoValue, int majorVersion, int minorVersion, String chained, String onException, String eventHandler, String misfire, String onComplete) throws ServiceException {
        SecurityService security = ServiceFactory.getSecurityService();
        security.authenticateAdmin();
        ConfigMap configMap = this._main;
        synchronized (configMap) {
            try {
                Object obj;
                ScheduleTagData scheduleTagData = new ScheduleTagData();
                if (task.contains(CronUtil.getTasknameDelimiter())) {
                    task = task.substring(task.lastIndexOf(CronUtil.getTasknameDelimiter()) + CronUtil.getTasknameDelimiter().length(), task.length());
                }
                if ((obj = this._main.get((Object)this.getUniqueKey(task, group, mode))) instanceof ScheduleTagData) {
                    try {
                        scheduleTagData = (ScheduleTagData)((Object)obj);
                        this.deleteTask(scheduleTagData.getTask(), scheduleTagData.getGroup(), scheduleTagData.getMode());
                    }
                    catch (Exception e) {
                        CFLogs.SCHEDULER_LOG.error((Throwable)e);
                    }
                }
                scheduleTagData.setTask(task);
                scheduleTagData.setGroup(group);
                scheduleTagData.setMode(mode);
                scheduleTagData.setPublish(publish);
                scheduleTagData.setUsername(username);
                scheduleTagData.setProxyserver(proxyserver);
                scheduleTagData.setProxyuser(proxyUser);
                scheduleTagData.setResolveUrl(resolveurl);
                scheduleTagData.setPort(httpport);
                scheduleTagData.setProxyport(httpproxyport);
                scheduleTagData.setFile(file);
                scheduleTagData.setPath(path);
                scheduleTagData.setUrl(url);
                scheduleTagData.setInterval(interval);
                scheduleTagData.setStartdate(startdate);
                scheduleTagData.setStarttime(starttime);
                scheduleTagData.setEnddate(enddate);
                scheduleTagData.setEndtime(endtime);
                scheduleTagData.setRepeat("-1");
                scheduleTagData.setClustered(false);
                scheduleTagData.setOverwrite(true);
                scheduleTagData.setChained(Cast._boolean((String)chained));
                scheduleTagData.setChianedtasks(onComplete);
                scheduleTagData.setMisfire(misfire);
                scheduleTagData.setEventhandler(eventHandler);
                scheduleTagData.setOnexception(onException);
                scheduleTagData.setPriority("5");
                if (crontime != null && !crontime.equals("")) {
                    scheduleTagData.setCrontime(crontime);
                }
                scheduleTagData.init();
                if (paused) {
                    scheduleTagData.setStatus("Paused");
                }
                boolean useNoEncodingForDecryption = false;
                if (!PasswordUtils.isAESS((int)majorVersion, (int)minorVersion)) {
                    useNoEncodingForDecryption = true;
                    oldSeed = OLDSEEDVAL;
                }
                if (password != null) {
                    password = PasswordUtils.reEncryptWithNewSeed((String)password, (String)oldSeed, (String)this.seed, (boolean)useNoEncodingForDecryption, (String)oldAlgoValue, (int)majorVersion, (int)minorVersion);
                }
                if (proxyPassword != null) {
                    proxyPassword = majorVersion < 9 ? PasswordUtils.encryptPassword((String)proxyPassword, (String)this.seed) : PasswordUtils.reEncryptWithNewSeed((String)proxyPassword, (String)oldSeed, (String)this.seed, (String)oldAlgoValue, (int)majorVersion, (int)minorVersion);
                }
                scheduleTagData.setPassword(password);
                scheduleTagData.setProxypassword(proxyPassword);
                scheduleTagData.setEncrypted(true);
                this.updateTask(scheduleTagData);
            }
            catch (Exception ex) {
                CFLogs.SCHEDULER_LOG.error((Throwable)ex);
                throw new ServiceException((Throwable)ex);
            }
        }
    }

    public void disableCluster() throws ServiceException {
        dsname = "";
        try {
            cScheduler.shutdown();
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
        cScheduler = null;
        this.store();
    }

    public String checkAllowedFileExtensions(String file) throws ServiceException {
        int index = file.lastIndexOf(".");
        if (index > 0) {
            String extension = file.substring(index + 1, file.length());
            for (String ext : extensions.split(",")) {
                if (!ext.equalsIgnoreCase(extension)) continue;
                return "true";
            }
        }
        return extensions;
    }

    public void setClusterDsnName(String dsn, boolean createtables) throws ServiceException {
        FeatureRouter.getInstance().allowFeature(EFRConstants.scheduler_new_features.intValue(), null);
        String temp = dsname;
        dsname = dsn;
        try {
            if (!this.verifyClusterDBSupport()) {
                dsname = temp;
                throw new ScheduleTag.ClusterDBNotSupportedException(SUPPORTED_CLUSTER_DBS.toString());
            }
            if (createtables) {
                this.createTablesForCluster();
            }
            if (null == (cScheduler = CronServiceImpl.getScheduler(true))) {
                dsname = temp;
            } else {
                this._mainClustered.clear();
                this.loadClusteredTasks();
            }
            final File f = new File(ServiceFactory.getRuntimeService().getLibDir() + "/" + QUARTZ_PROPERTY_FILE);
            final Properties prop = new Properties();
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws FileNotFoundException, IOException {
                    if (f.exists()) {
                        prop.load(new FileInputStream(f));
                    }
                    return null;
                }
            });
            prop.put(DSNAME, dsname);
            try (FileOutputStream stream = new FileOutputStream(f);){
                prop.store(stream, null);
            }
            CentralConfigClientUtil.pushToCCS((String)QUARTZ_PROPERTY_FILE_CCS, (Properties)prop, (Object)DSNAME, (Object)temp, (Object)dsname);
        }
        catch (ServiceException ex) {
            dsname = temp;
            CFLogs.SCHEDULER_LOG.error((Throwable)ex);
            throw new ServiceException((Throwable)ex);
        }
        catch (Exception ex) {
            dsname = temp;
            CFLogs.SCHEDULER_LOG.error((Throwable)ex);
            throw new ServiceException((Throwable)ex);
        }
    }

    private boolean verifyClusterDBSupport() throws Exception {
        CFDataSource datasource = CronServiceImpl.getDatasource();
        String dbtype = datasource.getConnection().getMetaData().getDatabaseProductName();
        String type = DBNAMEMAP.get(dbtype);
        return SUPPORTED_CLUSTER_DBS.contains(type);
    }

    public String getClusterDsnName() throws ServiceException {
        return dsname;
    }

    public static Scheduler getScheduler(boolean isCluster) throws Exception {
        Object sf = null;
        final Properties prop = new Properties();
        final File f = new File(ServiceFactory.getRuntimeService().getLibDir() + "/quartz/quartz.properties");
        AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws FileNotFoundException, IOException {
                if (f.exists()) {
                    prop.load(new FileInputStream(f));
                }
                return null;
            }
        });
        sf = isCluster ? AccessController.doPrivileged(new PrivilegedAction<SchedulerFactory>(){

            @Override
            public SchedulerFactory run() {
                try {
                    File f;
                    prop.putAll((Map<?, ?>)CronServiceImpl.getQrtzDbProperties());
                    if (!prop.containsKey("org.quartz.threadPool.threadCount")) {
                        prop.put("org.quartz.threadPool.threadCount", (Object)20);
                    }
                    if ((f = new File(ServiceFactory.getRuntimeService().getLibDir() + "/quartz/quartz_cluster.properties")).exists()) {
                        Properties prop2 = new Properties();
                        prop2.load(new FileInputStream(f));
                        prop.putAll((Map<?, ?>)prop2);
                    }
                    return new StdSchedulerFactory(prop);
                }
                catch (Exception ex) {
                    CFLogs.SCHEDULER_LOG.error((Throwable)ex);
                    return null;
                }
            }
        }) : new StdSchedulerFactory(prop);
        Scheduler sched = null;
        try {
            sched = sf.getScheduler();
        }
        catch (SchedulerException ex) {
            CFLogs.SCHEDULER_LOG.error((Throwable)ex);
        }
        if (!ServiceFactory.getRuntimeService().isCommandLineCompile()) {
            // empty if block
        }
        CronListener listener = new CronListener("cronlistener");
        sched.getListenerManager().addJobListener((JobListener)listener);
        sched.getListenerManager().addTriggerListener((TriggerListener)listener);
        try {
            sched.start();
        }
        catch (SchedulerException e) {
            CFLogs.SCHEDULER_LOG.error((Throwable)e);
        }
        return sched;
    }

    static Scheduler getSchedulerInstance(boolean clustered) {
        if (clustered) {
            if (null == cScheduler) {
                throw new ScheduleTag.ClusterNotEnabledException();
            }
            return cScheduler;
        }
        return ncScheduler;
    }

    private static Properties getQrtzDbProperties() throws Exception {
        Properties prop = new Properties();
        CFDataSource datasource = CronServiceImpl.getDatasource();
        DataSourceDef dsdef = datasource.getDataSourceDef();
        String database = dsdef.getDatabase();
        String product = datasource.getConnection().getMetaData().getDatabaseProductName();
        if (product.equalsIgnoreCase(DBNAMEMAP.get("Oracle"))) {
            database = dsdef.getSid();
        }
        prop.put("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
        prop.put("org.quartz.jobStore.class", "org.quartz.impl.jdbcjobstore.JobStoreTX");
        prop.put("org.quartz.jobStore.driverDelegateClass", "org.quartz.impl.jdbcjobstore.StdJDBCDelegate");
        prop.put("org.quartz.scheduler.instanceId", "AUTO");
        prop.put("org.quartz.scheduler.instanceName", "MyClusteredScheduler");
        prop.put("org.quartz.jobStore.driverDelegateClass", "org.quartz.impl.jdbcjobstore.StdJDBCDelegate");
        if (product.equalsIgnoreCase(DBNAMEMAP.get("postgres"))) {
            prop.put("org.quartz.jobStore.driverDelegateClass", "org.quartz.impl.jdbcjobstore.PostgreSQLDelegate");
        }
        if (database != null && database.length() > 0) {
            prop.put("org.quartz.jobStore.dataSource", database);
            prop.put("org.quartz.dataSource." + database + ".connectionProvider.class", "coldfusion.scheduling.mod.ConnectionProviderImpl");
        }
        prop.put("org.quartz.jobStore.tablePrefix", "qrtz_");
        prop.put("org.quartz.jobStore.isClustered", "true");
        return prop;
    }

    public void deleteTask(String taskname, String groupname) throws ServiceException {
        this.deleteTask(taskname, groupname, "server");
    }

    public void pauseScheduler() {
        try {
            Scheduler cScheduler = CronServiceImpl.getSchedulerInstance(true);
            if (cScheduler != null) {
                cScheduler.standby();
            }
        }
        catch (Exception cScheduler) {
            // empty catch block
        }
        try {
            Scheduler ncScheduler = CronServiceImpl.getSchedulerInstance(false);
            if (ncScheduler != null) {
                ncScheduler.standby();
            }
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
    }

    public void resumeScheduler() {
        try {
            Scheduler cScheduler = CronServiceImpl.getSchedulerInstance(true);
            if (cScheduler != null) {
                cScheduler.start();
            }
        }
        catch (Exception cScheduler) {
            // empty catch block
        }
        try {
            Scheduler ncScheduler = CronServiceImpl.getSchedulerInstance(false);
            if (ncScheduler != null) {
                ncScheduler.start();
            }
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
    }

    static {
        DBNAMEMAP = new HashMap<String, String>();
        SUPPORTED_CLUSTER_DBS = new HashSet<String>();
        DBNAMEMAP.put("MySQL", "mysql");
        DBNAMEMAP.put("PostgreSQL", "postgres");
        DBNAMEMAP.put("Microsoft SQL Server Database", "sqlserver");
        DBNAMEMAP.put("Microsoft SQL Server", "sqlserver");
        DBNAMEMAP.put("Informix Dynamic Server", "informix");
        DBNAMEMAP.put("Oracle", "oracle");
        DBNAMEMAP.put("Apache Derby", "derby");
        DBNAMEMAP.put("HSQL Database Engine", "hsqldb");
        DBNAMEMAP.put("DB2/NT", "db2");
        DBNAMEMAP.put("Firebird", "firebird");
        DBNAMEMAP.put("Cloudspace", "cloudspace");
        DBNAMEMAP.put("Pointbase", "pointbase");
        DBNAMEMAP.put("Sapdb", "sapdb");
        SUPPORTED_CLUSTER_DBS.add("mysql");
        SUPPORTED_CLUSTER_DBS.add("sqlserver");
        SUPPORTED_CLUSTER_DBS.add("oracle");
    }
}

