/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.excel;

import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.excel.Excel;
import coldfusion.excel.ExcelInfo;
import coldfusion.excel.datavalidation.CSVFormatConfig;
import coldfusion.excel.datavalidation.CSVFormatConfigMetadata;
import coldfusion.excel.datavalidation.Hyperlink;
import coldfusion.excel.datavalidation.HyperlinkMetadata;
import coldfusion.excel.datavalidation.SheetDataValidationRule;
import coldfusion.excel.datavalidation.SheetDataValidationRuleMetadata;
import coldfusion.excel.datavalidation.StreamingProcessConfig;
import coldfusion.excel.datavalidation.StreamingReadConfig;
import coldfusion.excel.datavalidation.StreamingSpreadsheetProcessMetadata;
import coldfusion.excel.datavalidation.StreamingSpreadsheetReadMetadata;
import coldfusion.excel.iterable.CSVRecordIterable;
import coldfusion.filter.FusionContext;
import coldfusion.osgi.services.ExcelService;
import coldfusion.runtime.Array;
import coldfusion.runtime.CFBoolean;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.FastArray;
import coldfusion.runtime.OrderedCaseSensitiveStruct;
import coldfusion.runtime.Struct;
import coldfusion.runtime.StructOrdered;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.async.Future;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.lang.SpreadSheetTag;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import com.monitorjbl.xlsx.StreamingReader;
import jakarta.servlet.jsp.PageContext;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.DuplicateHeaderMode;
import org.apache.commons.csv.QuoteMode;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExcelServiceImpl
implements ExcelService {
    private static final int CSV_RECORD_ITERABLE_DUMP_LIMIT = 10;
    private static final Set<String> formatsWithHeadersForCSVRead = Set.of("csvstring", "arrayofstruct", "query");
    private static final Set<String> formatsWithoutNullStringSupport = Set.of("csvstring", "xlsx");
    private static final String linesep = System.getProperty("line.separator");
    final String[] invalidKeysForCSVProcess = new String[]{"recordSeparator", "skipHeaderRecord", "duplicateHeaderMode", "headerComments", "header", "ignoreHeaderCase", "quoteMode", "allowMissingColumnNames", "trim", "autoFlush"};
    final String[] invalidKeysForCSVWrite = new String[]{"ignoreHeaderCase", "ignoreEmptyLines", "allowMissingColumnNames"};
    final String[] invalidKeysForCSVRead = new String[]{"headerComments", "autoFlush", "quoteMode"};
    final String[] headerValidationKeys = new String[]{"skipHeaderRecord", "duplicateHeaderMode", "header", "allowMissingColumnNames"};
    final String[] csvStringFormatSpecificKeys = new String[]{"recordSeparator", "trim"};
    private static final Set<String> twoOperandOperators = Set.of("NOT_BETWEEN", "BETWEEN");
    private static final Set<String> oneOperandOperators = Set.of("GREATER_OR_EQUAL", "GREATER_THAN", "LESS_OR_EQUAL", "LESS_THAN", "EQUAL", "NOT_EQUAL");
    final String[] invalidKeysForOneOperandOperation = new String[]{"minValue", "maxValue", "allowedValues"};
    final String[] invalidKeysForTwoOperandOperation = new String[]{"value", "allowedValues"};
    final String[] invalidKeysForListOperation = new String[]{"value", "minValue", "maxValue", "operator"};
    Predicate<CSVRecord> isEmptyRecord = record -> record.values().length == 1 && "".equals(record.values()[0]);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(PageContext pageContext, String filename, String sheetname, String name, String format, String query, boolean update, String password, Object autosize, boolean overWrite, int sheet) {
        String actionName;
        if (filename != null) {
            File destFile = VFSFileFactory.getFileObject((String)filename);
            if (!this.isOverWrite(update, overWrite) && destFile.exists()) {
                throw new SpreadSheetTag.FileAlreadyExistsException(destFile.getAbsolutePath());
            }
        }
        if (sheetname == null && (name == null || format != null)) {
            sheetname = "Sheet" + (sheet + 1);
        }
        String string = actionName = update ? "update" : "write";
        if (filename == null) {
            throw new SpreadSheetTag.ExcelMissingAttributeException(actionName, "filename");
        }
        if (name == null && query == null) {
            throw new SpreadSheetTag.ExcelMissingAttributeException(actionName, "name");
        }
        if (name != null) {
            Object o = pageContext.findAttribute(name);
            if (o == null) throw new SpreadSheetTag.ExcelInvalidVariableException(name);
            if (o instanceof ExcelInfo) {
                ExcelInfo info = (ExcelInfo)o;
                this.writeToExcel(info, update, filename, (String)sheetname, password, autosize);
                return;
            } else {
                if (!(o instanceof String) || !format.equalsIgnoreCase("csv")) throw new SpreadSheetTag.ExcelIllegalValueException(name, "name");
                String csv = (String)o;
                this.writeCSVToExcel(filename, csv, (String)sheetname, password, update, autosize);
            }
            return;
        } else {
            if (query == null) return;
            Object o = pageContext.findAttribute(query);
            if (!(o instanceof QueryTable) || o == null) throw new SpreadSheetTag.ExcelIllegalValueException(query, "query");
            QueryTable query2 = (QueryTable)o;
            this.writeToExcel(query2, update, filename, (String)sheetname, password, autosize, sheet);
        }
    }

    public boolean isOverWrite(boolean update, boolean overWrite) {
        return update || overWrite;
    }

    public void writeCSVToExcel(String filename, String csv, String sheetname, String password, boolean update, Object autosize) {
        Excel.writeCSVToExcel(filename, csv, sheetname, password, update, autosize);
    }

    public void writeToExcel(QueryTable q, boolean update, String filename, String sheetname, String password, Object autosize, int sheet) {
        ArrayList<String[]> values = new ArrayList<String[]>();
        String[] cols = q.getColumnList();
        values.add(cols);
        while (!q.isLast()) {
            coldfusion.sql.imq.Row r = q.getRow(q.getCurrentRow());
            int len = cols.length;
            String[] s = new String[len];
            for (int j = 0; j < cols.length; ++j) {
                Object colValue = r.getColumn(j);
                s[j] = colValue == null ? "" : colValue.toString();
            }
            values.add(s);
            q.next();
        }
        q.close();
        if (sheetname != null) {
            Excel.writeExcel(filename, values, (String)sheetname, password, update, autosize);
        } else {
            sheetname = "Sheet" + (sheet + 1);
            Excel.writeExcel(filename, values, (String)sheetname, password, update, autosize);
        }
    }

    public void writeToExcel(ExcelInfo in, boolean update, String filename, String sheetname, String password, Object autosize) {
        if (sheetname != null) {
            Excel.writeExcel(filename, in, sheetname, password, update, autosize);
        } else {
            Excel.writeExcel(filename, in, password, update, autosize);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void read(PageContext pageContext, String query, String format, String name, String src, int headerrow, String columnnames, String columns, int sheet, int maxcolcount, boolean excludeHeaderRow, String rows, String sheetname, boolean sheetNoProvided, String password) {
        if (query != null) {
            this.readExcelToQuery(pageContext, src, headerrow, columnnames, columns, sheet, maxcolcount, excludeHeaderRow, rows, sheetname, query, password);
            return;
        } else if (format != null && name != null) {
            if (format.equalsIgnoreCase("csv")) {
                this.readExcelToCSV(pageContext, src, headerrow, columnnames, columns, sheet, maxcolcount, excludeHeaderRow, rows, sheetname, name, password);
                return;
            } else {
                if (!format.equalsIgnoreCase("html")) throw new SpreadSheetTag.ExcelIllegalValueException(format, "format");
                this.readExcelToHTML(pageContext, src, headerrow, columnnames, columns, sheet, maxcolcount, excludeHeaderRow, rows, sheetname, name, password);
            }
            return;
        } else {
            if (format != null || name == null) throw new SpreadSheetTag.ExcelMissingAttributeException("read", "query/name");
            this.saveToVar(pageContext, src, sheetname, sheet, name, sheetNoProvided, password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToVar(PageContext pageContext, String src, String sheetname, int sheet, String name, boolean sheetNoProvided, String password) {
        InputStream inp = null;
        try {
            try {
                this.verifyFile(pageContext, src);
                inp = VFSFileFactory.getInputStream((String)src);
                Excel excel = new Excel(inp, password);
                if (sheetname != null) {
                    sheet = excel.getSheetIndex(sheetname);
                    if (sheet == -1) {
                        throw new SpreadSheetTag.ExcelInvalidSheetNameException2(sheetname);
                    }
                } else {
                    try {
                        ExcelInfo excelInfo = excel.getExcelInfo(sheet);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new SpreadSheetTag.ExcelInvalidSheetNumberException(sheet + 1);
                    }
                }
                ExcelInfo info = excel.getExcelInfo(sheet);
                Workbook book = info.getWorkbook();
                if (sheetNoProvided) {
                    for (int x = book.getNumberOfSheets() - 1; x >= 0; --x) {
                        if (sheet == x) continue;
                        book.removeSheetAt(x);
                    }
                    info.setSheetNoProvided(sheetNoProvided);
                }
                pageContext.setAttribute(name, (Object)info);
            }
            finally {
                if (inp != null) {
                    inp.close();
                }
            }
        }
        catch (IOException e) {
            throw new SpreadSheetTag.ExcelTagException((Throwable)e);
        }
    }

    public ArrayList<String[]> readExcel(Excel excel, String src, int headerrow, String columnnames, String columns, int sheet, boolean excludeHeaderRow, String rows, String sheetname) {
        ArrayList<String[]> values = null;
        if (sheetname != null && (sheet = excel.getSheetIndex(sheetname)) == -1) {
            throw new SpreadSheetTag.ExcelInvalidSheetNameException2(sheetname);
        }
        if (excel != null) {
            values = rows != null ? (columns != null ? (excludeHeaderRow ? excel.readXLS(sheet, rows, columns, headerrow - 1) : excel.readXLS(sheet, rows, columns, -1)) : (excludeHeaderRow ? excel.readXLS(sheet, rows, headerrow - 1) : excel.readXLS(sheet, rows, -1))) : (columns != null ? (excludeHeaderRow ? excel.readXLS(sheet, "", columns, headerrow - 1) : excel.readXLS(sheet, "", columns, -1)) : (excludeHeaderRow ? excel.readXLS(sheet, headerrow - 1) : excel.readXLS(sheet, -1)));
        }
        return values;
    }

    public Class<?> getExcelClass() {
        return ExcelInfo.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExcelToHTML(PageContext pageContext, String src, int headerrow, String columnnames, String columns, int sheet, int maxcolcount, boolean excludeHeaderRow, String rows, String sheetname, String name, String password) {
        String htmlString = "";
        InputStream inp = null;
        try {
            try {
                this.verifyFile(pageContext, src);
                inp = VFSFileFactory.getInputStream((String)src);
                Excel excel = new Excel(inp, password);
                ArrayList<String[]> values = this.readExcel(excel, src, headerrow, columnnames, columns, sheet, excludeHeaderRow, rows, sheetname);
                String[] header = new String[]{};
                if (headerrow != -1) {
                    if (columns != null) {
                        if (columns.contains(",")) {
                            Integer[] cols = new Integer[]{};
                            cols = Excel.doProcessList(columns);
                            Sheet hssfsheet = excel.getWorkbook().getSheetAt(sheet);
                            header = excel.getValuesAt(hssfsheet, headerrow - 1, cols);
                        } else {
                            int[] cols = Excel.doProcessRange(columns);
                            int startcol = cols[0] - 1;
                            int endcol = cols[1];
                            Sheet hssfsheet = excel.getWorkbook().getSheetAt(sheet);
                            header = excel.getValuesAt(hssfsheet, headerrow - 1, startcol, endcol);
                        }
                    } else {
                        header = excel.getValuesAt(sheet, headerrow - 1);
                    }
                }
                if (values != null) {
                    htmlString = this.populateTable(values, header, null);
                }
                pageContext.setAttribute(name, (Object)htmlString);
            }
            finally {
                if (inp != null) {
                    inp.close();
                }
            }
        }
        catch (IOException e) {
            throw new SpreadSheetTag.ExcelTagException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExcelToCSV(PageContext pageContext, String src, int headerrow, String columnnames, String columns, int sheet, int maxcolcount, boolean excludeHeaderRow, String rows, String sheetname, String name, String password) {
        String csvString = "";
        InputStream inp = null;
        try {
            try {
                this.verifyFile(pageContext, src);
                inp = VFSFileFactory.getInputStream((String)src);
                Excel excel = new Excel(inp, password);
                ArrayList<String[]> values = this.readExcel(excel, src, headerrow, columnnames, columns, sheet, excludeHeaderRow, rows, sheetname);
                if (values != null) {
                    csvString = this.populateCSV(values, null);
                }
                pageContext.setAttribute(name, (Object)csvString);
            }
            finally {
                if (inp != null) {
                    inp.close();
                }
            }
        }
        catch (IOException e) {
            throw new SpreadSheetTag.ExcelTagException((Throwable)e);
        }
    }

    private String verifyFile(PageContext pageContext, String filename) throws FileNotFoundException {
        if (filename.trim().length() == 0) {
            throw new FileNotFoundException(filename);
        }
        File file = VFSFileFactory.getFileObject((String)(filename = Utils.getFileFullPath((String)filename, (PageContext)pageContext, (boolean)true)));
        if (!file.exists()) {
            throw new FileNotFoundException(filename);
        }
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readExcelToQuery(PageContext pageContext, String src, int headerrow, String columnnames, String columns, int sheet, int maxcolcount, boolean excludeHeaderRow, String rows, String sheetname, String query, String password) {
        try (InputStream inp = null;){
            this.verifyFile(pageContext, src);
            inp = VFSFileFactory.getInputStream((String)src);
            Excel excel = new Excel(inp, password);
            ArrayList<String[]> values = this.readExcel(excel, src, headerrow, columnnames, columns, sheet, excludeHeaderRow, rows, sheetname);
            if (sheetname != null) {
                sheet = excel.getSheetIndex(sheetname);
            }
            int n = columns != null ? this.getColumnCountFromColumns(columns) : (maxcolcount = Excel.getColumnCount(excel.getWorkbook().getSheetAt(sheet)));
            if (values == null) return;
            if (headerrow != -1 && columnnames == null) {
                String[] header = null;
                if (columns != null) {
                    if (columns.contains(",")) {
                        Integer[] cols = new Integer[]{};
                        cols = Excel.doProcessList(columns);
                        Sheet hssfsheet = excel.getWorkbook().getSheetAt(sheet);
                        header = excel.getValuesAt(hssfsheet, headerrow - 1, cols);
                    } else {
                        int[] cols = Excel.doProcessRange(columns);
                        int startcol = cols[0] - 1;
                        int endcol = cols[1];
                        Sheet hssfsheet = excel.getWorkbook().getSheetAt(sheet);
                        header = excel.getValuesAt(hssfsheet, headerrow - 1, startcol, endcol);
                    }
                } else {
                    header = excel.getValuesAt(sheet, headerrow - 1);
                }
                if (header == null) throw new SpreadSheetTag.ExcelInvalidHeaderRowException(headerrow);
                this.populateQuery(pageContext, values, header, maxcolcount, query);
                return;
            } else {
                this.populateQuery(pageContext, values, maxcolcount, columnnames, query);
            }
            return;
        }
        catch (IOException e) {
            throw new SpreadSheetTag.ExcelTagException((Throwable)e);
        }
    }

    public int getColumnCountFromColumns(String range) {
        StringTokenizer st = new StringTokenizer(range, ",");
        int count = 0;
        while (st.hasMoreElements()) {
            String element = st.nextToken();
            if (element.contains("-")) {
                String[] parts = element.split("-");
                count += Integer.parseInt(parts[1].trim()) - Integer.parseInt(parts[0].trim()) + 1;
                continue;
            }
            ++count;
        }
        return count;
    }

    private void populateQuery(PageContext pageContext, ArrayList<String[]> values, int maxcolcount, String columnnames, String query) {
        Object stringTokenizer = null;
        if (columnnames != null) {
            String[] colnames = this.tokenizeColumnNamesStringToArray(columnnames);
            this.populateQuery(pageContext, values, colnames, maxcolcount, query);
        } else {
            this.populateQuery(pageContext, values, new String[0], maxcolcount, query);
        }
    }

    private String[] tokenizeColumnNamesStringToArray(String columnnames) {
        StringTokenizer stringTokenizer = new StringTokenizer(columnnames, "\t\n,");
        int count = stringTokenizer.countTokens();
        String[] colnames = new String[count];
        int index = 0;
        if (stringTokenizer != null) {
            while (stringTokenizer.hasMoreTokens()) {
                String columnname;
                colnames[index] = columnname = stringTokenizer.nextToken().trim();
                ++index;
            }
        }
        return colnames;
    }

    private void populateQuery(PageContext pageContext, ArrayList<String[]> values, String[] colnames, int maxcolcount, String query) {
        QueryTable resultQuery = this.populateQueryHelper(values, colnames, maxcolcount);
        pageContext.setAttribute(query, (Object)resultQuery);
    }

    private QueryTable populateQueryHelper(ArrayList<String[]> values, String[] colnames, int maxcolcount) {
        QueryTable resultQuery = new QueryTable();
        String colname = "col";
        ListIterator<String[]> iter = values.listIterator();
        int start = 0;
        while (iter.hasNext()) {
            String[] row = iter.next();
            if (start == 0) {
                String[] columnTypeNames;
                int[] columnTypes;
                String[] QueryColumns;
                if (maxcolcount > 0) {
                    QueryColumns = new String[maxcolcount];
                    columnTypes = new int[maxcolcount];
                    columnTypeNames = new String[maxcolcount];
                } else {
                    QueryColumns = new String[1];
                    columnTypes = new int[1];
                    columnTypeNames = new String[1];
                    columnTypes[0] = 12;
                    columnTypeNames[0] = "VARCHAR";
                    QueryColumns[0] = 0 < colnames.length ? colnames[0] : "col_1";
                }
                HashSet<String> colNameSet = new HashSet<String>();
                for (int i = 0; i < maxcolcount; ++i) {
                    columnTypes[i] = 12;
                    QueryColumns[i] = i < colnames.length && colnames[i] != null && !colnames[i].equalsIgnoreCase("") ? (colNameSet.contains(colnames[i].toLowerCase()) ? colnames[i] + "_" + i : colnames[i]) : colname + "_" + (i + 1);
                    colNameSet.add(QueryColumns[i].toLowerCase());
                }
                resultQuery = new QueryTable(0, QueryColumns, columnTypeNames, columnTypes);
            }
            resultQuery.addRows(1);
            for (int index = 0; index < row.length; ++index) {
                resultQuery.setField(start + 1, index + 1, (Object)row[index]);
            }
            ++start;
        }
        return resultQuery;
    }

    public Object read(Object source, Object sheetName_SheetNumber, String password) {
        int sheetnumber = 0;
        int sheetindex = 0;
        try {
            InputStream inp = null;
            if (source instanceof String) {
                if (VFSFileFactory.checkIfVFile((String)((String)source))) {
                    try {
                        inp = VFSFileFactory.getInputStream((String)((String)source));
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        inp = new FileInputStream((String)source);
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            } else if (source instanceof byte[]) {
                inp = new ByteArrayInputStream((byte[])source);
            }
            Excel excel = new Excel(inp, password);
            String sSheet = Cast._String((Object)sheetName_SheetNumber);
            if (CFPage.IsNumeric((Object)sheetName_SheetNumber)) {
                sheetnumber = Cast._int((Object)sheetName_SheetNumber, (boolean)false);
                --sheetnumber;
                sheetindex = excel.getSheetIndex(sSheet);
            } else {
                sheetindex = sheetnumber = excel.getSheetIndex(sSheet);
            }
            if (sheetnumber == -1 && !sSheet.equals("all")) {
                throw new SpreadSheetTag.ExcelInvalidSheetNameException(sSheet);
            }
            if ("all".equals(sSheet)) {
                sheetnumber = 0;
            }
            ExcelInfo info = excel.getExcelInfo(sheetnumber);
            Workbook book = info.getWorkbook();
            if (!"all".equals(sSheet)) {
                for (int x = book.getNumberOfSheets() - 1; x >= 0; --x) {
                    if (sheetnumber == x || sheetindex == x) continue;
                    book.removeSheetAt(x);
                }
                info.setSheetNoProvided(true);
            }
            if (info.getExcelSheetNumber() == -1) {
                throw new SpreadSheetTag.ExcelInvalidSheetException(sheetnumber + 1);
            }
            if (inp != null) {
                try {
                    inp.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return info;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new SpreadSheetTag.ExcelInvalidSheetException(sheetnumber + 1);
        }
        catch (IllegalArgumentException ex) {
            throw new SpreadSheetTag.ExcelInvalidSheetException(sheetnumber + 1);
        }
    }

    public boolean isExcelObject(Object o) {
        return o instanceof ExcelInfo;
    }

    public void write(String filePath, Object spreadsheet, String password, boolean overwrite, Object autosize) {
        File destFile = VFSFileFactory.getFileObject((String)filePath);
        if (!overwrite && destFile.exists()) {
            throw new SpreadSheetTag.FileAlreadyExistsException(destFile.getAbsolutePath());
        }
        Excel.writeExcel(filePath, (ExcelInfo)spreadsheet, password, false, autosize);
    }

    public byte[] readBinary(Object spreadsheet) {
        return Excel.readBinary((ExcelInfo)spreadsheet);
    }

    public void addRow(Object spreadsheet, String data, int row, int column, boolean insert, String datatype) {
        Excel.addRow((ExcelInfo)spreadsheet, data, row, column, insert, datatype);
    }

    public void addRows(Object obj, Object data, int startRow, int startColumn, boolean insert, Object datatypes, boolean insertColumnHeader) {
        ExcelInfo spreadsheet = (ExcelInfo)obj;
        String[] ds = null;
        Array d = null;
        if (null != datatypes) {
            if (datatypes instanceof Array) {
                d = (Array)datatypes;
            } else {
                throw new SpreadSheetTag.ExcelInvalidDatatypeTypeException();
            }
        }
        if (data instanceof QueryTable) {
            if (d != null) {
                ds = (String[])d.toArray((Object[])new String[((QueryTable)data).getRowCount()]);
            }
            Excel.addRows(spreadsheet, (QueryTable)data, startRow, startColumn, insert, ds, insertColumnHeader);
        } else if (data instanceof Array) {
            Array a = (Array)data;
            Object first = a.get(0);
            if (first instanceof Array) {
                int start = startRow;
                Iterator iter = a.iterator();
                int actualindex = 0;
                int sheetContaingRows = Excel.isSheetContaingRows(spreadsheet);
                while (iter.hasNext()) {
                    String datatype;
                    Integer[] datatypes_identifier;
                    Object o = iter.next();
                    if (!(o instanceof Array)) continue;
                    Array oArr = (Array)o;
                    for (Object innerarr : oArr) {
                        if (!(innerarr instanceof Array)) continue;
                        throw new SpreadSheetTag.InvalidDataException();
                    }
                    String[] s = ExcelServiceImpl.handleCFPrimitivesToString(oArr);
                    Integer[] lastdatatype = new Integer[oArr.size()];
                    if (d != null && d.size() > actualindex && (datatypes_identifier = Excel.getParsedDatatypes(datatype = (String)d.get(actualindex++), oArr.size())) != null) {
                        lastdatatype = datatypes_identifier;
                    }
                    if (start == -1) {
                        start = 1;
                    }
                    if (sheetContaingRows > 0) {
                        start = sheetContaingRows + 2;
                    }
                    Excel.addRow(spreadsheet, s, start, startColumn, insert, lastdatatype);
                    ++start;
                    sheetContaingRows = -1;
                }
            } else {
                if (d != null) {
                    ds = (String[])d.toArray((Object[])new String[a.size()]);
                }
                String[] s = (String[])a.toArray((Object[])new String[a.size()]);
                Excel.addRows(spreadsheet, s, startRow, startColumn, insert, ds);
            }
        } else {
            throw new SpreadSheetTag.InvalidInputException();
        }
    }

    public Struct getInfo(Object spreadsheet) {
        Struct result = Excel.info((ExcelInfo)spreadsheet);
        return result;
    }

    public void addInfo(Object spreadsheet, Struct properties) {
        Excel.addInfo((ExcelInfo)spreadsheet, properties);
    }

    public void applyAutofilter(Object o, String rowbreaks, String columnbreaks) {
        ExcelInfo spreadsheet = (ExcelInfo)o;
        Sheet sheet = spreadsheet.getWorkbook().getSheet(spreadsheet.getExcelSheetName());
        Excel.applyRowbreaks(rowbreaks, sheet);
        Excel.applyColumnbreaks(columnbreaks, sheet);
    }

    public void applyAutofilter(Object spreadsheet, String autofilter) {
        Excel.applyAutofilter(autofilter, ((ExcelInfo)spreadsheet).getWorkbook().getSheet(((ExcelInfo)spreadsheet).getExcelSheetName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSpreadsheetFile(String value) {
        boolean bSpreadSheet = false;
        FileInputStream inp = null;
        try {
            inp = new FileInputStream(value);
            new Excel(inp);
            bSpreadSheet = true;
        }
        catch (Exception exception) {
        }
        finally {
            if (inp != null) {
                try {
                    ((InputStream)inp).close();
                }
                catch (Exception exception) {}
            }
        }
        return bSpreadSheet;
    }

    public void createSheet(Object spreadsheet, String sheetName) {
        if (sheetName.isEmpty()) {
            Excel.createSheet((ExcelInfo)spreadsheet);
        } else {
            Excel.createSheet((ExcelInfo)spreadsheet, sheetName);
        }
    }

    public void setActiveSheet(Object spreadsheet, int sheetNumber) {
        Excel.setActiveSheet((ExcelInfo)spreadsheet, sheetNumber);
    }

    public void setActiveSheet(Object spreadsheet, String sheetName) {
        Excel.setActiveSheet((ExcelInfo)spreadsheet, sheetName);
    }

    public void removeSheet(Object spreadsheet, String sheetName) {
        Excel.removeSheet((ExcelInfo)spreadsheet, sheetName);
    }

    public void removeSheet(Object spreadsheet, int sheetNumber) {
        Excel.removeSheet((ExcelInfo)spreadsheet, sheetNumber);
    }

    public Object createNewSpreadsheet(Boolean xmlformat) {
        boolean isXSSF = xmlformat;
        Excel excel = null;
        excel = isXSSF ? new Excel("XSSF") : new Excel("HSSF");
        return excel.getExcelInfo();
    }

    public void addColumn(Object spreadsheet, String data, int startRow, int startColumn, boolean insert, String datatype) {
        Excel.addColumn((ExcelInfo)spreadsheet, data, startRow, startColumn, insert, datatype);
    }

    public void shiftRows(Object spreadsheet, int start, int end, int rows) {
        Excel.shiftRows((ExcelInfo)spreadsheet, start, end, rows);
    }

    public void shiftColumns(Object spreadsheet, int start, int columns) {
        Excel.shiftColumns((ExcelInfo)spreadsheet, start, columns);
    }

    public ArrayList<Struct> getCellComment(Object spreadsheet) {
        return Excel.getCellComment((ExcelInfo)spreadsheet);
    }

    public String getCellType(Object spreadsheet, int row, int column) {
        return Excel.getCellType((ExcelInfo)spreadsheet, row, column);
    }

    public Struct getCellFormat(Object spreadsheet, int row, int column) {
        return Excel.getCellFormat((ExcelInfo)spreadsheet, row, column);
    }

    public void setCellRangeValue(Object spreadsheet, String value, int startRow, int startColumn, int endRow, int endColumn, String datatype) {
        this.checkForValidRange(startRow, startColumn, endRow, endColumn);
        Excel.setCellRangeValue((ExcelInfo)spreadsheet, value, startRow, startColumn, endRow, endColumn, datatype);
    }

    public void setActiveCell(Object spreadsheet, int row, int column) {
        Excel.setActiveCell((ExcelInfo)spreadsheet, row, column);
    }

    public Struct getActiveCell(Object spreadsheet) {
        return Excel.getActiveCell((ExcelInfo)spreadsheet);
    }

    public void clearCell(Object spreadsheet, int row, int column) {
        Excel.clearCell((ExcelInfo)spreadsheet, row, column);
    }

    public void clearCellRange(Object spreadsheet, int startRow, int startColumn, int endRow, int endColumn) {
        this.checkForValidRange(startRow, startColumn, endRow, endColumn);
        Excel.clearCellRange((ExcelInfo)spreadsheet, startRow, startColumn, endRow, endColumn);
    }

    public void setCellHyperlink(Object spreadsheet, Map obj) {
        Hyperlink hyperlink = new Hyperlink();
        this.convertToUpperCase(obj, "type");
        ValidatorFiller.INSTANCE.fillObject((Object)hyperlink, obj, HyperlinkMetadata.getInstance().getConsumerMap());
        Excel.setCellHyperlink((ExcelInfo)spreadsheet, hyperlink);
    }

    public Struct getCellHyperlink(Object spreadsheet, int row, int column) {
        return Excel.getCellHyperlink((ExcelInfo)spreadsheet, row, column);
    }

    public List getHyperlinks(Object spreadsheet) {
        return Excel.getHyperlinks((ExcelInfo)spreadsheet);
    }

    public void setRepeatingRows(Object spreadsheet, String rows) {
        Excel.setRepeatingRows((ExcelInfo)spreadsheet, rows);
    }

    public void setRepeatingColumns(Object spreadsheet, String columns) {
        Excel.setRepeatingColumns((ExcelInfo)spreadsheet, columns);
    }

    public void addPrintGridlines(Object spreadsheet, String sheetName) {
        Excel.addPrintGridlines((ExcelInfo)spreadsheet, sheetName);
    }

    public void removePrintGridlines(Object spreadsheet, String sheetName) {
        Excel.removePrintGridlines((ExcelInfo)spreadsheet, sheetName);
    }

    public boolean isRowHidden(Object spreadsheet, int row) {
        return Excel.isRowHidden((ExcelInfo)spreadsheet, row);
    }

    public boolean isColumnHidden(Object spreadsheet, int column) {
        return Excel.isColumnHidden((ExcelInfo)spreadsheet, column);
    }

    public void setRowHidden(Object spreadsheet, int row, boolean hide) {
        Excel.setRowHidden((ExcelInfo)spreadsheet, row, hide);
    }

    public void setColumnHidden(Object spreadsheet, int column, boolean hide) {
        Excel.setColumnHidden((ExcelInfo)spreadsheet, column, hide);
    }

    public int getColumnWidth(Object spreadsheet, int column, boolean returnWidthInPixels) {
        return Excel.getColumnWidth((ExcelInfo)spreadsheet, column, returnWidthInPixels);
    }

    public int getLastRowNumber(Object spreadsheet) {
        return Excel.getLastRowNumber((ExcelInfo)spreadsheet);
    }

    public void setFitToPage(Object spreadsheet, boolean fitToPage, int pagesWidth, int pagesHeight) {
        Excel.setFitToPage((ExcelInfo)spreadsheet, fitToPage, pagesWidth, pagesHeight);
    }

    public boolean isXMLFormat(Object spreadsheet) {
        return Excel.isXMLFormat((ExcelInfo)spreadsheet);
    }

    public boolean isStreamingXMLFormat(Object spreadsheet) {
        return Excel.isStreamingXMLFormat((ExcelInfo)spreadsheet);
    }

    public boolean isBinaryFormat(Object spreadsheet) {
        return Excel.isBinaryFormat((ExcelInfo)spreadsheet);
    }

    public void addDataValidationRule(Object spreadsheet, Map map) {
        SheetDataValidationRule validationRule = new SheetDataValidationRule();
        this.convertToUpperCase(map, "operator");
        this.convertToUpperCase(map, "validationType");
        String validationType = Cast._String(map.get("validationType"));
        if ("LIST".equals(validationType)) {
            this.checkInvalidKeysForOperationException(map, this.invalidKeysForListOperation, "addDataValidationRule");
        } else if (map.containsKey("operator")) {
            String operator = Cast._String(map.get("operator"));
            if (oneOperandOperators.contains(operator)) {
                this.checkInvalidKeysForOperationException(map, this.invalidKeysForOneOperandOperation, "addDataValidationRule");
            } else if (twoOperandOperators.contains(operator)) {
                this.checkInvalidKeysForOperationException(map, this.invalidKeysForTwoOperandOperation, "addDataValidationRule");
            }
        } else {
            throw new SpreadSheetTag.KeyAbsentForSpecificKeyValuePairException("operator", "validationType", (Object)validationType, "addDataValidationRule");
        }
        ValidatorFiller.INSTANCE.fillObject((Object)validationRule, map, SheetDataValidationRuleMetadata.getInstance().getConsumerMap());
        Excel.addDataValidationRule((ExcelInfo)spreadsheet, validationRule);
    }

    public void setForceFormulaRecalculation(Object spreadsheet, boolean forceRecalculation) {
        Excel.setForceFormulaRecalculation((ExcelInfo)spreadsheet, forceRecalculation);
    }

    public boolean getForceFormulaRecalculation(Object spreadsheet) {
        return Excel.getForceFormulaRecalculation((ExcelInfo)spreadsheet);
    }

    public void setPrintOrientation(Object spreadsheet, String orientation, String sheetName) {
        Excel.setPrintOrientation((ExcelInfo)spreadsheet, orientation, sheetName);
    }

    public String getPrintOrientation(Object spreadsheet, String sheetName) {
        return Excel.getPrintOrientation((ExcelInfo)spreadsheet, sheetName);
    }

    public void renameSheet(Object spreadsheet, String oldName, String newName) {
        Excel.renameSheet((ExcelInfo)spreadsheet, oldName, newName);
    }

    public void setRowBreak(Object spreadsheet, int row) {
        Excel.setRowBreak((ExcelInfo)spreadsheet, row);
    }

    public void removeRowBreak(Object spreadsheet, int row) {
        Excel.removeRowBreak((ExcelInfo)spreadsheet, row);
    }

    public void setColumnBreak(Object spreadsheet, int column) {
        Excel.setColumnBreak((ExcelInfo)spreadsheet, column);
    }

    public void removeColumnBreak(Object spreadsheet, int column) {
        Excel.removeColumnBreak((ExcelInfo)spreadsheet, column);
    }

    public void groupRows(Object spreadsheet, int startRow, int endRow) {
        Excel.groupRows((ExcelInfo)spreadsheet, startRow, endRow);
    }

    public void ungroupRows(Object spreadsheet, int startRow, int endRow) {
        Excel.ungroupRows((ExcelInfo)spreadsheet, startRow, endRow);
    }

    public void groupColumn(Object spreadsheet, int startColumn, int endColumn) {
        Excel.groupColumns((ExcelInfo)spreadsheet, startColumn, endColumn);
    }

    public void ungroupColumn(Object spreadsheet, int startColumn, int endColumn) {
        Excel.ungroupColumns((ExcelInfo)spreadsheet, startColumn, endColumn);
    }

    public void deleteColumn(Object spreadsheet, int column) {
        new Excel().deleteColumn((ExcelInfo)spreadsheet, column);
    }

    public void deleteColumns(Object spreadsheet, String columns) {
        new Excel().deleteColumns((ExcelInfo)spreadsheet, columns);
    }

    public void mergeCells(Object spreadsheet, int startRow, int endRow, int startColumn, int endColumn) {
        new Excel().mergeCells((ExcelInfo)spreadsheet, startRow, endRow, startColumn, endColumn);
    }

    public void setFooter(Object spreadsheet, String leftFooter, String centerFooter, String rightFooter) {
        Excel.setFooter((ExcelInfo)spreadsheet, leftFooter, centerFooter, rightFooter);
    }

    public void setHeader(Object spreadsheet, String leftHeader, String centerHeader, String rightHeader) {
        Excel.setHeader((ExcelInfo)spreadsheet, leftHeader, centerHeader, rightHeader);
    }

    public int getColumnCount(Object spreadsheet) {
        return ((ExcelInfo)spreadsheet).getColumnCount();
    }

    public void addImage(Object spreadsheet, String imagePath, String anchor) {
        Excel.addImage((ExcelInfo)spreadsheet, imagePath, anchor);
    }

    public void setRowHeight(Object spreadsheet, int row, int height) {
        Excel.setRowHeight((ExcelInfo)spreadsheet, row, height);
    }

    public void setColumnWidth(Object o, int column, int width) {
        ExcelInfo spreadsheet = (ExcelInfo)o;
        spreadsheet.addIgnoreColumnsForAutoResize(column);
        Excel.setColumnWidth(spreadsheet, column, width);
    }

    public void addImage(Object spreadsheet, byte[] imageData, String imageType, String anchor) {
        Excel.addImage((ExcelInfo)spreadsheet, imageData, imageType, anchor);
    }

    public void setHeaderImage(Object spreadsheet, byte[] imageData, String alignment, String imageType) {
        Excel.setImage((ExcelInfo)spreadsheet, imageData, true, alignment, "header_image", imageType);
    }

    public void setFooterImage(Object spreadsheet, byte[] imageData, String alignment, String imageType) {
        Excel.setImage((ExcelInfo)spreadsheet, imageData, false, alignment, "footer_image", imageType);
    }

    public void setHeaderImage(Object spreadsheet, String imageData, String alignment) {
        Excel.setImage((ExcelInfo)spreadsheet, imageData, true, alignment, "header_image");
    }

    public void setFooterImage(Object spreadsheet, String imageData, String alignment) {
        Excel.setImage((ExcelInfo)spreadsheet, imageData, false, alignment, "footer_image");
    }

    public int getColumnCount(Object o, Object sheetName_SheetNumber) {
        ExcelInfo spreadsheet = (ExcelInfo)o;
        int columnCount = sheetName_SheetNumber == null ? spreadsheet.getColumnCount() : spreadsheet.getColumnCount(sheetName_SheetNumber);
        return columnCount;
    }

    public String getCellValue(Object spreadsheet, int row, int column) {
        return Excel.getCellValue((ExcelInfo)spreadsheet, row, column);
    }

    public void deleteRow(Object spreadsheet, int row) {
        new Excel().deleteRow((ExcelInfo)spreadsheet, row);
    }

    public void deleteRows(Object spreadsheet, String rows) {
        new Excel().deleteRows((ExcelInfo)spreadsheet, rows);
    }

    public void setCellValue(Object spreadsheet, String value, int row, int column, String datatype) {
        Excel.setCellValue((ExcelInfo)spreadsheet, value, row, column, datatype);
    }

    public Struct getCellComment(Object spreadsheet, int row, int column) {
        return Excel.getCellComment((ExcelInfo)spreadsheet, row, column);
    }

    public void setCellFormula(Object spreadsheet, String formula, int row, int column) {
        new Excel();
        Excel.setCellFormula((ExcelInfo)spreadsheet, formula, row, column);
    }

    public void setCellComment(Object spreadsheet, Struct comment, int row, int column) {
        new Excel().setCellComment((ExcelInfo)spreadsheet, comment, row, column);
    }

    public ArrayList<Struct> getCellFormula(Object spreadsheet) {
        new Excel();
        return Excel.getCellFormula((ExcelInfo)spreadsheet);
    }

    public String getCellFormula(Object spreadsheet, int row, int column) {
        new Excel();
        return Excel.getCellFormula((ExcelInfo)spreadsheet, row, column);
    }

    public void formatCellRange(Object spreadsheet, Struct format, int startRow, int startColumn, int endRow, int endColumn) {
        this.checkForValidRange(startRow, startColumn, endRow, endColumn);
        Excel.formatCellRange((ExcelInfo)spreadsheet, format, startRow, startColumn, endRow, endColumn);
    }

    public void addColumn(Object spreadsheet, String data, String datatype) {
        Excel.addColumn((ExcelInfo)spreadsheet, data, datatype);
    }

    public void formatColumn(Object spreadsheet, Struct format, int column) {
        Excel.formatColumn((ExcelInfo)spreadsheet, format, column);
    }

    public void formatColumns(Object spreadsheet, Struct format, String columns) {
        Excel.formatColumns((ExcelInfo)spreadsheet, format, columns);
    }

    public void formatCell(Object spreadsheet, Struct format, int row, int column) {
        Excel.formatCell((ExcelInfo)spreadsheet, format, row, column);
    }

    public void shiftColumns(Object spreadsheet, int start, int end, int columns) {
        Excel.shiftColumns((ExcelInfo)spreadsheet, start, end, columns);
    }

    public void shiftRows(Object spreadsheet, int start, int rows) {
        Excel.shiftRows((ExcelInfo)spreadsheet, start, rows);
    }

    public void formatRow(Object spreadsheet, Struct format, int row) {
        Excel.formatRow((ExcelInfo)spreadsheet, format, row);
    }

    public void formatRows(Object spreadsheet, Struct format, String rows) {
        Excel.formatRows((ExcelInfo)spreadsheet, format, rows);
    }

    public void addFreezePane(Object spreadsheet, int freezeColumn, int freezeRow, int column, int row) {
        Excel.addFreezePane((ExcelInfo)spreadsheet, freezeColumn, freezeRow, column, row);
    }

    public void addSplitPane(Object spreadsheet, int col, int row, int splitColumn, int splitRow, String position) {
        Excel.addSplitPane((ExcelInfo)spreadsheet, col, row, splitColumn, splitRow, position);
    }

    public Object createNewStreamingSpreadsheet(String sheetname, int randomAccessWindowSize, boolean autosizeColumn) {
        Excel excel = null;
        if (null != sheetname) {
            if (randomAccessWindowSize == Integer.MAX_VALUE) {
                excel = new Excel(sheetname, "SXSSF");
            } else {
                if (randomAccessWindowSize < -1 || randomAccessWindowSize == 0) {
                    throw new SpreadSheetTag.ExcelIllegalValueException(Integer.toString(randomAccessWindowSize), "randomAccessWindowSize");
                }
                excel = new Excel(sheetname, "SXSSF", randomAccessWindowSize);
            }
        } else {
            excel = new Excel("SXSSF");
        }
        ExcelInfo excelInfo = excel.getExcelInfo();
        if (autosizeColumn) {
            ((SXSSFSheet)excelInfo.getWorkbook().getSheet(sheetname == null ? "Sheet1" : sheetname)).trackAllColumnsForAutoSizing();
        }
        return excelInfo;
    }

    public Object processStreamingSheet(String filePath, UDFMethod rowProcessor, Map options) {
        StreamingProcessConfig processConfig = new StreamingProcessConfig();
        ValidatorFiller.INSTANCE.fillObject((Object)processConfig, options, StreamingSpreadsheetProcessMetadata.getInstance().getConsumerMap());
        InputStream is = null;
        try {
            is = new FileInputStream(new File(filePath));
            Workbook workbook = StreamingReader.builder().rowCacheSize(processConfig.getRandomAccessWindowSize()).open(is);
            String sheetName = processConfig.getSheetName() == null ? workbook.getSheetName(0) : processConfig.getSheetName();
            Sheet sheet = workbook.getSheet(sheetName);
            Excel processedSheet = new Excel(sheetName, "SXSSF", processConfig.getRandomAccessWindowSize());
            ExcelInfo processedSheetInfo = processedSheet.getExcelInfo(sheetName);
            if (processConfig.isAsync()) {
                Future future = Excel.doAsyncProcessStreamingSheet(sheet, rowProcessor, processedSheetInfo);
                return future;
            }
            Excel.doProcessStreamingSheet(sheet, rowProcessor, processedSheetInfo);
            ExcelInfo excelInfo = processedSheetInfo;
            return excelInfo;
        }
        catch (IOException e) {
            throw new SpreadSheetTag.ExcelProcessingException((Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new SpreadSheetTag.ExcelProcessingException((Throwable)e);
            }
        }
    }

    public boolean cleanupSXSSFTempFiles(Object spreadsheet) {
        ExcelInfo excelInfo = (ExcelInfo)spreadsheet;
        Workbook workbook = excelInfo.getWorkbook();
        if (workbook instanceof SXSSFWorkbook) {
            return ((SXSSFWorkbook)workbook).dispose();
        }
        throw new SpreadSheetTag.InvalidExcelFormatForMethodException("streamingSpreadsheetCleanup");
    }

    public Object readStreamingSheet(String filePath, Map options) {
        Object object;
        block9: {
            StreamingReadConfig readConfig = new StreamingReadConfig();
            ValidatorFiller.INSTANCE.fillObject((Object)readConfig, options, StreamingSpreadsheetReadMetadata.getInstance().getConsumerMap());
            if ("query".equals(readConfig.getFormat().toLowerCase())) {
                this.checkInvalidKeyFormatOperationException(options, "destinationFilePath", "query", "streamingSpreadsheetRead");
            }
            InputStream is = VFSFileFactory.getInputStream((String)filePath);
            try {
                Workbook workbook = StreamingReader.builder().rowCacheSize(readConfig.getRandomAccessWindowSize()).open(is);
                String sheetName = readConfig.getSheetName() == null ? workbook.getSheetName(0) : readConfig.getSheetName();
                Sheet sheet = workbook.getSheet(sheetName);
                ArrayList<String[]> rows = new ArrayList<String[]>();
                int maxNumberOfColumns = Excel.doReadStreamingSheet(rows, sheet, readConfig);
                object = this.processValues(rows, readConfig, maxNumberOfColumns);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SpreadSheetTag.ExcelReadException((Throwable)e);
                }
            }
            is.close();
        }
        return object;
    }

    private Object processValues(ArrayList<String[]> values, StreamingReadConfig readConfig, int maxNumberOfColumns) {
        switch (readConfig.getFormat().toLowerCase()) {
            case "html": {
                return this.toFormattedString(values, readConfig);
            }
            case "csv": {
                return this.toFormattedString(values, readConfig);
            }
            case "query": {
                return this.toQuery(values, readConfig, maxNumberOfColumns);
            }
        }
        return this.toFormattedString(values, readConfig);
    }

    private QueryTable toQuery(ArrayList<String[]> values, StreamingReadConfig readConfig, int maxNumberOfColumns) {
        String columns = readConfig.getColumns();
        int maxColCount = columns != null ? this.getColumnCountFromColumns(columns) : maxNumberOfColumns;
        String[] header = new String[]{};
        String columnNames = readConfig.getColumnNames();
        int headerRow = readConfig.getHeaderRow();
        if (headerRow != -1 && columnNames == null) {
            header = this.processHeader(values, readConfig);
        } else if (columnNames != null) {
            header = this.tokenizeColumnNamesStringToArray(columnNames);
            if (headerRow != -1 && readConfig.isExcludeHeaderRow()) {
                values.remove(headerRow - 1);
            }
        }
        return this.populateQueryHelper(values, header, maxColCount);
    }

    private String toFormattedString(ArrayList<String[]> values, StreamingReadConfig readConfig) {
        String[] header = this.processHeader(values, readConfig);
        switch (readConfig.getFormat().toLowerCase()) {
            case "html": {
                return this.populateTable(values, header, readConfig.getDestinationFilePath());
            }
            case "csv": {
                return this.populateCSV(values, readConfig.getDestinationFilePath());
            }
        }
        return null;
    }

    private String[] processHeader(ArrayList<String[]> values, StreamingReadConfig readConfig) {
        try {
            String[] header = new String[]{};
            int headerRow = readConfig.getHeaderRow();
            if (headerRow != -1 && !values.isEmpty()) {
                header = values.get(headerRow - 1);
                if (readConfig.isExcludeHeaderRow()) {
                    values.remove(headerRow - 1);
                }
            }
            return header;
        }
        catch (IndexOutOfBoundsException e) {
            throw new SpreadSheetTag.ExcelInvalidHeaderRowException(readConfig.getHeaderRow());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object createNewSpreadsheet(String sheetname, Object isXmlformat) {
        Excel excel = null;
        if (CFPage.IsBoolean((Object)isXmlformat)) {
            boolean isXSSF = Cast._boolean((Object)isXmlformat);
            excel = isXSSF ? new Excel(sheetname, "XSSF") : new Excel(sheetname, "HSSF");
            return excel.getExcelInfo();
        } else {
            if (!(isXmlformat instanceof String)) throw new SpreadSheetTag.InvalidExcelFormatException();
            if (((String)isXmlformat).equalsIgnoreCase("XSSF")) {
                excel = new Excel(sheetname, "XSSF");
                return excel.getExcelInfo();
            } else {
                if (!((String)isXmlformat).equalsIgnoreCase("HSSF")) throw new SpreadSheetTag.InvalidExcelFormatException();
                excel = new Excel(sheetname, "HSSF");
            }
        }
        return excel.getExcelInfo();
    }

    private static String[] handleCFPrimitivesToString(Array arr) {
        String[] strArray = new String[arr.size()];
        for (int i = 0; i < arr.size(); ++i) {
            Object value = arr.get(i);
            strArray[i] = value instanceof Number || value instanceof Boolean || value instanceof CFBoolean ? Cast._String((Object)value) : (String)value;
        }
        return strArray;
    }

    private String populateTable(ArrayList<String[]> values, String[] header, String destinationFilePath) {
        PrintWriter fileStream = null;
        try {
            if (null != destinationFilePath) {
                fileStream = new PrintWriter(new BufferedWriter(new OutputStreamWriter(VFSFileFactory.getOutputStream((String)destinationFilePath, (boolean)false), "UTF-16")));
            }
            ListIterator<String[]> iter = values.listIterator();
            StringBuilder outputBuilder = new StringBuilder();
            if (header != null && header.length > 0) {
                StringBuilder headerBuilder = new StringBuilder();
                for (String s : header) {
                    if (s == null || s.equalsIgnoreCase("")) continue;
                    headerBuilder.append(linesep).append("<TH>").append(s).append("</TH>").append(linesep);
                }
                this.appendToFileOrOutputBuilder(destinationFilePath, fileStream, outputBuilder, headerBuilder);
            }
            while (iter.hasNext()) {
                StringBuilder rowOutput = new StringBuilder();
                String[] row = iter.next();
                rowOutput.append("<TR>").append(linesep);
                for (int index = 0; index < row.length; ++index) {
                    String val = row[index];
                    if (val == null || val.equalsIgnoreCase("")) {
                        val = "&nbsp;";
                    }
                    rowOutput.append("<TD>").append(linesep).append(val).append(linesep).append("</TD>").append(linesep);
                }
                rowOutput.append("</TR>").append(linesep);
                this.appendToFileOrOutputBuilder(destinationFilePath, fileStream, outputBuilder, rowOutput);
            }
            String string = outputBuilder.toString();
            return string;
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            throw new SpreadSheetTag.ExcelProcessingException((Throwable)e);
        }
        finally {
            if (null != fileStream) {
                fileStream.close();
            }
        }
    }

    private void appendToFileOrOutputBuilder(String destinationFilePath, PrintWriter fileStream, StringBuilder outputBuilder, StringBuilder rowOutput) {
        if (null == destinationFilePath) {
            outputBuilder.append(rowOutput.toString());
        } else {
            fileStream.append(rowOutput.toString());
        }
    }

    public String populateCSV(ArrayList<String[]> values, String destinationFilePath) {
        PrintWriter fileStream = null;
        try {
            if (null != destinationFilePath) {
                fileStream = new PrintWriter(new BufferedWriter(new OutputStreamWriter(VFSFileFactory.getOutputStream((String)destinationFilePath, (boolean)false), "UTF-16")));
            }
            StringBuilder outputBuilder = new StringBuilder();
            ListIterator<String[]> iter = values.listIterator();
            while (iter.hasNext()) {
                StringBuilder rowOutput = new StringBuilder();
                String[] row = iter.next();
                for (int index = 0; index < row.length; ++index) {
                    Object val = row[index];
                    if (val == null) continue;
                    if (((String)val).contains(",")) {
                        val = "\"" + (String)val + "\"";
                    }
                    if (index == 0) {
                        rowOutput.append((String)val);
                        continue;
                    }
                    rowOutput.append(",").append((String)val);
                }
                rowOutput.append(linesep);
                this.appendToFileOrOutputBuilder(destinationFilePath, fileStream, outputBuilder, rowOutput);
            }
            String string = outputBuilder.toString();
            return string;
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            throw new SpreadSheetTag.ExcelProcessingException((Throwable)e);
        }
        finally {
            if (null != fileStream) {
                fileStream.close();
            }
        }
    }

    public void processCSV(String filePath, UDFMethod rowProcessor, Map csvFormatConfiguration, UDFMethod rowFilter, boolean processRowAsJavaArray) {
        try {
            CSVFormat csvFormat = CSVFormat.DEFAULT;
            String encoding = "UTF-8";
            if (null != csvFormatConfiguration) {
                this.checkInvalidKeysForOperationException(csvFormatConfiguration, this.invalidKeysForCSVProcess, "csvProcess");
                csvFormat = this.configureCSVFormat(csvFormatConfiguration);
                encoding = this.getEncodingFromMap(csvFormatConfiguration);
            }
            try (FileReader in = new FileReader(filePath, Charset.forName(encoding));){
                int rowNumber = 0;
                CSVParser records = csvFormat.parse((Reader)in);
                for (CSVRecord record : records) {
                    if (this.invokeRowFilter(rowFilter, record)) continue;
                    Object[] args = new Object[]{processRowAsJavaArray ? this.getArrayForRecordValues(record) : this.getCFArrayForCSVRecord(csvFormat, record), ++rowNumber};
                    CFPage._invokeUDF((Object)rowProcessor, (String)rowProcessor.getName(), (CFPage)((CFPage)FusionContext.getCurrent().pageContext.getPage()), (Object[])args);
                }
            }
        }
        catch (Throwable e) {
            throw new SpreadSheetTag.CSVProcessingException(e);
        }
    }

    private String getEncodingFromMap(Map csvFormatConfiguration) {
        if (csvFormatConfiguration.containsKey("ENCODING")) {
            return FieldTypecastUtil.INSTANCE.getStringProperty(csvFormatConfiguration.get("ENCODING"));
        }
        return "UTF-8";
    }

    private Object getArrayForRecordValues(CSVRecord record) {
        return this.isEmptyRecord.test(record) ? new String[]{} : record.values();
    }

    public Object readCSV(String filePath, String outputFormat, Map csvFormatConfiguration, UDFMethod rowFilter) {
        CSVFormat csvFormat = CSVFormat.DEFAULT;
        String encoding = "UTF-8";
        if (null != csvFormatConfiguration) {
            this.checkInvalidKeysForOperationException(csvFormatConfiguration, this.invalidKeysForCSVRead, "csvRead");
            String format = outputFormat.toLowerCase();
            if (formatsWithoutNullStringSupport.contains(format)) {
                this.checkInvalidKeyFormatOperationException(csvFormatConfiguration, "nullString", outputFormat, "csvRead");
            }
            if (!formatsWithHeadersForCSVRead.contains(format)) {
                this.checkInvalidKeysFormatOperation(this.headerValidationKeys, outputFormat, csvFormatConfiguration);
            }
            if (!"arrayofstruct".equals(format)) {
                this.checkInvalidKeyFormatOperationException(csvFormatConfiguration, "ignoreHeaderCase", outputFormat, "csvRead");
            }
            if (!"csvstring".equals(format)) {
                this.checkInvalidKeysFormatOperation(this.csvStringFormatSpecificKeys, outputFormat, csvFormatConfiguration);
            } else {
                this.checkInvalidKeyFormatOperationException(csvFormatConfiguration, "escapeCharacter", outputFormat, "csvRead");
            }
            csvFormat = this.configureCSVFormat(csvFormatConfiguration);
            encoding = this.getEncodingFromMap(csvFormatConfiguration);
        }
        try {
            return this.parseAndTransformCSVForRead(filePath, outputFormat, csvFormat, rowFilter, encoding);
        }
        catch (Exception e) {
            throw new SpreadSheetTag.CSVReadException((Throwable)e);
        }
    }

    public void writeCSV(Object data, String inputFormat, String outputFilePath, Map csvFormatConfiguration) {
        try {
            CSVFormat csvFormat = CSVFormat.DEFAULT;
            CSVFormat csvReadConfig = CSVFormat.DEFAULT;
            String encoding = "UTF-8";
            if (null != csvFormatConfiguration) {
                this.checkInvalidKeysForOperationException(csvFormatConfiguration, this.invalidKeysForCSVWrite, "csvWrite");
                String format = inputFormat.toLowerCase();
                if (formatsWithoutNullStringSupport.contains(format)) {
                    this.checkInvalidKeyFormatOperationException(csvFormatConfiguration, "nullString", inputFormat, "csvWrite");
                }
                if (!"csvstring".equals(format)) {
                    this.checkInvalidKeyFormatOperationException(csvFormatConfiguration, "readCSVConfig", inputFormat, "csvWrite");
                } else if (csvFormatConfiguration.containsKey("readCSVConfig")) {
                    csvReadConfig = this.configureCSVFormat(Cast._Map(csvFormatConfiguration.remove("readCSVConfig")));
                }
                csvFormat = this.configureCSVFormat(csvFormatConfiguration);
                encoding = this.getEncodingFromMap(csvFormatConfiguration);
            }
            this.parseAndTransformCSVForWrite(data, inputFormat, csvFormat, outputFilePath, csvReadConfig, encoding);
        }
        catch (Throwable e) {
            throw new SpreadSheetTag.CSVWriteException(e);
        }
    }

    private void parseAndTransformCSVForWrite(Object data, String inputFormat, CSVFormat csvFormat, String outputFilePath, CSVFormat csvReadConfig, String encoding) throws IOException {
        switch (inputFormat.toLowerCase()) {
            case "csvstring": {
                this.writeCSVStringToCSVFile(Cast._String((Object)data), csvFormat, outputFilePath, csvReadConfig, encoding);
                break;
            }
            case "arrayofcfarray": {
                this.writeArrayToCSVFile(Cast._Array((Object)data), csvFormat, "cfarray", outputFilePath, encoding);
                break;
            }
            case "arrayofjavaarray": {
                this.writeArrayToCSVFile(Cast._Array((Object)data), csvFormat, "javaarray", outputFilePath, encoding);
                break;
            }
            case "arrayofstruct": {
                this.writeArrayToCSVFile(Cast._Array((Object)data), csvFormat, "struct", outputFilePath, encoding);
                break;
            }
            case "query": {
                this.writeQueryToCSVFile((QueryTable)data, csvFormat, outputFilePath, encoding);
                break;
            }
            case "xlsx": {
                this.writeXLSXToCSVFile((ExcelInfo)data, csvFormat, outputFilePath, encoding);
                break;
            }
            case "csvrecorditerable": {
                this.writeCSVRecordIterableToFile((CSVRecordIterable)data, csvFormat, outputFilePath, encoding);
                break;
            }
            default: {
                throw new SpreadSheetTag.ExcelIllegalValueException(inputFormat, "inputFormat");
            }
        }
    }

    private void writeXLSXToCSVFile(ExcelInfo info, CSVFormat csvFormat, String outputFilePath, String encoding) throws IOException {
        Workbook workbook = info.getWorkbook();
        Sheet sheet = workbook.getSheetAt(0);
        Iterator rowIterator = sheet.rowIterator();
        FileWriter fileWriter = new FileWriter(outputFilePath, Charset.forName(encoding));
        try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)fileWriter, csvFormat);){
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                for (int i = 0; i < row.getLastCellNum(); ++i) {
                    this.printTypedValue(csvPrinter, Excel.getValueAt(row, i), csvFormat);
                }
                csvPrinter.println();
            }
        }
    }

    private void writeCSVRecordIterableToFile(CSVRecordIterable data, CSVFormat csvFormat, String outputFilePath, String encoding) throws IOException {
        FileWriter fileWriter = new FileWriter(outputFilePath, Charset.forName(encoding));
        try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)fileWriter, csvFormat);){
            Iterator<Array> iterator = data.iterator();
            while (iterator.hasNext()) {
                Array recordArray = iterator.next();
                for (Object value : recordArray) {
                    this.printTypedValue(csvPrinter, value, csvFormat);
                }
                csvPrinter.println();
            }
        }
    }

    private void writeQueryToCSVFile(QueryTable query, CSVFormat csvFormat, String outputFilePath, String encoding) throws IOException {
        FileWriter fileWriter = new FileWriter(outputFilePath, Charset.forName(encoding));
        try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)fileWriter, csvFormat);){
            String[] cols = query.getColumnList();
            while (!query.isLast()) {
                coldfusion.sql.imq.Row r = query.getRow(query.getCurrentRow());
                for (int j = 0; j < cols.length; ++j) {
                    Object columnValue = r.getColumn(j);
                    if (null != columnValue && columnValue instanceof char[]) {
                        columnValue = new String((char[])columnValue);
                    }
                    this.printTypedValue(csvPrinter, columnValue == null ? null : columnValue.toString(), csvFormat);
                }
                csvPrinter.println();
                query.next();
            }
            query.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeArrayToCSVFile(FastArray array, CSVFormat csvFormat, String type, String outputFilePath, String encoding) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(VFSFileFactory.getOutputStream((String)outputFilePath), Charset.forName(encoding));
        try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)outputStreamWriter, csvFormat);){
            switch (type) {
                case "javaarray": {
                    Iterator iterator = array.iterator();
                    while (iterator.hasNext()) {
                        String[] recordArray;
                        Object obj = iterator.next();
                        for (String value : recordArray = (String[])obj) {
                            this.printTypedValue(csvPrinter, value, csvFormat);
                        }
                        csvPrinter.println();
                    }
                    return;
                }
                case "cfarray": {
                    Iterator iterator = array.iterator();
                    while (iterator.hasNext()) {
                        Object obj = iterator.next();
                        Iterable recordArray = (Iterable)obj;
                        for (Object value : recordArray) {
                            this.printTypedValue(csvPrinter, value, csvFormat);
                        }
                        csvPrinter.println();
                    }
                    return;
                }
                case "struct": {
                    Iterator iterator = array.iterator();
                    while (iterator.hasNext()) {
                        Object obj = iterator.next();
                        Collection values = null;
                        values = obj instanceof OrderedCaseSensitiveStruct ? ((OrderedCaseSensitiveStruct)obj).values() : (obj instanceof StructOrdered ? ((StructOrdered)obj).values() : ((Struct)obj).values());
                        for (Object value : values) {
                            this.printTypedValue(csvPrinter, value, csvFormat);
                        }
                        csvPrinter.println();
                    }
                    return;
                }
            }
            return;
        }
    }

    private void writeCSVStringToCSVFile(String data, CSVFormat csvFormat, String outputFilePath, CSVFormat csvReadConfig, String encoding) throws IOException {
        CSVParser csvParser = CSVParser.parse((String)data, (CSVFormat)csvReadConfig);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(VFSFileFactory.getOutputStream((String)outputFilePath), Charset.forName(encoding));
        try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)outputStreamWriter, csvFormat);){
            for (CSVRecord record : csvParser) {
                if (!this.isEmptyRecord.test(record)) {
                    for (String value : record.values()) {
                        this.printTypedValue(csvPrinter, value, csvFormat);
                    }
                }
                csvPrinter.println();
            }
        }
    }

    private CSVFormat configureCSVFormat(Map options) {
        CSVFormatConfig readConfig = new CSVFormatConfig();
        this.convertToUpperCase(options, "ENCODING");
        this.convertToUpperCase(options, "quoteMode");
        this.convertToUpperCase(options, "duplicateHeaderMode");
        ValidatorFiller.INSTANCE.fillObject((Object)readConfig, options, CSVFormatConfigMetadata.getInstance().getConsumerMap());
        CSVFormat.Builder builder = CSVFormat.Builder.create().setDelimiter(readConfig.getDelimiter()).setAllowMissingColumnNames(readConfig.isAllowMissingColumnNames()).setTrailingDelimiter(readConfig.isTrailingDelimiter()).setRecordSeparator(readConfig.getRecordSeparator()).setIgnoreEmptyLines(readConfig.isIgnoreEmptyLines()).setTrim(readConfig.isTrim()).setAutoFlush(readConfig.isAutoFlush());
        if (null != readConfig.getQuoteCharacter()) {
            builder.setQuote(readConfig.getQuoteCharacter().charAt(0));
            if (options.containsKey("quoteMode")) {
                builder.setQuoteMode(QuoteMode.valueOf((String)readConfig.getQuoteMode()));
            }
        } else {
            this.checkDependentKeyException(options, "quoteCharacter", "quoteMode");
        }
        if (null != readConfig.getHeader()) {
            builder.setHeader(Arrays.asList(readConfig.getHeader()).toArray(new String[0])).setSkipHeaderRecord(readConfig.isSkipHeaderRecord()).setIgnoreHeaderCase(readConfig.isIgnoreHeaderCase()).setDuplicateHeaderMode(DuplicateHeaderMode.valueOf((String)readConfig.getDuplicateHeaderMode()));
        } else {
            this.checkDependentKeyException(options, "header", "skipHeaderRecord");
            this.checkDependentKeyException(options, "header", "ignoreHeaderCase");
            this.checkDependentKeyException(options, "header", "duplicateHeaderMode");
        }
        if (null != readConfig.getNullString()) {
            builder.setNullString(readConfig.getNullString());
        }
        if (null != readConfig.getEscapeCharacter()) {
            builder.setEscape(readConfig.getEscapeCharacter().charAt(0));
        }
        if (null != readConfig.getCommentMarker()) {
            builder.setCommentMarker(readConfig.getCommentMarker().charAt(0));
            if (null != readConfig.getHeaderComments()) {
                builder.setHeaderComments(Arrays.asList(readConfig.getHeaderComments()).toArray(new String[0]));
            }
        } else {
            this.checkDependentKeyException(options, "commentMarker", "headerComments");
        }
        return builder.build();
    }

    private void convertToUpperCase(Map options, String key) {
        if (options.containsKey(key)) {
            options.put(key, Cast._String(options.get(key)).toUpperCase());
        }
    }

    private void checkInvalidKeysForOperationException(Map options, String[] keys, String operation) {
        for (String key : keys) {
            if (!options.containsKey(key)) continue;
            throw new SpreadSheetTag.InvalidKeyForOperationException(key, operation);
        }
    }

    private void checkDependentKeyException(Map options, String key, String dependentKey) {
        if (options.containsKey(dependentKey)) {
            throw new SpreadSheetTag.ExcelInvalidKeyCombinationException(key, dependentKey);
        }
    }

    private void checkInvalidKeysFormatOperation(String[] keys, String outputFormat, Map csvFormatConfiguration) {
        for (String key : keys) {
            this.checkInvalidKeyFormatOperationException(csvFormatConfiguration, key, outputFormat, "csvRead");
        }
    }

    private void checkInvalidKeyFormatOperationException(Map options, String key, String format, String operation) {
        if (options.containsKey(key)) {
            throw new SpreadSheetTag.InvalidKeyFormatOperationException(key, format, operation);
        }
    }

    private Object parseAndTransformCSVForRead(String filePath, String outputFormat, CSVFormat csvFormat, UDFMethod rowFilter, String encoding) throws Exception {
        try (InputStreamReader in = new InputStreamReader(VFSFileFactory.getInputStream((String)filePath), Charset.forName(encoding));){
            CSVParser records = csvFormat.parse((Reader)in);
            switch (outputFormat.toLowerCase()) {
                case "csvstring": {
                    String string = this.csvRecordsToString((Iterable<CSVRecord>)records, csvFormat, rowFilter);
                    return string;
                }
                case "arrayofcfarray": {
                    Array array = this.csvRecordsToArray((Iterable<CSVRecord>)records, csvFormat, rowFilter, "cfarray");
                    return array;
                }
                case "arrayofjavaarray": {
                    Array array = this.csvRecordsToArray((Iterable<CSVRecord>)records, csvFormat, rowFilter, "javaarray");
                    return array;
                }
                case "arrayofstruct": {
                    Array array = this.csvRecordsToArray((Iterable<CSVRecord>)records, csvFormat, rowFilter, "struct");
                    return array;
                }
                case "query": {
                    Object object = this.csvRecordsToQuery((Iterable<CSVRecord>)records, csvFormat, rowFilter);
                    return object;
                }
                case "xlsx": {
                    Object object = this.csvRecordsToSpreadSheet((Iterable<CSVRecord>)records, csvFormat, rowFilter);
                    return object;
                }
                case "csvrecorditerable": {
                    CSVRecordIterable cSVRecordIterable = this.createCSVRecordIterable((Iterable<CSVRecord>)records, filePath, csvFormat, encoding);
                    return cSVRecordIterable;
                }
            }
            throw new SpreadSheetTag.ExcelIllegalValueException(outputFormat, "outputFormat");
        }
    }

    private CSVRecordIterable createCSVRecordIterable(Iterable<CSVRecord> records, String filePath, CSVFormat csvFormat, String encoding) throws IOException {
        FileReader in = new FileReader(filePath, Charset.forName(encoding));
        CSVParser recordsIterable = csvFormat.parse((Reader)in);
        Array firstTenRecords = new Array();
        int count = 0;
        for (CSVRecord record : records) {
            if (count++ == 10) break;
            if (this.isEmptyRecord.test(record)) {
                firstTenRecords.add((Object)new String[0]);
                continue;
            }
            firstTenRecords.add((Object)record.values());
        }
        return new CSVRecordIterable((Iterable<CSVRecord>)recordsIterable, firstTenRecords, in, this.isEmptyRecord);
    }

    private Object csvRecordsToSpreadSheet(Iterable<CSVRecord> records, CSVFormat csvFormat, UDFMethod rowFilter) throws IOException {
        ExcelInfo excelInfo = (ExcelInfo)this.createNewSpreadsheet("Sheet1", true);
        this.addCSVRecordsToSpreadsheet(records, csvFormat, excelInfo, rowFilter);
        return excelInfo;
    }

    private Object csvRecordsToQuery(Iterable<CSVRecord> records, CSVFormat csvFormat, UDFMethod rowFilter) throws IOException {
        ArrayList<String[]> recordsList = new ArrayList<String[]>();
        int maxLen = 0;
        for (CSVRecord record : records) {
            String[] recordArray;
            if (this.invokeRowFilter(rowFilter, record)) continue;
            String[] stringArray = recordArray = this.isEmptyRecord.test(record) ? new String[]{} : record.values();
            if (maxLen < recordArray.length) {
                maxLen = recordArray.length;
            }
            recordsList.add(recordArray);
        }
        if (null != csvFormat.getHeader()) {
            return this.populateQueryHelper(recordsList, csvFormat.getHeader(), maxLen);
        }
        return this.populateQueryHelper(recordsList, new String[0], maxLen);
    }

    private void addCSVRecordsToSpreadsheet(Iterable<CSVRecord> records, CSVFormat csvFormat, ExcelInfo excelInfo, UDFMethod rowFilter) throws IOException {
        for (CSVRecord record : records) {
            if (this.invokeRowFilter(rowFilter, record)) continue;
            String[] row = this.isEmptyRecord.test(record) ? new String[]{} : record.values();
            Excel.addRow(excelInfo, row, -1, 0, true, null);
        }
    }

    private Array csvRecordsToArray(Iterable<CSVRecord> records, CSVFormat csvFormat, UDFMethod rowFilter, String type) throws IOException {
        Array outputArray = new Array();
        for (CSVRecord record : records) {
            if (this.invokeRowFilter(rowFilter, record)) continue;
            switch (type) {
                case "javaarray": {
                    outputArray.add(this.getArrayForRecordValues(record));
                    break;
                }
                case "cfarray": {
                    outputArray.add((Object)this.getCFArrayForCSVRecord(csvFormat, record));
                    break;
                }
                case "struct": {
                    StructOrdered struct;
                    if (csvFormat.getIgnoreHeaderCase()) {
                        struct = new StructOrdered();
                        if (!this.isEmptyRecord.test(record)) {
                            struct.putAll(record.toMap());
                        }
                        outputArray.add((Object)struct);
                        break;
                    }
                    struct = new OrderedCaseSensitiveStruct();
                    if (!this.isEmptyRecord.test(record)) {
                        struct.putAll(record.toMap());
                    }
                    outputArray.add((Object)struct);
                }
            }
        }
        return outputArray;
    }

    private Array getCFArrayForCSVRecord(CSVFormat csvFormat, CSVRecord record) throws IOException {
        Array recordArray = new Array(1, "string");
        if (this.isEmptyRecord.test(record)) {
            return recordArray;
        }
        recordArray.addAll(Arrays.asList(record.values()));
        return recordArray;
    }

    private String csvRecordsToString(Iterable<CSVRecord> records, CSVFormat csvFormat, UDFMethod rowFilter) throws IOException {
        StringWriter stringWriter = new StringWriter();
        try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, csvFormat);){
            for (CSVRecord record : records) {
                if (this.invokeRowFilter(rowFilter, record)) continue;
                if (!this.isEmptyRecord.test(record)) {
                    for (String value : record) {
                        csvPrinter.print((Object)value);
                    }
                }
                csvPrinter.println();
            }
        }
        return stringWriter.toString();
    }

    private boolean invokeRowFilter(UDFMethod rowFilter, CSVRecord record) {
        boolean toIncludeRecord = true;
        if (null != rowFilter) {
            try {
                Array cfArray = new Array(1, record.size());
                cfArray.addAll((Collection)record.toList());
                Object[] args = new Object[]{cfArray, record.getRecordNumber()};
                toIncludeRecord = Cast._boolean((Object)CFPage._invokeUDF((Object)rowFilter, (String)rowFilter.getName(), (CFPage)((CFPage)FusionContext.getCurrent().pageContext.getPage()), (Object[])args), (boolean)true);
            }
            catch (Throwable e) {
                throw new SpreadSheetTag.CSVReadException(e);
            }
        }
        return !toIncludeRecord;
    }

    private void printTypedValue(CSVPrinter csvPrinter, Object value, CSVFormat csvFormat) throws IOException {
        if (CFPage.IsNumeric((Object)value)) {
            if (value instanceof String && csvFormat.getTrim()) {
                this.printNumericString(csvPrinter, ((String)value).trim());
            } else {
                csvPrinter.print(value);
            }
        } else {
            csvPrinter.print(value);
        }
    }

    private void printNumericString(CSVPrinter csvPrinter, String value) throws IOException {
        try {
            csvPrinter.print((Object)Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            try {
                csvPrinter.print((Object)Long.parseLong(value));
            }
            catch (NumberFormatException e1) {
                csvPrinter.print((Object)Double.parseDouble(value));
            }
        }
    }

    private void checkForValidRange(int startRow, int startColumn, int endRow, int endColumn) {
        if (startRow > endRow) {
            throw new SpreadSheetTag.InvalidStartRowParameterException(startRow, endRow);
        }
        if (startColumn > endColumn) {
            throw new SpreadSheetTag.InvalidStartColumnParameterException(startColumn, endColumn);
        }
    }
}

