/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.webp;

import com.drew.imaging.riff.RiffHandler;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.icc.IccReader;
import com.drew.metadata.webp.WebpDirectory;
import com.drew.metadata.xmp.XmpReader;
import java.io.IOException;

public class WebpRiffHandler
implements RiffHandler {
    @NotNull
    private final Metadata _metadata;

    public WebpRiffHandler(@NotNull Metadata metadata) {
        this._metadata = metadata;
    }

    public boolean shouldAcceptRiffIdentifier(@NotNull String string) {
        return string.equals("WEBP");
    }

    public boolean shouldAcceptChunk(@NotNull String string) {
        return string.equals("VP8X") || string.equals("EXIF") || string.equals("ICCP") || string.equals("XMP ");
    }

    public void processChunk(@NotNull String string, @NotNull byte[] byArray) {
        if (string.equals("EXIF")) {
            new ExifReader().extract(new ByteArrayReader(byArray), this._metadata);
        } else if (string.equals("ICCP")) {
            new IccReader().extract(new ByteArrayReader(byArray), this._metadata);
        } else if (string.equals("XMP ")) {
            new XmpReader().extract(byArray, this._metadata);
        } else if (string.equals("VP8X") && byArray.length == 10) {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            byteArrayReader.setMotorolaByteOrder(false);
            try {
                boolean bl = byteArrayReader.getBit(1);
                boolean bl2 = byteArrayReader.getBit(4);
                int n = byteArrayReader.getInt24(4);
                int n2 = byteArrayReader.getInt24(7);
                WebpDirectory webpDirectory = new WebpDirectory();
                webpDirectory.setInt(2, n + 1);
                webpDirectory.setInt(1, n2 + 1);
                webpDirectory.setBoolean(3, bl2);
                webpDirectory.setBoolean(4, bl);
                this._metadata.addDirectory(webpDirectory);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }
    }
}

